/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterCodeStyleImporter;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintConfigWrapper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintCodeStyleImporter
extends JSLinterCodeStyleImporter<EslintConfigWrapper> {
    public EslintCodeStyleImporter(boolean isForInitialImport) {
        super(isForInitialImport);
    }

    @Override
    @NotNull
    protected Configurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(0);
        }
        return new EslintConfigurable(project);
    }

    @Override
    @NotNull
    protected JSNpmLinterState getStoredState(Project project) {
        JSNpmLinterState jSNpmLinterState = (JSNpmLinterState)EslintConfiguration.getInstance(project).getExtendedState().getState();
        if (jSNpmLinterState == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(1);
        }
        return jSNpmLinterState;
    }

    @Override
    @NotNull
    protected String getNpmPackageName() {
        return "eslint";
    }

    @Override
    @NotNull
    protected String getToolName() {
        String string = JavaScriptBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
        if (string == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyImportable(@NotNull PsiFile configPsi, @Nullable EslintConfigWrapper parsedConfig) {
        if (configPsi == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(3);
        }
        return EslintCodeStyleImporter.configDoesNotRequireTranslation(configPsi);
    }

    @Override
    @Nullable
    protected EslintConfigWrapper parseConfigFromFile(@NotNull PsiFile configPsi) {
        if (configPsi == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(4);
        }
        return EslintConfigWrapper.getForFile(configPsi);
    }

    @Override
    @NotNull
    protected JSLinterCodeStyleImporter.ImportResult importConfig(@NotNull PsiFile configPsi, @NotNull EslintConfigWrapper config2) {
        if (configPsi == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(5);
        }
        if (config2 == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(6);
        }
        if (!config2.hasDataToImport(configPsi.getProject())) {
            JSLinterCodeStyleImporter.ImportResult importResult = JSLinterCodeStyleImporter.ImportResult.alreadyImported();
            if (importResult == null) {
                EslintCodeStyleImporter.$$$reportNull$$$0(7);
            }
            return importResult;
        }
        JSLinterCodeStyleImporter.ImportResult importResult = JSLinterCodeStyleImporter.ImportResult.success(config2.modifySettings(configPsi.getProject()));
        if (importResult == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(8);
        }
        return importResult;
    }

    @Override
    @Nullable
    protected EslintConfigWrapper computeEffectiveConfig(@NotNull PsiFile configPsi, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage linterPackage) throws ExecutionException {
        if (configPsi == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(9);
        }
        if (interpreter == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(10);
        }
        if (linterPackage == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(11);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (linterPackage instanceof YarnPnpNodePackage) {
            ((YarnPnpNodePackage)linterPackage).addYarnRunToCommandLine(commandLine, configPsi.getProject(), interpreter, null);
        } else {
            commandLine.addParameter(Objects.requireNonNull(EslintCodeStyleImporter.getBinJsFile(linterPackage)).getAbsolutePath());
        }
        String configFilePath = configPsi.getVirtualFile().getPath();
        commandLine.addParameters(new String[]{"-c", configFilePath, "--print-config", configFilePath});
        String stdOut = this.runCommandLine(commandLine, configPsi, interpreter);
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("ESLint: computed effective config for file %s:\n%s", configFilePath, stdOut));
        }
        return (EslintConfigWrapper)ReadAction.compute(() -> {
            PsiFile tempFile = PsiFileFactory.getInstance((Project)configPsi.getProject()).createFileFromText(".eslintrc.json", (FileType)JsonFileType.INSTANCE, (CharSequence)stdOut);
            return EslintConfigWrapper.getForFile(tempFile);
        });
    }

    private static boolean configDoesNotRequireTranslation(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EslintCodeStyleImporter.$$$reportNull$$$0(12);
        }
        if (!JsonFileType.INSTANCE.equals(psiFile.getFileType())) {
            return false;
        }
        JsonObject rootObject = EslintUtil.getConfigRootObject(psiFile);
        if (rootObject == null) {
            return false;
        }
        if (rootObject.findProperty("extends") != null) {
            return false;
        }
        JsonProperty root = rootObject.findProperty("root");
        return root != null && root.getValue() != null && "true".equals(root.getValue().getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintCodeStyleImporter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPsi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterPackage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintCodeStyleImporter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "importConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyImportable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigFromFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importConfig";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeEffectiveConfig";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configDoesNotRequireTranslation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

