/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.jshint.JSHintInspection;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JSHintConfiguration", storages={@Storage(value="jsLinters/jshint.xml")})
public class JSHintConfiguration
extends JSLinterConfiguration<JSHintState> {
    private static final String JSHINT_ELEMENT_NAME = "jshint";
    private static final String JSHINT_VERSION_ATTRIBUTE_NAME = "version";
    private static final String IS_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-config-file";
    private static final String IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-custom-config-file";
    private static final String CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME = "custom-config-file-path";
    private static final String OPTION_ELEMENT_NAME = "option";
    private static final JSHintState DEFAULT_STATE = new JSHintState.Builder().setVersion("2.10.2").setOptionsState(new JSHintOptionsState.Builder().put(JSHintOption.FORIN, (Object)true).put(JSHintOption.NOARG, (Object)true).put(JSHintOption.NOEMPTY, (Object)true).put(JSHintOption.EQEQEQ, (Object)true).put(JSHintOption.BITWISE, (Object)true).put(JSHintOption.STRICT, (Object)true).put(JSHintOption.UNDEF, (Object)true).put(JSHintOption.CURLY, (Object)true).put(JSHintOption.NONEW, (Object)true).put(JSHintOption.BROWSER, (Object)true).put(JSHintOption.MAXERR, (Object)50).build()).build();

    public JSHintConfiguration(@NotNull Project project) {
        if (project == null) {
            JSHintConfiguration.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    protected void savePrivateSettings(@NotNull JSHintState state) {
        if (state == null) {
            JSHintConfiguration.$$$reportNull$$$0(1);
        }
    }

    @Override
    @NotNull
    protected JSHintState loadPrivateSettings(@NotNull JSHintState state) {
        if (state == null) {
            JSHintConfiguration.$$$reportNull$$$0(2);
        }
        JSHintState jSHintState = state;
        if (jSHintState == null) {
            JSHintConfiguration.$$$reportNull$$$0(3);
        }
        return jSHintState;
    }

    @NotNull
    public static JSHintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            JSHintConfiguration.$$$reportNull$$$0(4);
        }
        JSHintConfiguration jSHintConfiguration = JSLinterConfiguration.getInstance(project, JSHintConfiguration.class);
        if (jSHintConfiguration == null) {
            JSHintConfiguration.$$$reportNull$$$0(5);
        }
        return jSHintConfiguration;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return JSHintInspection.class;
    }

    @Override
    @NotNull
    protected Element toXml(@NotNull JSHintState state) {
        String customConfigFilePath;
        if (state == null) {
            JSHintConfiguration.$$$reportNull$$$0(6);
        }
        Element root = new Element(JSHINT_ELEMENT_NAME);
        root.setAttribute(JSHINT_VERSION_ATTRIBUTE_NAME, state.getVersion());
        root.setAttribute(IS_CONFIG_FILE_USED_ATTRIBUTE_NAME, String.valueOf(state.isConfigFileUsed()));
        if (state.isCustomConfigFileUsed()) {
            root.setAttribute(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME, Boolean.TRUE.toString());
        }
        if (!(customConfigFilePath = state.getCustomConfigFilePath()).isEmpty()) {
            root.setAttribute(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME, FileUtil.toSystemIndependentName((String)customConfigFilePath));
        }
        JSHintOptionsState optionsState = state.getOptionsState();
        List<String> optionKeysInOrder = JSHintConfiguration.sortOptionKeysInOrder(optionsState.getOptionKeys());
        for (String optionKey : optionKeysInOrder) {
            String valueStr;
            Object value;
            JSHintOption option = JSHintOption.findByName(optionKey);
            if (option == null || (value = optionsState.getValue(option)) == null) continue;
            if (value instanceof OptionEnumVariant) {
                OptionEnumVariant variant = (OptionEnumVariant)value;
                valueStr = variant.getValue().toString();
            } else {
                valueStr = value.toString();
            }
            Element child = new Element(OPTION_ELEMENT_NAME);
            child.setAttribute(option.getKey(), valueStr);
            root.addContent(child);
        }
        Element element = root;
        if (element == null) {
            JSHintConfiguration.$$$reportNull$$$0(7);
        }
        return element;
    }

    @NotNull
    private static List<String> sortOptionKeysInOrder(@NotNull Collection<String> optionKeys) {
        if (optionKeys == null) {
            JSHintConfiguration.$$$reportNull$$$0(8);
        }
        Object[] array = ArrayUtilRt.toStringArray(optionKeys);
        Arrays.sort(array);
        List<Object> list2 = Arrays.asList(array);
        if (list2 == null) {
            JSHintConfiguration.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    @NotNull
    protected JSHintState fromXml(@NotNull Element element) {
        if (element == null) {
            JSHintConfiguration.$$$reportNull$$$0(10);
        }
        JSHintState.Builder builder = new JSHintState.Builder();
        JSHintOptionsState optionsState = JSHintConfiguration.loadOptionsValues(element.getChildren());
        builder.setOptionsState(optionsState);
        String version = element.getAttributeValue(JSHINT_VERSION_ATTRIBUTE_NAME);
        if (StringUtil.isNotEmpty((String)version)) {
            builder.setVersion(version);
        }
        builder.setConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        builder.setCustomConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        String customConfigFilePath = StringUtil.notNullize((String)element.getAttributeValue(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME));
        builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)customConfigFilePath));
        JSHintState jSHintState = builder.build();
        if (jSHintState == null) {
            JSHintConfiguration.$$$reportNull$$$0(11);
        }
        return jSHintState;
    }

    @NotNull
    private static JSHintOptionsState loadOptionsValues(@NotNull List<Element> optionsElements) {
        if (optionsElements == null) {
            JSHintConfiguration.$$$reportNull$$$0(12);
        }
        JSHintOptionsState.Builder optionsValuesBuilder = new JSHintOptionsState.Builder();
        for (Element child : optionsElements) {
            if (!OPTION_ELEMENT_NAME.equals(child.getName())) continue;
            List attributes = child.getAttributes();
            for (Attribute attribute : attributes) {
                Object value;
                String optionName = attribute.getName();
                JSHintOption option = JSHintOption.findByName(optionName);
                if (option == null || (value = option.fromString(attribute.getValue())) == null) continue;
                optionsValuesBuilder.put(option, value);
            }
        }
        JSHintOptionsState jSHintOptionsState = optionsValuesBuilder.build();
        if (jSHintOptionsState == null) {
            JSHintConfiguration.$$$reportNull$$$0(13);
        }
        return jSHintOptionsState;
    }

    @Override
    @NotNull
    protected JSHintState getDefaultState() {
        JSHintState jSHintState = DEFAULT_STATE;
        if (jSHintState == null) {
            JSHintConfiguration.$$$reportNull$$$0(14);
        }
        return jSHintState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionKeys";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPrivateSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toXml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sortOptionKeysInOrder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromXml";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadOptionsValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "savePrivateSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateSettings";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sortOptionKeysInOrder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadOptionsValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

