/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSHintConfigFileAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        JsonFile file2;
        if (element == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(1);
        }
        if ((file2 = (JsonFile)ObjectUtils.tryCast((Object)element, JsonFile.class)) != null && JSHintConfigFileUtil.isJSHintConfigFile((PsiFile)file2)) {
            JSHintConfigFileAnnotator.annotateFile(file2, holder);
        }
    }

    private static void annotateFile(@NotNull JsonFile file2, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(3);
        }
        for (PsiElement element : file2.getChildren()) {
            JsonObject objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
            if (objectLiteralExpression == null) continue;
            JSHintConfigFileAnnotator.annotateObjectLiteralExpression(objectLiteralExpression, holder);
        }
    }

    private static void annotateObjectLiteralExpression(@NotNull JsonObject expression, @NotNull AnnotationHolder holder) {
        if (expression == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(5);
        }
        List properties = expression.getPropertyList();
        EnumMap<JSHintOption, PsiElement> encounteredOptions = new EnumMap<JSHintOption, PsiElement>(JSHintOption.class);
        for (JsonProperty property : properties) {
            JSHintConfigFileAnnotator.annotateJSProperty(property, holder, encounteredOptions);
        }
    }

    private static void annotateJSProperty(@NotNull JsonProperty property, @NotNull AnnotationHolder holder, @NotNull Map<JSHintOption, PsiElement> encounteredOptions) {
        PsiElement keyElement;
        if (property == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(7);
        }
        if (encounteredOptions == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(8);
        }
        if ((keyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property)) == null) {
            return;
        }
        String keyStr = StringUtil.stripQuotesAroundValue((String)keyElement.getText());
        if ("extends".equals(keyStr)) {
            return;
        }
        JSHintOption option = JSHintOption.findByName(keyStr);
        if (option == null) {
            if (!JSHintConfigFileUtil.isWarningKey(keyStr)) {
                JSHintConfigFileAnnotator.annotateJSPropertyKeyAsUnknown(keyElement, holder);
            }
            return;
        }
        PsiElement oldKeyElement = encounteredOptions.get(option);
        if (oldKeyElement != null) {
            JSHintConfigFileAnnotator.annotateJSPropertyKeyAsDuplicated(oldKeyElement, keyElement, holder);
            return;
        }
        encounteredOptions.put(option, keyElement);
        JSHintConfigFileAnnotator.annotateJSPropertyValue(property, option, holder);
    }

    private static void annotateJSPropertyKeyAsUnknown(@NotNull PsiElement keyElement, @NotNull AnnotationHolder holder) {
        if (keyElement == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(10);
        }
        JSHintConfigFileAnnotator.annotateKeyElement(keyElement, holder, "Unexpected JSHint option name");
    }

    private static void annotateJSPropertyKeyAsDuplicated(@NotNull PsiElement oldKeyElement, @NotNull PsiElement newKeyElement, @NotNull AnnotationHolder holder) {
        String newKeyStr;
        String oldKeyStr;
        if (oldKeyElement == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(11);
        }
        if (newKeyElement == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(13);
        }
        if (!(oldKeyStr = StringUtil.stripQuotesAroundValue((String)oldKeyElement.getText())).equals(newKeyStr = StringUtil.stripQuotesAroundValue((String)newKeyElement.getText()))) {
            String message = "Duplicate JSHint options: " + oldKeyStr + ", " + newKeyStr + ".";
            JSHintConfigFileAnnotator.annotateKeyElement(oldKeyElement, holder, message);
            JSHintConfigFileAnnotator.annotateKeyElement(newKeyElement, holder, message);
        }
    }

    private static void annotateKeyElement(@NotNull PsiElement keyElement, @NotNull AnnotationHolder holder, @NotNull String message) {
        int endInd;
        int startInd;
        if (keyElement == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(15);
        }
        if (message == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(16);
        }
        TextRange textRange = keyElement.getTextRange();
        if (JSLinterConfigFileUtil.isStringLiteral(keyElement) && (startInd = textRange.getStartOffset() + 1) < (endInd = textRange.getEndOffset() - 1)) {
            textRange = new TextRange(startInd, endInd);
        }
        if (!textRange.isEmpty()) {
            holder.newAnnotation(HighlightSeverity.WARNING, message).range(textRange).create();
        }
    }

    private static void annotateJSPropertyValue(@NotNull JsonProperty property, @NotNull JSHintOption option, @NotNull AnnotationHolder holder) {
        JsonValue value;
        if (property == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(17);
        }
        if (option == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(18);
        }
        if (holder == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(19);
        }
        if ((value = property.getValue()) == null) {
            return;
        }
        if (option == JSHintOption.PREDEF) {
            if (!(value instanceof JsonObject) && !(value instanceof JsonArray)) {
                holder.newAnnotation(HighlightSeverity.WARNING, "object or array expected").range((PsiElement)value).create();
            }
            return;
        }
        String valueStr = value.getText();
        Object unifiedValue = option.getType().fromString(valueStr);
        if (unifiedValue != null) {
            return;
        }
        String message = JSHintConfigFileAnnotator.formatErrorMessageFor(option);
        holder.newAnnotation(HighlightSeverity.WARNING, message).range((PsiElement)value).create();
    }

    private static String formatErrorMessageFor(@NotNull JSHintOption option) {
        String message;
        if (option == null) {
            JSHintConfigFileAnnotator.$$$reportNull$$$0(20);
        }
        List validVariants = Collections.emptyList();
        if (OptionTypes.isEnumOption(option)) {
            OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
            validVariants = ContainerUtil.map(enumType.getVariants(), variant -> variant.getValueAsJsonStr());
        } else if (OptionTypes.isBooleanOption(option)) {
            validVariants = ContainerUtil.newArrayList((Object[])new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()});
        }
        if (validVariants.size() > 0) {
            StringBuilder buf = new StringBuilder("Expected values: ");
            StringUtil.join(validVariants.subList(0, validVariants.size() - 1), (String)", ", (StringBuilder)buf);
            buf.append(" or ").append((String)validVariants.get(validVariants.size() - 1));
            message = buf.toString();
        } else {
            message = "unexpected value";
        }
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encounteredOptions";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeyElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newKeyElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateObjectLiteralExpression";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateJSProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateJSPropertyKeyAsUnknown";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateJSPropertyKeyAsDuplicated";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateKeyElement";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateJSPropertyValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "formatErrorMessageFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

