/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSResolvableModuleReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.ES6CheckImportInspection;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.JSModuleVisitor;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NpmUsedModulesInstalledInspection;
import com.intellij.lang.javascript.modules.TypeScriptCheckImportInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.inspection.TypeScriptConfigEnableOptionFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J/\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0011\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/modules/TypeScriptCheckImportInspection;", "Lcom/intellij/lang/javascript/modules/ES6CheckImportInspection;", "()V", "checkConfigIsAcceptable", "", "tsConfig", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getEnableOptionFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "importExportPart", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "getFixes", "", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;", "resolveResult", "Lcom/intellij/psi/PsiElement;", "resolveProblemKey", "", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/LocalQuickFix;", "getRangeForError", "Lcom/intellij/openapi/util/TextRange;", "psiElementForError", "moduleName", "isAcceptableModule", "it", "isFileAcceptable", "file", "Lcom/intellij/psi/PsiFile;", "intellij.javascript.impl"})
public final class TypeScriptCheckImportInspection
extends ES6CheckImportInspection {
    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.ERROR");
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"holder.file");
        PsiFile file2 = psiFile;
        boolean isServiceEnabled = this.isFileAcceptable(file2) && TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file2) instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider;
        return (PsiElementVisitor)new JSModuleVisitor(this, holder, isServiceEnabled){
            final /* synthetic */ TypeScriptCheckImportInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isServiceEnabled;

            protected boolean isAvailable(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return DialectDetector.isTypeScript(element);
            }

            public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
                Intrinsics.checkParameterIsNotNull((Object)importedBinding, (String)"importedBinding");
                if (!this.isAvailable((PsiElement)importedBinding)) {
                    return;
                }
                ProblemHighlightType problemHighlightType = this.getProblemHighlightType();
                if (this.shouldIgnoreErrors(problemHighlightType)) {
                    return;
                }
                this.this$0.visitES6ImportedBindingImpl(importedBinding, this.$holder, problemHighlightType);
            }

            public void visitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier node) {
                boolean bl;
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (!this.isAvailable((PsiElement)node)) {
                        return;
                    }
                    Object object = node.getDeclaration();
                    if (object == null || (object = object.getFromClause()) == null || (object = object.resolveReferencedElements()) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"node.declaration?.fromCl\u2026Elements() ?: emptyList()");
                    Object elements = object;
                    Iterable $this$any$iv = (Iterable)elements;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof TypeScriptModule && ((TypeScriptModule)it).isShorthandAmbientModule())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                ProblemHighlightType problemHighlightType = this.getProblemHighlightType();
                if (this.shouldIgnoreErrors(problemHighlightType)) {
                    return;
                }
                this.this$0.visitSpecifierImpl(this.$holder, node, problemHighlightType);
            }

            protected void processImport(@NotNull PsiElement literalElement, @NotNull String quotedLiteralValue, @NotNull PsiReference[] references, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkParameterIsNotNull((Object)literalElement, (String)"literalElement");
                Intrinsics.checkParameterIsNotNull((Object)quotedLiteralValue, (String)"quotedLiteralValue");
                Intrinsics.checkParameterIsNotNull((Object)references, (String)"references");
                Intrinsics.checkParameterIsNotNull((Object)importResolver, (String)"importResolver");
                Intrinsics.checkParameterIsNotNull((Object)pointerBuilder, (String)"pointerBuilder");
                this.checkImports(literalElement, quotedLiteralValue, references, importResolver, pointerBuilder);
            }

            protected void processRequire(@NotNull JSCallExpression element, @NotNull JSLiteralExpression argument, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                Intrinsics.checkParameterIsNotNull((Object)importResolver, (String)"importResolver");
                Intrinsics.checkParameterIsNotNull((Object)pointerBuilder, (String)"pointerBuilder");
            }

            private final void checkImports(PsiElement psiElementForError, String refText, PsiReference[] references, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                if (!this.checkAsNodePackage(psiElementForError, refText, importResolver, pointerBuilder)) {
                    Collection<PsiElement> resolveImportModules;
                    Collection<PsiElement> collection = resolveImportModules = importResolver.resolveImportModules();
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        return;
                    }
                    this.validateImportReferences(references);
                }
            }

            private final void validateImportReferences(PsiReference[] references) {
                boolean resolve = false;
                boolean bl = false;
                List unresolvedRefs = new ArrayList<E>();
                for (PsiReference reference : references) {
                    block10: {
                        block9: {
                            block8: {
                                ResolveResult[] resolveResultArray;
                                if (!(reference instanceof PsiPolyVariantReference)) break block8;
                                Intrinsics.checkExpressionValueIsNotNull((Object)((PsiPolyVariantReference)reference).multiResolve(false), (String)"reference.multiResolve(false)");
                                boolean bl2 = false;
                                ResolveResult[] resolveResultArray2 = resolveResultArray;
                                boolean bl3 = false;
                                if (!(resolveResultArray2.length == 0)) break block9;
                            }
                            if (reference.resolve() == null) break block10;
                        }
                        if (reference instanceof FileReference && !((FileReference)reference).isLast()) continue;
                        resolve = true;
                        continue;
                    }
                    if (reference instanceof JSResolvableModuleReference) continue;
                    unresolvedRefs.add(reference);
                }
                if (!resolve) {
                    PsiReference[] reference = references;
                    int n = 0;
                    PsiReference[] psiReferenceArray = reference;
                    int n2 = 0;
                    if (!(psiReferenceArray.length == 0)) {
                        Object object = ContainerUtil.getFirstItem((List)unresolvedRefs);
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        PsiReference element = (PsiReference)object;
                        ProblemHighlightType problemHighlightType = this.getProblemHighlightType();
                        if (this.shouldIgnoreErrors(problemHighlightType)) {
                            return;
                        }
                        this.$holder.registerProblem(element, XmlHighlightVisitor.getErrorDescription((PsiReference)element), problemHighlightType);
                    }
                }
            }

            private final boolean checkAsNodePackage(PsiElement psiElementForError, String refText, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                boolean isNodeJSCoreModule;
                String expectedTypesName;
                boolean bl;
                Collection<PsiElement> resolveImportModules;
                VirtualFile virtualFile;
                TypeScriptConfig tsConfig;
                String moduleName;
                block16: {
                    String string = JSFileReferencesUtil.getNodeModuleName(refText);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSFileReferencesUtil.getNodeModuleName(refText)");
                    moduleName = string;
                    if (!JSFileReferencesUtil.isAcceptableNodeModulesPackageName(moduleName)) {
                        return false;
                    }
                    PsiFile containingFile = psiElementForError.getContainingFile();
                    tsConfig = TypeScriptConfigUtil.getConfigForPsiFile(containingFile);
                    if (!TypeScriptCheckImportInspection.access$checkConfigIsAcceptable(this.this$0, tsConfig)) {
                        return false;
                    }
                    virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)containingFile));
                    if (virtualFile == null) {
                        return false;
                    }
                    resolveImportModules = importResolver.resolveImportModules();
                    Iterable $this$any$iv = resolveImportModules;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!TypeScriptCheckImportInspection.access$isAcceptableModule(this.this$0, it)) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (bl || resolveImportModules.size() > 1) {
                    return true;
                }
                TypeScriptConfig typeScriptConfig = tsConfig;
                if (typeScriptConfig == null || (typeScriptConfig = typeScriptConfig.getConfigFile()) == null) {
                    typeScriptConfig = virtualFile;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)typeScriptConfig, (String)"tsConfig?.configFile ?: virtualFile");
                TypeScriptConfig contextFile = typeScriptConfig;
                VirtualFile nodeModulesDirectory = NodeModuleUtil.findUpClosestNodeModulesResolveRoot((VirtualFile)contextFile);
                VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDirectory);
                if (packageJson == null) {
                    packageJson = PackageJsonUtil.findChildPackageJsonFile(contextFile.getParent());
                }
                String string = expectedTypesName = (isNodeJSCoreModule = NodeCoreLibraryManager.isCoreModuleName(moduleName)) ? "@types/node" : "@types" + '/' + moduleName;
                if (!isNodeJSCoreModule) {
                    if (packageJson == null) {
                        return false;
                    }
                    PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageJsonData, (String)"PackageJsonData.getOrCreate(packageJson)");
                    PackageJsonData data = packageJsonData;
                    if (data.isDependencyOfAnyType(expectedTypesName)) {
                        return false;
                    }
                    if (!data.isDependencyOfAnyType(moduleName)) {
                        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                        boolean reportOwnError = tsConfig != null && tsConfig.getEffectiveResolution() != TypeScriptConfig.ModuleResolution.CLASSIC;
                        NpmUsedModulesInstalledInspection.Reporter errorReporter = this.createReporter(psiElementForError, moduleName, !reportOwnError);
                        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, CollectionsKt.listOf((Object)packageJson), false, nodeModulesDirectory, errorReporter);
                        return reportOwnError;
                    }
                    NpmUsedModulesInstalledInspection.ModuleTypingsState typingsState = NpmUsedModulesInstalledInspection.modulePackageJsonHasTypings(moduleName, nodeModulesDirectory);
                    if (typingsState == NpmUsedModulesInstalledInspection.ModuleTypingsState.HAS_TYPINGS) {
                        return false;
                    }
                    if (typingsState == NpmUsedModulesInstalledInspection.ModuleTypingsState.MODULE_DIRECTORY_NOT_EXIST) {
                        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                        NpmUsedModulesInstalledInspection.Reporter errorReporter = this.createReporter(psiElementForError, moduleName, false);
                        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, CollectionsKt.listOf((Object)packageJson), true, nodeModulesDirectory, errorReporter);
                        return true;
                    }
                }
                if (StringsKt.startsWith$default((String)moduleName, (String)"@", (boolean)false, (int)2, null)) {
                    return false;
                }
                InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                InstallNodeModuleQuickFix.ModuleElement moduleElementWrapper2 = new InstallNodeModuleQuickFix.ModuleElement(moduleElement, moduleName, expectedTypesName, psiElementForError){
                    final /* synthetic */ InstallNodeModuleQuickFix.ModuleElement $moduleElement;
                    final /* synthetic */ String $moduleName;
                    final /* synthetic */ String $expectedTypesName;
                    final /* synthetic */ PsiElement $psiElementForError;

                    @Nullable
                    public String getModuleName() {
                        return Intrinsics.areEqual((Object)this.$moduleElement.getModuleName(), (Object)this.$moduleName) ? this.$expectedTypesName : null;
                    }

                    @NotNull
                    public Project getProject() {
                        Project project = this.$psiElementForError.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiElementForError.project");
                        return project;
                    }
                    {
                        this.$moduleElement = $captured_local_variable$0;
                        this.$moduleName = $captured_local_variable$1;
                        this.$expectedTypesName = $captured_local_variable$2;
                        this.$psiElementForError = $captured_local_variable$3;
                    }
                };
                this.registerErrorWithFixes(packageJson, moduleElementWrapper2, psiElementForError, moduleName, resolveImportModules);
                return true;
            }

            private final NpmUsedModulesInstalledInspection.Reporter createReporter(PsiElement psiElementForError, String moduleName, boolean infoOnly) {
                return new NpmUsedModulesInstalledInspection.Reporter(this, psiElementForError, moduleName, infoOnly){
                    final /* synthetic */ createVisitor.1 this$0;
                    final /* synthetic */ PsiElement $psiElementForError;
                    final /* synthetic */ String $moduleName;
                    final /* synthetic */ boolean $infoOnly;

                    /*
                     * WARNING - void declaration
                     */
                    public final void reportError(@NotNull String text, @NotNull List<LocalQuickFix> fixes) {
                        LocalQuickFix[] localQuickFixArray;
                        void $this$toTypedArray$iv;
                        ProblemHighlightType problemHighlightType;
                        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                        Intrinsics.checkParameterIsNotNull(fixes, (String)"fixes");
                        TextRange range = TypeScriptCheckImportInspection.access$getRangeForError(this.this$0.this$0, this.$psiElementForError, this.$moduleName);
                        ProblemHighlightType problemHighlightType2 = problemHighlightType = this.$infoOnly ? ProblemHighlightType.INFORMATION : createVisitor.1.access$getProblemHighlightType(this.this$0);
                        if (createVisitor.1.access$shouldIgnoreErrors(this.this$0, problemHighlightType)) {
                            return;
                        }
                        Collection collection = fixes;
                        TextRange textRange = range;
                        ProblemHighlightType problemHighlightType3 = problemHighlightType;
                        String string = text;
                        PsiElement psiElement = this.$psiElementForError;
                        ProblemsHolder problemsHolder = this.this$0.$holder;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                        if (localQuickFixArray2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                        problemsHolder.registerProblem(psiElement, string, problemHighlightType3, textRange, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$psiElementForError = psiElement;
                        this.$moduleName = string;
                        this.$infoOnly = bl;
                    }
                };
            }

            private final void registerErrorWithFixes(VirtualFile packageJson, InstallNodeModuleQuickFix.ModuleElement moduleElementWrapper2, PsiElement psiElementForError, String moduleName, Collection<? extends PsiElement> resolveImportModules) {
                ProblemHighlightType defaultHighlight;
                InstallNodeModuleQuickFix fix = packageJson == null ? new InstallNodeModuleQuickFix(moduleElementWrapper2, CollectionsKt.emptyList()) : (InstallNodeModuleQuickFix)new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElementWrapper2, CollectionsKt.listOf((Object)packageJson));
                TextRange range = TypeScriptCheckImportInspection.access$getRangeForError(this.this$0, psiElementForError, moduleName);
                Collection<? extends PsiElement> collection = resolveImportModules;
                boolean bl = false;
                ProblemHighlightType problemHighlightType = defaultHighlight = !collection.isEmpty() ? ProblemHighlightType.INFORMATION : this.getProblemHighlightType();
                if (this.shouldIgnoreErrors(defaultHighlight)) {
                    return;
                }
                this.$holder.registerProblem(psiElementForError, JavaScriptBundle.message((String)"typescript.types.module.not.installed.warning", (Object[])new Object[]{moduleName}), defaultHighlight, range, new LocalQuickFix[]{fix});
            }

            private final boolean shouldIgnoreErrors(ProblemHighlightType problemHighlightType) {
                return !this.$holder.isOnTheFly() && problemHighlightType == ProblemHighlightType.INFORMATION;
            }

            private final ProblemHighlightType getProblemHighlightType() {
                return this.$isServiceEnabled ? ProblemHighlightType.INFORMATION : ProblemHighlightType.ERROR;
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
                this.$isServiceEnabled = $captured_local_variable$2;
            }

            public static final /* synthetic */ ProblemHighlightType access$getProblemHighlightType(createVisitor.1 $this) {
                return $this.getProblemHighlightType();
            }

            public static final /* synthetic */ boolean access$shouldIgnoreErrors(createVisitor.1 $this, ProblemHighlightType problemHighlightType) {
                return $this.shouldIgnoreErrors(problemHighlightType);
            }
        };
    }

    private final TextRange getRangeForError(PsiElement psiElementForError, String moduleName) {
        int indexOfModuleName = StringUtil.indexOf((CharSequence)psiElementForError.getText(), (CharSequence)moduleName);
        return new TextRange(indexOfModuleName, indexOfModuleName + moduleName.length());
    }

    private final boolean isFileAcceptable(PsiFile file2) {
        return DialectDetector.isTypeScript((PsiElement)file2);
    }

    private final boolean checkConfigIsAcceptable(TypeScriptConfig tsConfig) {
        if (tsConfig == null) {
            return true;
        }
        return tsConfig.getEffectiveResolution() != TypeScriptConfig.ModuleResolution.CLASSIC;
    }

    @Override
    @NotNull
    protected LocalQuickFix[] getFixes(@NotNull ES6ImportExportDeclarationPart importExportPart, @Nullable PsiElement resolveResult, @Nullable String resolveProblemKey) {
        Intrinsics.checkParameterIsNotNull((Object)importExportPart, (String)"importExportPart");
        Object[] result2 = super.getFixes(importExportPart, resolveResult, resolveProblemKey);
        if (importExportPart instanceof ES6ImportedBinding) {
            TypeScriptConfig tsConfig = TypeScriptConfigUtil.getConfigForPsiFile(((ES6ImportedBinding)importExportPart).getContainingFile());
            if (tsConfig == null) {
                return result2;
            }
            if (!tsConfig.allowSyntheticDefaultImports()) {
                LocalQuickFix localQuickFix = this.getEnableOptionFix((ES6ImportedBinding)importExportPart, tsConfig);
                if (localQuickFix == null) {
                    return result2;
                }
                LocalQuickFix fix = localQuickFix;
                boolean bl = false;
                List newResult = new ArrayList();
                CollectionsKt.addAll((Collection)newResult, (Object[])result2);
                newResult.add(fix);
                Collection $this$toTypedArray$iv = newResult;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (localQuickFixArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return localQuickFixArray;
            }
        }
        return result2;
    }

    private final boolean isAcceptableModule(PsiElement it) {
        if (DialectDetector.isTypeScript(it)) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)it);
        return virtualFile != null && !JSLibraryUtil.isProbableLibraryFile(virtualFile);
    }

    private final LocalQuickFix getEnableOptionFix(ES6ImportedBinding importExportPart, TypeScriptConfig tsConfig) {
        ES6ImportDeclaration eS6ImportDeclaration = importExportPart.getDeclaration();
        if (eS6ImportDeclaration == null || (eS6ImportDeclaration = eS6ImportDeclaration.getFromClause()) == null) {
            return null;
        }
        ES6ImportDeclaration fromClause = eS6ImportDeclaration;
        Collection collection = fromClause.resolveReferencedElements();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fromClause.resolveReferencedElements()");
        Collection resolveReferencedElements = collection;
        if (resolveReferencedElements.isEmpty()) {
            return null;
        }
        boolean preferAllow = true;
        for (PsiElement module : resolveReferencedElements) {
            if (!(module instanceof PsiFile) || TypeScriptUtil.isDefinitionFile((PsiFile)module)) continue;
            if (TypeScriptPsiUtil.findExportAssignment(module) == null) {
                return null;
            }
            preferAllow = false;
        }
        boolean configHasESInterop = tsConfig.hasCompilerOption("esModuleInterop");
        String optionName = !configHasESInterop && preferAllow ? "allowSyntheticDefaultImports" : "esModuleInterop";
        return new TypeScriptConfigEnableOptionFix(optionName, JsonSchemaType._boolean, "true");
    }

    public static final /* synthetic */ boolean access$checkConfigIsAcceptable(TypeScriptCheckImportInspection $this, TypeScriptConfig tsConfig) {
        return $this.checkConfigIsAcceptable(tsConfig);
    }

    public static final /* synthetic */ boolean access$isAcceptableModule(TypeScriptCheckImportInspection $this, PsiElement it) {
        return $this.isAcceptableModule(it);
    }

    public static final /* synthetic */ TextRange access$getRangeForError(TypeScriptCheckImportInspection $this, PsiElement psiElementForError, String moduleName) {
        return $this.getRangeForError(psiElementForError, moduleName);
    }
}

