/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSComplexityAwareRecursionGuard<K> {
    @NotNull
    private final RecursionGuard<K> myDelegate;

    public JSComplexityAwareRecursionGuard(@NotNull @NonNls String id) {
        if (id == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(0);
        }
        this.myDelegate = RecursionManager.createGuard((String)id);
    }

    @Nullable
    public <V> V getCachedValue(@NotNull K place, @NotNull JSEvaluatorComplexityTracker complexityTracker, @NotNull Supplier<@Nullable JSComplexityAwareCachedValue<V>> getValueFromCache, @NotNull @NotNull Consumer<@NotNull JSComplexityAwareCachedValue<V>> cacheNewValue, @NotNull Function<K, V> provider) {
        if (place == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(1);
        }
        if (complexityTracker == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(2);
        }
        if (getValueFromCache == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(3);
        }
        if (cacheNewValue == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(5);
        }
        int initialComplexityLeft = complexityTracker.getComplexityLeft();
        JSComplexityAwareCachedValue<V> valueFromCache = getValueFromCache.get();
        if (valueFromCache != null && ((JSComplexityAwareCachedValue)valueFromCache).myComplexityUsed <= initialComplexityLeft) {
            complexityTracker.useComplexity(((JSComplexityAwareCachedValue)valueFromCache).myComplexityUsed);
            return (V)((JSComplexityAwareCachedValue)valueFromCache).myValue;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        V value = this.doPreventingRecursion(place, true, () -> provider.apply(place));
        if (value == null) {
            return null;
        }
        if (stamp.mayCacheNow()) {
            cacheNewValue.accept(new JSComplexityAwareCachedValue(initialComplexityLeft - complexityTracker.getComplexityLeft(), value));
        }
        return value;
    }

    @Nullable
    public static <V> V getCachedValue(@NotNull JSEvaluatorComplexityTracker complexityTracker, @NotNull Supplier<? extends V> calculate, @NotNull CachingEvaluator calculateWithCaching) {
        int initialComplexityLeft;
        Supplier<JSComplexityAwareCachedValue> resolverWithComplexityCheck;
        JSComplexityAwareCachedValue resultWithComplexity;
        if (complexityTracker == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(6);
        }
        if (calculate == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(7);
        }
        if (calculateWithCaching == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(8);
        }
        if ((resultWithComplexity = calculateWithCaching.calculateWithCaching(resolverWithComplexityCheck = () -> JSComplexityAwareRecursionGuard.lambda$getCachedValue$1(calculate, initialComplexityLeft = complexityTracker.getComplexityLeft(), complexityTracker))) == null) {
            return null;
        }
        if (complexityTracker.getComplexityLeft() == initialComplexityLeft) {
            if (initialComplexityLeft >= resultWithComplexity.myComplexityUsed) {
                complexityTracker.useComplexity(resultWithComplexity.myComplexityUsed);
                return (V)resultWithComplexity.getValue();
            }
            return calculate.get();
        }
        return (V)resultWithComplexity.getValue();
    }

    @Nullable
    public <V> V doPreventingRecursion(@NotNull K place, boolean memoize, @NotNull Computable<? extends V> computation) {
        if (place == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(9);
        }
        if (computation == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(10);
        }
        return (V)this.myDelegate.doPreventingRecursion(place, memoize, computation);
    }

    private static /* synthetic */ JSComplexityAwareCachedValue lambda$getCachedValue$1(Supplier calculate, int initialComplexityLeft, JSEvaluatorComplexityTracker complexityTracker) {
        Object value = calculate.get();
        return new JSComplexityAwareCachedValue(initialComplexityLeft - complexityTracker.getComplexityLeft(), value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "complexityTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getValueFromCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheNewValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculateWithCaching";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSComplexityAwareRecursionGuard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doPreventingRecursion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class JSComplexityAwareCachedValue<K> {
        private final int myComplexityUsed;
        private final K myValue;

        private JSComplexityAwareCachedValue(int complexityUsed, @NotNull K value) {
            if (value == null) {
                JSComplexityAwareCachedValue.$$$reportNull$$$0(0);
            }
            if (complexityUsed < 0) {
                throw new IllegalArgumentException("complexityUsed = " + complexityUsed);
            }
            this.myComplexityUsed = complexityUsed;
            this.myValue = value;
        }

        @NotNull
        public K getValue() {
            K k = this.myValue;
            if (k == null) {
                JSComplexityAwareCachedValue.$$$reportNull$$$0(1);
            }
            return k;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSComplexityAwareRecursionGuard$JSComplexityAwareCachedValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSComplexityAwareRecursionGuard$JSComplexityAwareCachedValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface CachingEvaluator {
        public <T> T calculateWithCaching(Supplier<T> var1);
    }
}

