/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSResolveScopeProvider
extends ResolveScopeProvider {
    private static final Key<ProjectScopeWrapper> PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY = Key.create((String)"js.project.scope.with.predefined.language.specific");

    @NotNull
    public final GlobalSearchScope getProjectScopeIncludingPredefines(@NotNull Project project) {
        ProjectScopeWrapper wrapper;
        if (project == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if ((wrapper = (ProjectScopeWrapper)project.getUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY)) == null || !wrapper.isUpToDate()) {
            wrapper = new ProjectScopeWrapper(project);
            project.putUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY, (Object)wrapper);
        }
        Class<?> aClass = ((Object)((Object)this)).getClass();
        GlobalSearchScope scope = (GlobalSearchScope)wrapper.myScopeByClassMap.get(aClass);
        if (scope == null) {
            List<VirtualFile> predefinedLibraryFiles = this.getPredefinedLibraryFiles(project);
            scope = GlobalSearchScope.filesScope((Project)project, predefinedLibraryFiles).uniteWith(GlobalSearchScope.allScope((Project)project));
            wrapper.myScopeByClassMap.put(aClass, scope);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    protected GlobalSearchScope getProjectAndLibrariesScope(@NotNull VirtualFile file2, @NotNull Project project, @NotNull Set<VirtualFile> includedFiles, @NotNull Set<VirtualFile> excludedFiles) {
        Module module;
        if (file2 == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if (includedFiles == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(4);
        }
        if (excludedFiles == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(5);
        }
        if ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file2)) == null) {
            HashSet<VirtualFile> files = new HashSet<VirtualFile>(includedFiles);
            files.removeAll(excludedFiles);
            GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(project).uniteWith(GlobalSearchScope.filesScope((Project)project, files));
            if (globalSearchScope == null) {
                JSResolveScopeProvider.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        GlobalSearchScope scopeExcludingJsLibs = (GlobalSearchScope)((CachedValue)JSResolveUtil.ourScopeCache.get((UserDataHolder)module, null)).getValue();
        GlobalSearchScope libraryFilesScope = JSLibraryMappings.getInstance(project).getLibraryScopeForFileWithoutPredefined(file2, includedFiles, excludedFiles);
        GlobalSearchScope globalSearchScope = scopeExcludingJsLibs.uniteWith(libraryFilesScope);
        if (globalSearchScope == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    protected List<VirtualFile> getPredefinedLibraryFiles(@NotNull Project project) {
        if (project == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(8);
        }
        THashSet libFiles2 = new THashSet();
        libFiles2.addAll((Collection)ScriptingLibraryManager.getAllLibraryFiles((Project)project, JSLibraryKind.INSTANCE));
        libFiles2.addAll(JSPredefinedLibraryManager.getPredefinedLibraryManager(project).getPredefinedLibraryFilesForResolve());
        List list2 = ContainerUtil.filter((Collection)libFiles2, this::isApplicablePredefinedLibraryFile);
        if (list2 == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(9);
        }
        return list2;
    }

    protected abstract boolean isApplicablePredefinedLibraryFile(@NotNull VirtualFile var1);

    @Nullable
    public static VirtualFile getFileForScopeEvaluation(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            JSResolveScopeProvider.$$$reportNull$$$0(10);
        }
        if ((containingFile = element.getContainingFile()) == null) {
            return null;
        }
        return containingFile.getOriginalFile().getViewProvider().getVirtualFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveScopeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveScopeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectScopeIncludingPredefines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectAndLibrariesScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectScopeIncludingPredefines";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectAndLibrariesScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileForScopeEvaluation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectScopeWrapper {
        private final ModificationTracker myTracker;
        private final Map<Class<?>, GlobalSearchScope> myScopeByClassMap;
        private final long myCreationModCount;

        private ProjectScopeWrapper(@NotNull Project project) {
            if (project == null) {
                ProjectScopeWrapper.$$$reportNull$$$0(0);
            }
            this.myScopeByClassMap = ContainerUtil.newConcurrentMap();
            this.myTracker = ProjectRootManager.getInstance((Project)project);
            this.myCreationModCount = this.myTracker.getModificationCount();
        }

        public boolean isUpToDate() {
            return this.myCreationModCount == this.myTracker.getModificationCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/resolve/JSResolveScopeProvider$ProjectScopeWrapper", "<init>"));
        }
    }
}

