/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.context;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyCallElement
implements JSApplyContextElement {
    @NotNull
    private final JSCallItem myCallItem;
    @Nullable
    private final JSExpression myMethodExpression;

    JSApplyCallElement(@NotNull JSCallItem callItem) {
        if (callItem == null) {
            JSApplyCallElement.$$$reportNull$$$0(0);
        }
        this(callItem, callItem instanceof JSCallLikeExpression ? ((JSCallLikeExpression)callItem).getMethodExpression() : null);
    }

    private JSApplyCallElement(@NotNull JSCallItem callItem, @Nullable JSExpression methodExpression) {
        if (callItem == null) {
            JSApplyCallElement.$$$reportNull$$$0(1);
        }
        this.myCallItem = callItem;
        this.myMethodExpression = methodExpression;
    }

    @Nullable
    public JSExpression getMethodExpression() {
        return this.myMethodExpression;
    }

    @NotNull
    public JSCallItem getCallItem() {
        JSCallItem jSCallItem = this.myCallItem;
        if (jSCallItem == null) {
            JSApplyCallElement.$$$reportNull$$$0(2);
        }
        return jSCallItem;
    }

    @NotNull
    public static JSApplyCallElement fromTaggedTemplateExpression(@NotNull ES6TaggedTemplateExpression expression) {
        if (expression == null) {
            JSApplyCallElement.$$$reportNull$$$0(3);
        }
        return new JSApplyCallElement((JSCallItem)expression);
    }

    @NotNull
    public static JSApplyCallElement fromCall(@NotNull JSCallExpression callExpression, @Nullable JSExpression methodExpression) {
        if (callExpression == null) {
            JSApplyCallElement.$$$reportNull$$$0(4);
        }
        assert (!(callExpression instanceof JSNewExpression)) : "use JSApplyInstanceContext for 'new' expressions";
        if (methodExpression == null) {
            methodExpression = callExpression.getMethodExpression();
        }
        return new JSApplyCallElement((JSCallItem)callExpression, methodExpression);
    }

    @NotNull
    public static JSApplyCallElement fromContextStubSafe(@NotNull PsiElement context) {
        if (context == null) {
            JSApplyCallElement.$$$reportNull$$$0(5);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context, false);
        return new JSApplyCallElement(new JSApplyCallType(new JSSpreadTypeImpl(typeSource, JSAnyType.get(typeSource)), typeSource));
    }

    @NotNull
    public static JSApplyCallElement fromMethodExpressionStubSafe(@NotNull JSExpression methodExpression) {
        if (methodExpression == null) {
            JSApplyCallElement.$$$reportNull$$$0(6);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)methodExpression, false);
        return new JSApplyCallElement(new JSApplyCallType(new JSSpreadTypeImpl(typeSource, JSAnyType.get(typeSource)), typeSource));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyCallElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyCallElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromTaggedTemplateExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromContextStubSafe";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromMethodExpressionStubSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

