/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JSNamedObjectStubBase<T extends JSPsiNamedElementBase>
extends JSStubBase<T>
implements JSStubElement<T> {
    protected static final BooleanStructureElement IS_SYMBOL_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(IS_SYMBOL_FLAG);
    protected final String myName;

    protected JSNamedObjectStubBase(T psiElement, StubElement parent, @NotNull JSStubElementType<?, T> elementType) {
        if (elementType == null) {
            JSNamedObjectStubBase.$$$reportNull$$$0(0);
        }
        super(psiElement, parent, (IStubElementType)elementType);
        this.writeFlag(IS_SYMBOL_FLAG, elementType.shouldIndexSymbol(psiElement));
        this.myName = psiElement.getName();
    }

    protected JSNamedObjectStubBase(String name, StubElement parent, @NotNull IStubElementType elementType) {
        if (elementType == null) {
            JSNamedObjectStubBase.$$$reportNull$$$0(1);
        }
        super(parent, elementType);
        this.myName = name;
        this.writeFlag(IS_SYMBOL_FLAG, Boolean.TRUE);
    }

    protected JSNamedObjectStubBase(StubInputStream dataStream, StubElement parentStub, IStubElementType elementType) throws IOException {
        super(dataStream, parentStub, elementType);
        this.myName = dataStream.readNameString();
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        dataStream.writeName(this.myName);
    }

    public String getName() {
        return this.myName;
    }

    public void index(IndexSink sink) {
        String name = this.getName();
        IStubElementType type = this.getStubType();
        if (name != null && type instanceof JSStubElementType && this.readFlag(IS_SYMBOL_FLAG).booleanValue()) {
            sink.occurrence(JSSymbolIndex2.KEY, (Object)name);
            if (this.doIndexGlobalSymbol()) {
                sink.occurrence(JSGlobalSymbolIndex.KEY, (Object)name);
            }
            if (this.doIndexNonGlobalSymbol()) {
                sink.occurrence(JSNonGlobalSymbolIndex.KEY, (Object)name);
            }
        }
    }

    protected boolean doIndexGlobalSymbol() {
        return true;
    }

    protected boolean doIndexNonGlobalSymbol() {
        return true;
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSNamedObjectStubBase.$$$reportNull$$$0(2);
        }
        return flagsStructure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSNamedObjectStubBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSNamedObjectStubBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

