/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.convertToClass.ClassInheritanceNode;
import com.intellij.lang.javascript.refactoring.convertToClass.InheritanceBuilder;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassConvertor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSToClassConversionConstructorFunction;
import com.intellij.lang.javascript.refactoring.convertToClass.JSToClassConversionResults;
import com.intellij.lang.javascript.refactoring.convertToClass.ReferenceUnbounder;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSItemToClassDataProcessor {
    private final JSAssignmentExpression myParentAssignment;
    private final JSToClassConversionConstructorFunction myConstructorFunction;
    private final Map<String, JSAssignmentExpression> myStaticDeclarations;
    private final Map<String, JSAssignmentExpression> myMemberDeclarations;
    private final Map<String, Pair<JSFunction, JSFunction>> myMemberPropertyDeclarations;
    private final Map<String, JSObjectLiteralExpression> myMemberProps;
    private final Map<String, JSObjectLiteralExpression> myStaticProps;
    private final Map<String, JSItemToClassDataProcessor> myChildConvertors;
    private final MultiMap<ReferenceUnbounder.Case, PairProcessor<JSReferenceExpression, UsageInfo>> myUsageInfoProcessors;
    private final ReferenceUnbounder myReferenceUnbounder;
    private final InheritanceBuilder myInheritanceBuilder;
    private final JSToClassConversionResults myConversionResults;
    private final List<JSExpression> myRemoveOld;
    private final Map<PsiElement, PsiElement> myFilePlace;
    private final Set<PsiElement> myFormerConstructorParts;

    public JSItemToClassDataProcessor(@NotNull JSFunction function2, @Nullable JSAssignmentExpression assignment, @Nullable String functionName) {
        if (function2 == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(0);
        }
        this.myStaticDeclarations = new HashMap<String, JSAssignmentExpression>();
        this.myMemberDeclarations = new HashMap<String, JSAssignmentExpression>();
        this.myMemberPropertyDeclarations = new HashMap<String, Pair<JSFunction, JSFunction>>();
        this.myMemberProps = new HashMap<String, JSObjectLiteralExpression>();
        this.myStaticProps = new HashMap<String, JSObjectLiteralExpression>();
        this.myChildConvertors = new HashMap<String, JSItemToClassDataProcessor>();
        this.myUsageInfoProcessors = new MultiMap();
        this.myFilePlace = new HashMap<PsiElement, PsiElement>();
        this.myFormerConstructorParts = new HashSet<PsiElement>();
        this.myConstructorFunction = new JSToClassConversionConstructorFunction(function2, functionName);
        this.myParentAssignment = assignment;
        this.myInheritanceBuilder = new InheritanceBuilder();
        this.initUsageInfoProcessors();
        this.myReferenceUnbounder = new ReferenceUnbounder(this.myUsageInfoProcessors);
        this.myRemoveOld = new ArrayList<JSExpression>();
        this.myConversionResults = new JSToClassConversionResults();
    }

    public Map<String, JSAssignmentExpression> getStaticDeclarations() {
        return this.myStaticDeclarations;
    }

    public Map<String, JSAssignmentExpression> getMemberDeclarations() {
        return this.myMemberDeclarations;
    }

    public Map<String, Pair<JSFunction, JSFunction>> getMemberPropertyDeclarations() {
        return this.myMemberPropertyDeclarations;
    }

    public Map<String, JSObjectLiteralExpression> getMemberProps() {
        return this.myMemberProps;
    }

    public Map<String, JSObjectLiteralExpression> getStaticProps() {
        return this.myStaticProps;
    }

    public Map<String, JSItemToClassDataProcessor> getChildConvertors() {
        return this.myChildConvertors;
    }

    public JSToClassConversionResults getConversionResults() {
        return this.myConversionResults;
    }

    public List<JSExpression> getRemoveOld() {
        return this.myRemoveOld;
    }

    public JSToClassConversionConstructorFunction getConstructorFunction() {
        return this.myConstructorFunction;
    }

    public JSAssignmentExpression getParentAssignment() {
        return this.myParentAssignment;
    }

    public Map<PsiElement, PsiElement> getFilePlace() {
        return this.myFilePlace;
    }

    public InheritanceBuilder getInheritanceBuilder() {
        return this.myInheritanceBuilder;
    }

    void usedAsError(@NotNull List<JSReferenceExpression> usedAsError) {
        if (usedAsError == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(1);
        }
        for (JSReferenceExpression reference : usedAsError) {
            PsiElement parent = reference.getParent();
            if (parent instanceof JSReferenceExpression) {
                JSItemToClassDataProcessor convertor;
                String referenceName = ((JSReferenceExpression)parent).getReferenceName();
                if ("prototype".equals(referenceName) || "__proto__".equals(referenceName) || (convertor = this.myChildConvertors.get(referenceName)) == null) continue;
                convertor.usedAsError(Collections.singletonList((JSReferenceExpression)parent));
                continue;
            }
            this.myInheritanceBuilder.usedAsError();
        }
    }

    void extractFunctionDeclarationsFromConstructorBlock() {
        this.myConstructorFunction.replaceUsedParameters();
        for (JSAssignmentExpression expression : this.myConstructorFunction.getOnlyFunctions()) {
            String name;
            Pair<String, Boolean> pair = this.checkAssignmentForDuplication(new UsageInfo((PsiElement)expression), expression, JSToClassConversionResults.PropertyDefinitionType.value);
            if (pair == null || !Boolean.TRUE.equals(pair.getSecond()) || (name = expression.getDefinitionExpression().getName()) == null) continue;
            this.myMemberDeclarations.put(name, expression);
            this.myFormerConstructorParts.add((PsiElement)expression);
            this.myFilePlace.put((PsiElement)expression, JSItemToClassConvertor.deleteMovedDeclaration((PsiElement)expression));
            this.myConstructorFunction.removeInnerProperty(name);
        }
    }

    public String createExtendsClause() {
        String extendsTarget = this.myInheritanceBuilder.getExtendsTarget();
        if (StringUtil.isEmptyOrSpaces((String)extendsTarget)) {
            return " ";
        }
        if (this.myInheritanceBuilder.getExtendsDeclaringExpression() != null) {
            this.myRemoveOld.add(this.myInheritanceBuilder.getExtendsDeclaringExpression());
        }
        return " extends " + extendsTarget + " ";
    }

    public void filterDuplicatesAndNotSelected(@NotNull List<PsiElement> selectedUsages) {
        if (selectedUsages == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(2);
        }
        for (String key : this.myConversionResults.filterDuplicates(this.myConstructorFunction)) {
            this.myMemberProps.remove(key);
            this.myStaticProps.remove(key);
            this.myMemberDeclarations.remove(key);
            this.myStaticDeclarations.remove(key);
        }
        this.filterMap(this.myMemberProps, selectedUsages);
        this.filterMap(this.myStaticProps, selectedUsages);
        this.filterMap(this.myMemberDeclarations, selectedUsages);
        this.filterMap(this.myStaticDeclarations, selectedUsages);
    }

    private <T extends PsiElement> void filterMap(@NotNull Map<String, T> map, @NotNull List<PsiElement> selectedUsages) {
        if (map == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(3);
        }
        if (selectedUsages == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(4);
        }
        Iterator<Map.Entry<String, T>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            JSSourceElement sourceElement;
            Map.Entry<String, T> next = iterator.next();
            boolean found = false;
            PsiElement value = (PsiElement)next.getValue();
            if (this.myFormerConstructorParts.contains(value)) continue;
            if (this.myFilePlace.containsKey(value)) {
                value = this.myFilePlace.get(value);
            }
            value = (sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)value, JSSourceElement.class)) == null ? value : sourceElement;
            for (PsiElement usage : selectedUsages) {
                if (usage == null || !PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)usage, (boolean)false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public boolean canBeConvertedToStaticDeclaration() {
        if (!(this.myMemberDeclarations.isEmpty() && this.myChildConvertors.isEmpty() && this.myMemberProps.isEmpty() && this.myStaticProps.isEmpty())) {
            return false;
        }
        if (this.myInheritanceBuilder.hasBase()) {
            return false;
        }
        return this.myConstructorFunction.isEmpty();
    }

    public List<Pair<String, UsageInfo>> prepareAndFindConflicts(@NotNull List<UsageInfo> usagesList, List<JSReferenceExpression> usedAsError) {
        if (usagesList == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.processUsages(ContainerUtil.mapNotNull((Collection)usagesList, info -> {
            PsiReference reference = info.getReference();
            if (!(reference instanceof JSReferenceExpression)) {
                return null;
            }
            return Pair.create((Object)((JSReferenceExpression)reference), (Object)info);
        })));
        this.usedAsError(usedAsError);
        return this.myConversionResults.previewDuplicates(this.myConstructorFunction);
    }

    public void convertToStaticDeclarationsAndSuperCalls() {
        this.myInheritanceBuilder.findAndConvertSuperCalls(this.myConstructorFunction.getFunction(), this.myMemberDeclarations);
        Iterator<Map.Entry<String, JSItemToClassDataProcessor>> iterator = this.myChildConvertors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JSItemToClassDataProcessor> next = iterator.next();
            JSItemToClassDataProcessor convertor = next.getValue();
            convertor.convertToStaticDeclarationsAndSuperCalls();
            if (!convertor.canBeConvertedToStaticDeclaration()) continue;
            this.myStaticDeclarations.put(next.getKey(), convertor.myParentAssignment);
            iterator.remove();
        }
    }

    void processUsages(@NotNull List<Pair<JSReferenceExpression, UsageInfo>> usagesList) {
        if (usagesList == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(6);
        }
        for (Pair<JSReferenceExpression, UsageInfo> pair : usagesList) {
            if (this.myReferenceUnbounder.processReferenceRecursively((JSReferenceExpression)pair.getFirst(), (UsageInfo)pair.getSecond())) continue;
            this.myConversionResults.notConverted((UsageInfo)pair.getSecond());
        }
        this.myReferenceUnbounder.formChildConvertors(this.myChildConvertors, this.myConversionResults);
    }

    @Nullable
    Pair<String, Boolean> checkAssignmentForDuplication(@NotNull UsageInfo usageInfo, @NotNull JSAssignmentExpression assignment, @NotNull JSToClassConversionResults.PropertyDefinitionType definitionType) {
        String newName;
        if (usageInfo == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(7);
        }
        if (assignment == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(8);
        }
        if (definitionType == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(9);
        }
        if (assignment.getDefinitionExpression() == null) {
            return null;
        }
        JSExpression expression = assignment.getDefinitionExpression().getExpression();
        if (!(expression instanceof JSReferenceExpression)) {
            return null;
        }
        return Pair.create((Object)newName, (Object)(!this.myConversionResults.isDuplicate(newName = StringUtil.notNullize((String)((JSReferenceExpression)expression).getReferenceName()), usageInfo, definitionType) ? 1 : 0));
    }

    private void initUsageInfoProcessors() {
        this.addAssignmentCases();
        this.addPropertyDefinitionCases();
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._static, (reference, info) -> {
            if (reference.getParent() instanceof JSNewExpression) {
                return this.myInheritanceBuilder.usedAsBasePrototypeConstructor((JSReferenceExpression)reference);
            }
            if (this.myInheritanceBuilder.usedAsBaseInInheritsCall((JSReferenceExpression)reference)) {
                return true;
            }
            return this.myInheritanceBuilder.parseInheritsCall((PsiReference)reference);
        });
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._prototype, (reference, info) -> {
            if (this.myInheritanceBuilder.usedAsBaseInPrototypeAssignmentMethods((JSReferenceExpression)reference)) {
                return true;
            }
            return this.myInheritanceBuilder.parseSetPrototype((PsiReference)reference);
        });
    }

    private void addAssignmentCases() {
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._prototype, (reference, info) -> {
            if (reference.getParent() instanceof JSAssignmentExpression) {
                return this.myInheritanceBuilder.usedAsBaseInAssignment((JSReferenceExpression)reference);
            }
            JSAssignmentExpression assignment = ClassInheritanceNode.findParentAssignment((PsiReference)reference);
            if (assignment == null || assignment.getDefinitionExpression() == null) {
                return false;
            }
            JSExpression initializer = assignment.getDefinitionExpression().getInitializer();
            if (initializer instanceof JSObjectLiteralExpression) {
                return this.addPrototypeChildren((UsageInfo)info, assignment);
            }
            return this.myInheritanceBuilder.tryToParsePrototypeAssignment(assignment, (PairConsumer<String, JSObjectLiteralExpression>)((PairConsumer)(propName, literal) -> {
                if (this.myConversionResults.isDuplicate((String)propName, new UsageInfo(literal.getParent()), JSToClassConversionResults.PropertyDefinitionType.value)) {
                    return;
                }
                this.myMemberProps.put((String)propName, (JSObjectLiteralExpression)literal);
            }));
        });
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._proto, (reference, info) -> {
            JSAssignmentExpression assignment = ClassInheritanceNode.findParentAssignment((PsiReference)reference);
            if (assignment == null || assignment.getDefinitionExpression() == null) {
                return false;
            }
            if (reference.getQualifier() instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)reference.getQualifier()).getReferenceName())) {
                return this.myInheritanceBuilder.tryToParseProtoAssignment(assignment);
            }
            return false;
        });
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._member, (reference, info) -> {
            JSAssignmentExpression assignment = ClassInheritanceNode.findParentAssignment((PsiReference)reference);
            if (assignment == null || assignment.getDefinitionExpression() == null) {
                return false;
            }
            if ("constructor".equals(reference.getReferenceName())) {
                return this.removeSelfConstructorAssignment(assignment, assignment.getDefinitionExpression().getInitializer());
            }
            if (reference.getQualifier() instanceof JSReferenceExpression) {
                return this.addMemberChild((UsageInfo)info, assignment, (JSReferenceExpression)reference.getQualifier(), false, false);
            }
            return false;
        });
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._static, (reference, info) -> {
            JSAssignmentExpression assignment = ClassInheritanceNode.findParentAssignment((PsiReference)reference);
            if (assignment == null || assignment.getDefinitionExpression() == null) {
                return false;
            }
            if (this.myConstructorFunction.getFunction().equals(assignment.getDefinitionExpression().getInitializer())) {
                return false;
            }
            if (reference.getReferenceName() != null) {
                return this.addStaticChild((UsageInfo)info, reference.getReferenceName(), assignment);
            }
            return false;
        });
    }

    private void addPropertyDefinitionCases() {
        PairProcessor common = (reference, consumer) -> {
            List<Pair<String, JSObjectLiteralExpression>> list2 = JSItemToClassDataProcessor.parseDefineProperty((PsiReference)reference);
            if (list2 != null) {
                boolean everythingCorrect = true;
                for (Pair<String, JSObjectLiteralExpression> pair : list2) {
                    if (consumer.process(pair)) continue;
                    everythingCorrect = false;
                }
                return everythingCorrect;
            }
            return false;
        };
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._prototype, (reference, info) -> common.process(reference, pair -> {
            String name = (String)pair.getFirst();
            if (this.myConversionResults.isDuplicate(name, (UsageInfo)info, JSToClassConversionResults.PropertyDefinitionType.value)) {
                return true;
            }
            this.myMemberProps.put(name, (JSObjectLiteralExpression)pair.getSecond());
            return true;
        }));
        this.myUsageInfoProcessors.putValue((Object)ReferenceUnbounder.Case._static, (reference, info) -> common.process(reference, pair -> {
            String name = (String)pair.getFirst();
            if (this.myConversionResults.isDuplicate(name, (UsageInfo)info, JSToClassConversionResults.PropertyDefinitionType.value)) {
                return true;
            }
            this.myStaticProps.put(name, (JSObjectLiteralExpression)pair.getSecond());
            return true;
        }));
    }

    private boolean removeSelfConstructorAssignment(@NotNull JSAssignmentExpression assignment, JSExpression initializer) {
        if (assignment == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(10);
        }
        if (initializer instanceof JSReferenceExpression && this.myConstructorFunction.getFunctionName().equals(((JSReferenceExpression)initializer).getReferenceName()) && ((JSReferenceExpression)initializer).getQualifier() == null) {
            this.myRemoveOld.add((JSExpression)assignment);
            return true;
        }
        return false;
    }

    @Nullable
    private static List<Pair<String, JSObjectLiteralExpression>> parseDefineProperty(@NotNull PsiReference reference) {
        PsiReference topReference;
        if (reference == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(11);
        }
        if (!((topReference = JSConvertToClassProcessor.getTopReference(reference)) instanceof PsiElement)) {
            return null;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        if (parent instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression) {
            JSArgumentList list2 = (JSArgumentList)parent;
            JSCallExpression call = (JSCallExpression)parent.getParent();
            if (JSConvertToClassProcessor.checkForObjectMethod(call.getMethodExpression(), "defineProperty") && list2.getArguments().length == 3) {
                JSExpression[] arguments = list2.getArguments();
                if (!PsiTreeUtil.isAncestor((PsiElement)arguments[0], (PsiElement)((PsiElement)topReference), (boolean)false)) {
                    return null;
                }
                JSReferenceExpression expression = (JSReferenceExpression)ObjectUtils.tryCast((Object)arguments[0], JSReferenceExpression.class);
                JSLiteralExpression nameLiteral = (JSLiteralExpression)ObjectUtils.tryCast((Object)arguments[1], JSLiteralExpression.class);
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)arguments[2], JSObjectLiteralExpression.class);
                if (expression == null || nameLiteral == null || object == null) {
                    return null;
                }
                if (!nameLiteral.isQuotedLiteral()) {
                    return null;
                }
                return Collections.singletonList(Pair.create((Object)StringUtil.unquoteString((String)nameLiteral.getText()), (Object)object));
            }
            if (JSConvertToClassProcessor.checkForObjectMethod(call.getMethodExpression(), "defineProperties") && list2.getArguments().length == 2) {
                JSExpression[] arguments = list2.getArguments();
                if (!PsiTreeUtil.isAncestor((PsiElement)arguments[0], (PsiElement)((PsiElement)topReference), (boolean)false)) {
                    return null;
                }
                JSReferenceExpression expression = (JSReferenceExpression)ObjectUtils.tryCast((Object)arguments[0], JSReferenceExpression.class);
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)arguments[1], JSObjectLiteralExpression.class);
                if (expression == null || object == null) {
                    return null;
                }
                JSProperty[] properties = object.getProperties();
                ArrayList<Pair<String, JSObjectLiteralExpression>> result2 = new ArrayList<Pair<String, JSObjectLiteralExpression>>();
                for (JSProperty property : properties) {
                    if (!(property.getValue() instanceof JSObjectLiteralExpression)) continue;
                    result2.add((Pair<String, JSObjectLiteralExpression>)Pair.create((Object)property.getName(), (Object)((JSObjectLiteralExpression)property.getValue())));
                }
                return result2;
            }
        }
        return null;
    }

    private boolean addPrototypeChildren(UsageInfo usageInfo, @NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(12);
        }
        if (assignment.getDefinitionExpression() == null || !(assignment.getDefinitionExpression().getInitializer() instanceof JSObjectLiteralExpression)) {
            return false;
        }
        JSObjectLiteralExpression initializer = (JSObjectLiteralExpression)assignment.getDefinitionExpression().getInitializer();
        JSProperty[] properties = initializer.getProperties();
        boolean success = true;
        for (JSProperty property : properties) {
            PsiElement replacement;
            PsiComment docComment;
            JSExpressionStatement statement = JSPsiElementFactory.createJSStatement("prototype." + property.getName() + "= 1;", (PsiElement)property, JSExpressionStatement.class);
            if (!property.isGetProperty() && !property.isSetProperty() && (docComment = JSDocumentationUtils.findDocComment((PsiElement)property)) != null) {
                JSDocumentationUtils.copyJSDocComment(docComment, (PsiElement)statement);
            }
            JSAssignmentExpression expression = (JSAssignmentExpression)statement.getExpression();
            if (property instanceof JSFunctionProperty && !property.isGetProperty() && !property.isSetProperty()) {
                replacement = JSFunctionsRefactoringUtil.createAnonymousFunctionExpression((JSFunction)((JSFunctionProperty)property));
            } else if (property.tryGetFunctionInitializer() == property) {
                replacement = property.copy();
            } else {
                if (property.getValue() == null) {
                    return false;
                }
                replacement = property.getValue().copy();
            }
            JSDefinitionExpression definition = expression.getDefinitionExpression();
            assert (definition != null);
            assert (definition.getInitializer() != null);
            definition.getInitializer().replace(replacement);
            assert (definition.getExpression() != null);
            JSReferenceExpression prototypeReference = (JSReferenceExpression)definition.getExpression().getFirstChild();
            if (property.tryGetFunctionInitializer() != null && (property.isSetProperty() || property.isGetProperty())) {
                success &= this.addMemberGetterSetter(property.tryGetFunctionInitializer(), property);
                continue;
            }
            this.myFilePlace.put((PsiElement)expression, (PsiElement)property);
            success &= this.addMemberChild(usageInfo, expression, prototypeReference, property.isGetProperty(), property.isSetProperty());
        }
        if (success) {
            this.myRemoveOld.add((JSExpression)assignment);
        }
        return success;
    }

    private boolean addMemberGetterSetter(@NotNull JSFunction initializer, @NotNull JSProperty property) {
        JSFunction etter;
        if (initializer == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(13);
        }
        if (property == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(14);
        }
        assert (property.isSetProperty() || property.isGetProperty());
        String name = StringUtil.notNullize((String)property.getName());
        Pair<JSFunction, JSFunction> functionPair = this.myMemberPropertyDeclarations.get(name);
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)property);
        if (property.isGetProperty()) {
            etter = JSFunctionsRefactoringUtil.createGetter((PsiElement)initializer, initializer, name, false);
            this.myMemberPropertyDeclarations.put(name, (Pair<JSFunction, JSFunction>)Pair.create((Object)etter, (Object)Pair.getSecond(functionPair)));
        } else {
            etter = JSFunctionsRefactoringUtil.createSetter((PsiElement)initializer, initializer, name, false);
            this.myMemberPropertyDeclarations.put(name, (Pair<JSFunction, JSFunction>)Pair.create((Object)Pair.getFirst(functionPair), (Object)etter));
        }
        PsiComment etterComment = JSDocumentationUtils.findDocComment((PsiElement)etter);
        if (docComment != null && etterComment == null) {
            JSDocumentationUtils.copyJSDocComment(docComment, (PsiElement)etter);
        }
        this.myFilePlace.put((PsiElement)etter, (PsiElement)initializer);
        return true;
    }

    public boolean addMemberChild(@NotNull UsageInfo usageInfo, @NotNull JSAssignmentExpression assignment, @NotNull JSReferenceExpression prototypeReference, boolean isGetProperty, boolean isSetProperty) {
        PsiElement grand;
        if (usageInfo == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(15);
        }
        if (assignment == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(16);
        }
        if (prototypeReference == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(17);
        }
        assert ("prototype".equals(prototypeReference.getReferenceName()));
        PsiElement parent = prototypeReference.getParent();
        if (parent instanceof JSReferenceExpression && JSItemToClassDataProcessor.isDefinitionInAssignment(grand = parent.getParent())) {
            JSToClassConversionResults.PropertyDefinitionType definitionType = isGetProperty ? JSToClassConversionResults.PropertyDefinitionType.get : (isSetProperty ? JSToClassConversionResults.PropertyDefinitionType.set : JSToClassConversionResults.PropertyDefinitionType.value);
            Pair<String, Boolean> pair = this.checkAssignmentForDuplication(usageInfo, assignment, definitionType);
            if (pair == null) {
                return false;
            }
            if (!((Boolean)pair.getSecond()).booleanValue()) {
                return true;
            }
            this.myMemberDeclarations.put((String)pair.getFirst(), assignment);
            return true;
        }
        return false;
    }

    public boolean addStaticChild(UsageInfo usageInfo, @NotNull String referenceName, @NotNull JSAssignmentExpression assignment) {
        if (referenceName == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(18);
        }
        if (assignment == null) {
            JSItemToClassDataProcessor.$$$reportNull$$$0(19);
        }
        if (assignment.getDefinitionExpression() != null && assignment.getDefinitionExpression().getInitializer() instanceof JSFunctionExpression) {
            this.myChildConvertors.put(referenceName, new JSItemToClassDataProcessor((JSFunction)assignment.getDefinitionExpression().getInitializer(), assignment, null));
        } else {
            Pair<String, Boolean> pair = this.checkAssignmentForDuplication(usageInfo, assignment, JSToClassConversionResults.PropertyDefinitionType.value);
            if (pair == null) {
                return false;
            }
            if (!((Boolean)pair.getSecond()).booleanValue()) {
                return true;
            }
            this.myStaticDeclarations.put((String)pair.getFirst(), assignment);
        }
        return true;
    }

    private static boolean isDefinitionInAssignment(PsiElement parent) {
        return parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedAsError";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedUsages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesList";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototypeReference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassDataProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "usedAsError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filterDuplicatesAndNotSelected";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "filterMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareAndFindConflicts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processUsages";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignmentForDuplication";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeSelfConstructorAssignment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDefineProperty";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addPrototypeChildren";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addMemberGetterSetter";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addMemberChild";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addStaticChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

