/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react.extractComponent;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentDialog;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactExtractComponentHandler
implements RefactoringActionHandler {
    public static final String HELP_ID = "javascript.refactoring.extractComponent";
    public static final DataKey<String> TEST_NAME_KEY = DataKey.create((String)"javascript.refactoring.extractComponent.test.name");
    public static final DataKey<ComponentType> TEST_COMPONENT_TYPE_KEY = DataKey.create((String)"javascript.refactoring.extractComponent.test.component.type");
    public static final String COMPONENT_TYPE_PROPERTY_KEY = "javascript.refactoring.extractComponent.property.key";
    private static final String PROP_TYPES_NAMESPACE = "PropTypes";
    public static final String NAME_TEMPLATE_PROPERTY = "NAME";
    private static final String BODY_TEMPLATE_PROPERTY = "COMPONENT_BODY";
    public static final String PROP_TYPES_TEMPLATE_PROPERTY = "PROP_TYPES";
    public static final String DEFAULT_PROPS_TEMPLATE_PROPERTY = "DEFAULT_PROPS";
    public static final String HAS_PROPS_TEMPLATE_PROPERTY = "HAS_PROPS";
    private static final Comparator<PsiElement> REVERSE_RANGE_COMPARATOR = Comparator.comparingInt(t -> t.getTextRange().getStartOffset()).reversed();

    public boolean isAvailable(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(1);
        }
        return ReactExtractComponentHandler.getSourceExpression(editor, file2) != null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(3);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        Pair<JSXmlLiteralExpression, TextRange> sourceExpressionDescriptor;
        if (project == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(4);
        }
        if ((sourceExpressionDescriptor = ReactExtractComponentHandler.getSourceExpression(editor, file2)) == null) {
            ReactExtractComponentHandler.error(project, editor, JavaScriptBundle.message((String)"refactoring.extract.react.component.no.expression", (Object[])new Object[0]));
            return;
        }
        JSExpression sourceExpression = (JSExpression)sourceExpressionDescriptor.first;
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)sourceExpression, editor, ReactExtractComponentHandler.getRefactoringTitle())) {
            return;
        }
        JSPsiElementBase sourceComponent = ReactExtractComponentHandler.getContainingComponent(sourceExpression);
        JSElement introductionScope = ReactExtractComponentHandler.getIntroductionScope(sourceExpression);
        PsiElement parent = PsiTreeUtil.findFirstParent((PsiElement)sourceExpression, e -> e.getParent() == introductionScope);
        if (introductionScope == null || parent == null) {
            ReactExtractComponentHandler.error(project, editor, JavaScriptBundle.message((String)"refactoring.extract.react.component.no.scope", (Object[])new Object[0]));
            return;
        }
        PsiElement anchorBefore = JSPsiImplUtils.findLeadingCommentOrSelf(parent);
        Pair<String, ComponentType> userSettings = ReactExtractComponentHandler.getUserSettings(introductionScope, dataContext);
        if (userSettings == null) {
            return;
        }
        ComponentType type = (ComponentType)((Object)userSettings.second);
        String name = (String)userSettings.first;
        Pair<Collection<Prop>, String> result2 = ReactExtractComponentHandler.buildPropsAndReplacement(sourceExpressionDescriptor, sourceComponent, (PsiElement)introductionScope, type);
        Collection props = (Collection)result2.first;
        ComponentToExtract component = new ComponentToExtract(name, props, type);
        JSIntroducedExpressionUtil.Replacer replacer = JSIntroducedExpressionUtil.createReplacer(sourceExpressionDescriptor);
        String usageReplacementText = String.format("<%s %s/>", component.name, StringUtil.join((Collection)props, prop -> prop.name + "={" + prop.value + "}", (String)""));
        WriteCommandAction.runWriteCommandAction((Project)sourceExpression.getProject(), (String)ReactExtractComponentHandler.getRefactoringTitle(), null, () -> {
            ReactExtractComponentHandler.addDeclarations(component, editor, anchorBefore, (String)result2.second);
            JSExpression replacementExpression = JSChangeUtil.createExpressionPsiWithContext(usageReplacementText, (PsiElement)sourceExpression, JSExpression.class);
            assert (replacementExpression != null);
            replacer.replaceExpression(replacementExpression);
        }, (PsiFile[])new PsiFile[0]);
    }

    @Nullable
    private static Pair<String, ComponentType> getUserSettings(@NotNull JSElement introductionScope, @NotNull DataContext dataContext) {
        if (introductionScope == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Pair.create((Object)dataContext.getData(TEST_NAME_KEY), (Object)dataContext.getData(TEST_COMPONENT_TYPE_KEY));
        }
        InputValidatorEx inputValidator = ReactExtractComponentHandler.createNameValidator((PsiElement)introductionScope);
        ReactExtractComponentDialog dialog = new ReactExtractComponentDialog(introductionScope.getProject(), inputValidator, "NewComponent");
        if (!dialog.showAndGet()) {
            return null;
        }
        return Pair.create((Object)dialog.getSelectedName(), (Object)((Object)dialog.getSelectedType()));
    }

    @NotNull
    public static InputValidatorEx createNameValidator(final @NotNull PsiElement introductionScope) {
        if (introductionScope == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(7);
        }
        return new InputValidatorEx(){

            @Nullable
            public String getErrorText(String inputString) {
                boolean isIdentifier = JSNamesValidation.isIdentifier(inputString, introductionScope);
                if (!isIdentifier) {
                    return JavaScriptBundle.message((String)"invalid.identifier.value.0", (Object[])new Object[]{inputString});
                }
                List<PsiElement> existing = JSRefactoringUtil.findExistingInScope(inputString, introductionScope, false);
                if (!existing.isEmpty()) {
                    return JSRefactoringUtil.getMemberAlreadyExistsMessage(existing.get(0));
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                return this.getErrorText(inputString) == null;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        };
    }

    @Nullable
    private static JSPsiElementBase getContainingComponent(@Nullable JSExpression sourceExpression) {
        return (JSPsiElementBase)PsiTreeUtil.findFirstParent((PsiElement)sourceExpression, parent -> {
            if (parent instanceof JSClass && ReactXmlExtension.isAcceptableClassComponent((JSClass)parent) == ThreeState.YES) {
                return true;
            }
            return parent instanceof JSFunction && ReactXmlExtension.isFunctionComponentBySignature((JSFunction)parent) && JSXResolveUtil.isComponentName(((JSFunction)parent).getName());
        });
    }

    @Nullable
    private static JSElement getIntroductionScope(@Nullable JSExpression sourceExpression) {
        return sourceExpression != null ? ES6PsiUtil.getExportScope((PsiElement)sourceExpression) : null;
    }

    @Nullable
    private static Pair<JSXmlLiteralExpression, TextRange> getSourceExpression(@NotNull Editor editor, @NotNull PsiFile file2) {
        Pair<JSExpression, TextRange> candidate;
        int selectionEnd;
        int selectionStart;
        List<Pair<JSExpression, TextRange>> expressionCandidates;
        if (editor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(9);
        }
        if ((expressionCandidates = JSIntroducedExpressionUtil.findExpressionsInRange(file2, selectionStart = editor.getSelectionModel().getSelectionStart(), selectionEnd = editor.getSelectionModel().getSelectionEnd())) == null || expressionCandidates.isEmpty()) {
            return null;
        }
        Pair<JSExpression, TextRange> pair = candidate = expressionCandidates.size() > 1 ? (Pair<JSExpression, TextRange>)ContainerUtil.find(expressionCandidates, t -> t.first instanceof JSXmlLiteralExpression && t.second == null) : expressionCandidates.get(0);
        if (candidate != null) {
            JSExpression withoutPars;
            if (candidate.first instanceof JSXmlLiteralExpression) {
                return Pair.create((Object)((JSXmlLiteralExpression)candidate.first), (Object)candidate.second);
            }
            if (candidate.second == null && (withoutPars = JSUtils.unparenthesize((JSExpression)candidate.first)) instanceof JSXmlLiteralExpression) {
                return Pair.create((Object)((JSXmlLiteralExpression)withoutPars), null);
            }
        }
        return null;
    }

    @NotNull
    private static Pair<Collection<Prop>, String> buildPropsAndReplacement(@NotNull Pair<JSXmlLiteralExpression, TextRange> expressionDescriptor, final @Nullable JSPsiElementBase sourceComponent, final @NotNull PsiElement introductionScope, final @NotNull ComponentType componentType) {
        if (expressionDescriptor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(10);
        }
        if (introductionScope == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(11);
        }
        if (componentType == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(12);
        }
        JSXmlLiteralExpression sourceExpression = (JSXmlLiteralExpression)expressionDescriptor.first;
        final TextRange rangeToProcess = expressionDescriptor.second != null ? (TextRange)expressionDescriptor.second : sourceExpression.getTextRange();
        final Ref keyProp = new Ref();
        final LinkedHashMap expressionReplacements = new LinkedHashMap();
        final LinkedHashMap propsByValue = new LinkedHashMap();
        final HashSet propNames = new HashSet();
        sourceExpression.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                if (embeddedContent.getParent() instanceof XmlAttributeValue && embeddedContent.getParent().getParent() instanceof XmlAttribute && StringUtil.equals((CharSequence)"key", (CharSequence)((XmlAttribute)embeddedContent.getParent().getParent()).getName())) {
                    JSExpression expression = (JSExpression)PsiTreeUtil.findChildOfType((PsiElement)embeddedContent, JSExpression.class);
                    if (expression != null) {
                        Prop prop = new Prop("key", null, expression.getText());
                        expressionReplacements.put(embeddedContent.getParent().getParent(), "");
                        keyProp.set((Object)prop);
                    }
                } else {
                    super.visitJSEmbeddedContent(embeddedContent);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                if (ReactExtractComponentHandler.isContextDependant(node, sourceComponent, introductionScope)) {
                    this.processPropCandidate((JSExpression)node);
                } else {
                    super.visitJSReferenceExpression(node);
                }
            }

            public void visitJSThisExpression(JSThisExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                this.processPropCandidate((JSExpression)node);
            }

            public void visitJSCallExpression(JSCallExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                Object[] arguments = node.getArguments();
                JSReferenceExpression methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)node.getMethodExpression(), JSReferenceExpression.class);
                if (ContainerUtil.or((Object[])arguments, expression -> expression instanceof JSThisExpression) || methodExpression != null && ReactExtractComponentHandler.isContextDependant(methodExpression, sourceComponent, introductionScope)) {
                    this.processPropCandidate((JSExpression)node);
                } else {
                    super.visitJSCallExpression(node);
                }
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                this.processPropCandidate((JSExpression)node);
            }

            private void processPropCandidate(@NotNull JSExpression node) {
                Prop prop;
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((prop = (Prop)propsByValue.get(node.getText())) == null) {
                    prop = ReactExtractComponentHandler.propFromExpression(node, propNames);
                    propsByValue.put(node.getText(), prop);
                }
                expressionReplacements.put(node, this.getReplacementForProp(node, prop));
            }

            @NotNull
            private String getReplacementForProp(@NotNull JSExpression expression, @NotNull Prop prop) {
                ES6Property property;
                if (expression == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (prop == null) {
                    2.$$$reportNull$$$0(2);
                }
                String text = (componentType != ComponentType.Function ? "this." : "") + "props" + "." + prop.name;
                if (expression.getParent() instanceof ES6Property && (property = (ES6Property)expression.getParent()).isShorthanded()) {
                    String string = property.getName() + ": " + text;
                    if (string == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                String string = text;
                if (string == null) {
                    2.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prop";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler$2";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReplacementForProp";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processPropCandidate";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getReplacementForProp";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        String result2 = ReactExtractComponentHandler.replaceOccurrences((JSElement)sourceExpression, rangeToProcess, expressionReplacements);
        ArrayList resultProps = new ArrayList();
        ContainerUtil.addIfNotNull(resultProps, (Object)keyProp.get());
        resultProps.addAll(((HashMap)propsByValue).values());
        String replacementText = expressionDescriptor.second == null ? result2 : "<>" + (StringUtil.contains((CharSequence)result2, (CharSequence)"\n") ? "\n" + result2 + "\n" : result2) + "</>";
        Pair pair = Pair.create(resultProps, (Object)replacementText);
        if (pair == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    public static String replaceOccurrences(@NotNull JSElement toProcess, @NotNull TextRange textRange, @NotNull Map<? extends PsiElement, String> replacements) {
        if (toProcess == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(14);
        }
        if (textRange == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(15);
        }
        if (replacements == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(16);
        }
        TextRange expressionRelativeRange = textRange.shiftLeft(toProcess.getTextRange().getStartOffset());
        StringBuilder result2 = new StringBuilder(expressionRelativeRange.substring(toProcess.getText()));
        for (PsiElement entry : ContainerUtil.sorted(replacements.keySet(), REVERSE_RANGE_COMPARATOR)) {
            TextRange rangeInFragment = entry.getTextRange().shiftLeft(textRange.getStartOffset());
            result2.replace(rangeInFragment.getStartOffset(), rangeInFragment.getEndOffset(), replacements.get(entry));
        }
        String string = result2.toString();
        if (string == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static boolean isContextDependant(@NotNull JSReferenceExpression referenceExpression, @Nullable JSPsiElementBase sourceComponent, @NotNull PsiElement introductionScope) {
        JSExpression qualifier;
        if (referenceExpression == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(18);
        }
        if (introductionScope == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(19);
        }
        if ((qualifier = referenceExpression.getQualifier()) == null) {
            List<PsiElement> resolveResults = JSResolveResult.toElements(referenceExpression.multiResolve(false));
            return resolveResults.isEmpty() || ContainerUtil.or(resolveResults, e -> ReactExtractComponentHandler.isLocallyDefined(introductionScope, e));
        }
        if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
            return true;
        }
        if (ReactExtractComponentHandler.isThisMemberAccess(qualifier, "props") || ReactExtractComponentHandler.isThisMemberAccess(qualifier, "state")) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null) {
            List<PsiElement> qualifierResolveResults = JSResolveResult.toElements(((JSReferenceExpression)qualifier).multiResolve(false));
            if (sourceComponent instanceof JSFunction && ContainerUtil.or(qualifierResolveResults, qualifierResolve -> qualifierResolve instanceof JSParameter && sourceComponent.isEquivalentTo((PsiElement)((JSParameter)qualifierResolve).getDeclaringFunction()))) {
                return true;
            }
            JSClass contextClass = JSResolveUtil.getClassOfContext((PsiElement)referenceExpression);
            if (contextClass != null && ReactExtractComponentHandler.isStaticClassAccess(qualifierResolveResults, contextClass)) {
                for (PsiElement resolved : JSResolveResult.toElements(referenceExpression.multiResolve(false))) {
                    if (!(resolved instanceof JSPsiElementBase)) continue;
                    if (((JSPsiElementBase)resolved).getJSContext() != JSContext.STATIC) {
                        return true;
                    }
                    JSAttributeList.AccessType accessType = ((JSPsiElementBase)resolved).getAccessType();
                    if (accessType != JSAttributeList.AccessType.PRIVATE && accessType != JSAttributeList.AccessType.PROTECTED) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLocallyDefined(@NotNull PsiElement introductionScope, @Nullable PsiElement resolved) {
        if (introductionScope == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(20);
        }
        if (!(resolved instanceof JSNamedElement)) {
            return false;
        }
        PsiElement declarationScope = JSUseScopeProvider.getUseScopeElement((JSNamedElement)resolved);
        return declarationScope != null && PsiTreeUtil.isAncestor((PsiElement)introductionScope, (PsiElement)declarationScope, (boolean)true);
    }

    private static boolean isStaticClassAccess(@NotNull List<PsiElement> qualifierResolveResults, @NotNull JSClass contextClass) {
        if (qualifierResolveResults == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(21);
        }
        if (contextClass == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(22);
        }
        return ContainerUtil.or(qualifierResolveResults, result2 -> contextClass.isEquivalentTo(result2));
    }

    private static boolean isThisMemberAccess(@Nullable JSExpression expression, @NotNull String memberName) {
        if (memberName == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(23);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)expression;
        JSExpression qualifier = refExpr.getQualifier();
        return (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && StringUtil.equals((CharSequence)refExpr.getReferenceName(), (CharSequence)memberName);
    }

    @NotNull
    private static Prop propFromExpression(@NotNull JSExpression e, @NotNull Set<String> existingNames) {
        String propName;
        if (e == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(24);
        }
        if (existingNames == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(25);
        }
        if ((propName = (String)ContainerUtil.getFirstItem(JSNameSuggestionsUtil.generateVariableNamesFromExpression(e, null, existingNames))) != null) {
            propName = JSNameSuggestionsUtil.ensureUniqueVariableName(propName, null, existingNames, true);
        }
        if (propName == null) {
            propName = "prop" + (existingNames.isEmpty() ? "" : Integer.valueOf(existingNames.size()));
        }
        existingNames.add(propName);
        return new Prop(propName, ReactExtractComponentHandler.getUsableExpressionType(e, (PsiElement)e), e.getText());
    }

    @NotNull
    public static JSType getUsableExpressionType(@Nullable JSExpression e, @NotNull PsiElement context) {
        boolean isJavaScriptResolve;
        if (context == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(26);
        }
        Object type = JSResolveUtil.getExpressionJSType(e);
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement(context);
        boolean bl = isJavaScriptResolve = dialectOptionHolder != null && dialectOptionHolder.isJavaScript();
        if (type instanceof JSTypeImpl && isJavaScriptResolve) {
            JSType functionType = JSTypeUtils.getFunctionType(type, false, context).findAny().orElse(null);
            if (functionType != null) {
                PsiElement functionSource = type.getSource().getSourceElement();
                type = functionSource instanceof JSFunctionItem ? TypeScriptTypeParser.buildFunctionType((JSFunctionItem)functionSource) : JSNamedTypeFactory.createFunctionType(type.getSource());
            } else if (!(type.getSource().getSourceElement() instanceof JSClass)) {
                type = JSAnyType.get(type.getSource());
            }
        }
        if (type == null) {
            type = JSAnyType.get(context, false);
        }
        JSType jSType = dialectOptionHolder != null && dialectOptionHolder.isFlow ? JSTypeUtils.copyWithLanguageRecursive(type, JSTypeSource.SourceLanguage.TS) : type;
        if (jSType == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(27);
        }
        return jSType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDeclarations(@NotNull ComponentToExtract component, Editor editor, @NotNull PsiElement anchorBefore, @NotNull String componentBody) {
        String templateName;
        JSNamedElement createdDeclaration;
        boolean isTypedDialect;
        JSLanguageDialect languageDialect;
        if (component == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(28);
        }
        if (anchorBefore == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(29);
        }
        if (componentBody == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(30);
        }
        DialectOptionHolder optionHolder = (languageDialect = DialectDetector.languageDialectOfElement(anchorBefore)) != null ? languageDialect.getOptionHolder() : null;
        boolean bl = isTypedDialect = optionHolder != null && optionHolder.hasFeature(JSLanguageFeature.TYPES);
        String propTypesText = isTypedDialect ? ReactExtractComponentHandler.buildTypedPropTypesText(component.props, !optionHolder.isFlow || component.componentType != ComponentType.Class) : ReactExtractComponentHandler.buildJSPropTypesText(component.props, anchorBefore);
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)anchorBefore.getProject());
        Properties properties = fileTemplateManager.getDefaultProperties();
        properties.setProperty(NAME_TEMPLATE_PROPERTY, component.name);
        properties.setProperty(BODY_TEMPLATE_PROPERTY, componentBody);
        if (!component.props.isEmpty()) {
            properties.setProperty(HAS_PROPS_TEMPLATE_PROPERTY, "true");
        }
        if (!StringUtil.isEmpty((String)propTypesText)) {
            properties.setProperty(PROP_TYPES_TEMPLATE_PROPERTY, propTypesText);
        }
        if ((createdDeclaration = ReactExtractComponentHandler.expandTemplate(anchorBefore, properties, templateName = ReactExtractComponentHandler.getCodeTemplateName(component.componentType, isTypedDialect), JSNamedElement.class)) == null) {
            String message = JavaScriptBundle.message((String)"refactoring.react.could.not.find.in.template", (Object[])new Object[]{component.name, templateName});
            ReactExtractComponentHandler.error(anchorBefore.getProject(), editor, message);
            return;
        }
        PsiFile createdFile = createdDeclaration.getContainingFile();
        if (component.componentType == ComponentType.Class) {
            ReactExtractComponentHandler.addRequiredImportsForClassComponent((JSClass)createdDeclaration, anchorBefore);
        }
        PsiElement firstAdded = (PsiElement)JSChangeUtil.doAddRangeBefore((PsiElement)anchorBefore.getParent(), (PsiElement)createdFile.getFirstChild(), (PsiElement)createdFile.getLastChild(), (PsiElement)anchorBefore).first;
        if (editor == null) {
            return;
        }
        JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)createdFile);
        boolean forceSemicolon = codeStyleSettings.FORCE_SEMICOLON_STYLE;
        boolean forceQuotes = codeStyleSettings.FORCE_QUOTE_STYlE;
        try {
            codeStyleSettings.FORCE_SEMICOLON_STYLE = true;
            codeStyleSettings.FORCE_QUOTE_STYlE = true;
            FormatFixer.create(firstAdded.getContainingFile(), new TextRange(firstAdded.getTextRange().getStartOffset(), anchorBefore.getTextRange().getStartOffset()), editor.getDocument(), FormatFixer.Mode.Reformat).fixFormat();
        }
        finally {
            codeStyleSettings.FORCE_SEMICOLON_STYLE = forceSemicolon;
            codeStyleSettings.FORCE_QUOTE_STYlE = forceQuotes;
        }
    }

    @Nullable
    public static <T extends JSNamedElement> T expandTemplate(@NotNull PsiElement context, @NotNull Properties properties, @NotNull String templateName, final @NotNull Class<T> resultClass) {
        if (context == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(31);
        }
        if (properties == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(32);
        }
        if (templateName == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(33);
        }
        if (resultClass == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(34);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)context.getProject());
        final String componentName = properties.getProperty(NAME_TEMPLATE_PROPERTY);
        FileTemplate fileTemplate = fileTemplateManager.getCodeTemplate(templateName);
        String text = TypeScriptImplementMemberUtil.getBodyTextFromTemplate(fileTemplate, properties).trim();
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(context);
        JSFile expandedTemplateFile = (JSFile)JSChangeUtil.createJSFileFromText(context.getProject(), text, dialect);
        final Ref result2 = new Ref();
        expandedTemplateFile.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (resultClass.isInstance(element)) {
                    if (StringUtil.isEmpty((String)componentName) || StringUtil.equals((CharSequence)((JSNamedElement)element).getName(), (CharSequence)componentName)) {
                        result2.set((Object)((JSNamedElement)element));
                    }
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler$3", "visitElement"));
            }
        });
        return (T)((JSNamedElement)result2.get());
    }

    @Nullable
    public static String buildJSPropTypesText(@NotNull Collection<? extends Prop> props, @NotNull PsiElement context) {
        if (props == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(35);
        }
        if (context == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(36);
        }
        if (props.isEmpty()) {
            return null;
        }
        String importedName = ReactExtractComponentHandler.importModuleAsNamespace(context, "prop-types", PROP_TYPES_NAMESPACE);
        if (importedName == null) {
            return "";
        }
        return "{" + props.stream().filter(prop -> prop.type != null).map(prop -> {
            String propType = JSXPropTypesUtil.toPropType(importedName, prop.type, context);
            return String.format("%s: %s", prop.name, propType);
        }).collect(Collectors.joining(",\n")) + "}";
    }

    @Nullable
    public static String buildTypedPropTypesText(@NotNull Collection<? extends Prop> props, boolean allowEmpty) {
        if (props == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(37);
        }
        if (allowEmpty && props.isEmpty()) {
            return null;
        }
        return "{" + props.stream().filter(prop -> prop.type != null).map(prop -> {
            String propTypeText = prop.type.getTypeText(JSType.TypeTextFormat.CODE);
            return String.format("%s: %s", prop.name, propTypeText);
        }).collect(Collectors.joining(",")) + "}";
    }

    public static void addRequiredImportsForClassComponent(@NotNull JSClass jsClass, @NotNull PsiElement context) {
        JSReferenceList extendsList;
        JSExpression[] extendsExpressions;
        if (jsClass == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(38);
        }
        if (context == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(39);
        }
        for (JSExpression expression : extendsExpressions = (extendsList = jsClass.getExtendsList()) != null ? extendsList.getExpressions() : JSExpression.EMPTY_ARRAY) {
            JSReferenceExpression replacement;
            String imported;
            String extendsExpressionText = expression.getText();
            if (!TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(extendsExpressionText) || StringUtil.equals((CharSequence)extendsExpressionText, (CharSequence)(imported = ReactExtractComponentHandler.importNamedElementIfNeeded(extendsExpressionText, context, "react"))) || (replacement = JSChangeUtil.createExpressionPsiWithContext(imported, (PsiElement)expression, JSReferenceExpression.class)) == null) continue;
            expression.replace((JSExpression)replacement);
        }
    }

    @NotNull
    private static String importNamedElementIfNeeded(@NotNull String elementName, @NotNull PsiElement context, @NotNull String targetModuleName) {
        PsiElement module;
        if (elementName == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(40);
        }
        if (context == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(41);
        }
        if (targetModuleName == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(42);
        }
        if ((module = (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule(context), (Object)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class}))) == null) {
            String string = elementName;
            if (string == null) {
                ReactExtractComponentHandler.$$$reportNull$$$0(43);
            }
            return string;
        }
        for (ES6ImportDeclaration declaration : ReactExtractComponentHandler.getImportDeclarationsByModuleName(module, targetModuleName)) {
            for (ES6ImportSpecifier specifier : declaration.getImportSpecifiers()) {
                if (!StringUtil.equals((CharSequence)specifier.getReferenceName(), (CharSequence)elementName)) continue;
                String string = elementName;
                if (string == null) {
                    ReactExtractComponentHandler.$$$reportNull$$$0(44);
                }
                return string;
            }
            int n = 0;
            ES6ImportSpecifier[] eS6ImportSpecifierArray = declaration.getImportedBindings();
            int n2 = eS6ImportSpecifierArray.length;
            if (n >= n2) continue;
            ES6ImportSpecifier binding = eS6ImportSpecifierArray[n];
            String string = binding.getName() + "." + elementName;
            if (string == null) {
                ReactExtractComponentHandler.$$$reportNull$$$0(45);
            }
            return string;
        }
        Collection<PsiElement> targetModules = JSFileReferencesUtil.resolveModuleReference((PsiElement)context.getContainingFile(), targetModuleName);
        if (targetModules.isEmpty()) {
            String string = elementName;
            if (string == null) {
                ReactExtractComponentHandler.$$$reportNull$$$0(46);
            }
            return string;
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(elementName, null, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
        ES6ImportPsiUtil.insertJSImport(context, info, targetModules.iterator().next(), null);
        String string = elementName;
        if (string == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(47);
        }
        return string;
    }

    @Nullable
    private static String importModuleAsNamespace(@NotNull PsiElement context, @NotNull String moduleName, @NotNull String defaultName) {
        PsiElement module;
        if (context == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(48);
        }
        if (moduleName == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(49);
        }
        if (defaultName == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(50);
        }
        if ((module = (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule(context), (Object)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class}))) == null) {
            return null;
        }
        for (ES6ImportDeclaration element : ReactExtractComponentHandler.getImportDeclarationsByModuleName(module, moduleName)) {
            if (element.getImportedBindings().length <= 0) continue;
            return element.getImportedBindings()[0].getDeclaredName();
        }
        Collection<PsiElement> targetModules = JSFileReferencesUtil.resolveModuleReference((PsiElement)context.getContainingFile(), moduleName);
        if (targetModules.isEmpty()) {
            return null;
        }
        ES6ImportPsiUtil.CreateImportExportInfo importExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(defaultName, null, ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL, true, false);
        ES6ImportPsiUtil.insertJSImport(context, importExportInfo, targetModules.iterator().next(), null);
        return defaultName;
    }

    @NotNull
    public static String getCodeTemplateName(ComponentType type, boolean useTypescript) {
        if (type == ComponentType.Class && useTypescript) {
            return "Typed React Class Component.tsx";
        }
        if (type == ComponentType.Function && useTypescript) {
            return "Typed React Functional Component.tsx";
        }
        return type == ComponentType.Class ? "React Class Component.jsx" : "React Functional Component.jsx";
    }

    @NotNull
    private static List<ES6ImportDeclaration> getImportDeclarationsByModuleName(@Nullable PsiElement context, @NotNull String moduleName) {
        PsiElement[] declarations;
        if (moduleName == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(51);
        }
        ArrayList<ES6ImportDeclaration> results = new ArrayList<ES6ImportDeclaration>();
        for (PsiElement element : declarations = JSResolveUtil.getStubbedChildren(context, ES6ImportPsiUtil.ES6_IMPORT_DECLARATION)) {
            if (!(element instanceof ES6ImportDeclaration) || !moduleName.equals(ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)element))) continue;
            results.add((ES6ImportDeclaration)element);
        }
        ArrayList<ES6ImportDeclaration> arrayList = results;
        if (arrayList == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    private static void error(Project project, Editor editor, String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ReactExtractComponentHandler.getRefactoringTitle(), (String)HELP_ID);
    }

    public static ComponentType getLastComponentType() {
        String strValue = PropertiesComponent.getInstance().getValue(COMPONENT_TYPE_PROPERTY_KEY);
        if (strValue == null) {
            return ComponentType.Class;
        }
        return (ComponentType)StringUtil.parseEnum((String)strValue, (Enum)ComponentType.Class, ComponentType.class);
    }

    public static void setLastComponentType(ComponentType componentType) {
        PropertiesComponent.getInstance().setValue(COMPONENT_TYPE_PROPERTY_KEY, componentType.toString());
    }

    public static String getRefactoringTitle() {
        return JavaScriptBundle.message((String)"refactoring.extract.react.component.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResolveResults";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 26: 
            case 31: 
            case 36: 
            case 39: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentBody";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultClass";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModuleName";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPropsAndReplacement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceOccurrences";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsableExpressionType";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "importNamedElementIfNeeded";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportDeclarationsByModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNameValidator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildPropsAndReplacement";
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceOccurrences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isContextDependant";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyDefined";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isStaticClassAccess";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isThisMemberAccess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "propFromExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUsableExpressionType";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addDeclarations";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "buildJSPropTypesText";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "buildTypedPropTypesText";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredImportsForClassComponent";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "importNamedElementIfNeeded";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "importModuleAsNamespace";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getImportDeclarationsByModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Prop {
        @NotNull
        public final String name;
        @Nullable
        public final String value;
        @Nullable
        public final JSType type;

        public Prop(@NotNull String name, @Nullable JSType type, @Nullable String value) {
            if (name == null) {
                Prop.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type;
            this.value = value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler$Prop", "<init>"));
        }
    }

    private static class ComponentToExtract {
        final String name;
        @NotNull
        final Collection<Prop> props;
        final ComponentType componentType;

        ComponentToExtract(@NotNull String name, @NotNull Collection<Prop> props, @NotNull ComponentType componentType) {
            if (name == null) {
                ComponentToExtract.$$$reportNull$$$0(0);
            }
            if (props == null) {
                ComponentToExtract.$$$reportNull$$$0(1);
            }
            if (componentType == null) {
                ComponentToExtract.$$$reportNull$$$0(2);
            }
            this.name = name;
            this.props = props;
            this.componentType = componentType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "props";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler$ComponentToExtract";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ComponentType {
        Class("Class"),
        Function("Functional");

        public final String description;

        private ComponentType(String description) {
            this.description = description;
        }
    }
}

