/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.inspections.JSSuppressByCommentFix;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptServiceRelatedAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class TypeScriptSuppressByCommentFix
extends BaseIntentionAction
implements LowPriorityAction,
TypeScriptServiceRelatedAction {
    private final Class<? extends JSSuppressionHolder> myHolderClass;

    public TypeScriptSuppressByCommentFix(Class<? extends JSSuppressionHolder> aClass) {
        this.myHolderClass = aClass;
    }

    @NotNull
    public String getFamilyName() {
        return "Suppress with @ts-ignore";
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TypeScriptSuppressByCommentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            TypeScriptSuppressByCommentFix.$$$reportNull$$$0(1);
        }
        return file2 instanceof JSFile;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        int offset;
        PsiElement element;
        if (project == null) {
            TypeScriptSuppressByCommentFix.$$$reportNull$$$0(2);
        }
        if ((element = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)(offset = editor.getCaretModel().getOffset()))) instanceof PsiFile) {
            return;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element, this.myHolderClass);
        if (container == null) {
            return;
        }
        JSSuppressByCommentFix.suppressByComment(project, element, container, "@ts-ignore");
    }

    @Override
    public int getIndex() {
        return Integer.MAX_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptSuppressByCommentFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptSuppressByCommentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

