/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.lang.javascript.refactoring.rename.JSInplaceRenameHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2) {
        boolean isTypeScriptContext;
        if (editor == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof JSFile) || element == null || !DialectDetector.isTypeScript((PsiElement)file2)) {
            return false;
        }
        PsiElement context = file2.findElementAt(editor.getCaretModel().getOffset());
        if (context == null && editor.getCaretModel().getOffset() > 0) {
            context = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        boolean bl = isTypeScriptContext = context != null && DialectDetector.isTypeScript(context);
        if (!isTypeScriptContext) {
            return false;
        }
        if (JSInplaceRenameHandler.isForbiddenContextForInplace(context.getParent())) {
            return false;
        }
        if (TypeScriptMemberInplaceRenameHandler.elementIsAcceptable(element)) {
            return editor.getSettings().isVariableInplaceRenameEnabled();
        }
        return false;
    }

    private static boolean elementIsAcceptable(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (JSGetterSetterRenameUtil.isFieldWithAccessors(element) || JSGetterSetterRenameUtil.isGetterSetterFunction(element)) {
            return false;
        }
        if (element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
            return false;
        }
        return TypeScriptMemberInplaceRenameHandler.isClassOrInterfaceWithName(element) || element instanceof TypeScriptVariable && !(element.getUseScope() instanceof LocalSearchScope) || element instanceof TypeScriptFunction && !(element.getUseScope() instanceof LocalSearchScope) || JSUtils.isMember(element) || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedBinding || element instanceof JSField || element instanceof TypeScriptImportStatement || element instanceof TypeScriptModule && ((TypeScriptModule)element).isInternal();
    }

    private static boolean isClassOrInterfaceWithName(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        return element instanceof JSClass && ((JSClass)element).getName() != null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(final @NotNull PsiElement substituted, @NotNull PsiNameIdentifierOwner originalElement, @NotNull Editor editor) {
        if (substituted == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        if (originalElement == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(5);
        }
        return new MemberInplaceRenamer((PsiNamedElement)originalElement, substituted, editor){

            protected boolean acceptReference(PsiReference reference) {
                return JSDefaultRenameProcessor.acceptReference(reference, false, true, substituted, true);
            }

            public boolean performInplaceRename() {
                return this.checkNeedInplace() && super.performInplaceRename();
            }

            private boolean checkNeedInplace() {
                String name;
                if (substituted.getUseScope() instanceof LocalSearchScope) {
                    return true;
                }
                if (JSDefaultRenameProcessor.getSearchDynamicReferences(substituted)) {
                    return false;
                }
                if (!JSDefaultRenameProcessor.getSearchJavaScriptReferences(substituted)) {
                    return true;
                }
                SearchScope scope = JSDefaultRenameProcessor.getScope(substituted, JSDefaultRenameProcessor.ReferencesType.JS);
                if (substituted instanceof JSNamedElement && scope instanceof GlobalSearchScope && (name = ((JSNamedElement)substituted).getName()) != null) {
                    PsiSearchHelper.SearchCostResult cheapEnough = PsiSearchHelper.getInstance((Project)substituted.getProject()).isCheapEnoughToSearch(name, (GlobalSearchScope)scope, substituted.getContainingFile(), null);
                    if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                        return false;
                    }
                    if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                        return true;
                    }
                }
                return ReferencesSearch.search((PsiElement)substituted, (SearchScope)scope).findFirst() == null;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }
                if (!(element.getParent() instanceof JSRecordType.PropertySignature)) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }
                TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(element);
                if (textRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (reference instanceof JSLiteralTextReference && ((JSLiteralTextReference)reference).isLiteralKeyReference()) {
                    TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(reference.getElement());
                    if (textRange == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return textRange;
                }
                TextRange textRange = super.getRangeToRename(reference);
                if (textRange == null) {
                    1.$$$reportNull$$$0(6);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeToRename";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeToRename";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituted";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassOrInterfaceWithName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createMemberRenamer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

