/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.lang.typescript.settings.exclude.TypeScriptGeneratedFilesStartupActivity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGeneratedFilesListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        ExcludeState providers;
        if (events == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(0);
        }
        return (providers = TypeScriptGeneratedFilesListener.getFilesToExclude(events)) != null ? new AsyncFileListener.ChangeApplier(){

            public void afterVfsChange() {
                Project[] projects;
                List excluded = ContainerUtil.mapNotNull(providers.excludedFiles, Supplier::get);
                for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                    TypeScriptExcludeManager generatedFilesManager;
                    ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
                    List excludedFiles = ((StreamEx)StreamEx.of((Collection)excluded).filter(el -> el.isValid() && index.isInContent(el))).toList();
                    if (excludedFiles.isEmpty() && providers.unExcludedFiles.isEmpty() || !(generatedFilesManager = TypeScriptExcludeManager.getInstance(project)).removeFiles(providers.unExcludedFiles) && !generatedFilesManager.addFiles(excludedFiles)) continue;
                    TypeScriptGeneratedFilesStartupActivity.updateProject(project, generatedFilesManager);
                }
            }
        } : null;
    }

    @Nullable
    private static ExcludeState getFilesToExclude(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(1);
        }
        ExcludeState state = null;
        for (VFileEvent vFileEvent : events) {
            Collection<Object> toExclude = Collections.emptyList();
            Collection<Object> unExclude = Collections.emptyList();
            if (vFileEvent instanceof VFileCreateEvent) {
                toExclude = TypeScriptGeneratedFilesListener.processCreateEvent(vFileEvent);
            } else if (vFileEvent instanceof VFileCopyEvent) {
                toExclude = TypeScriptGeneratedFilesListener.processCopyEvent(vFileEvent);
            } else if (vFileEvent instanceof VFileDeleteEvent) {
                unExclude = TypeScriptGeneratedFilesListener.processDeleteEvent(vFileEvent);
            } else if (vFileEvent instanceof VFileMoveEvent) {
                VirtualFile file2 = vFileEvent.getFile();
                if (file2 != null) {
                    VirtualFile oldParent = ((VFileMoveEvent)vFileEvent).getOldParent();
                    String fileName = file2.getName();
                    if (oldParent != null) {
                        unExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToUnExclude(fileName, oldParent);
                    }
                    VirtualFile newParent = ((VFileMoveEvent)vFileEvent).getNewParent();
                    toExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(fileName, newParent);
                }
            } else if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                VirtualFile parent;
                VirtualFile file2 = vFileEvent.getFile();
                VirtualFile virtualFile = parent = file2 != null ? file2.getParent() : null;
                if (parent != null) {
                    String oldName = (String)((VFilePropertyChangeEvent)vFileEvent).getOldValue();
                    String newName = (String)((VFilePropertyChangeEvent)vFileEvent).getNewValue();
                    unExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToUnExclude(oldName, parent);
                    toExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(newName, parent);
                }
            }
            if (!toExclude.isEmpty()) {
                if (state == null) {
                    state = new ExcludeState();
                }
                state.excludedFiles.addAll(toExclude);
            }
            if (unExclude.isEmpty()) continue;
            if (state == null) {
                state = new ExcludeState();
            }
            state.unExcludedFiles.addAll(unExclude);
        }
        return state;
    }

    private static Collection<String> processDeleteEvent(VFileEvent event) {
        VirtualFile tsCandidate = event.getFile();
        if (tsCandidate != null) {
            return TypeScriptGeneratedFilesListener.getSiblingFilesToUnExclude(tsCandidate.getName(), tsCandidate.getParent());
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Collection<Supplier<VirtualFile>> processCopyEvent(@NotNull VFileEvent event) {
        VirtualFile parent;
        String name;
        if (event == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(2);
        }
        if (TypeScriptGeneratedFilesListener.shouldExcludeFile(name = ((VFileCopyEvent)event).getNewChildName(), parent = ((VFileCopyEvent)event).getNewParent())) {
            List<Supplier<VirtualFile>> list2 = Collections.singletonList(() -> event.getFileSystem().findFileByPath(event.getPath()));
            if (list2 == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(3);
            }
            return list2;
        }
        return TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(name, parent);
    }

    @NotNull
    private static Collection<Supplier<VirtualFile>> processCreateEvent(@NotNull VFileEvent event) {
        VirtualFile parent;
        String name;
        if (event == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(4);
        }
        if (TypeScriptGeneratedFilesListener.shouldExcludeFile(name = ((VFileCreateEvent)event).getChildName(), parent = ((VFileCreateEvent)event).getParent())) {
            Set<Supplier<VirtualFile>> set = Collections.singleton(() -> event.getFile());
            if (set == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(5);
            }
            return set;
        }
        return TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(name, parent);
    }

    @NotNull
    private static List<Supplier<VirtualFile>> getSiblingFilesToExclude(@NotNull String tsFileName, @Nullable VirtualFile directory) {
        if (tsFileName == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            List<Supplier<VirtualFile>> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(7);
            }
            return list2;
        }
        String tsExtension = JSFileReference.findExtension(tsFileName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (tsExtension == null) {
            List<Supplier<VirtualFile>> list3 = Collections.emptyList();
            if (list3 == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(8);
            }
            return list3;
        }
        CharSequence fileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(tsFileName, tsExtension);
        SmartList objects = new SmartList();
        for (String ext : TypeScriptGeneratedFilesStartupActivity.JS_AND_DTS_EXTENSIONS) {
            if (directory.findChild(fileNameWithoutExtension + ext) == null) continue;
            objects.add(() -> directory.findChild(fileNameWithoutExtension + ext));
        }
        SmartList smartList = objects;
        if (smartList == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @NotNull
    private static List<String> getSiblingFilesToUnExclude(@NotNull String tsFileName, @Nullable VirtualFile directory) {
        if (tsFileName == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(10);
        }
        if (directory == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(11);
            }
            return list2;
        }
        String tsExtension = JSFileReference.findExtension(tsFileName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (tsExtension == null) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(12);
            }
            return list3;
        }
        CharSequence fileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(tsFileName, tsExtension);
        ArrayList<String> objects = new ArrayList<String>(TypeScriptGeneratedFilesStartupActivity.JS_AND_DTS_EXTENSIONS.length);
        String directoryString = TypeScriptExcludeManager.mapToString(directory);
        for (String ext : TypeScriptGeneratedFilesStartupActivity.JS_AND_DTS_EXTENSIONS) {
            objects.add(directoryString + "/" + fileNameWithoutExtension + ext);
        }
        ArrayList<String> arrayList = objects;
        if (arrayList == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static boolean shouldExcludeFile(@NotNull String name, @Nullable VirtualFile directory) {
        if (name == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(14);
        }
        if (directory == null) {
            return false;
        }
        String jsExtension = JSFileReference.findExtension(name, TypeScriptGeneratedFilesStartupActivity.JS_AND_DTS_EXTENSIONS);
        if (jsExtension == null) {
            return false;
        }
        CharSequence jsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(name, jsExtension);
        for (String ext : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS) {
            VirtualFile child = directory.findChild(jsFileNameWithoutExtension + ext);
            if (child == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesListener";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsFileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processCopyEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processCreateEvent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingFilesToExclude";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingFilesToUnExclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToExclude";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processCopyEvent";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCreateEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingFilesToExclude";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingFilesToUnExclude";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldExcludeFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ExcludeState {
        Collection<Supplier<VirtualFile>> excludedFiles = new SmartList();
        Collection<String> unExcludedFiles = new SmartList();

        private ExcludeState() {
        }
    }
}

