/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import java.util.Collection;
import java.util.List;

public class JSExprTypePredicate
extends MatchPredicate {
    private final List<String> myTypes;
    private final boolean myHierarchy;
    private final boolean myCaseSensitive;

    public JSExprTypePredicate(String type, boolean hierarchy, boolean caseSensitive) {
        this.myTypes = StringUtil.split((String)type, (String)"|");
        this.myHierarchy = hierarchy;
        this.myCaseSensitive = caseSensitive;
    }

    public boolean match(PsiElement matchedNode, int start, int end, MatchContext context) {
        JSType type;
        if ((matchedNode = StructuralSearchUtil.getParentIfIdentifier((PsiElement)matchedNode)) instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)matchedNode);
        } else if (matchedNode instanceof JSFunction) {
            JSFunction function2 = (JSFunction)matchedNode;
            JSType returnType = function2.getReturnType();
            type = returnType == null ? TypeFromUsageDetector.detectTypeFromUsage(matchedNode) : returnType;
        } else if (matchedNode instanceof JSVariable) {
            JSVariable variable = (JSVariable)matchedNode;
            JSType varType = variable.getJSType();
            type = varType == null ? TypeFromUsageDetector.detectTypeFromUsage(matchedNode) : varType;
        } else {
            return false;
        }
        if (this.myHierarchy && type instanceof JSResolvableType) {
            JSClassUtils.JSClassHierarchyProcessor processor = (aClass1, typeSubstitutor, fromImplements, fromStaticContext, depth) -> !this.doMatch(aClass1.getStaticJSType());
            if (DialectDetector.isActionScript(matchedNode)) {
                JSClass aClass = type.resolveClass();
                return aClass != null && !JSClassUtils.processClassesInHierarchy(aClass, true, processor);
            }
            JSResolvableType resolvableType = (JSResolvableType)type;
            JSResolvedTypeInfo resolvedTypeInfo = resolvableType.resolveType();
            Collection<JSClass> classes = resolvedTypeInfo.getDeclarationsOfType(JSClass.class);
            for (JSClass aClass : classes) {
                if (JSClassUtils.processClassesInHierarchy(aClass, true, processor)) continue;
                return true;
            }
            return false;
        }
        return this.doMatch(type);
    }

    private boolean doMatch(JSType type) {
        if (type == null) {
            return false;
        }
        String text = type.getResolvedTypeText();
        return this.myTypes.stream().anyMatch(t -> this.myCaseSensitive ? t.equals(text) : t.equalsIgnoreCase(text));
    }
}

