/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.model.DasIndex;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableIndexColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> {
    public static final Pattern COLUMN_SPLITTER_PATTERN = Pattern.compile("\\s*,\\s*");
    private final DatabaseMetaDataWrapper.TableIndexColumn myTemplate;
    private final DatabaseMetaDataWrapper.Table myTable;
    private String[] mySubColumns;
    private int mySubIdx;

    public TableIndexColumnIt(@Nullable RemoteResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (table == null) {
            TableIndexColumnIt.$$$reportNull$$$0(0);
        }
        super(rs);
        this.mySubIdx = -1;
        this.myTable = table;
        this.myTemplate = this.createStorage();
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableIndexColumn createStorage() {
        return new DatabaseMetaDataWrapper.TableIndexColumn(new DatabaseMetaDataWrapper.TableIndex(this.myTable, ""));
    }

    @Override
    protected DatabaseMetaDataWrapper.TableIndexColumn calcValue() {
        DatabaseMetaDataWrapper.TableIndexColumn res2 = (DatabaseMetaDataWrapper.TableIndexColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            res2.index.type = this.myRs.getShort("TYPE", 7);
            if (res2.index.type == 0) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.myTable.schema.schema);
            if (!Comparing.equal((String)schema, (String)this.myTable.schema.schema) || !Comparing.equal((String)table, (String)this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            res2.index.nonUnique = this.myRs.getBoolean("NON_UNIQUE", 4);
            res2.index.name = this.myRs.getString("INDEX_NAME", 6);
            String ascOrDesc = this.myRs.getString("ASC_OR_DESC", 10);
            res2.sorting = "a".equalsIgnoreCase(ascOrDesc) ? DasIndex.Sorting.ASCENDING : ("d".equalsIgnoreCase(ascOrDesc) ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.NONE);
            res2.index.qualifier = this.myRs.getString("INDEX_QUALIFIER", 5);
            res2.position = this.myRs.getShort("ORDINAL_POSITION", 8);
            res2.name = this.myRs.getString("COLUMN_NAME", 9);
            String[] columnNames = COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)res2.name), 0);
            if (columnNames.length > 1) {
                for (int i2 = 0; i2 < columnNames.length; ++i2) {
                    columnNames[i2] = StringUtil.unquoteString((String)columnNames[i2]);
                }
                this.myTemplate.assign(res2);
                this.mySubColumns = columnNames;
                this.mySubIdx = 0;
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            if (!StringUtil.isEmpty((String)res2.name)) {
                res2.name = StringUtil.unquoteString((String)res2.name);
            }
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
        }
        return res2;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableIndexColumn nextImpl() {
        if (this.mySubIdx != -1 && this.mySubColumns != null) {
            DatabaseMetaDataWrapper.TableIndexColumn res2 = (DatabaseMetaDataWrapper.TableIndexColumn)this.getStorageToFill();
            res2.assign(this.myTemplate);
            res2.name = this.mySubColumns[this.mySubIdx];
            ++this.mySubIdx;
            if (this.mySubIdx >= this.mySubColumns.length) {
                this.mySubIdx = -1;
                this.mySubColumns = null;
            }
            return res2;
        }
        return (DatabaseMetaDataWrapper.TableIndexColumn)super.nextImpl();
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableIndexColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.index.table.schema.database, cur.index.table.schema.schema, cur.index.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableIndexColumnIt", "<init>"));
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn, DatabaseMetaDataWrapper.TableIndexColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> it) {
            final String indexName = ((DatabaseMetaDataWrapper.TableIndexColumn)it.current()).index.name;
            return new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableIndexColumn item) {
                    return Comparing.equal((String)indexName, (String)item.index.name);
                }
            };
        }

        @Override
        protected DatabaseMetaDataWrapper.TableIndex getItem(ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> it) {
            return ((DatabaseMetaDataWrapper.TableIndexColumn)it.current()).index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableIndexColumnIt$Grouping", "<init>"));
        }
    }
}

