/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSCodeFragment;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/mongo/MongoGridHelper;", "Lcom/intellij/database/datagrid/GridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "createFilterCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "project", "Lcom/intellij/openapi/project/Project;", "filterText", "", "queryText", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "table", "Lcom/intellij/database/model/DasTable;", "getFilterLanguage", "Lcom/intellij/lang/Language;", "intellij.database.dialects.mongo"})
public final class MongoGridHelper
implements GridHelper {
    @NotNull
    private final Dbms dbms;

    @Nullable
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project project, @NotNull String filterText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasTable table) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)filterText, (String)"filterText");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        IElementType iElementType = JSElementTypes.ARGUMENT_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"JSElementTypes.ARGUMENT_LIST");
        MongoJSCodeFragment codeFragment = MongoJSCodeFragment.Companion.create(iElementType, project, "dummy.js", filterText, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, dataSource);
        DasNamespace nsp = DbImplUtil.getSearchPathObject((DatabaseDialectEx)DbImplUtil.getDatabaseDialect((DbElement)((DbElement)dataSource)), (DasObject)((DasObject)table));
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, ObjectPaths.searchPathOf((DasObject)((DasObject)nsp)));
        return codeFragment;
    }

    @NotNull
    public Language getFilterLanguage() {
        return (Language)MongoJSLanguage.INSTANCE;
    }

    @NotNull
    public Dbms getDbms() {
        return this.dbms;
    }

    public MongoGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @NotNull
    public Set<DataConsumer.Column.Attribute> getAttributes(@NotNull DasColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return GridHelper.DefaultImpls.getAttributes((GridHelper)this, (DasColumn)column2);
    }
}

