/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dialects.mssql.ssrp.LocalDb;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class LocalDbParamEditor
extends ParamEditorBase<ComboBox<LocalDb.LocalDbInstance>> {
    private String myText;

    public LocalDbParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            LocalDbParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            LocalDbParamEditor.$$$reportNull$$$0(1);
        }
        super((JComponent)new ComboBox(), interchange, TypesRegistry.ParamEditor.FieldSize.LARGE, label, new AnAction[0]);
        interchange.addPersistentProperty("LOCAL_DB_INSTANCE");
        ((ComboBox)this.getEditorComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                LocalDb.LocalDbInstance inst = (LocalDb.LocalDbInstance)ObjectUtils.tryCast((Object)e.getItem(), LocalDb.LocalDbInstance.class);
                if (inst != null) {
                    LocalDbParamEditor.this.setText("<pipe name>");
                    LocalDbParamEditor.this.getInterchange().putProperty("LOCAL_DB_INSTANCE", StringUtil.nullize((String)inst.instance));
                }
                LocalDbParamEditor.this.fireChanged();
            }
        });
        this.getInterchange().addPropertyChangeListener("LOCAL_DB_INSTANCE", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String newVal = StringUtil.notNullize((String)((String)evt.getNewValue()));
                ((ComboBox)LocalDbParamEditor.this.getEditorComponent()).setSelectedItem(LocalDb.byInstance(newVal));
            }
        }, (Disposable)this);
        this.getInterchange().addPropertyChangeListener("LOCAL_DB_EXECUTABLE", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LocalDbParamEditor.this.updateInstances();
            }
        }, (Disposable)this);
        this.myText = "<pipe name>";
        ((ComboBox)this.getEditorComponent()).setRenderer((ListCellRenderer)new ColoredListCellRenderer<LocalDb.LocalDbInstance>(){
            {
                this.setIconTextGap(0);
                this.setIpad((Insets)JBUI.emptyInsets());
            }

            protected void customizeCellRenderer(@NotNull JList list, LocalDb.LocalDbInstance value, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    return;
                }
                this.append(value.instance);
                if (!value.running) {
                    this.append(" (stopped)", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor$4", "customizeCellRenderer"));
            }
        });
        new UiNotifyConnector((Component)this.getEditorComponent(), new Activatable(){

            public void showNotify() {
                LocalDbParamEditor.this.updateInstances();
            }

            public void hideNotify() {
            }
        });
    }

    private void updateInstances() {
        new Task.Backgroundable(this.getInterchange().getProject(), "Fetching LocalDB Instances", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                try {
                    Collection<LocalDb.LocalDbInstance> instances = LocalDb.getInstances(StringUtil.notNullize((String)LocalDbParamEditor.this.getInterchange().getProperty("LOCAL_DB_EXECUTABLE")), indicator);
                    GuiUtils.invokeLaterIfNeeded(() -> LocalDbParamEditor.this.setInstances(instances), (ModalityState)ModalityState.defaultModalityState());
                }
                catch (ExecutionException e1) {
                    UIUtil.invokeLaterIfNeeded(() -> LocalDbParamEditor.this.getInterchange().showError("Failed to Update LocalDB Instances:\n" + e1.getMessage(), (Object)"localdb"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor$6", "run"));
            }
        }.queue();
    }

    private void setInstances(@NotNull Collection<LocalDb.LocalDbInstance> instances) {
        if (instances == null) {
            LocalDbParamEditor.$$$reportNull$$$0(2);
        }
        ((ComboBox)this.getEditorComponent()).setModel(new DefaultComboBoxModel<LocalDb.LocalDbInstance>(instances.toArray(new LocalDb.LocalDbInstance[0])));
        LocalDb.LocalDbInstance instance = (LocalDb.LocalDbInstance)ContainerUtil.find(instances, LocalDb.byInstance(this.getInterchange().getProperty("LOCAL_DB_INSTANCE")));
        ((ComboBox)this.getEditorComponent()).setSelectedItem((Object)instance);
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            LocalDbParamEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            LocalDbParamEditor.$$$reportNull$$$0(4);
        }
        this.myText = text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instances";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInstances";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

