/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.base.BaseDatabaseErrorHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraErrorHandler
extends BaseDatabaseErrorHandler {
    @RegExp
    private static final String LINE_COLUMN_PATTERN = "(ORA-\\d+: line|Line:) (\\d+), column:? (\\d+)";
    @RegExp
    private static final String OFFSET_PATTERN = "(Error : \\d+, Position :|Position:) (\\d+)";

    public int getErrorOffsetFromException(@NotNull Project project, @NotNull Throwable error, @NotNull String queryText) {
        String errorMessage;
        int offset;
        if (project == null) {
            OraErrorHandler.$$$reportNull$$$0(0);
        }
        if (error == null) {
            OraErrorHandler.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            OraErrorHandler.$$$reportNull$$$0(2);
        }
        return (offset = OraErrorHandler.getOffset(errorMessage = StringUtil.notNullize((String)error.getMessage()))) == -1 ? OraErrorHandler.getOffsetFromMessageImpl(LINE_COLUMN_PATTERN, -1, 2, 3, errorMessage, queryText, null) : offset;
    }

    private static int getOffset(@NotNull String text) {
        Matcher matcher;
        if (text == null) {
            OraErrorHandler.$$$reportNull$$$0(3);
        }
        return (matcher = Pattern.compile(OFFSET_PATTERN).matcher(text)).find() ? StringUtil.parseInt((String)matcher.group(2), (int)-1) : -1;
    }

    @Override
    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        String message;
        if (original == null) {
            OraErrorHandler.$$$reportNull$$$0(4);
        }
        if (cause == null) {
            OraErrorHandler.$$$reportNull$$$0(5);
        }
        if ((message = original.getMessage()) == null) {
            String string = super.getErrorMessage(dataSource, original, cause, fixes);
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(6);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        OraErrorHandler.appendGenericMessage(original, sb);
        if (StringUtil.contains((CharSequence)sb, (CharSequence)"ORA-12705:")) {
            sb.append("\n").append(DatabaseBundle.message((String)"error.message.ora.nls", (Object[])new Object[]{dataSource == null ? "" : dataSource.getName()}));
            OraErrorHandler.addSettingsFix(fixes, "Set locale", dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> {
                String example = "-Duser.language=en -Duser.region=US -Duser.country=en";
                DataSourceUiUtil.modify((DataSourceConfigurable)configurable, ds -> {
                    String options = ds.getVmOptions();
                    ds.setVmOptions(StringUtil.isEmpty((String)options) ? example : options + " " + example);
                });
                JComponent panel2 = configurable.selectAdvancedPanel();
                IdeFocusManager.getInstance((Project)configurable.getProject()).doWhenFocusSettlesDown(() -> {
                    JBIterable editors = UIUtil.uiTraverser((Component)panel2).filter(RawCommandLineEditor.class).collect();
                    RawCommandLineEditor options = (RawCommandLineEditor)editors.filter(e -> e.getText().contains(example)).append((Iterable)editors).first();
                    if (options != null) {
                        IdeFocusManager.getInstance((Project)configurable.getProject()).requestFocus((Component)options.getTextField(), true);
                    }
                });
            }));
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(7);
            }
            return string;
        }
        Pattern lineColumnPattern = Pattern.compile(LINE_COLUMN_PATTERN);
        Pattern offsetPattern = Pattern.compile(OFFSET_PATTERN);
        if (lineColumnPattern.matcher(sb).find() || offsetPattern.matcher(sb).find()) {
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(8);
            }
            return string;
        }
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            String string = super.getErrorMessage(dataSource, original, cause, fixes);
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(9);
            }
            return string;
        }
        Matcher lcMatcher = lineColumnPattern.matcher(causeMessage);
        if (lcMatcher.find()) {
            String line = lcMatcher.group(2);
            String column2 = lcMatcher.group(3);
            sb.append(String.format("Line: %s, column: %s", line, column2));
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(10);
            }
            return string;
        }
        Matcher oMatcher = offsetPattern.matcher(causeMessage);
        if (oMatcher.find()) {
            String offset = oMatcher.group(2);
            sb.append(String.format("Position: %s", offset));
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = super.getErrorMessage(dataSource, original, cause, fixes);
        if (string == null) {
            OraErrorHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    public Boolean mayRequestPassword(@NotNull SQLException e) {
        if (e == null) {
            OraErrorHandler.$$$reportNull$$$0(13);
        }
        if (e.getErrorCode() == 28001) {
            return true;
        }
        if (e.getErrorCode() == 12705) {
            return false;
        }
        return super.mayRequestPassword(e);
    }

    @Override
    public boolean isPasswordExpired(@NotNull SQLException e) {
        if (e == null) {
            OraErrorHandler.$$$reportNull$$$0(14);
        }
        return e.getErrorCode() == 28001;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraErrorHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraErrorHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffsetFromException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPasswordExpired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

