/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dialects.oracle.debugger.OraDebuggerSettings;
import com.intellij.database.dialects.oracle.debugger.SteppingMode;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSteppingConfigurableUI;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings;", "()V", "steppingAtBeginCb", "Ljavax/swing/JCheckBox;", "steppingModeSelector", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/database/dialects/oracle/debugger/SteppingMode;", "apply", "", "settings", "getComponent", "Ljavax/swing/JComponent;", "isModified", "", "reset", "Companion", "intellij.database.dialects.oracle"})
public final class OraDebuggerSteppingConfigurableUI
implements ConfigurableUi<OraDebuggerSettings> {
    private final ComboBox<SteppingMode> steppingModeSelector;
    private final JCheckBox steppingAtBeginCb;
    private static final String steppingModeNote;
    private static final String pauseAtBeginNote = "Pause at the first command in the script.";
    @Deprecated
    public static final Companion Companion;

    public void reset(@NotNull OraDebuggerSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.steppingModeSelector.setSelectedItem((Object)settings.getSteppingMode());
        this.steppingAtBeginCb.setSelected(settings.getSteppingPauseAtBegin());
    }

    public boolean isModified(@NotNull OraDebuggerSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return this.steppingModeSelector.getSelectedItem() != settings.getSteppingMode() || this.steppingAtBeginCb.isSelected() != settings.getSteppingPauseAtBegin();
    }

    public void apply(@NotNull OraDebuggerSettings settings) {
        SteppingMode steppingMode;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Object object = this.steppingModeSelector.getSelectedItem();
        if (!(object instanceof SteppingMode)) {
            object = null;
        }
        if ((steppingMode = (SteppingMode)((Object)object)) == null) {
            steppingMode = SteppingMode.STEPPING_GRACEFUL;
        }
        settings.setSteppingMode(steppingMode);
        settings.setSteppingPauseAtBegin(this.steppingAtBeginCb.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        JLabel jLabel = new JLabel("Stepping mode:");
        boolean bl = false;
        boolean bl2 = false;
        JLabel $this$apply22 = jLabel;
        boolean bl3 = false;
        $this$apply22.setLabelFor((Component)this.steppingModeSelector);
        $this$apply22.setToolTipText(steppingModeNote);
        JLabel steppingModeLabel = jLabel;
        JLabel jLabel2 = new JLabel("Pause at begin:");
        bl2 = false;
        boolean $this$apply22 = false;
        JLabel $this$apply = jLabel2;
        boolean bl4 = false;
        $this$apply.setLabelFor(this.steppingAtBeginCb);
        $this$apply.setToolTipText(pauseAtBeginNote);
        JLabel steppingAtBeginLabel = jLabel2;
        JPanel grid = new JPanel(new GridBagLayout());
        grid.add((Component)steppingModeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        grid.add((Component)this.steppingModeSelector, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        grid.add((Component)steppingAtBeginLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        grid.add((Component)this.steppingAtBeginCb, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel corner = new JPanel(new FlowLayout(0));
        corner.add(grid);
        JBScrollPane scroller = new JBScrollPane((Component)corner);
        return (JComponent)scroller;
    }

    public OraDebuggerSteppingConfigurableUI() {
        ComboBox comboBox;
        Object object = new ComboBox((Object[])SteppingMode.values());
        OraDebuggerSteppingConfigurableUI oraDebuggerSteppingConfigurableUI = this;
        boolean bl = false;
        boolean bl2 = false;
        ComboBox $this$apply = object;
        boolean bl3 = false;
        $this$apply.setToolTipText(steppingModeNote);
        oraDebuggerSteppingConfigurableUI.steppingModeSelector = comboBox = object;
        object = new JCheckBox("");
        oraDebuggerSteppingConfigurableUI = this;
        bl = false;
        bl2 = false;
        $this$apply = object;
        boolean bl4 = false;
        $this$apply.setToolTipText(pauseAtBeginNote);
        comboBox = object;
        oraDebuggerSteppingConfigurableUI.steppingAtBeginCb = comboBox;
    }

    static {
        Companion = new Companion(null);
        steppingModeNote = "<html>\n              <b>Graceful mode</b> allows you to set and remove breakpoints when the process     <br> \n              that you debug is running and pause this process. If no valid breakpoints are set, <br>\n              debugger steps through code on a command-by-command basis.                         <br>\n              <b>Native mode</b> uses Oracle native debugging commands. If no                    <br>\n              valid breakpoints are set, the debugger executes the whole routine. In this mode,  <br>\n              you can only kill the target (debugged) session.\n             </html>";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSteppingConfigurableUI$Companion;", "", "()V", "pauseAtBeginNote", "", "steppingModeNote", "intellij.database.dialects.oracle"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

