/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntroQueriesKt;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBase;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBase$DatabaseRetriever$retrieveLanguages$1$$special$;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBase$SchemaRetriever$retrieveFunSources$;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBase$SchemaRetriever$retrieveViewSources$;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBaseKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseArgument;
import com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLanguage;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRegularTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoot;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTableColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseView;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PgDataTypeSubKind;
import com.intellij.database.model.properties.PgDateInputStyle;
import com.intellij.database.model.properties.PgOperatorKind;
import com.intellij.database.model.properties.PgTimeZone;
import com.intellij.database.model.properties.PgVolatilityKind;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Rewriters;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.util.StringOperator;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.StringFun;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 O*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\u0003OPQB\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J9\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00028\u00010\u001dR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010!J,\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0004J.\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u001c\u0010-\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110/\u0012\u0006\u0012\u0004\u0018\u00010\u00110.H\u0004J&\u00100\u001a\b\u0012\u0004\u0012\u00028\u0001012\u0006\u00102\u001a\u00020\u001f2\u000e\u00103\u001a\n\u0012\u0004\u0012\u000205\u0018\u000104H\u0014J!\u00106\u001a\u00020#2\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b08\"\u00020\u001bH\u0016\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020#H\u0016J\u0012\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010%H\u0004J\b\u0010>\u001a\u00020<H\u0014J\u0014\u0010?\u001a\u0004\u0018\u00010@2\b\u0010A\u001a\u0004\u0018\u00010%H\u0002J\u001d\u0010B\u001a\u00020#2\u0006\u00102\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010CJ(\u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020%H\u0004J\"\u0010I\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020<0J2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020K01H\u0016J\u0010\u0010M\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010N\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006R"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase;", "MR", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoot;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/Dbms;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "affectedKeySchemaIds", "Lcom/intellij/util/containers/ArrayListSet;", "", "helper", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "connectionDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase$DatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;)Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase$DatabaseRetriever;", "freezeOnWrapAround", "", "param", "", "memory", "", "ageComputable", "Lkotlin/Function0;", "", "getCurrentXid", "defaultValue", "retriever", "Lkotlin/Function1;", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "getDatabasesToIntrospect", "", "tran", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectServerObjects", "isColumnNameSurrogate", "", "it", "isItPossibleToRetieveCurrentXid", "parseDateStyle", "Lcom/intellij/database/model/properties/PgDateInputStyle;", "s", "postProcessDatabase", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;)V", "progress", "increment", "kind", "name", "what", "retrieveInvalid", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "retrieveSettings", "retrieveTimeZones", "Companion", "DatabaseRetriever", "SchemaRetriever", "intellij.database.dialects.postgresbase"})
public abstract class PgIntrospectorBase<MR extends PgBaseRoot, D extends PgBaseDatabase, S extends PgBaseLikeSchema>
extends BaseMultiDatabaseIntrospector<MR, D, S> {
    private final ArrayListSet<Long> affectedKeySchemaIds;
    public static final int FROZEN_TXID = 2;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract PgBaseModelHelper getHelper();

    @NotNull
    protected abstract PgBaseIntroQueries getQueries();

    protected final void progress(boolean increment, @NotNull String kind, @NotNull String name2, @NotNull String what) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        String mode = increment ? "incrementally" : "completely";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Introspecting %s %s (%s)";
        Object[] objectArray = new Object[]{kind, name2, mode};
        PgIntrospectorBase pgIntrospectorBase = this;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        pgIntrospectorBase.updateStatus(string3, what);
    }

    private final BasicDatabase connectionDatabase() {
        BasicDatabase basicDatabase;
        String databaseName = this.getDbConnectionInfo().databaseName;
        if (databaseName == null) {
            basicDatabase = null;
        } else {
            Object v4;
            block3: {
                BasicRoot basicRoot = this.getModel().getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"model.root");
                Iterable iterable = basicRoot.getAllDatabases();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"model.root.allDatabases");
                Iterable iterable2 = iterable;
                boolean bl = false;
                Iterable iterable3 = iterable2;
                boolean bl2 = false;
                for (Object t : iterable3) {
                    BasicDatabase it = (BasicDatabase)t;
                    boolean bl3 = false;
                    BasicDatabase basicDatabase2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicDatabase2, (String)"it");
                    if (!Intrinsics.areEqual((Object)basicDatabase2.getName(), (Object)databaseName)) continue;
                    v4 = t;
                    break block3;
                }
                v4 = null;
            }
            basicDatabase = v4;
        }
        return basicDatabase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull D database) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        BaseIntrospector baseIntrospector = this;
        String operationName$iv = "Detect and handle cross-schema foreign keys";
        boolean $i$f$handleErrors = false;
        try {
            boolean bl = false;
            Collection collection = (Collection)this.affectedKeySchemaIds;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                void $this$toTypedArray$iv;
                String signs = StringFun.replicate((String)"?", (int)this.affectedKeySchemaIds.size(), (String)",", (String)"null");
                SqlQuery sqlQuery = this.getQueries().getListReferencingSchemas().rewrite(Rewriters.replace((String)"SCHEMAIDS", (String)signs));
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"queries.listReferencingS\u2026lace(\"SCHEMAIDS\", signs))");
                SqlQuery query = sqlQuery;
                Object object = (Collection)this.affectedKeySchemaIds;
                DBQueryRunner dBQueryRunner = tran.query(query);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Long[] longArray = thisCollection$iv.toArray(new Long[0]);
                if (longArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Long[] longArray2 = longArray;
                DBQueryRunner dBQueryRunner2 = dBQueryRunner.withParams((Object[])Arrays.copyOf(longArray2, longArray2.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)dBQueryRunner2, (String)"tran.query(query).withPa\u2026SchemaIds.toTypedArray())");
                long[] referencingSchemaIds = (long[])BaseIntroQueriesKt.runAndClose(dBQueryRunner2);
                Intrinsics.checkExpressionValueIsNotNull((Object)referencingSchemaIds, (String)"referencingSchemaIds");
                object = referencingSchemaIds;
                boolean bl3 = false;
                if (!(((Object)object).length == 0)) {
                    this.getModel().modify((BasicElement)database, PgBaseDatabase.class, (ModelModifier)new ModelModifier<PgBaseDatabase>(referencingSchemaIds, this, tran, (PgBaseDatabase)database){
                        final /* synthetic */ long[] $referencingSchemaIds;
                        final /* synthetic */ PgIntrospectorBase this$0;
                        final /* synthetic */ DBTransaction $tran$inlined;
                        final /* synthetic */ PgBaseDatabase $database$inlined;
                        {
                            this.$referencingSchemaIds = lArray;
                            this.this$0 = pgIntrospectorBase;
                            this.$tran$inlined = dBTransaction;
                            this.$database$inlined = pgBaseDatabase;
                        }

                        public final void perform(PgBaseDatabase database) {
                            PgBaseDatabase pgBaseDatabase = database;
                            Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseDatabase, (String)"database");
                            for (PgBaseSchema schema : pgBaseDatabase.getSchemas()) {
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.$referencingSchemaIds, (String)"referencingSchemaIds");
                                PgBaseSchema pgBaseSchema = schema;
                                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseSchema, (String)"schema");
                                if (!ArraysKt.contains((long[])this.$referencingSchemaIds, (long)pgBaseSchema.getObjectId())) continue;
                                Iterator iterator = schema.getTables().iterator();
                                while (iterator.hasNext()) {
                                    PgBaseRegularTable table;
                                    PgBaseRegularTable pgBaseRegularTable = table = (PgBaseRegularTable)iterator.next();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseRegularTable, (String)"table");
                                    Iterator iterator2 = pgBaseRegularTable.getForeignKeys().iterator();
                                    while (iterator2.hasNext()) {
                                        PgBaseForeignKey fk;
                                        PgBaseForeignKey pgBaseForeignKey = fk = (PgBaseForeignKey)iterator2.next();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseForeignKey, (String)"fk");
                                        if (pgBaseForeignKey.getRefTableId() <= 0L || fk.getRefTable() != null) {
                                            List<Short> list = fk.getRefColPositions();
                                            Intrinsics.checkExpressionValueIsNotNull(list, (String)"fk.refColPositions");
                                            Collection collection = list;
                                            boolean bl = false;
                                            if (!(!collection.isEmpty()) || !fk.getRefColNames().isEmpty()) continue;
                                        }
                                        this.this$0.getHelper().resolveReference(fk);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    @Override
    public void introspectServerObjects() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ PgIntrospectorBase this$0;

            public final void invoke(@NotNull DBTransaction trans) {
                Intrinsics.checkParameterIsNotNull((Object)trans, (String)"trans");
                PgIntrospectorBase.access$retrieveSettings(this.this$0, trans);
                PgIntrospectorBase.access$retrieveTimeZones(this.this$0, trans);
            }
            {
                this.this$0 = pgIntrospectorBase;
                super(1);
            }
        }));
    }

    private final void retrieveSettings(DBTransaction transaction) {
        String dateStyle = this.performQuery(transaction, this.getQueries().getRetrieveDateStyle());
        this.inModel((Function1)new Function1<MR, Unit>(this, dateStyle){
            final /* synthetic */ PgIntrospectorBase this$0;
            final /* synthetic */ String $dateStyle;

            public final void invoke(@NotNull MR root2) {
                Intrinsics.checkParameterIsNotNull(root2, (String)"root");
                root2.setDateStyle(PgIntrospectorBase.access$parseDateStyle(this.this$0, this.$dateStyle));
            }
            {
                this.this$0 = pgIntrospectorBase;
                this.$dateStyle = string;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void retrieveTimeZones(DBTransaction transaction) {
        void $this$mapTo$iv$iv;
        List<PgBaseIntroQueries.OneTimeZone> list = this.performQuery(transaction, this.getQueries().getRetrieveTimeZones());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(transaction\u2026ueries.retrieveTimeZones)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PgBaseIntroQueries.OneTimeZone oneTimeZone = (PgBaseIntroQueries.OneTimeZone)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PgTimeZone pgTimeZone = new PgTimeZone(it.name, it.is_dst);
            collection.add(pgTimeZone);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PgTimeZone it = (PgTimeZone)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (PgTimeZone)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        List zones = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        this.inModel((Function1)new Function1<MR, Unit>(zones){
            final /* synthetic */ List $zones;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MR root2) {
                Map map2;
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Intrinsics.checkParameterIsNotNull(root2, (String)"root");
                Iterable iterable = this.$zones;
                MR MR = root2;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var5_6 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    PgTimeZone it;
                    PgTimeZone pgTimeZone = (PgTimeZone)element$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl = false;
                    String string = StringUtil.toLowerCase((String)it.getName());
                    it = (PgTimeZone)element$iv$iv;
                    boolean bl2 = false;
                    PgTimeZone pgTimeZone2 = new PgTimeZone(it.getName(), it.isDST());
                    map2.put(string, pgTimeZone2);
                }
                map2 = destination$iv$iv;
                MR.setTimeZones(map2);
            }
            {
                this.$zones = list;
                super(1);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PgDateInputStyle parseDateStyle(String s) {
        if (s == null) {
            return null;
        }
        int i2 = StringsKt.indexOf$default((CharSequence)s, (String)",", (int)0, (boolean)false, (int)6, null);
        if (i2 < 0) {
            return null;
        }
        String string = s;
        int n = i2 + 1;
        boolean bl = false;
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        string = string2;
        n = 0;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = StringUtil.toUpperCase((String)((Object)StringsKt.trim((CharSequence)string3)).toString());
        if (string4 == null) return null;
        switch (string4) {
            case "DMY": {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.DMY;
                return pgDateInputStyle;
            }
            case "MDY": {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.MDY;
                return pgDateInputStyle;
            }
            case "YMD": {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.YMD;
                return pgDateInputStyle;
            }
            default: {
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        BasicDatabase[] basicDatabaseArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)databases, (String)"databases");
        Iterable dbs2 = (Iterable)this.inTransaction((Function1)new Function1<DBTransaction, Iterable<? extends D>>(this, databases){
            final /* synthetic */ PgIntrospectorBase this$0;
            final /* synthetic */ BasicDatabase[] $databases;

            @NotNull
            public final Iterable<D> invoke(@NotNull DBTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.getDatabasesToIntrospect(it, ArraysKt.toList((Object[])this.$databases));
            }
            {
                this.this$0 = pgIntrospectorBase;
                this.$databases = basicDatabaseArray;
                super(1);
            }
        });
        Collection collection = CollectionsKt.toList((Iterable)dbs2);
        PgIntrospectorBase pgIntrospectorBase = this;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        BasicDatabase[] basicDatabaseArray2 = thisCollection$iv.toArray(new BasicDatabase[0]);
        if (basicDatabaseArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        BasicDatabase[] basicDatabaseArray3 = basicDatabaseArray = basicDatabaseArray2;
        super.introspectDatabaseSchemas(Arrays.copyOf(basicDatabaseArray3, basicDatabaseArray3.length));
    }

    @Override
    @NotNull
    protected DatabaseRetriever<D> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull D database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        return new DatabaseRetriever(this, transaction, database);
    }

    @Override
    @NotNull
    protected Iterable<D> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        BasicDatabase connectionDatabase;
        block20: {
            block19: {
                boolean bl;
                block16: {
                    List list;
                    block18: {
                        block17: {
                            boolean bl2;
                            block15: {
                                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                                if (namespaces == null || namespaces.isEmpty()) break block17;
                                Iterable $this$any$iv = namespaces;
                                boolean $i$f$any = false;
                                if (((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        BasicNamespace it = (BasicNamespace)element$iv;
                                        boolean bl3 = false;
                                        if (!(it instanceof PgBaseDatabase)) continue;
                                        bl2 = true;
                                        break block15;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) break block18;
                        }
                        this.introspectNamespacesInTran(tran);
                    }
                    if ((list = namespaces) == null || (list = CollectionsKt.filterIsInstance((Iterable)list, PgBaseDatabase.class)) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List filtered = list;
                    connectionDatabase = this.connectionDatabase();
                    if (connectionDatabase == null) break block19;
                    if (filtered.isEmpty()) break block20;
                    Iterable $this$any$iv = filtered;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PgBaseDatabase it = (PgBaseDatabase)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)connectionDatabase.getName())) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (bl) break block20;
            }
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty()");
            return (Iterable)jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)((PgBaseDatabase)connectionDatabase));
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.of(connectionDatabase as D)");
        return (Iterable)jBIterable;
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        BasicElement basicElement = (BasicElement)CollectionsKt.firstOrNull(elements2);
        if (basicElement == null || (basicElement = basicElement.getDatabase()) == null) {
            return MapsKt.emptyMap();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"elements.firstOrNull()?.\u2026base ?: return emptyMap()");
        BasicElement database = basicElement;
        boolean bl = false;
        LinkedHashMap ids = new LinkedHashMap();
        Iterable<? extends BasicElement> $this$forEach$iv = elements2;
        boolean $i$f$forEach = false;
        Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement element$iv;
            BasicElement it = element$iv = iterator.next();
            boolean bl2 = false;
            if (!PgIntrospectorBaseKt.canCheckOutdated(it)) continue;
            BasicElement basicElement2 = it;
            if (basicElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject");
            }
            PgBaseCatalogObject cfr_ignored_0 = (PgBaseCatalogObject)basicElement2;
            if (Intrinsics.areEqual((Object)database, (Object)((PgBaseCatalogObject)it).getDatabase()) ^ true) {
                this.getLog().error("Element from different database");
            }
            ((Map)ids).put(((PgBaseCatalogObject)it).getObjectId(), it);
        }
        if (ids.isEmpty()) {
            return MapsKt.emptyMap();
        }
        SqlQuery sqlQuery = this.getQueries().getRetrieveStates().rewrite(new StringOperator(ids){
            final /* synthetic */ LinkedHashMap $ids;

            @NotNull
            public final String apply(String s) {
                String string = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
                Set<K> set = this.$ids.keySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"ids.keys");
                return StringsKt.replace$default((String)string, (String)"OIDS", (String)CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)retrieveInvalid.states.1.INSTANCE, (int)31, null), (boolean)false, (int)4, null);
            }
            {
                this.$ids = linkedHashMap;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"queries.retrieveStates.r\u2026ring { it.toString() }) }");
        List states2 = (List)this.performQuery(sqlQuery);
        boolean bl3 = false;
        LinkedHashMap res2 = new LinkedHashMap();
        ids.forEach((BiConsumer)new BiConsumer<Long, PgBaseCatalogObject>(res2){
            final /* synthetic */ LinkedHashMap $res;

            public final void accept(@NotNull Long $noName_0, @NotNull PgBaseCatalogObject v2) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v");
                ((Map)this.$res).put(v2, false);
            }
            {
                this.$res = linkedHashMap;
            }
        });
        List list = states2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"states");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PgBaseCatalogObject obj2;
            PgBaseIntroQueries.OneState s = (PgBaseIntroQueries.OneState)element$iv;
            boolean bl4 = false;
            if ((PgBaseCatalogObject)ids.get(s.oid) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)obj2, (String)"ids[s.oid] ?: return@forEach");
            ((Map)res2).put(obj2, obj2.getStateNumber() == s.xmin);
        }
        this.inModel((Function1)new Function1<MR, Unit>(res2){
            final /* synthetic */ LinkedHashMap $res;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MR it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                Set<Map.Entry<K, V>> set = this.$res.entrySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"res.entries");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void obj2;
                    Map.Entry $dstr$obj$ok = (Map.Entry)element$iv;
                    boolean bl = false;
                    Map.Entry entry = $dstr$obj$ok;
                    boolean bl2 = false;
                    BasicElement basicElement = (BasicElement)entry.getKey();
                    entry = $dstr$obj$ok;
                    bl2 = false;
                    Boolean ok = (Boolean)entry.getValue();
                    void v1 = obj2;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    }
                    ((BasicModElement)v1).setOutdated(ok == false);
                }
            }
            {
                this.$res = linkedHashMap;
                super(1);
            }
        });
        return res2;
    }

    protected final void freezeOnWrapAround(@NotNull String param, @NotNull Set<String> memory, @NotNull Function0<Integer> ageComputable) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        Intrinsics.checkParameterIsNotNull(memory, (String)"memory");
        Intrinsics.checkParameterIsNotNull(ageComputable, (String)"ageComputable");
        if (memory.contains(param)) {
            return;
        }
        int age = ((Number)ageComputable.invoke()).intValue();
        if (age >= 0 && age != Integer.MAX_VALUE) {
            return;
        }
        this.setQueryParameter(param, 2);
        Collection collection = memory;
        boolean bl = false;
        collection.add(param);
    }

    protected final long getCurrentXid(long defaultValue, @NotNull Function1<? super SqlQuery<Long>, Long> retriever) {
        long l;
        Intrinsics.checkParameterIsNotNull(retriever, (String)"retriever");
        if (this.isItPossibleToRetieveCurrentXid()) {
            Long l2 = (Long)retriever.invoke(this.getQueries().currentXid);
            l = l2 != null ? l2 : 0L;
        } else {
            l = defaultValue;
        }
        return l;
    }

    protected boolean isItPossibleToRetieveCurrentXid() {
        return true;
    }

    protected final boolean isColumnNameSurrogate(@Nullable String it) {
        return it != null && StringsKt.startsWith$default((String)it, (String)"?", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"?", (boolean)false, (int)2, null);
    }

    public PgIntrospectorBase(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        super(dbms, project, modelFactory);
        this.affectedKeySchemaIds = new ArrayListSet();
    }

    public static final /* synthetic */ void access$writeSources(PgIntrospectorBase $this, Function0 r) {
        $this.writeSources((Function0<Unit>)r);
    }

    public static final /* synthetic */ void access$retrieveSettings(PgIntrospectorBase $this, DBTransaction transaction) {
        $this.retrieveSettings(transaction);
    }

    public static final /* synthetic */ void access$retrieveTimeZones(PgIntrospectorBase $this, DBTransaction transaction) {
        $this.retrieveTimeZones(transaction);
    }

    public static final /* synthetic */ PgDateInputStyle access$parseDateStyle(PgIntrospectorBase $this, String s) {
        return $this.parseDateStyle(s);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase$DatabaseRetriever;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;)V", "beforeSchemasRetrieval", "", "retrieveLanguages", "retrieveObjects", "retrieveSchemas", "intellij.database.dialects.postgresbase"})
    protected static class DatabaseRetriever<D extends PgBaseDatabase>
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<D> {
        final /* synthetic */ PgIntrospectorBase this$0;

        @Override
        protected void beforeSchemasRetrieval() {
            super.beforeSchemasRetrieval();
            this.setQueryParameter("INTROSPECTSYSTEMSCHEMAS", Registry.is((String)"database.postgres.introspect.system.schemas", (boolean)false));
        }

        @Override
        public void retrieveObjects() {
            super.retrieveObjects();
            this.retrieveLanguages();
        }

        private final void retrieveLanguages() {
            List<PgBaseIntroQueries.OneLanguage> languages = this.performQuery(this.this$0.getQueries().getListLanguages());
            this.inDatabase((Function1)new Function1<D, Unit>(languages){
                final /* synthetic */ List $languages;

                public final void invoke(@NotNull D db) {
                    Intrinsics.checkParameterIsNotNull(db, (String)"db");
                    boolean $i$f$cleanupFamilies = false;
                    Function1 it = DatabaseRetriever$retrieveLanguages$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                    boolean bl = false;
                    ModNamingFamily<? extends PgBaseLanguage> modNamingFamily = db.getLanguages();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"db.languages");
                    it.invoke(modNamingFamily);
                    boolean bl2 = false;
                    Iterable $this$forEach$iv = this.$languages;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PgBaseIntroQueries.OneLanguage it2 = (PgBaseIntroQueries.OneLanguage)element$iv;
                        boolean bl3 = false;
                        db.getLanguages().createOrGet(it2.lanname);
                    }
                    it = DatabaseRetriever$retrieveLanguages$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                    $i$a$-cleanupFamilies-PgIntrospectorBase$DatabaseRetriever$retrieveLanguages$1$1 = false;
                    ModNamingFamily<? extends PgBaseLanguage> modNamingFamily2 = db.getLanguages();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"db.languages");
                    it.invoke(modNamingFamily2);
                }
                {
                    this.$languages = list;
                    super(1);
                }
            });
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            if (Intrinsics.areEqual((Object)((PgBaseDatabase)this.getDatabase()).getName(), (Object)((PgIntrospectorBase)this.this$0).getDbConnectionInfo().databaseName) ^ true) {
                return;
            }
            List<PgBaseIntroQueries.IdNameCommentOwner> scs = this.performQuery(this.this$0.getQueries().getListSchemas());
            this.inDatabase((Function1)new Function1<D, Unit>(scs){
                final /* synthetic */ List $scs;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull D db) {
                    void $this$applySchemasImpl$iv;
                    Intrinsics.checkParameterIsNotNull(db, (String)"db");
                    ModNamingIdentifyingFamily<? extends PgBaseSchema> modNamingIdentifyingFamily = db.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"db.schemas");
                    ModNamingFamily modNamingFamily = (ModNamingFamily)modNamingIdentifyingFamily;
                    List scs$iv = this.$scs;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv = scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void sc2;
                        T element$iv$iv;
                        T sc$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner = (PgBaseIntroQueries.IdNameCommentOwner)sc$iv;
                        void $this$applySchemasImpl = $this$applySchemasImpl$iv;
                        boolean bl2 = false;
                        BasicModNamedElement basicModNamedElement = db.getSchemas().renew(sc2.id, sc2.name);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        PgBaseSchema $this$apply = (PgBaseSchema)basicModNamedElement;
                        boolean bl5 = false;
                        $this$apply.setStateNumber(sc2.state_number);
                        $this$apply.setComment(sc2.description);
                        $this$apply.setOwner(sc2.getOwnerName());
                        PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner2 = (PgBaseIntroQueries.IdNameCommentOwner)CollectionsKt.firstOrNull((List)this.$scs);
                        $this$apply.setCurrent(idNameCommentOwner2 != null && idNameCommentOwner2.id == $this$apply.getObjectId());
                        PgBaseSchema cfr_ignored_0 = (PgBaseSchema)basicModNamedElement;
                    }
                    $this$applySchemasImpl$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv.sort();
                }
                {
                    this.$scs = list;
                    super(1);
                }
            });
        }

        public DatabaseRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull(database, (String)"database");
            this.this$0 = $outer;
            super((BaseMultiDatabaseIntrospector)$outer, tran, (BasicModMateDatabase)database);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0014J\u001a\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020\rH\u0014J\u001d\u0010-\u001a\u00020.2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010/\u001a\u000200H\u0014\u00a2\u0006\u0002\u00101J)\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0007\u001a\u00028\u00032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020$H\u0014J#\u00109\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020<0;0:2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u00020\nH\u0014J'\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010A\u001a\u0002052\u0006\u0010B\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010CJ(\u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020\rH\u0014J \u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020@2\u0006\u0010H\u001a\u00020\r2\u0006\u0010J\u001a\u00020\rH\u0014J\b\u0010K\u001a\u00020$H\u0002J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020NH\u0014J\b\u0010O\u001a\u00020\u000fH\u0014J\u001d\u0010P\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010RJ\u0010\u0010S\u001a\u00020\u000f2\u0006\u00104\u001a\u000205H\u0014J\u0014\u0010T\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0:0UH$J\b\u0010W\u001a\u00020$H\u0002J\b\u0010X\u001a\u00020$H\u0014J\b\u0010Y\u001a\u00020$H\u0004J\u0018\u0010Z\u001a\u00020$2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0014J0\u0010_\u001a\u00020$\"\b\b\u0004\u0010`*\u00020a2\u0006\u0010/\u001a\u00020b2\f\u0010c\u001a\b\u0012\u0004\u0012\u0002H`0d2\u0006\u0010e\u001a\u00020fH\u0002J\u0018\u0010g\u001a\u00020$2\u0006\u0010E\u001a\u00020h2\u0006\u0010M\u001a\u00020NH\u0014J0\u0010i\u001a\u00020$2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020m2\u000e\u0010n\u001a\n\u0012\u0006\b\u0001\u0012\u00020m0d2\u0006\u0010E\u001a\u00020@H\u0014J#\u0010o\u001a\u00020$2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020k0q2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010rJ%\u0010s\u001a\u00020$2\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020w2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010xJ-\u0010y\u001a\u00020$2\u0006\u0010z\u001a\u00020{2\u0006\u0010E\u001a\u00020h2\u0006\u0010M\u001a\u00020N2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010|J \u0010}\u001a\u00020$2\u0006\u0010~\u001a\u00020\u007f2\u0006\u0010E\u001a\u00020h2\u0006\u0010M\u001a\u00020NH\u0014J\u001b\u0010\u0080\u0001\u001a\u00020$2\u0006\u0010E\u001a\u00020h2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H$J\u001b\u0010\u0083\u0001\u001a\u00020$2\u0006\u0010E\u001a\u00020@2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H$J\u001d\u0010\u0084\u0001\u001a\u00020$2\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0014J)\u0010\u0089\u0001\u001a\u00020$2\u0006\u0010E\u001a\u00020@2\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010\u008a\u0001\u001a\u00030\u0082\u0001H\u0014\u00a2\u0006\u0003\u0010\u008b\u0001J&\u0010\u008c\u0001\u001a\u00020$2\u000e\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u00030\u0082\u00010q2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010rJ\u001d\u0010\u008e\u0001\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010@2\b\u0010)\u001a\u0004\u0018\u00010\rH\u0014J\u0012\u0010\u008f\u0001\u001a\u00020$2\u0007\u0010\u0090\u0001\u001a\u00020\rH\u0004J'\u0010\u0091\u0001\u001a\u00020$2\u0013\u0010\u0092\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0:0U2\u0007\u0010\u0093\u0001\u001a\u00020<H\u0014J!\u0010\u0094\u0001\u001a\u00020$2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u0097\u0001J\t\u0010\u0098\u0001\u001a\u00020$H\u0014J3\u0010\u0099\u0001\u001a\u0004\u0018\u00010@2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010A\u001a\u0002052\u0007\u0010\u009a\u0001\u001a\u00020\n2\u0007\u0010\u009b\u0001\u001a\u00020\rH\u0014\u00a2\u0006\u0003\u0010\u009c\u0001J\t\u0010\u009d\u0001\u001a\u00020$H\u0002J\t\u0010\u009e\u0001\u001a\u00020$H\u0002J\t\u0010\u009f\u0001\u001a\u00020$H\u0014J\t\u0010\u00a0\u0001\u001a\u00020$H\u0014J\t\u0010\u00a1\u0001\u001a\u00020$H\u0002J\t\u0010\u00a2\u0001\u001a\u00020$H\u0014J\t\u0010\u00a3\u0001\u001a\u00020$H\u0002J\t\u0010\u00a4\u0001\u001a\u00020$H\u0002J\t\u0010\u00a5\u0001\u001a\u00020$H\u0002J\t\u0010\u00a6\u0001\u001a\u00020$H\u0002J\t\u0010\u00a7\u0001\u001a\u00020$H\u0002J\t\u0010\u00a8\u0001\u001a\u00020$H\u0004J\t\u0010\u00a9\u0001\u001a\u00020\u000fH\u0004J\t\u0010\u00aa\u0001\u001a\u00020\u000fH\u0014J\u0011\u0010\u00ab\u0001\u001a\u00020$2\u0006\u0010E\u001a\u00020hH\u0014J\u0016\u0010\u00ac\u0001\u001a\t\u0012\u0005\u0012\u00030\u00ad\u00010:H\u0014\u00a2\u0006\u0003\u0010\u00ae\u0001J\t\u0010\u00af\u0001\u001a\u00020\u000fH\u0014J%\u0010\u00b0\u0001\u001a\u00020$*\u00028\u00032\u0007\u0010\u00b1\u0001\u001a\u00020\r2\u0007\u0010\u00b2\u0001\u001a\u00020\rH\u0002\u00a2\u0006\u0003\u0010\u00b3\u0001R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001c\u00a8\u0006\u00b4\u0001"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase$SchemaRetriever;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "myBeginIntrospectionSchemaStateNumber", "", "myFrozen", "", "", "myHasChanges", "", "myTypes", "", "Lcom/intellij/database/model/DataType;", "getMyTypes", "()Ljava/util/Map;", "setMyTypes", "(Ljava/util/Map;)V", "srcFromTx", "wasStructures", "getWasStructures", "()Z", "setWasStructures", "(Z)V", "wasTables", "getWasTables", "setWasTables", "wasViews", "getWasViews", "setWasViews", "analyzeBriefInfo", "", "analyzeCurrentContent", "applySourceText", "view", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseView;", "sourceText", "createCompositeText", "Lcom/intellij/database/script/SimpleCompositeText;", "source", "createRoutine", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "findObjectById", "Lcom/intellij/database/model/basic/BasicElement;", "kind", "", "id", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicElement;", "finishSchema", "getSchemaChildrenToDrop", "", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "getSchemaStateNumber", "getTableOrView", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "relKind", "tableId", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJ)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "handleColumnRenaming", "table", "childrenKind", "Lcom/intellij/database/model/ObjectKind;", "oldName", "newName", "tableName", "handleXidWrapAround", "hasReference", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "incrementalViewSources", "isPossibleToIntrospectSchemaIncrementally", "tran", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)Z", "isTableKind", "listExistentComments", "Lgnu/trove/TLongObjectHashMap;", "", "obtainUsedTypes", "performNonIncrementalPart", "prepareParameters", "processAggregate", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "processArgs", "T", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$ArgumentHolder;", "family", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "processCheck", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "processColumns", "cols", "", "(Ljava/util/List;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processForeignKey", "fkey", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processKey", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseKey;", "processModTable", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "processOperator", "o", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneOperator;", "operator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "processTable", "oneTable", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "processTables", "ts", "processViewSource", "progress", "what", "removeComments", "existentComments", "e", "removeDroppedClasses", "existentIds", "Lgnu/trove/TLongHashSet;", "(Lgnu/trove/TLongHashSet;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "removeDroppedComments", "renewTableOrView", "objectId", "objectName", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJLjava/lang/String;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "retrieveAggregates", "retrieveConstraints", "retrieveDataTypes", "retrieveDescriptions", "retrieveFunSources", "retrieveMainContent", "retrieveOperators", "retrieveRoutines", "retrieveStructAttributes", "retrieveTableColumns", "retrieveTables", "retrieveViewSources", "shouldIntrospectTableRelatedData", "shouldIntrospectTableRelatedDataIncremental", "sortConstraints", "steps", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "()[Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "wasDataTables", "handleTableRenaming", "old", "new", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Ljava/lang/String;Ljava/lang/String;)V", "intellij.database.dialects.postgresbase"})
    protected static abstract class SchemaRetriever<S extends PgBaseSchema>
    extends BaseIntrospector.AbstractSchemaRetriever<S> {
        private long myBeginIntrospectionSchemaStateNumber;
        private boolean myHasChanges;
        @NotNull
        protected Map<Long, DataType> myTypes;
        private boolean wasStructures;
        private boolean wasTables;
        private boolean wasViews;
        private final long srcFromTx;
        private final Set<String> myFrozen;
        final /* synthetic */ PgIntrospectorBase this$0;

        @NotNull
        protected final Map<Long, DataType> getMyTypes() {
            Map<Long, DataType> map2 = this.myTypes;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
            }
            return map2;
        }

        protected final void setMyTypes(@NotNull Map<Long, DataType> map2) {
            Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
            this.myTypes = map2;
        }

        protected final boolean getWasStructures() {
            return this.wasStructures;
        }

        protected final void setWasStructures(boolean bl) {
            this.wasStructures = bl;
        }

        protected final boolean getWasTables() {
            return this.wasTables;
        }

        protected final void setWasTables(boolean bl) {
            this.wasTables = bl;
        }

        protected final boolean getWasViews() {
            return this.wasViews;
        }

        protected final void setWasViews(boolean bl) {
            this.wasViews = bl;
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            return true;
        }

        protected final void progress(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            boolean bl = this.getMode().increment;
            String string = ((PgBaseSchema)this.getSchema()).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.name");
            this.this$0.progress(bl, "schema", string, what);
        }

        @Override
        protected final void prepareParameters() {
            super.prepareParameters();
            long stateNumber = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber() : 0L;
            this.setQueryParameter("tx", stateNumber);
            this.setQueryParameter("src_tx", this.getWithSources() ? this.srcFromTx : stateNumber);
        }

        @Override
        protected void analyzeBriefInfo() {
            long currentSchemaStateNumber;
            Boolean bl = this.performQuery(this.this$0.getQueries().getCheckSchemaChanges());
            this.myHasChanges = bl != null ? bl : true;
            long currentTx2 = this.this$0.getCurrentXid(((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber(), (Function1<SqlQuery<Long>, Long>)((Function1)new Function1<SqlQuery<Long>, Long>(this){

                @Nullable
                public final Long invoke(@NotNull SqlQuery<Long> p1) {
                    Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                    return (Long)SchemaRetriever.access$performQuery((SchemaRetriever)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(SchemaRetriever.class);
                }

                public final String getName() {
                    return "performQuery";
                }

                public final String getSignature() {
                    return "performQuery(Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;";
                }
            }));
            Long l = this.performQuery(this.this$0.getQueries().stateNumber);
            this.myBeginIntrospectionSchemaStateNumber = currentSchemaStateNumber = l != null ? l : currentTx2;
        }

        @Override
        protected void analyzeCurrentContent() {
            long[] existentIdsArray = this.performQuery(this.this$0.getQueries().getListExistentClasses());
            TLongHashSet existentIds = new TLongHashSet(existentIdsArray);
            this.inSchema((Function1)new Function1<S, Unit>(this, existentIds){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $existentIds;

                public final void invoke(@NotNull S it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    this.this$0.removeDroppedClasses(this.$existentIds, it);
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$existentIds = tLongHashSet;
                    super(1);
                }
            });
            this.removeDroppedComments();
        }

        protected void removeDroppedComments() {
            TLongObjectHashMap<Short[]> existentComments = this.listExistentComments();
            this.inSchema((Function1)new Function1<S, Unit>(this, existentComments){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ TLongObjectHashMap $existentComments;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    for (BasicModElement c : schema.getChildren()) {
                        if (!(c instanceof BasicModIdentifiedElement)) continue;
                        this.this$0.removeComments((TLongObjectHashMap<Short[]>)this.$existentComments, (BasicModIdentifiedElement)c);
                    }
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$existentComments = tLongObjectHashMap;
                    super(1);
                }
            });
        }

        @NotNull
        protected abstract TLongObjectHashMap<Short[]> listExistentComments();

        protected void removeComments(@NotNull TLongObjectHashMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e) {
            Object[] commented;
            Intrinsics.checkParameterIsNotNull(existentComments, (String)"existentComments");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            BasicModNamedElement cfr_ignored_0 = (BasicModNamedElement)e;
            Object[] objectArray = (Short[])existentComments.get(e.getObjectId());
            if (objectArray == null) {
                objectArray = commented = new Short[]{};
            }
            if (!ArraysKt.contains((Object[])commented, (Object)((short)0))) {
                ((BasicModNamedElement)e).setComment(null);
            }
            if (e instanceof PgBaseDefType) {
                for (Object column2 : ((PgBaseDefType)e).getAttributes()) {
                    PgBaseDefTypeAttribute pgBaseDefTypeAttribute = column2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseDefTypeAttribute, (String)"column");
                    if (ArraysKt.contains((Object[])commented, (Object)pgBaseDefTypeAttribute.getPosition())) continue;
                    column2.setComment((String)null);
                }
            }
            if (e instanceof PgBaseLikeTable) {
                Iterator iterator = ((PgBaseLikeTable)e).getColumns().iterator();
                while (iterator.hasNext()) {
                    Object column2;
                    Object object = column2 = (PgBaseLikeColumn)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"column");
                    if (ArraysKt.contains((Object[])commented, (Object)object.getPosition())) continue;
                    column2.setComment((String)null);
                }
                iterator = ((PgBaseLikeTable)e).getKeys().iterator();
                while (iterator.hasNext()) {
                    BasicModKey k;
                    BasicModKey basicModKey = k = (BasicModKey)iterator.next();
                    if (basicModKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseKey");
                    }
                    this.removeComments(existentComments, (PgBaseKey)basicModKey);
                }
                iterator = ((PgBaseLikeTable)e).getForeignKeys().iterator();
                while (iterator.hasNext()) {
                    BasicModForeignKey fk;
                    BasicModForeignKey basicModForeignKey = fk = (BasicModForeignKey)iterator.next();
                    if (basicModForeignKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey");
                    }
                    this.removeComments(existentComments, (PgBaseForeignKey)basicModForeignKey);
                }
            }
        }

        protected void removeDroppedClasses(@NotNull TLongHashSet existentIds, @NotNull S schema) {
            Intrinsics.checkParameterIsNotNull((Object)existentIds, (String)"existentIds");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            ModIdentifyingFamily<BasicModIdentifiedElement>[] modIdentifyingFamilyArray = this.getSchemaChildrenToDrop(schema);
            PgIntrospectorBaseKt.removeDroppedChildren(existentIds, Arrays.copyOf(modIdentifyingFamilyArray, modIdentifyingFamilyArray.length));
            for (PgBaseRegularTable t : schema.getTables()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray2 = new ModIdentifyingFamily[2];
                PgBaseRegularTable pgBaseRegularTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseRegularTable, (String)"t");
                ModNamingIdentifyingFamily<? extends PgBaseKey> modNamingIdentifyingFamily = pgBaseRegularTable.getKeys();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"t.keys");
                modIdentifyingFamilyArray2[0] = (ModIdentifyingFamily)modNamingIdentifyingFamily;
                ModNamingIdentifyingFamily<? extends PgBaseForeignKey> modNamingIdentifyingFamily2 = t.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"t.foreignKeys");
                modIdentifyingFamilyArray2[1] = (ModIdentifyingFamily)modNamingIdentifyingFamily2;
                PgIntrospectorBaseKt.removeDroppedChildren(existentIds, modIdentifyingFamilyArray2);
            }
        }

        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull S schema) {
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[6];
            ModNamingIdentifyingFamily<? extends PgBaseDefType> modNamingIdentifyingFamily = schema.getDefTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.defTypes");
            modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)modNamingIdentifyingFamily;
            ModNamingIdentifyingFamily<? extends PgBaseRegularTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.tables");
            modIdentifyingFamilyArray[1] = (ModIdentifyingFamily)modNamingIdentifyingFamily2;
            ModNamingIdentifyingFamily<? extends PgBaseView> modNamingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily3, (String)"schema.views");
            modIdentifyingFamilyArray[2] = (ModIdentifyingFamily)modNamingIdentifyingFamily3;
            ModNamingIdentifyingFamily<? extends PgBaseRoutine> modNamingIdentifyingFamily4 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily4, (String)"schema.routines");
            modIdentifyingFamilyArray[3] = (ModIdentifyingFamily)modNamingIdentifyingFamily4;
            ModNamingIdentifyingFamily<? extends PgBaseOperator> modNamingIdentifyingFamily5 = schema.getOperators();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily5, (String)"schema.operators");
            modIdentifyingFamilyArray[4] = (ModIdentifyingFamily)modNamingIdentifyingFamily5;
            ModNamingIdentifyingFamily<? extends PgBaseAggregate> modNamingIdentifyingFamily6 = schema.getAggregates();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily6, (String)"schema.aggregates");
            modIdentifyingFamilyArray[5] = (ModIdentifyingFamily)modNamingIdentifyingFamily6;
            return modIdentifyingFamilyArray;
        }

        @Override
        protected void retrieveMainContent() {
            if (this.getMode().increment && !this.myHasChanges) {
                this.performNonIncrementalPart();
                return;
            }
            IntroStep[] steps2 = this.steps();
            Comparable[] comparableArray = steps2;
            int n = 0;
            if (comparableArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            ArraysKt.sort((Object[])comparableArray);
            for (IntroStep step : steps2) {
                this.handleXidWrapAround();
                step.perform();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleXidWrapAround() {
            void ages;
            if (!this.getMode().increment) {
                return;
            }
            this.setQueryParameter("schema_txid", ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber());
            if (this.getWithSources()) {
                this.setQueryParameter("sources_txid", this.srcFromTx);
            }
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            this.this$0.freezeOnWrapAround("tx", this.myFrozen, (Function0<Integer>)((Function0)new Function0<Integer>(this, (Ref.ObjectRef)ages){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ Ref.ObjectRef $ages;

                public final int invoke() {
                    this.$ages.element = (PgBaseIntroQueries.SchemaAges)SchemaRetriever.access$performQuery(this.this$0, this.this$0.this$0.getQueries().getSchemaAges());
                    PgBaseIntroQueries.SchemaAges schemaAges = (PgBaseIntroQueries.SchemaAges)this.$ages.element;
                    if (schemaAges == null) {
                        Intrinsics.throwNpe();
                    }
                    return schemaAges.schema_age;
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$ages = objectRef;
                    super(0);
                }
            }));
            if (this.getWithSources()) {
                this.this$0.freezeOnWrapAround("src_tx", this.myFrozen, (Function0<Integer>)((Function0)new Function0<Integer>(this, (Ref.ObjectRef)ages){
                    final /* synthetic */ SchemaRetriever this$0;
                    final /* synthetic */ Ref.ObjectRef $ages;

                    public final int invoke() {
                        if ((PgBaseIntroQueries.SchemaAges)this.$ages.element == null) {
                            this.$ages.element = (PgBaseIntroQueries.SchemaAges)SchemaRetriever.access$performQuery(this.this$0, this.this$0.this$0.getQueries().getSchemaAges());
                        }
                        PgBaseIntroQueries.SchemaAges schemaAges = (PgBaseIntroQueries.SchemaAges)this.$ages.element;
                        if (schemaAges == null) {
                            Intrinsics.throwNpe();
                        }
                        return schemaAges.sources_age;
                    }
                    {
                        this.this$0 = schemaRetriever;
                        this.$ages = objectRef;
                        super(0);
                    }
                }));
            }
        }

        protected void performNonIncrementalPart() {
            if (!this.incrementalViewSources()) {
                this.retrieveViewSources();
            }
        }

        protected boolean incrementalViewSources() {
            return false;
        }

        @Override
        protected long getSchemaStateNumber() {
            return this.myBeginIntrospectionSchemaStateNumber;
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            this.inSchema((Function1)new Function1<S, Unit>(this){
                final /* synthetic */ SchemaRetriever this$0;

                public final void invoke(@NotNull S it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    it.setIntrospectionStateNumber(SchemaRetriever.access$getMyBeginIntrospectionSchemaStateNumber$p(this.this$0));
                }
                {
                    this.this$0 = schemaRetriever;
                    super(1);
                }
            });
        }

        @NotNull
        protected IntroStep[] steps() {
            return new IntroStep[]{new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    this.this$0.retrieveDataTypes();
                }

                public int priority() {
                    return 10;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveTables(this.this$0);
                }

                public int priority() {
                    return 20;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$obtainUsedTypes(this.this$0);
                }

                public int priority() {
                    return 30;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveRoutines(this.this$0);
                }

                public int priority() {
                    return 40;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveAggregates(this.this$0);
                }

                public int priority() {
                    return 45;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveOperators(this.this$0);
                }

                public int priority() {
                    return 50;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveStructAttributes(this.this$0);
                }

                public int priority() {
                    return 60;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveTableColumns(this.this$0);
                }

                public int priority() {
                    return 70;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveConstraints(this.this$0);
                }

                public int priority() {
                    return 80;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    this.this$0.retrieveDescriptions();
                }

                public int priority() {
                    return 90;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    this.this$0.retrieveViewSources();
                }

                public int priority() {
                    return 100;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ SchemaRetriever this$0;

                public void perform() {
                    SchemaRetriever.access$retrieveFunSources(this.this$0);
                }

                public int priority() {
                    return 110;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }};
        }

        protected void retrieveDataTypes() {
            this.progress("data types");
            List<PgBaseIntroQueries.OneDataType> dts = this.performQuery(this.this$0.getQueries().getRetrieveDataTypes());
            Collection collection = dts;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.inSchema((Function1)new Function1<S, Unit>(this, dts){
                    final /* synthetic */ SchemaRetriever this$0;
                    final /* synthetic */ List $dts;

                    public final void invoke(@NotNull S sc2) {
                        Intrinsics.checkParameterIsNotNull(sc2, (String)"sc");
                        for (PgBaseIntroQueries.OneDataType dt : this.$dts) {
                            PgBaseDefType dataType;
                            PgBaseDefType pgBaseDefType = dataType = (PgBaseDefType)sc2.getDefTypes().renew(dt.type_id, dt.type_name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseDefType, (String)"dataType");
                            this.this$0.processDataType(pgBaseDefType, dt, sc2);
                        }
                    }
                    {
                        this.this$0 = schemaRetriever;
                        this.$dts = list;
                        super(1);
                    }
                });
            }
        }

        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull S schema) {
            Intrinsics.checkParameterIsNotNull((Object)dataType, (String)"dataType");
            Intrinsics.checkParameterIsNotNull((Object)oneType, (String)"oneType");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            PgDataTypeSubKind subKind = PgDataTypeSubKind.of((char)oneType.type_sub_kind);
            dataType.setStateNumber(oneType.type_state_number);
            dataType.setSubKind(subKind);
            String string = oneType.type_def;
            dataType.setDefinition(string != null ? PgIntrospectorBaseKt.normalizeDataTypeSpec(string) : null);
            dataType.setDefaultExpression(oneType.default_expression);
            dataType.setNotNull(oneType.mandatory);
            this.wasStructures = this.wasStructures || subKind == PgDataTypeSubKind.COMPOSITE;
        }

        private final void retrieveTables() {
            this.progress("tables and views");
            List<PgBaseIntroQueries.OneTable> ts2 = this.performQuery(this.this$0.getQueries().getRetrieveTables());
            if (ts2.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(this, ts2){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $ts;

                public final void invoke(@NotNull S it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    this.this$0.processTables(this.$ts, it);
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$ts = list;
                    super(1);
                }
            });
        }

        protected void processTables(@NotNull List<PgBaseIntroQueries.OneTable> ts2, @NotNull S schema) {
            Intrinsics.checkParameterIsNotNull(ts2, (String)"ts");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            for (PgBaseIntroQueries.OneTable t : ts2) {
                PgBaseLikeStoredTable table;
                char c = t.table_kind;
                long l = t.table_id;
                String string = t.table_name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if (this.renewTableOrView(schema, c, l, string) == null) {
                    continue;
                }
                this.processTable(table, schema, t);
            }
            if (this.wasTables) {
                schema.getTables().sort();
            }
            if (this.wasViews) {
                schema.getViews().sort();
            }
        }

        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull S schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)oneTable, (String)"oneTable");
            table.setStateNumber(oneTable.table_state_number);
            table.setOwner(oneTable.getOwnerName());
            PgBaseLikeStoredTable pgBaseLikeStoredTable = table;
            if (pgBaseLikeStoredTable instanceof PgBaseTable) {
                this.processModTable((PgBaseTable)table, oneTable);
            } else if (pgBaseLikeStoredTable instanceof PgBaseView) {
                this.processModView(table, oneTable);
            }
            this.wasTables = this.wasTables || this.isTableKind(oneTable.table_kind);
            this.wasViews = this.wasViews || oneTable.table_kind == 'v';
        }

        @Nullable
        protected PgBaseLikeStoredTable renewTableOrView(@NotNull S schema, char relKind, long objectId, @NotNull String objectName) {
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)objectName, (String)"objectName");
            if (this.isTableKind(relKind)) {
                pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getTables().renew(objectId, objectName, (BiConsumer)new BiConsumer<String, String>(this, (PgBaseSchema)schema){
                    final /* synthetic */ SchemaRetriever this$0;
                    final /* synthetic */ PgBaseSchema $schema;

                    public final void accept(String o, String n) {
                        String string = o;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o");
                        String string2 = n;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"n");
                        SchemaRetriever.access$handleTableRenaming(this.this$0, this.$schema, string, string2);
                    }
                    {
                        this.this$0 = schemaRetriever;
                        this.$schema = pgBaseSchema;
                    }
                });
            } else {
                PgBaseView pgBaseView;
                switch (relKind) {
                    case 'v': {
                        pgBaseView = (PgBaseView)schema.getViews().renew(objectId, objectName);
                        break;
                    }
                    default: {
                        pgBaseView = null;
                    }
                }
                pgBaseLikeStoredTable = pgBaseView;
            }
            return pgBaseLikeStoredTable;
        }

        protected boolean isTableKind(char kind) {
            return kind == 'r';
        }

        private final void retrieveStructAttributes() {
            if (!(this.wasStructures || this.getMode().increment && ((PgBaseSchema)this.getSchema()).getDefTypes().hasChildren())) {
                return;
            }
            this.progress("struct attributes");
            List<PgBaseIntroQueries.OneStructAttribute> ats = this.performQuery(this.this$0.getQueries().getRetrieveStructAttributes());
            if (ats.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(ats){
                final /* synthetic */ List $ats;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S schema) {
                    void $this$groupByTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    Iterable $this$groupBy$iv = this.$ats;
                    boolean $i$f$groupBy = false;
                    Object object = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object2;
                        PgBaseIntroQueries.OneStructAttribute it = (PgBaseIntroQueries.OneStructAttribute)element$iv$iv;
                        boolean bl = false;
                        Long key$iv$iv = it.type_id;
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object2 = answer$iv$iv$iv;
                        } else {
                            object2 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object2;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map $this$forEach$iv = destination$iv$iv;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        PgBaseDefType dataType;
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> entry = element$iv = iterator.next();
                        boolean bl3 = false;
                        if ((PgBaseDefType)schema.getDefTypes().getByObjectId(((Number)entry.getKey()).longValue()) == null) {
                            continue;
                        }
                        dataType.getAttributes().markChildrenAsSyncPending();
                        for (PgBaseIntroQueries.OneStructAttribute at : (List)entry.getValue()) {
                            DataType attributeType;
                            PgBaseDefTypeAttribute attribute;
                            if (at.att_dropped) continue;
                            PgBaseDefTypeAttribute pgBaseDefTypeAttribute = attribute = (PgBaseDefTypeAttribute)dataType.getAttributes().createOrGetAt(at.att_position);
                            Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseDefTypeAttribute, (String)"attribute");
                            String string = at.att_name;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            pgBaseDefTypeAttribute.setName(string);
                            if (at.att_type == null) continue;
                            String string2 = at.att_type;
                            if (string2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)DataTypeFactory.of((String)PgIntrospectorBaseKt.normalizeDataTypeSpec(string2)), (String)"DataTypeFactory.of(at.at\u2026.normalizeDataTypeSpec())");
                            attribute.setDataType(attributeType);
                        }
                        dataType.getAttributes().removeSyncPendingChildren();
                    }
                }
                {
                    this.$ats = list;
                    super(1);
                }
            });
        }

        private final void obtainUsedTypes() {
            Map<Long, String> typeSpecs = this.performQuery(this.this$0.getQueries().getRetrieveUsedArgumentTypes());
            this.myTypes = new HashMap(typeSpecs.size());
            for (Map.Entry<Long, String> entry : typeSpecs.entrySet()) {
                DataType type;
                long typeId = ((Number)entry.getKey()).longValue();
                String typeSpec = entry.getValue();
                typeSpec = PgIntrospectorBaseKt.normalizeDataTypeSpec(typeSpec);
                Intrinsics.checkExpressionValueIsNotNull((Object)DataTypeFactory.of((String)typeSpec), (String)"DataTypeFactory.of(typeSpec)");
                Map<Long, DataType> map2 = this.myTypes;
                if (map2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
                }
                map2.put(typeId, type);
            }
        }

        private final void retrieveRoutines() {
            this.progress("routines");
            List<PgBaseIntroQueries.OneRoutine> rs = this.performQuery(this.this$0.getQueries().getRetrieveRoutines());
            if (rs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(this, rs){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $rs;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    for (PgBaseIntroQueries.OneRoutine r : this.$rs) {
                        Object object;
                        PgBaseRoutine routine = this.this$0.createRoutine(schema, r);
                        routine.setLanguageName(DbUtil.intern2((String)r.lang));
                        routine.setStateNumber(r.r_state_number);
                        routine.setRoutineKind(r.kind == 'p' ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                        routine.setReturnsSet(r.ret_set);
                        routine.setVolatilityKind(PgVolatilityKind.of((char)r.volatile_kind));
                        PgBaseIntroQueries.ArgumentHolder argumentHolder = r;
                        ModPositioningNamingFamily<? extends PgBaseArgument> modPositioningNamingFamily = routine.getArguments();
                        Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"routine.arguments");
                        SchemaRetriever.access$processArgs(this.this$0, argumentHolder, modPositioningNamingFamily, routine);
                        if (r.arg_defaults != null) {
                            String[] defaults;
                            List list;
                            String string = r.arg_defaults;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            object = string;
                            String string2 = ",\\s+";
                            int n = 0;
                            string2 = new Regex(string2);
                            n = 0;
                            boolean bl = false;
                            List $this$dropLastWhile$iv = string2.split((CharSequence)object, n);
                            boolean $i$f$dropLastWhile = false;
                            if (!$this$dropLastWhile$iv.isEmpty()) {
                                ListIterator<E> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                                while (iterator$iv.hasPrevious()) {
                                    String p1 = (String)iterator$iv.previous();
                                    boolean bl2 = false;
                                    CharSequence charSequence = p1;
                                    boolean bl3 = false;
                                    if (charSequence.length() == 0) continue;
                                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                    break;
                                }
                            } else {
                                list = CollectionsKt.emptyList();
                            }
                            Collection $this$toTypedArray$iv = list;
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            if (thisCollection$iv.toArray(new String[0]) == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                            }
                            ModPositioningNamingFamily<? extends PgBaseArgument> modPositioningNamingFamily2 = routine.getArguments();
                            Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily2, (String)"routine.arguments");
                            List<E> arguments = BaseIntrospectionFunctions.toList((Family)modPositioningNamingFamily2);
                            int an = arguments.size();
                            int k = defaults.length;
                            int p1 = an - 1;
                            boolean bl4 = false;
                            while (p1 >= 0) {
                                void i2;
                                PgBaseArgument a;
                                PgBaseArgument pgBaseArgument = a = (PgBaseArgument)arguments.get((int)i2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseArgument, (String)"a");
                                ArgumentDirection argumentDirection = pgBaseArgument.getArgumentDirection();
                                Intrinsics.checkExpressionValueIsNotNull((Object)argumentDirection, (String)"a.argumentDirection");
                                if (argumentDirection.isIn()) {
                                    if (--k >= 0) {
                                        String theDefaultExpression = PgIntrospectorBaseKt.normalizeDefaultExpression(defaults[k]);
                                        a.setDefaultExpression(theDefaultExpression);
                                    } else {
                                        a.setDefaultExpression(null);
                                    }
                                } else {
                                    a.setDefaultExpression(null);
                                }
                                --i2;
                            }
                        } else {
                            object = routine.getArguments().iterator();
                            while (object.hasNext()) {
                                PgBaseArgument a;
                                PgBaseArgument pgBaseArgument = a = (PgBaseArgument)object.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseArgument, (String)"a");
                                pgBaseArgument.setDefaultExpression(null);
                            }
                        }
                        routine.getArguments().removeSyncPendingChildren();
                    }
                    schema.getRoutines().sort();
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$rs = list;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final <T extends PgBaseArgument> void processArgs(PgBaseIntroQueries.ArgumentHolder r, ModPositioningNamingFamily<T> family, BasicModRoutine routine) {
            String[] argNames = r.getArgNames();
            char[] argDirections = PgIntrospectorBaseKt.stringsToChars(r.getArgModes());
            long[] argTypeIds = r.getArgTypes();
            int argNamesCount = argNames != null ? argNames.length : 0;
            int n = Math.max(Math.max(argNamesCount, argDirections.length), argTypeIds != null ? argTypeIds.length : 0);
            String resultType = null;
            StringBuilder resultArguments = null;
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    String string;
                    void i2;
                    ArgumentDirection direction = null;
                    if (i2 < argDirections.length) {
                        char d = argDirections[i2];
                        switch (d) {
                            case 'b': {
                                direction = ArgumentDirection.INOUT;
                                break;
                            }
                            case 'o': {
                                direction = ArgumentDirection.OUT;
                                break;
                            }
                            case 't': {
                                direction = ArgumentDirection.RESULT;
                                break;
                            }
                            default: {
                                direction = ArgumentDirection.IN;
                                break;
                            }
                        }
                    } else {
                        direction = ArgumentDirection.IN;
                    }
                    if (i2 < argNamesCount) {
                        if (argNames == null) {
                            Intrinsics.throwNpe();
                        }
                        string = argNames[i2];
                    } else {
                        string = null;
                    }
                    String argName = string;
                    DataType dataType = DataType.UNKNOWN;
                    if (argTypeIds == null) {
                        Intrinsics.throwNpe();
                    }
                    if (i2 < argTypeIds.length) {
                        DataType dt;
                        Map<Long, DataType> map2 = this.myTypes;
                        if (map2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
                        }
                        if ((dt = map2.get(argTypeIds[i2])) != null) {
                            dataType = dt;
                        }
                    }
                    if (r instanceof PgBaseIntroQueries.OneRoutine && ((PgBaseIntroQueries.OneRoutine)r).ret_set && direction == ArgumentDirection.RESULT) {
                        if (resultType == null || resultArguments == null) {
                            resultType = "table";
                            resultArguments = new StringBuilder();
                        } else {
                            resultArguments.append(", ");
                        }
                        if (argName != null) {
                            resultArguments.append(argName).append(' ');
                        }
                        DataType dataType2 = dataType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"dataType");
                        resultArguments.append(dataType2.getSpecification());
                    } else {
                        short position = (short)(i2 + true);
                        PgBaseArgument argument = (PgBaseArgument)family.getByNaturalPosition(position);
                        if (argument == null) {
                            argument = (PgBaseArgument)family.createNewOne();
                            argument.setPosition(position);
                        } else {
                            argument.resetSyncPending();
                        }
                        argument.setRealName(argName);
                        argument.setArgumentDirection(direction);
                        argument.setDataType(dataType);
                    }
                    if (i2 == n3) break;
                    ++i2;
                }
            }
            BasicModArgument basicModArgument = routine.createOrGetReturnArgument();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModArgument, (String)"routine.createOrGetReturnArgument()");
            BasicModArgument returns = basicModArgument;
            if (resultType != null) {
                StringBuilder stringBuilder = resultArguments;
                if (stringBuilder == null) {
                    Intrinsics.throwNpe();
                }
                DataType dataType = DataTypeFactory.ofArgs(null, (String)resultType, (String)stringBuilder.toString(), (boolean)false);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.ofArgs(n\u2026ents!!.toString(), false)");
                DataType resultDataType = dataType;
                returns.setArgumentDirection(ArgumentDirection.RESULT);
                returns.setDataType(resultDataType);
            } else if (r.getReturnType() != 0L) {
                DataType retType;
                DataType dataType;
                returns.setArgumentDirection(ArgumentDirection.RETURN);
                Map<Long, DataType> map3 = this.myTypes;
                if (map3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
                }
                if ((dataType = map3.get(r.getReturnType())) == null) {
                    dataType = retType = DataType.UNKNOWN;
                }
                if (r.getReturnsSet()) {
                    StringBuilder stringBuilder = new StringBuilder().append("setof ");
                    DataType dataType3 = retType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"retType");
                    retType = DataTypeFactory.of((String)stringBuilder.append(dataType3.getSpecification()).toString());
                }
                returns.setDataType(retType);
            }
            returns.setRealName((String)null);
            returns.setPosition((short)0);
            returns.setDefaultExpression((String)null);
        }

        @NotNull
        protected PgBaseRoutine createRoutine(@NotNull S schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
            BasicModNamedElement basicModNamedElement = schema.getRoutines().renew(r.r_id, r.r_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModNamedElement, (String)"schema.routines.renew(r.r_id, r.r_name)");
            return (PgBaseRoutine)basicModNamedElement;
        }

        private final void retrieveAggregates() {
            this.progress("aggregates");
            List<PgBaseIntroQueries.OneAggregate> aggs = this.performQuery(this.this$0.getQueries().getRetrieveAggregates());
            if (aggs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(this, aggs){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $aggs;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    for (PgBaseIntroQueries.OneAggregate agg : this.$aggs) {
                        PgBaseAggregate aggregate;
                        PgBaseAggregate pgBaseAggregate = aggregate = (PgBaseAggregate)schema.getAggregates().renew(agg.aggregate_id, agg.aggregate_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseAggregate, (String)"aggregate");
                        pgBaseAggregate.setStateNumber(agg.state_number);
                        PgBaseIntroQueries.ArgumentHolder argumentHolder = agg;
                        ModPositioningNamingFamily<? extends PgBaseArgument> modPositioningNamingFamily = aggregate.getArguments();
                        Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"aggregate.arguments");
                        SchemaRetriever.access$processArgs(this.this$0, argumentHolder, modPositioningNamingFamily, aggregate);
                        this.this$0.processAggregate(agg, aggregate);
                    }
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$aggs = list;
                    super(1);
                }
            });
        }

        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            DataType dataType;
            Intrinsics.checkParameterIsNotNull((Object)agg, (String)"agg");
            Intrinsics.checkParameterIsNotNull((Object)aggregate, (String)"aggregate");
            aggregate.setTransition(agg.transition_function_name);
            aggregate.setTransitionId(agg.transition_function_id);
            aggregate.setFinal(agg.final_function_name);
            aggregate.setFinalId(agg.final_function_id);
            aggregate.setInitialValue(agg.initial_value);
            Map<Long, DataType> map2 = this.myTypes;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
            }
            if ((dataType = map2.get(agg.transition_type)) == null) {
                dataType = DataType.UNKNOWN;
            }
            aggregate.setTransitionDataType(dataType);
        }

        private final void retrieveOperators() {
            this.progress("operators");
            List<PgBaseIntroQueries.OneOperator> ops = this.performQuery(this.this$0.getQueries().getRetrieveOperators());
            if (ops.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(this, ops){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $ops;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    for (PgBaseIntroQueries.OneOperator op : this.$ops) {
                        PgBaseOperator operator;
                        PgBaseOperator pgBaseOperator = operator = (PgBaseOperator)schema.getOperators().renew(op.op_id, op.op_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseOperator, (String)"operator");
                        this.this$0.processOperator(op, pgBaseOperator);
                    }
                    schema.getOperators().sort();
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$ops = list;
                    super(1);
                }
            });
        }

        protected void processOperator(@NotNull PgBaseIntroQueries.OneOperator o, @NotNull PgBaseOperator operator) {
            DataType dataType;
            DataType dataType2;
            DataType dataType3;
            DataType dataType4;
            DataType dataType5;
            DataType dataType6;
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            Intrinsics.checkParameterIsNotNull((Object)operator, (String)"operator");
            operator.setStateNumber(o.state_number);
            operator.setOperatorKind(PgOperatorKind.of((char)o.op_kind));
            if (o.arg_left_type_id > 0L) {
                Map<Long, DataType> map2 = this.myTypes;
                if (map2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
                }
                dataType6 = map2.get(o.arg_left_type_id);
            } else {
                dataType6 = dataType5 = null;
            }
            if (dataType6 == null) {
                dataType5 = DataType.UNKNOWN;
            }
            operator.setLeftType(dataType5);
            if (o.arg_right_type_id > 0L) {
                Map<Long, DataType> map3 = this.myTypes;
                if (map3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
                }
                dataType4 = map3.get(o.arg_right_type_id);
            } else {
                dataType4 = dataType3 = null;
            }
            if (dataType4 == null) {
                dataType3 = DataType.UNKNOWN;
            }
            operator.setRightType(dataType3);
            if (o.arg_result_type_id > 0L) {
                Map<Long, DataType> map4 = this.myTypes;
                if (map4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
                }
                dataType2 = map4.get(o.arg_result_type_id);
            } else {
                dataType2 = dataType = null;
            }
            if (dataType2 == null) {
                dataType = DataType.UNKNOWN;
            }
            operator.setResultType(dataType);
            operator.setCallRoutineName(DbUtil.intern2((String)o.func_main));
        }

        private final void retrieveTableColumns() {
            if (!this.shouldIntrospectTableRelatedData()) {
                return;
            }
            this.progress("table columns");
            List<PgBaseIntroQueries.OneColumn> cols2 = this.performQuery(this.this$0.getQueries().getRetrieveColumns());
            if (cols2.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(this, cols2){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $cols;

                public final void invoke(@NotNull S it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    this.this$0.processColumns(this.$cols, it);
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$cols = list;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        protected void processColumns(@NotNull List<PgBaseIntroQueries.OneColumn> cols2, @NotNull S schema) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(cols2, (String)"cols");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            HashSet<PgBaseLikeStoredTable> affectedTables = new HashSet<PgBaseLikeStoredTable>();
            Iterable $this$groupBy$iv = cols2;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                PgBaseIntroQueries.OneColumn it = (PgBaseIntroQueries.OneColumn)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.table_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                PgBaseLikeStoredTable table;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                if (this.getTableOrView(schema, '\u0000', ((Number)entry.getKey()).longValue()) == null) {
                    continue;
                }
                table.getColumns().markChildrenAsSyncPending();
                affectedTables.add(table);
                Intrinsics.checkExpressionValueIsNotNull(table.getColumns(), (String)"table.columns");
                for (PgBaseIntroQueries.OneColumn col : (List)entry.getValue()) {
                    PgBaseLikeColumn pgBaseLikeColumn;
                    ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns;
                    if (col.column_is_dropped) continue;
                    if (col.column_position >= 1) {
                        BasicModElement basicModElement = columns.createOrGetAt(col.column_position);
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicModElement, (String)"columns.createOrGetAt(col.column_position)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)basicModElement;
                    } else {
                        String string = col.column_name;
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        BasicModNamedElement basicModNamedElement = columns.createOrGet(string);
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicModNamedElement, (String)"columns.createOrGet(col.column_name!!)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)basicModNamedElement;
                    }
                    PgBaseLikeColumn column2 = pgBaseLikeColumn;
                    this.processColumn(col, column2, columns, table);
                }
            }
            Iterator iterator2 = affectedTables.iterator();
            while (iterator2.hasNext()) {
                PgBaseLikeStoredTable affectedTable;
                PgBaseLikeStoredTable pgBaseLikeStoredTable = affectedTable = (PgBaseLikeStoredTable)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseLikeStoredTable, (String)"affectedTable");
                pgBaseLikeStoredTable.getColumns().removeSyncPendingChildren();
                affectedTable.getColumns().sort();
            }
        }

        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
            Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
            Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            column2.setPosition(col.column_position);
            String string = column2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"column.name");
            String oldName = string;
            String string2 = col.column_name;
            if (string2 == null) {
                String string3 = ModelConsts.NO_NAME;
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"NO_NAME");
            }
            String newName = string2;
            if (Intrinsics.areEqual((Object)oldName, (Object)newName) ^ true) {
                column2.setName(newName);
                if (Intrinsics.areEqual((Object)oldName, (Object)ModelConsts.NO_NAME) ^ true) {
                    this.handleColumnRenaming(table, oldName, newName);
                }
            }
            column2.resetSyncPending();
            column2.setStateNumber(col.column_state_number);
            column2.setDataType(PgIntrospectorBaseKt.dataTypeOf(col.type_spec));
            column2.setNotNull(col.mandatory);
            if (column2 instanceof PgBaseTableColumn) {
                ((PgBaseTableColumn)column2).setDefaultExpression(StringKt.nullize$default((String)col.column_default_expression, (boolean)false, (int)1, null));
            }
            column2.setNameSurrogate(this.this$0.isColumnNameSurrogate(col.column_name));
        }

        @Nullable
        protected PgBaseLikeStoredTable getTableOrView(@NotNull S schema, char relKind, long tableId) {
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            char c = relKind;
            boolean bl = false;
            char lowerCaseKind = Character.toLowerCase(c);
            if (this.isTableKind(lowerCaseKind)) {
                pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getTables().getByObjectId(tableId);
            } else {
                switch (lowerCaseKind) {
                    case 'v': {
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getViews().getByObjectId(tableId);
                        break;
                    }
                    case '\u0000': {
                        PgBaseRegularTable pgBaseRegularTable = (PgBaseRegularTable)schema.getTables().getByObjectId(tableId);
                        if (pgBaseRegularTable != null) {
                            pgBaseLikeStoredTable = pgBaseRegularTable;
                            break;
                        }
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getViews().getByObjectId(tableId);
                        break;
                    }
                    default: {
                        pgBaseLikeStoredTable = null;
                    }
                }
            }
            return pgBaseLikeStoredTable;
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull String oldName, @NotNull String tableName) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)oldName, (String)"oldName");
            Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.KEY");
            this.handleColumnRenaming(table, objectKind, oldName, tableName);
            ObjectKind objectKind2 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.FOREIGN_KEY");
            this.handleColumnRenaming(table, objectKind2, oldName, tableName);
        }

        /*
         * WARNING - void declaration
         */
        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull ObjectKind childrenKind, @NotNull String oldName, @NotNull String newName) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)childrenKind, (String)"childrenKind");
            Intrinsics.checkParameterIsNotNull((Object)oldName, (String)"oldName");
            Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
            ModFamily f = (ModFamily)table.familyOf(childrenKind);
            if (f != null && f.hasChildren()) {
                for (BasicModElement child : f) {
                    if (!(child instanceof BasicModColumniation)) continue;
                    boolean changed = false;
                    ArrayList<String> names = new ArrayList<String>(((BasicModColumniation)child).getColNames());
                    int n = 0;
                    int n2 = names.size();
                    while (n < n2) {
                        void i2;
                        if (Intrinsics.areEqual((Object)((String)names.get((int)i2)), (Object)oldName)) {
                            names.set((int)i2, newName);
                            changed = true;
                        }
                        ++i2;
                    }
                    if (!changed) continue;
                    ((BasicModColumniation)child).setColNames((List)names);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstraints() {
            void wasKeys;
            this.progress("constraints");
            List<PgBaseIntroQueries.OneConstraint> cons = this.performQuery(this.this$0.getQueries().getRetrieveConstraints());
            if (cons.isEmpty()) {
                return;
            }
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            this.inSchema((Function1)new Function1<S, Unit>(this, cons, (Ref.BooleanRef)wasKeys){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $cons;
                final /* synthetic */ Ref.BooleanRef $wasKeys;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    HashSet<PgBaseTable> affectedTables = new HashSet<PgBaseTable>(this.$cons.size() / 3);
                    block5: for (PgBaseIntroQueries.OneConstraint con : this.$cons) {
                        PgBaseTable table;
                        if (this.this$0.this$0.getHelper().findTableByObjectId((PgBaseSchema)schema, con.table_id) == null) {
                            continue;
                        }
                        affectedTables.add(table);
                        switch (con.con_kind) {
                            case 'p': 
                            case 'u': {
                                PgBaseKey key2;
                                PgBaseRegularTable pgBaseRegularTable;
                                PgBaseTable pgBaseTable = table;
                                if (!(pgBaseTable instanceof PgBaseRegularTable)) {
                                    pgBaseTable = null;
                                }
                                if ((PgBaseRegularTable)pgBaseTable == null) continue block5;
                                boolean bl = false;
                                boolean bl2 = false;
                                PgBaseRegularTable it = pgBaseRegularTable;
                                boolean bl3 = false;
                                PgBaseKey pgBaseKey = key2 = (PgBaseKey)it.getKeys().renew(con.con_id, con.con_name);
                                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseKey, (String)"key");
                                this.this$0.processKey(pgBaseKey, it, con);
                                this.$wasKeys.element = true;
                                break;
                            }
                            case 'f': {
                                PgBaseForeignKey fkey;
                                PgBaseRegularTable pgBaseRegularTable;
                                PgBaseTable pgBaseTable = table;
                                if (!(pgBaseTable instanceof PgBaseRegularTable)) {
                                    pgBaseTable = null;
                                }
                                if ((PgBaseRegularTable)pgBaseTable == null) continue block5;
                                boolean bl = false;
                                boolean bl2 = false;
                                PgBaseRegularTable it = pgBaseRegularTable;
                                boolean bl4 = false;
                                PgBaseForeignKey pgBaseForeignKey = fkey = (PgBaseForeignKey)it.getForeignKeys().renew(con.con_id, con.con_name);
                                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseForeignKey, (String)"fkey");
                                this.this$0.processForeignKey(pgBaseForeignKey, it, con, schema);
                                break;
                            }
                            case 'c': {
                                this.this$0.processCheck(table, con);
                                break;
                            }
                        }
                    }
                    Iterator<E> iterator = affectedTables.iterator();
                    while (iterator.hasNext()) {
                        PgBaseTable table;
                        PgBaseTable pgBaseTable = table = (PgBaseTable)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseTable, (String)"table");
                        this.this$0.sortConstraints(pgBaseTable);
                    }
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$cons = list;
                    this.$wasKeys = booleanRef;
                    super(1);
                }
            });
            if (wasKeys.element) {
                Collection collection = (Collection)this.this$0.affectedKeySchemaIds;
                Long l = ((PgBaseSchema)this.getSchema()).getObjectId();
                boolean bl = false;
                collection.add(l);
            }
        }

        protected void sortConstraints(@NotNull PgBaseTable table) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
                PgBaseTable pgBaseTable = table;
                if (!(pgBaseTable instanceof PgBaseRegularTable)) {
                    pgBaseTable = null;
                }
                PgBaseRegularTable pgBaseRegularTable = (PgBaseRegularTable)pgBaseTable;
                if (pgBaseRegularTable == null) break block1;
                PgBaseRegularTable pgBaseRegularTable2 = pgBaseRegularTable;
                boolean bl = false;
                boolean bl2 = false;
                PgBaseRegularTable it = pgBaseRegularTable2;
                boolean bl3 = false;
                it.getKeys().sort();
                it.getForeignKeys().sort();
            }
        }

        protected void processKey(@NotNull PgBaseKey key2, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
            key2.setStateNumber(con.con_state_id);
            key2.setPrimary(con.con_kind == 'p');
            String string = con.con_columns;
            String string2 = "Key " + con.con_name + " column positions";
            ModPositioningNamingFamily<? extends PgBaseTableColumn> modPositioningNamingFamily = table.getColumns();
            Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"table.columns");
            key2.setColNames(PgIntrospectorBaseKt.peekColNames(string, string2, (PositioningFamily<? extends BasicTableOrViewColumn>)((PositioningFamily)modPositioningNamingFamily)));
        }

        protected void processCheck(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
        }

        protected void processForeignKey(@NotNull PgBaseForeignKey fkey, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con, @NotNull S schema) {
            Intrinsics.checkParameterIsNotNull((Object)fkey, (String)"fkey");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            fkey.setStateNumber(con.con_state_id);
            fkey.setRefTableId(con.ref_table_id);
            String string = con.con_columns;
            String string2 = "Foreign key " + con.con_name + " domestic column positions";
            ModPositioningNamingFamily<? extends PgBaseTableColumn> modPositioningNamingFamily = table.getColumns();
            Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"table.columns");
            fkey.setColNames(PgIntrospectorBaseKt.peekColNames(string, string2, (PositioningFamily<? extends BasicTableOrViewColumn>)((PositioningFamily)modPositioningNamingFamily)));
            if (!this.hasReference(con)) {
                return;
            }
            fkey.setRefTableId(con.ref_table_id);
            fkey.setRefColPositions(PgIntrospectorBaseKt.parseArrayOfPositions(con.ref_columns, "Foreign Key " + fkey.getName() + " ref columns"));
            this.this$0.getHelper().resolveReference(fkey);
        }

        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.ref_columns != null;
        }

        protected void retrieveDescriptions() {
            this.progress("comments");
            List<PgBaseIntroQueries.OneComment> comments = this.performQuery(this.this$0.getQueries().getRetrieveSchemaComments());
            if (comments.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(this, comments){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $comments;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S schema) {
                    void $this$groupByTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    Iterable $this$groupBy$iv = this.$comments;
                    boolean $i$f$groupBy = false;
                    Object object = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object2;
                        PgBaseIntroQueries.OneComment it = (PgBaseIntroQueries.OneComment)element$iv$iv;
                        boolean bl = false;
                        Long key$iv$iv = it.id;
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object2 = answer$iv$iv$iv;
                        } else {
                            object2 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object2;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map $this$forEach$iv = destination$iv$iv;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (this.this$0.findObjectById(schema, ((PgBaseIntroQueries.OneComment)CollectionsKt.first((List)((List)it.getValue()))).kind, ((Number)it.getKey()).longValue()) == null) {
                            continue;
                        }
                        Iterable $this$forEach$iv2 = (Iterable)it.getValue();
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            BasicModNamedElement target2;
                            Object object3;
                            BasicElement obj2;
                            PgBaseIntroQueries.OneComment it2 = (PgBaseIntroQueries.OneComment)element$iv2;
                            boolean bl4 = false;
                            if (it2.sub_id == 0) {
                                BasicElement basicElement = obj2;
                                if (!(basicElement instanceof BasicModNamedElement)) {
                                    basicElement = null;
                                }
                                object3 = (BasicModNamedElement)basicElement;
                            } else {
                                object3 = obj2 instanceof BasicModLikeTable ? (BasicModNamedElement)((BasicModLikeTable)obj2).getColumns().getByNaturalPosition(it2.sub_id) : (obj2 instanceof PgBaseDefType ? (BasicModNamedElement)((PgBaseDefType)obj2).getAttributes().getByNaturalPosition(it2.sub_id) : null);
                            }
                            BasicModNamedElement basicModNamedElement = target2 = object3;
                            if (basicModNamedElement == null) continue;
                            basicModNamedElement.setComment(it2.description);
                        }
                    }
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$comments = list;
                    super(1);
                }
            });
        }

        @Nullable
        protected BasicElement findObjectById(@NotNull S schema, @Nullable Character kind, long id) {
            Object object;
            Character c;
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            Character c2 = c = kind;
            if (c2 != null && c2.charValue() == 'k') {
                ModNamingIdentifyingFamily<? extends PgBaseRegularTable> modNamingIdentifyingFamily = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tables");
                object = (BasicElement)PgIntrospectorBaseKt.findSub((Family)modNamingIdentifyingFamily, id, findObjectById.1.INSTANCE);
            } else {
                Character c3 = c;
                if (c3 != null && c3.charValue() == 'x') {
                    ModNamingIdentifyingFamily<? extends PgBaseRegularTable> modNamingIdentifyingFamily = schema.getTables();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tables");
                    object = (BasicElement)PgIntrospectorBaseKt.findSub((Family)modNamingIdentifyingFamily, id, findObjectById.2.INSTANCE);
                } else {
                    Character c4 = c;
                    if (c4 != null && c4.charValue() == 'F') {
                        PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)schema.getRoutines().getByObjectId(id);
                        object = pgBaseRoutine != null ? (BasicElement)pgBaseRoutine : (BasicElement)schema.getAggregates().getByObjectId(id);
                    } else {
                        Character c5 = c;
                        if (c5 != null && c5.charValue() == 'T') {
                            object = (BasicElement)schema.getDefTypes().getByObjectId(id);
                        } else {
                            Character c6 = c;
                            object = c6 != null && c6.charValue() == 'O' ? (BasicElement)schema.getOperators().getByObjectId(id) : (c == null ? null : (BasicElement)this.getTableOrView(schema, kind.charValue(), id));
                        }
                    }
                }
            }
            return object;
        }

        protected final void retrieveViewSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.setQueryParameter("INCSRC", this.getMode().increment && this.incrementalViewSources());
            this.progress("view sources");
            List<PgBaseIntroQueries.OneViewSource> viewSources = this.performQuery(this.this$0.getQueries().getRetrieveViewSources());
            if (viewSources.isEmpty()) {
                return;
            }
            BaseIntrospector this_$iv = this.this$0;
            boolean $i$f$writeSources = false;
            this_$iv.getModel().writeSources(new Runnable(this, viewSources){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $viewSources$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$viewSources$inlined = list;
                }

                public final void run() {
                    boolean bl = false;
                    SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this){
                        final /* synthetic */ SchemaRetriever$retrieveViewSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull S schema) {
                            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                            for (PgBaseIntroQueries.OneViewSource vs : this.this$0.$viewSources$inlined) {
                                PgBaseLikeStoredTable view = this.this$0.this$0.getTableOrView(schema, vs.view_kind, vs.view_id);
                                String sourceText = vs.source_text;
                                this.this$0.this$0.processViewSource(view, sourceText);
                            }
                        }
                    });
                }
            });
        }

        protected void processViewSource(@Nullable PgBaseLikeStoredTable view, @Nullable String sourceText) {
            if (view instanceof PgBaseView) {
                this.applySourceText((PgBaseView)view, sourceText);
            }
        }

        private final void retrieveFunSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.progress("functions' sources");
            List<PgBaseIntroQueries.OneFunctionSource> funSources = this.performQuery(this.this$0.getQueries().getRetrieveFunctionSources());
            if (funSources.isEmpty()) {
                return;
            }
            BaseIntrospector this_$iv = this.this$0;
            boolean $i$f$writeSources = false;
            this_$iv.getModel().writeSources(new Runnable(this, funSources){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $funSources$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$funSources$inlined = list;
                }

                public final void run() {
                    boolean bl = false;
                    SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this){
                        final /* synthetic */ SchemaRetriever$retrieveFunSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull S schema) {
                            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                            for (PgBaseIntroQueries.OneFunctionSource fs : this.this$0.$funSources$inlined) {
                                String sourceText;
                                PgBaseRoutine function;
                                if (fs.source_text == null) {
                                    continue;
                                }
                                if ((PgBaseRoutine)schema.getRoutines().getByObjectId(fs.id) == null) {
                                    continue;
                                }
                                function.setArgumentsDefinition(StringKt.nullize((String)fs.arguments_def, (boolean)true));
                                function.setResultsDefinition(StringKt.nullize((String)fs.result_def, (boolean)true));
                                function.setSourceText((CompositeText)BaseIntrospectionFunctions.toCompositeText(sourceText, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        }
                    });
                }
            });
        }

        private final void handleTableRenaming(@NotNull S $this$handleTableRenaming, String old, String string) {
            Iterator iterator = $this$handleTableRenaming.getTables().iterator();
            while (iterator.hasNext()) {
                PgBaseRegularTable table;
                PgBaseRegularTable pgBaseRegularTable = table = (PgBaseRegularTable)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseRegularTable, (String)"table");
                Iterator iterator2 = pgBaseRegularTable.getForeignKeys().iterator();
                while (iterator2.hasNext()) {
                    PgBaseForeignKey fk;
                    PgBaseForeignKey pgBaseForeignKey = fk = (PgBaseForeignKey)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseForeignKey, (String)"fk");
                    if (!Intrinsics.areEqual((Object)pgBaseForeignKey.getRefTableName(), (Object)old)) continue;
                    fk.setRefTableName(string);
                }
            }
        }

        private final void applySourceText(PgBaseView view, String sourceText) {
            block3: {
                block2: {
                    if (sourceText == null) break block2;
                    CharSequence charSequence = sourceText;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block3;
                }
                view.setSourceText(null);
                return;
            }
            view.setSourceText((CompositeText)this.createCompositeText(view, sourceText));
        }

        @NotNull
        protected SimpleCompositeText createCompositeText(@NotNull PgBaseView view, @NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            String string = source;
            boolean bl = false;
            String body2 = PgIntrospectorBaseKt.removeSuffix(((Object)StringsKt.trim((CharSequence)string)).toString(), ';');
            return new SimpleCompositeText((CharSequence)body2, CompositeText.Kind.DECOMPILED_TEXT);
        }

        protected final boolean shouldIntrospectTableRelatedData() {
            return this.wasDataTables() || this.getMode().increment && this.shouldIntrospectTableRelatedDataIncremental();
        }

        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return ((PgBaseSchema)this.getSchema()).getTables().hasChildren();
        }

        protected boolean wasDataTables() {
            return this.wasTables || this.wasViews;
        }

        protected abstract void processModView(@NotNull PgBaseLikeStoredTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        protected abstract void processModTable(@NotNull PgBaseTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        protected SchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            long l;
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            super((BaseIntrospector)$outer, transaction, (BasicModSchema)schema);
            this.this$0 = $outer;
            this.myHasChanges = true;
            this.myFrozen = new HashSet();
            Long existentSourcesTx = this.getModel().getSchemaSourcesVersion((BasicSchema)schema);
            if (this.getMode().increment) {
                Long l2 = existentSourcesTx;
                l = l2 != null ? l2 : 0L;
            } else {
                l = 0L;
            }
            this.srcFromTx = l;
            this.prepareParameters();
        }

        public static final /* synthetic */ Object access$performQuery(SchemaRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }

        public static final /* synthetic */ long access$getMyBeginIntrospectionSchemaStateNumber$p(SchemaRetriever $this) {
            return $this.myBeginIntrospectionSchemaStateNumber;
        }

        public static final /* synthetic */ void access$setMyBeginIntrospectionSchemaStateNumber$p(SchemaRetriever $this, long l) {
            $this.myBeginIntrospectionSchemaStateNumber = l;
        }

        public static final /* synthetic */ void access$retrieveTables(SchemaRetriever $this) {
            $this.retrieveTables();
        }

        public static final /* synthetic */ void access$obtainUsedTypes(SchemaRetriever $this) {
            $this.obtainUsedTypes();
        }

        public static final /* synthetic */ void access$retrieveRoutines(SchemaRetriever $this) {
            $this.retrieveRoutines();
        }

        public static final /* synthetic */ void access$retrieveAggregates(SchemaRetriever $this) {
            $this.retrieveAggregates();
        }

        public static final /* synthetic */ void access$retrieveOperators(SchemaRetriever $this) {
            $this.retrieveOperators();
        }

        public static final /* synthetic */ void access$retrieveStructAttributes(SchemaRetriever $this) {
            $this.retrieveStructAttributes();
        }

        public static final /* synthetic */ void access$retrieveTableColumns(SchemaRetriever $this) {
            $this.retrieveTableColumns();
        }

        public static final /* synthetic */ void access$retrieveConstraints(SchemaRetriever $this) {
            $this.retrieveConstraints();
        }

        public static final /* synthetic */ void access$retrieveFunSources(SchemaRetriever $this) {
            $this.retrieveFunSources();
        }

        public static final /* synthetic */ void access$handleTableRenaming(SchemaRetriever $this, PgBaseSchema $this$access_u24handleTableRenaming, String old, String string) {
            $this.handleTableRenaming($this$access_u24handleTableRenaming, old, string);
        }

        public static final /* synthetic */ void access$processArgs(SchemaRetriever $this, PgBaseIntroQueries.ArgumentHolder r, ModPositioningNamingFamily family, BasicModRoutine routine) {
            $this.processArgs(r, family, routine);
        }

        public static final /* synthetic */ void access$inSchema(SchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase$Companion;", "", "()V", "FROZEN_TXID", "", "intellij.database.dialects.postgresbase"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

