/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.dialects.redshift.model.RsModelFunKt;
import com.intellij.database.dialects.redshift.model.RsTable;
import com.intellij.database.dialects.redshift.model.RsTableColumn;
import com.intellij.database.dialects.redshift.model.RsUser;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicDistTableColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.RsExternalTableStorageType;
import com.intellij.database.model.properties.RsTableBackupMode;
import com.intellij.database.model.properties.RsTableDistStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/redshift/model/RsDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeRedshiftColumn", "column", "Lcom/intellij/database/dialects/redshift/model/RsTableColumn;", "describeRedshiftExternalSchema", "schema", "Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;", "describeRedshiftExternalTable", "table", "Lcom/intellij/database/dialects/redshift/model/RsExternalTable;", "describeRedshiftExternalTableColumn", "Lcom/intellij/database/dialects/redshift/model/RsExternalTableColumn;", "describeRedshiftTable", "Lcom/intellij/database/dialects/redshift/model/RsTable;", "describeRedshiftUser", "user", "Lcom/intellij/database/dialects/redshift/model/RsUser;", "intellij.database.dialects.redshift"})
public final class RsDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof RsTable ? this.describeRedshiftTable((RsTable)e) : (basicElement instanceof RsTableColumn ? this.describeRedshiftColumn((RsTableColumn)e) : (basicElement instanceof RsExternalSchema ? this.describeRedshiftExternalSchema((RsExternalSchema)e) : (basicElement instanceof RsExternalTable ? this.describeRedshiftExternalTable((RsExternalTable)e) : (basicElement instanceof RsExternalTableColumn ? this.describeRedshiftExternalTableColumn((RsExternalTableColumn)e) : (basicElement instanceof RsUser ? this.describeRedshiftUser((RsUser)e) : super.content(e, context))))));
    }

    @NotNull
    public final String describeRedshiftColumn(@NotNull RsTableColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String d = this.describeDistColumn((BasicDistTableColumn)column2);
        if (column2.getEncoding() != null && !RsModelFunKt.isDefaultEncoding(column2)) {
            d = d + " encode(" + column2.getEncoding() + ')';
        }
        return d;
    }

    @NotNull
    public final String describeRedshiftExternalSchema(@NotNull RsExternalSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        ArrayList<String> attributes2 = new ArrayList<String>();
        if (schema.getDatabaseName() != null) {
            attributes2.add("database name: " + schema.getDatabaseName());
        }
        if (schema.getIamRole() != null) {
            attributes2.add("iam role: " + schema.getIamRole());
        }
        if (schema.getUri() != null) {
            attributes2.add("uri: " + schema.getUri());
        }
        if (schema.getPort() != null) {
            attributes2.add("port: " + schema.getPort());
        }
        if (schema.getRegion() != null) {
            attributes2.add("region: " + schema.getRegion());
        }
        if (schema.getSchemaKind() != -1) {
            attributes2.add("kind: " + (schema.getSchemaKind() == 2 ? "hive metastore" : "data catalog"));
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public final String describeRedshiftExternalTable(@NotNull RsExternalTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        ArrayList<String> attributes2 = new ArrayList<String>();
        if (table.getSerializationLib() != null) {
            attributes2.add("serialization lib: " + table.getSerializationLib());
        }
        if (table.getInputFormat() != null) {
            attributes2.add("input format: " + table.getInputFormat());
        }
        if (table.getOutputFormat() != null) {
            attributes2.add("output fotmat: " + table.getOutputFormat());
        }
        if (table.getLocation() != null) {
            attributes2.add("location: " + table.getLocation());
        }
        List<String> list = table.getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("serde properties: ");
            List<String> list2 = table.getSerdeProperties();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"table.serdeProperties");
            attributes2.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null)).toString());
        }
        List<String> list3 = table.getProps();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"table.props");
        collection = list3;
        bl = false;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("properties: ");
            List<String> list4 = table.getProps();
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"table.props");
            attributes2.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null)).toString());
        }
        if (table.getStorageType() != RsExternalTableStorageType.UNKNOWN) {
            attributes2.add("stored as: " + table.getStorageType().getSqlDefinition());
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public final String describeRedshiftExternalTableColumn(@NotNull RsExternalTableColumn column2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        StringBuilder stringBuilder = new StringBuilder().append(this.describeColumn((BasicLikeColumn)column2)).append(" ");
        switch (column2.getPartitionKeyOrder()) {
            case 0: {
                string = "";
                break;
            }
            default: {
                string = "partition key order: " + column2.getPartitionKeyOrder();
            }
        }
        return stringBuilder.append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String describeRedshiftTable(@NotNull RsTable table) {
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String d = this.describeTable((BasicTable)table);
        if (table.getDistStyle() != RsTableDistStyle.EVEN) {
            d = d + " diststyle(" + table.getDistStyle().name() + ')';
        }
        if (table.getBackupMode() != RsTableBackupMode.ON) {
            d = d + " backup(no)";
        }
        ModPositioningNamingFamily<? extends RsTableColumn> modPositioningNamingFamily = table.getColumns();
        Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"table.columns");
        Iterable $this$filter$iv = (Iterable)modPositioningNamingFamily;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RsTableColumn it = (RsTableColumn)element$iv$iv;
            boolean bl3 = false;
            RsTableColumn rsTableColumn = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)rsTableColumn, (String)"it");
            if (!(rsTableColumn.getSortKeyOrder() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$filterTo$iv$iv = $this$sortedBy$iv;
        boolean bl = false;
        Comparator $i$f$filterTo22 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                RsTableColumn it = (RsTableColumn)a;
                boolean bl2 = false;
                RsTableColumn rsTableColumn = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)rsTableColumn, (String)"it");
                it = (RsTableColumn)b;
                Comparable comparable = Integer.valueOf(Math.abs(rsTableColumn.getSortKeyOrder()));
                bl2 = false;
                RsTableColumn rsTableColumn2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)rsTableColumn2, (String)"it");
                Integer n = Math.abs(rsTableColumn2.getSortKeyOrder());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        List sorted = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv, (Comparator)$i$f$filterTo22);
        if (sorted.isEmpty()) {
            return d;
        }
        if (RsModelFunKt.hasInterleavedSortKey(table)) {
            d = d + " interleaved";
        }
        d = d + " sortkey(";
        Iterable $this$forEachIndexed$iv = sorted;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void col;
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            RsTableColumn bl3 = (RsTableColumn)item$iv;
            int idx = n2;
            boolean bl4 = false;
            if (idx != 0) {
                d = d + ", ";
            }
            StringBuilder stringBuilder = new StringBuilder().append(d);
            void v3 = col;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"col");
            d = stringBuilder.append(v3.getName()).toString();
        }
        d = d + ")";
        return d;
    }

    @NotNull
    public final String describeRedshiftUser(@NotNull RsUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        ArrayList<String> props = new ArrayList<String>();
        if (user.isSuperRole()) {
            props.add("superuser");
        }
        if (user.isCreateDb()) {
            props.add("create db");
        }
        if (user.getConnectionLimit() != -1L) {
            props.add("connection limit: " + user.getConnectionLimit());
        }
        if (user.getValidUntil() != null) {
            props.add("valid until: " + user.getValidUntil());
        }
        props.addAll((Collection)user.getConfig());
        return CollectionsKt.joinToString$default((Iterable)props, null, null, null, (int)0, null, null, (int)63, null);
    }
}

