/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.derby;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.derby.DerbyDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerbyTypeSystem
extends SqlTypeSystem {
    public static final DerbyTypeSystem INSTANCE = new DerbyTypeSystem();

    private DerbyTypeSystem() {
        super((SqlLanguageDialectEx)DerbyDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            DerbyTypeSystem.$$$reportNull$$$0(0);
        }
        if ("BINARY LARGE OBJECT".equals(name2 = super.getNormalizedTypeName(name2))) {
            return "BLOB";
        }
        if ("CHARACTER LARGE OBJECT".equals(name2)) {
            return "CLOB";
        }
        if ("CHARACTER".equals(name2)) {
            return "CHAR";
        }
        if ("CHAR VARYING".equals(name2)) {
            return "VARCHAR";
        }
        if ("CHARACTER VARYING".equals(name2)) {
            return "VARCHAR";
        }
        if ("DEC".equals(name2)) {
            return "DECIMAL";
        }
        if ("DOUBLE PRECISION".equals(name2)) {
            return "DOUBLE";
        }
        if ("FLOAT".equals(name2)) {
            return "DOUBLE";
        }
        if ("INT".equals(name2)) {
            return "INTEGER";
        }
        String string = name2;
        if (string == null) {
            DerbyTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            DerbyTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "array";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/derby/DerbyTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/derby/DerbyTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

