/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oraplus;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.oracle.OraParser;
import com.intellij.sql.dialects.oraplus.OraPlusDialect;
import com.intellij.sql.dialects.oraplus.OraPlusGeneratedParser;
import com.intellij.sql.dialects.oraplus.OraPlusTokens;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Pattern;

public class OraPlusParser
extends OraParser {
    private static final Pattern PARAM_PATTERN = Pattern.compile("&\\d+");
    private static final ITokenTypeRemapper TO_PLUS_MAPPER = (source, start2, end, text) -> {
        if (source == OraPlusTokens.ORAP_WS_DELIMITER_TOKEN) {
            return ORAP_DELIMITER_TOKEN;
        }
        if (OraPlusParser.isContinuation(source, end, text)) {
            return OraPlusTokens.ORAP_WS_CONTINUATION_TOKEN;
        }
        return source;
    };
    private static final ITokenTypeRemapper TO_ORA_MAPPER = (source, start2, end, text) -> {
        if (source == ORAP_DELIMITER_TOKEN) {
            return OraPlusTokens.ORAP_WS_DELIMITER_TOKEN;
        }
        if (OraPlusParser.isContinuation(source, end, text)) {
            return OraPlusTokens.ORAP_WS_CONTINUATION_TOKEN;
        }
        return source;
    };
    private static final ITokenTypeRemapper TO_ORA_PL_MAPPER = (source, start2, end, text) -> {
        if (source == ORAP_DELIMITER_TOKEN) {
            return OraPlusTokens.ORAP_WS_DELIMITER_TOKEN;
        }
        if (source == OraPlusTokens.ORAP_WS_CONTINUATION_TOKEN) {
            return SQL_OP_MINUS;
        }
        return source;
    };
    private boolean myPlusContext = true;

    private static boolean isContinuation(IElementType source, int end, CharSequence text) {
        if (source == SQL_OP_MINUS) {
            int e = text.length();
            for (int i2 = end; i2 < e; ++i2) {
                char c = text.charAt(i2);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                if (!Character.isWhitespace(c)) break;
            }
        }
        return false;
    }

    public OraPlusParser() {
        super(OraPlusDialect.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        this.setPlusContext(builder, true);
        if (OraPlusGeneratedParser.root_statement(builder, level)) {
            return true;
        }
        try {
            this.setPlusContext(builder, false);
            boolean bl = super.parseSqlStatement(builder, level);
            return bl;
        }
        finally {
            this.setPlusContext(builder, true);
        }
    }

    @Override
    protected boolean parseArgumentListInner(PsiBuilder builder) {
        boolean prev = this.myPlusContext;
        this.setPlusContext(builder, false);
        boolean res2 = super.parseArgumentListInner(builder);
        this.setPlusContext(builder, prev);
        return res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseJdbcProcedureCall(PsiBuilder builder, int level) {
        boolean prev = this.myPlusContext;
        try {
            this.setPlusContext(builder, false);
            boolean bl = super.parseJdbcProcedureCall(builder, level);
            return bl;
        }
        finally {
            this.setPlusContext(builder, prev);
        }
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result2;
        String tokenText = builder.getTokenText();
        if (tokenText != null && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && PARAM_PATTERN.matcher(tokenText).matches()) {
            this.consumeIdentifier(builder);
            result2 = SQL_PARAMETER_REFERENCE;
        } else {
            result2 = super.consumeCustomParameterReference(builder);
        }
        return result2;
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        boolean prev = this.myPlusContext;
        boolean res2 = false;
        if (!res2) {
            this.setPlusContext(builder, false);
            res2 = super.parseExtraRoots(root2, builder, level);
        }
        this.setPlusContext(builder, prev);
        return res2;
    }

    @Override
    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        if ((builder.getTokenType() == SQL_OP_BITWISE_AND || builder.getTokenType() == SQL_OP_LOGICAL_AND) && this.isIdentifierToken(builder, builder.rawLookup(1), true, false)) {
            PsiBuilder.Marker mark2 = builder.mark();
            IElementType lookup = builder.rawLookup(2);
            IElementType lookupup = builder.rawLookup(3);
            if (lookup == SQL_PERIOD && lookupup == SQL_PERIOD) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            builder.advanceLexer();
            mark2.done((IElementType)SQL_PARAMETER_REFERENCE);
            this.myExternalReferenceJustParsed = true;
            return true;
        }
        return super.parseExternalParameterImpl(builder, checkStart, checkEnd);
    }

    @Override
    protected boolean isWhitespace(IElementType type) {
        return type == SqlTokens.ORAP_DELIMITER_TOKEN || OraPlusTokens.WHITE_SPACE_TOKENS.contains(type);
    }

    @Override
    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return super.statementRecoverPrefixParser(builder, level) || OraPlusGeneratedParser.statement_recover_prefix(builder, level);
    }

    @Override
    public void updatePlContext(PsiBuilder b) {
        OraPlusParser.updateRemapper(b, this.myPlusContext, SqlGeneratedParserUtil.wasOn(b, 0, "PL_DIALECT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        boolean prev = this.myPlusContext;
        try {
            this.setPlusContext(builder, true);
            boolean bl = super.statementRecover(builder, level, prefixParser);
            return bl;
        }
        finally {
            this.setPlusContext(builder, prev);
        }
    }

    private void setPlusContext(PsiBuilder builder, boolean plus2) {
        if (this.myPlusContext == plus2) {
            return;
        }
        this.myPlusContext = plus2;
        OraPlusParser.updateRemapper(builder, plus2, SqlGeneratedParserUtil.wasOn(builder, 0, "PL_DIALECT"));
    }

    private static void updateRemapper(PsiBuilder builder, boolean plus2, boolean pl) {
        builder.setTokenTypeRemapper(plus2 ? TO_PLUS_MAPPER : (pl ? TO_ORA_PL_MAPPER : TO_ORA_MAPPER));
    }
}

