/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShTypes;
import com.intellij.sh.lexer.ShTokenTypes;
import gnu.trove.TObjectLongHashMap;

public class ShParserUtil
extends GeneratedParserUtilBase {
    private static final Key<TObjectLongHashMap<String>> MODES_KEY = Key.create((String)"MODES_KEY");

    private static TObjectLongHashMap<String> getParsingModes(PsiBuilder b) {
        TObjectLongHashMap flags = (TObjectLongHashMap)b.getUserData(MODES_KEY);
        if (flags == null) {
            flags = new TObjectLongHashMap();
            b.putUserData(MODES_KEY, (Object)flags);
        }
        return flags;
    }

    static boolean isModeOn(PsiBuilder b, int level, String mode) {
        return ShParserUtil.getParsingModes(b).get((Object)mode) > 0L;
    }

    static boolean withOn(PsiBuilder b, int level_, String mode, GeneratedParserUtilBase.Parser parser) {
        return ShParserUtil.withImpl(b, level_, mode, true, parser, parser);
    }

    private static boolean withImpl(PsiBuilder b, int level_, String mode, boolean onOff, GeneratedParserUtilBase.Parser whenOn, GeneratedParserUtilBase.Parser whenOff) {
        boolean change;
        TObjectLongHashMap<String> map = ShParserUtil.getParsingModes(b);
        long prev = map.get((Object)mode);
        boolean bl = change = (prev & 1L) == 0L == onOff;
        if (change) {
            map.put((Object)mode, prev << 1 | (long)(onOff ? 1 : 0));
        }
        boolean result = (change ? whenOn : whenOff).parse(b, level_);
        if (change) {
            map.put((Object)mode, prev);
        }
        return result;
    }

    static boolean backslash(PsiBuilder b, int level) {
        return ShParserUtil.consumeTokenFast((PsiBuilder)b, (String)"\\\n");
    }

    static boolean notQuote(PsiBuilder b, int level) {
        if (b.getTokenType() == ShTypes.OPEN_QUOTE || b.getTokenType() == ShTypes.CLOSE_QUOTE) {
            return false;
        }
        b.advanceLexer();
        return true;
    }

    static boolean differentBracketsWarning(PsiBuilder b, int level) {
        b.error(ShBundle.message("sh.parser.expected.similar.close.bracket", new Object[0]));
        return true;
    }

    static boolean parseUntilSpace(PsiBuilder b, int level, GeneratedParserUtilBase.Parser parser) {
        PsiBuilder.Marker mark = b.mark();
        while (parser.parse(b, level) && !ShTokenTypes.whitespaceTokens.contains(b.rawLookup(0)) && !b.eof()) {
        }
        mark.drop();
        return true;
    }

    static boolean keywordsRemapped(PsiBuilder b, int level) {
        IElementType type = b.getTokenType();
        if (ShTokenTypes.identifierKeywords.contains(type)) {
            PsiBuilder.Marker mark = b.mark();
            b.remapCurrentToken(ShTypes.WORD);
            b.advanceLexer();
            mark.done(ShTypes.SIMPLE_COMMAND_ELEMENT);
            return true;
        }
        return false;
    }

    static boolean functionNameKeywordsRemapped(PsiBuilder b, int level) {
        IElementType type = b.getTokenType();
        if (ShTokenTypes.identifierKeywords.contains(type)) {
            b.remapCurrentToken(ShTypes.WORD);
            b.advanceLexer();
            return true;
        }
        return false;
    }
}

