/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.rt.execution;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ForkedDebuggerHelper {
    public static final String JVM_DEBUG_SETUP_PREFIX = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=";
    public static final String DEBUG_FORK_SOCKET_PARAM = "-forkSocket";
    public static final String DEBUG_SERVER_PORT_KEY = "DEBUG_SERVER_PORT";
    public static final String PARAMETERS_SEPARATOR = ";";
    public static final String FINISH_PARAMS = "FINISH_PARAMS";

    public static int setupDebugger(String debuggerId, String processName, String processParameters, int dispatchPort) {
        int port = 0;
        try {
            port = ForkedDebuggerHelper.findAvailableSocketPort();
            processParameters = processParameters == null || processParameters.isEmpty() ? "" : processParameters + PARAMETERS_SEPARATOR;
            processParameters = processParameters + DEBUG_SERVER_PORT_KEY + "=" + port;
            ForkedDebuggerHelper.send(debuggerId, processName, processParameters, dispatchPort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return port;
    }

    public static void signalizeFinish(String debuggerId, String processName, int dispatchPort) {
        try {
            ForkedDebuggerHelper.send(debuggerId, processName, FINISH_PARAMS, dispatchPort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send(String debuggerId, String processName, String processParameters, int dispatchPort) throws IOException {
        Socket socket = new Socket("127.0.0.1", dispatchPort);
        try {
            DataOutputStream stream = new DataOutputStream(socket.getOutputStream());
            try {
                stream.writeUTF(debuggerId);
                stream.writeUTF(processName);
                stream.writeUTF(processParameters);
                int n = socket.getInputStream().read();
            }
            finally {
                stream.close();
            }
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int findAvailableSocketPort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            int port = serverSocket.getLocalPort();
            ServerSocket serverSocket2 = serverSocket;
            synchronized (serverSocket2) {
                try {
                    serverSocket.wait(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (port <= -1) {
                throw new IOException("Failed to find available port");
            }
            int n = port;
            return n;
        }
        finally {
            serverSocket.close();
        }
    }
}

