/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.models;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.models.WorkbookInfo;
import com.jetbrains.intellij.datalore.services.ProjectService;
import com.jetbrains.intellij.datalore.util.JGitUtilKt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/intellij/datalore/models/SyncEntity;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myInfo", "Lcom/jetbrains/intellij/datalore/models/WorkbookInfo;", "myGit", "Lorg/eclipse/jgit/api/Git;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/intellij/datalore/models/WorkbookInfo;Lorg/eclipse/jgit/api/Git;)V", "myProjectService", "Lcom/jetbrains/intellij/datalore/services/ProjectService;", "applyAllFiles", "", "applyChanges", "createAddCommand", "Lorg/eclipse/jgit/api/AddCommand;", "createRmCommand", "Lorg/eclipse/jgit/api/RmCommand;", "getAddedFiles", "", "", "getDiff", "getHeadHash", "getRemovedFiles", "Companion", "datalore-intellij-plugin"})
public final class SyncEntity {
    private final ProjectService myProjectService;
    private final WorkbookInfo myInfo;
    private final Git myGit;
    private static final Logger LOG;
    public static final Companion Companion;

    public final boolean applyAllFiles() {
        boolean bl;
        try {
            AddCommand addCommand = this.createAddCommand();
            if (addCommand != null) {
                addCommand.call();
            }
            this.myGit.commit().setMessage("created").call();
            bl = true;
        }
        catch (GitAPIException e) {
            LOG.error("Could not apply files: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public final boolean applyChanges() {
        boolean bl;
        try {
            AddCommand addCommand = this.createAddCommand();
            RmCommand rmCommand = this.createRmCommand();
            if (addCommand != null || rmCommand != null) {
                AddCommand addCommand2 = addCommand;
                if (addCommand2 != null) {
                    addCommand2.call();
                }
                RmCommand rmCommand2 = rmCommand;
                if (rmCommand2 != null) {
                    rmCommand2.call();
                }
                this.myGit.commit().setMessage("changes applied").call();
            }
            bl = true;
        }
        catch (GitAPIException e) {
            LOG.error("Could not apply changes and create git commit: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final String getHeadHash() {
        String string;
        try {
            ObjectId objectId = this.myGit.getRepository().resolve("HEAD");
            string = objectId != null ? objectId.getName() : null;
        }
        catch (GitAPIException e) {
            LOG.error("Error while getting HEAD for repository " + this.myInfo.getSyncId() + ": " + e.getMessage());
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getDiff() {
        String string;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DiffCommand diffCommand = this.myGit.diff();
            String oldHash = this.myInfo.getHeadHash();
            if (oldHash != null) {
                diffCommand.setOldTree(JGitUtilKt.getTreeIterator(this.myGit, oldHash)).setNewTree(JGitUtilKt.getHeadIterator(this.myGit));
            }
            diffCommand.setOutputStream((OutputStream)os).call();
            string = os.toString();
        }
        catch (GitAPIException e) {
            LOG.warn("Could not get diff: " + e.getMessage());
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> getAddedFiles() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.myProjectService.getProjectFiles();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (this.myProjectService.getRelativePath(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<String> getRemovedFiles() {
        Status statusCommand;
        Status status = statusCommand = this.myGit.status().call();
        Intrinsics.checkExpressionValueIsNotNull((Object)status, (String)"statusCommand");
        Set set = status.getMissing();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"statusCommand.missing");
        Set set2 = statusCommand.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"statusCommand.removed");
        return SetsKt.plus((Set)set, (Iterable)set2);
    }

    private final AddCommand createAddCommand() {
        AddCommand addCommand = this.myGit.add();
        Collection<String> addedFiles = this.getAddedFiles();
        if (addedFiles.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = addedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            addCommand.addFilepattern(it);
        }
        return addCommand;
    }

    private final RmCommand createRmCommand() {
        RmCommand rmCommand = this.myGit.rm();
        Collection<String> removedFiles = this.getRemovedFiles();
        if (removedFiles.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = removedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            rmCommand.addFilepattern(it);
        }
        return rmCommand;
    }

    private SyncEntity(Project myProject, WorkbookInfo myInfo, Git myGit) {
        this.myInfo = myInfo;
        this.myGit = myGit;
        this.myProjectService = ProjectService.Companion.getInstance(myProject);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SyncEntity.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(SyncEntity::class.java)");
        LOG = logger;
    }

    public /* synthetic */ SyncEntity(Project myProject, WorkbookInfo myInfo, Git myGit, DefaultConstructorMarker $constructor_marker) {
        this(myProject, myInfo, myGit);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/intellij/datalore/models/SyncEntity$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createEntity", "Lcom/jetbrains/intellij/datalore/models/SyncEntity;", "project", "Lcom/intellij/openapi/project/Project;", "info", "Lcom/jetbrains/intellij/datalore/models/WorkbookInfo;", "createGitRepository", "Lorg/eclipse/jgit/api/Git;", "repoDir", "Ljava/io/File;", "gitDir", "createOrOpenGitRepo", "getSyncEntityDirectory", "openGitRepository", "datalore-intellij-plugin"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final SyncEntity createEntity(@NotNull Project project, @NotNull WorkbookInfo info) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
            ProjectService projectService = ProjectService.Companion.getInstance(project);
            File directoryToSync = Paths.get(projectService.getRootPath(), new String[0]).toFile();
            File file = this.getSyncEntityDirectory(project, info);
            File file2 = file;
            if (file == null) return null;
            File file3 = file2;
            boolean bl = false;
            boolean bl2 = false;
            File file4 = file3;
            boolean bl3 = false;
            File file5 = directoryToSync;
            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"directoryToSync");
            Git git = Companion.createOrOpenGitRepo(file5, file4);
            file2 = git;
            if (git == null) return null;
            file3 = file2;
            bl = false;
            bl2 = false;
            File git2 = file3;
            boolean bl4 = false;
            SyncEntity syncEntity = new SyncEntity(project, info, (Git)git2, null);
            return syncEntity;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final File getSyncEntityDirectory(Project project, WorkbookInfo info) {
            File directory;
            block3: {
                block2: {
                    ProjectService projectService = ProjectService.Companion.getInstance(project);
                    directory = projectService.getWorkbookDirectoryPath().resolve(info.getSyncId()).toFile();
                    directory.mkdirs();
                    if (!directory.exists()) break block2;
                    File file = directory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"directory");
                    if (file.isDirectory()) break block3;
                }
                LOG.error("Could not create sync directory: " + directory);
                return null;
            }
            File file = directory;
            return file;
        }

        private final Git createOrOpenGitRepo(File repoDir, File gitDir) {
            Git opened = this.openGitRepository(gitDir);
            Git git = opened;
            if (git == null) {
                git = this.createGitRepository(repoDir, gitDir);
            }
            return git;
        }

        private final Git createGitRepository(File repoDir, File gitDir) {
            Git git;
            try {
                File gitFile = FilesKt.resolve((File)repoDir, (String)".git");
                String gitFileContent = null;
                if (gitFile.exists() && !gitFile.isDirectory()) {
                    gitFileContent = FilesKt.readText((File)gitFile, (Charset)Charsets.UTF_8);
                }
                Git git2 = Git.init().setDirectory(repoDir).setGitDir(gitDir).call();
                if (gitFileContent != null) {
                    FilesKt.writeText$default((File)gitFile, (String)gitFileContent, null, (int)2, null);
                } else if (gitFile.exists() && !gitFile.isDirectory()) {
                    gitFile.delete();
                }
                git = git2;
            }
            catch (GitAPIException e) {
                LOG.error("Could not create git repo: " + e.getMessage());
                git = null;
            }
            return git;
        }

        private final Git openGitRepository(File gitDir) {
            Git git;
            try {
                git = Git.open((File)gitDir);
            }
            catch (IOException e) {
                git = null;
            }
            return git;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

