/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.pull.DockerPullToTerminal;
import com.intellij.docker.pull.DockerTerminalPipe;
import com.intellij.docker.registry.search.DockerSearch;
import com.intellij.docker.registry.search.DockerSearchResult;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.view.details.ImagePullPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remoteServer.impl.runtime.log.CloudTerminalProvider;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\r\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u001fH\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u0016H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/docker/view/details/ImagePullPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "runtime", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;)V", "focusManager", "Lcom/intellij/openapi/wm/IdeFocusManager;", "getFocusManager", "()Lcom/intellij/openapi/wm/IdeFocusManager;", "imageTagField", "Lcom/intellij/ui/TextFieldWithAutoCompletion;", "Lcom/intellij/docker/registry/search/DockerSearchResult;", "mainPanel", "Ljavax/swing/JComponent;", "getMainPanel$intellij_clouds_docker", "()Ljavax/swing/JComponent;", "operationLabel", "Lcom/intellij/ui/components/JBLabel;", "pullQueue", "Ljava/util/Deque;", "", "spinningLabel", "terminalHandler", "Lcom/intellij/remoteServer/impl/runtime/log/TerminalHandlerBase;", "terminalPipe", "Lcom/intellij/docker/pull/DockerTerminalPipe;", "chooseNextValidTagToPull", "Lcom/intellij/docker/agent/DockerRepoTag;", "disposeTerminal", "", "disposeTerminal$intellij_clouds_docker", "preferredFocusableComponent", "preferredFocusableComponent$intellij_clouds_docker", "pullNextOne", "refreshQueueLabel", "requestPull", "request", "Companion", "DockerImageCompletionProvider", "intellij.clouds.docker"})
public final class ImagePullPanel {
    private final JBLabel spinningLabel;
    private final JBLabel operationLabel;
    private final TextFieldWithAutoCompletion<DockerSearchResult> imageTagField;
    private final DockerTerminalPipe terminalPipe;
    private final Deque<String> pullQueue;
    private final TerminalHandlerBase terminalHandler;
    @NotNull
    private final JComponent mainPanel;
    private final Project project;
    private final DockerGroupRuntime.ImagesGroup runtime;
    public static final int ICON_GAP = 6;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JComponent getMainPanel$intellij_clouds_docker() {
        return this.mainPanel;
    }

    public final void disposeTerminal$intellij_clouds_docker() {
        if (!this.terminalHandler.isClosed()) {
            this.terminalHandler.close();
        }
    }

    @NotNull
    public final TextFieldWithAutoCompletion<DockerSearchResult> preferredFocusableComponent$intellij_clouds_docker() {
        return this.imageTagField;
    }

    private final void requestPull(String request) {
        CharSequence charSequence = request;
        String string = "\\s+";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List newTags = string.split(charSequence, n);
        boolean queueWasEmpty = this.pullQueue.isEmpty();
        this.pullQueue.addAll(newTags);
        this.imageTagField.setText("");
        this.getFocusManager().requestFocusInProject((Component)this.terminalHandler.getComponent(), this.project);
        if (queueWasEmpty) {
            this.pullNextOne();
        }
    }

    private final void pullNextOne() {
        DockerRepoTag tagToPull = this.chooseNextValidTagToPull();
        if (tagToPull == null) {
            this.getFocusManager().requestFocusInProject((Component)this.imageTagField, this.project);
            return;
        }
        DockerPullToTerminal dockerPullToTerminal = new DockerPullToTerminal(this.terminalPipe, null, 2, null);
        CompletableFuture<BlockingQueue<byte[]>> completableFuture = this.runtime.asyncPullImage(tagToPull);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"runtime.asyncPullImage(tagToPull)");
        ((CompletableFuture)dockerPullToTerminal.redirectToTerminalLater(completableFuture).thenRun(new Runnable(this){
            final /* synthetic */ ImagePullPanel this$0;

            public final void run() {
                DockerTerminalPipe.println$default(ImagePullPanel.access$getTerminalPipe$p(this.this$0), "", null, 2, null);
                ImagePullPanel.access$getTerminalPipe$p(this.this$0).releaseWriteToTerminalThread();
            }
            {
                this.this$0 = imagePullPanel;
            }
        })).thenRun(new Runnable(this){
            final /* synthetic */ ImagePullPanel this$0;

            public final void run() {
                ImagePullPanel.access$pullNextOne(this.this$0);
            }
            {
                this.this$0 = imagePullPanel;
            }
        });
    }

    private final DockerRepoTag chooseNextValidTagToPull() {
        while (!this.pullQueue.isEmpty()) {
            DockerRepoTag nextTag;
            String nextTagString = this.pullQueue.removeFirst();
            this.refreshQueueLabel();
            DockerTerminalPipe.println$default(this.terminalPipe, "docker pull " + nextTagString, null, 2, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)DockerRepoTag.fromString((String)nextTagString), (String)"DockerRepoTag.fromString(nextTagString)");
            if (!nextTag.hasCustomTag()) {
                String string = nextTagString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nextTagString");
                CharSequence charSequence = string;
                String string2 = nextTag.getTagNotNull();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"nextTag.tagNotNull");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) {
                    String string3 = DockerBundle.message("ImagePullPanel.terminal.info.using.default.tag", new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DockerBundle.message(\"Im\u2026.info.using.default.tag\")");
                    DockerTerminalPipe.println$default(this.terminalPipe, string3, null, 2, null);
                }
            }
            if (nextTag.isValidReferenceFormat()) {
                return nextTag;
            }
            String string = DockerBundle.message("ImagePullPanel.terminal.error.reference.format", nextTagString);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DockerBundle.message(\"Im\u2026e.format\", nextTagString)");
            DockerTerminalPipe.println$default(this.terminalPipe, string, null, 2, null);
            DockerTerminalPipe.println$default(this.terminalPipe, null, null, 3, null);
        }
        return null;
    }

    private final void refreshQueueLabel() {
        this.operationLabel.setText(DockerBundle.message("ImagePullPanel.queue.label", this.pullQueue.size()));
        Collection collection = this.pullQueue;
        JBLabel jBLabel = this.operationLabel;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        jBLabel.setVisible(bl2);
        collection = this.pullQueue;
        jBLabel = this.spinningLabel;
        bl = false;
        bl2 = !collection.isEmpty();
        jBLabel.setVisible(bl2);
    }

    private final IdeFocusManager getFocusManager() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)ideFocusManager, (String)"IdeFocusManager.getInstance(project)");
        return ideFocusManager;
    }

    public ImagePullPanel(@NotNull Project project, @NotNull DockerGroupRuntime.ImagesGroup runtime) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)runtime, (String)"runtime");
        this.project = project;
        this.runtime = runtime;
        this.spinningLabel = new JBLabel((Icon)new AnimatedIcon.Default());
        this.operationLabel = new JBLabel("");
        this.terminalPipe = new DockerTerminalPipe("ImagePullPanel.pipe");
        this.pullQueue = new ArrayDeque();
        this.terminalPipe.setShowCursor(false);
        this.imageTagField = new TextFieldWithAutoCompletion(this.project, (TextFieldWithAutoCompletionListProvider)new DockerImageCompletionProvider(), true, null);
        this.imageTagField.setPreferredSize(new JTextField(30).getPreferredSize());
        ShortcutSet shortcut = CommonShortcuts.CTRL_ENTER;
        new DumbAwareAction(DockerBundle.message("ImagePullPanel.action.pull", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                String string = imageTagField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"imageTagField.text");
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                CharSequence charSequence = it;
                boolean bl4 = false;
                if (charSequence.length() > 0) {
                    this.requestPull(it);
                }
            }
        }.registerCustomShortcutSet(shortcut, (JComponent)this.imageTagField, null);
        JPanel jPanel = UI.PanelFactory.panel((JComponent)((JComponent)this.imageTagField)).withLabel(DockerBundle.message("ImagePullPanel.image.to.pull.label", new Object[0])).withComment(DockerBundle.message("ImagePullPanel.image.to.pull.comment", KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)shortcut))).moveCommentRight().createPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"UI.PanelFactory.panel(im\u2026ht()\n      .createPanel()");
        JPanel imageTagPanel = jPanel;
        this.mainPanel = new JPanel(new BorderLayout(ImagePullPanel.Companion.scale(10), ImagePullPanel.Companion.scale(4)));
        JPanel jPanel2 = new JPanel((LayoutManager)new HorizontalLayout(ImagePullPanel.Companion.scale(6)));
        boolean bl = false;
        boolean bl2 = false;
        JPanel it = jPanel2;
        boolean bl3 = false;
        it.setBorder((Border)JBUI.Borders.emptyRight((int)ImagePullPanel.Companion.scale(10)));
        it.add((Component)new JBLabel(), "LEFT");
        it.add((Component)imageTagPanel, "LEFT");
        it.add((Component)this.operationLabel, "RIGHT");
        it.add((Component)this.spinningLabel, "RIGHT");
        JPanel topRow = jPanel2;
        this.mainPanel.add((Component)topRow, "North");
        TerminalHandlerBase terminalHandlerBase = CloudTerminalProvider.getInstance().createTerminal(DockerBundle.message("ImagePullPanel.terminal.name", new Object[0]), this.project, this.terminalPipe.getTerminalOutput(), this.terminalPipe.getTerminalInput(), true);
        Intrinsics.checkExpressionValueIsNotNull((Object)terminalHandlerBase, (String)"CloudTerminalProvider.ge\u2026Pipe.terminalInput, true)");
        this.terminalHandler = terminalHandlerBase;
        this.mainPanel.add((Component)this.terminalHandler.getComponent(), "Center");
        this.refreshQueueLabel();
    }

    public static final /* synthetic */ DockerTerminalPipe access$getTerminalPipe$p(ImagePullPanel $this) {
        return $this.terminalPipe;
    }

    public static final /* synthetic */ void access$pullNextOne(ImagePullPanel $this) {
        $this.pullNextOne();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0002H\u0014R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/view/details/ImagePullPanel$DockerImageCompletionProvider;", "Lcom/intellij/ui/TextFieldWithAutoCompletionListProvider;", "Lcom/intellij/docker/registry/search/DockerSearchResult;", "()V", "search", "Lcom/intellij/docker/registry/search/DockerSearch;", "getSearch", "()Lcom/intellij/docker/registry/search/DockerSearch;", "search$delegate", "Lkotlin/Lazy;", "compare", "", "item1", "item2", "getIcon", "Ljavax/swing/Icon;", "item", "getItems", "", "prefix", "", "cached", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getLookupString", "Companion", "intellij.clouds.docker"})
    private static final class DockerImageCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<DockerSearchResult> {
        private final Lazy search$delegate = LazyKt.lazy((Function0)search.2.INSTANCE);
        private static final Lazy LOG$delegate;
        public static final Companion Companion;

        private final DockerSearch getSearch() {
            Lazy lazy = this.search$delegate;
            DockerImageCompletionProvider dockerImageCompletionProvider = this;
            Object var3_3 = null;
            boolean bl = false;
            return (DockerSearch)lazy.getValue();
        }

        @NotNull
        public Collection<DockerSearchResult> getItems(@Nullable String prefix, boolean cached, @Nullable CompletionParameters parameters) {
            try {
                DockerSearch dockerSearch = this.getSearch();
                String string = prefix;
                if (string == null) {
                    string = "";
                }
                List<DockerSearchResult> list = dockerSearch.searchForCompletions(string).get(5L, TimeUnit.SECONDS);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"search.searchForCompleti\u2026.get(5, TimeUnit.SECONDS)");
                return list;
            }
            catch (Exception ex) {
                DockerImageCompletionProvider.Companion.getLOG().warn("Can't list images for " + prefix, (Throwable)ex);
                List list = Collections.emptyList();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
                return list;
            }
        }

        @Nullable
        protected Icon getIcon(@NotNull DockerSearchResult item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getIcon();
        }

        @NotNull
        protected String getLookupString(@NotNull DockerSearchResult item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getLookupText();
        }

        public int compare(@NotNull DockerSearchResult item1, @NotNull DockerSearchResult item2) {
            Intrinsics.checkParameterIsNotNull((Object)item1, (String)"item1");
            Intrinsics.checkParameterIsNotNull((Object)item2, (String)"item2");
            DockerSearchResult.Kind kind1 = item1.getKind();
            DockerSearchResult.Kind kind2 = item2.getKind();
            if (kind1 != kind2) {
                return kind1.compareTo((Enum)kind2);
            }
            return super.compare((Object)item1, (Object)item2);
        }

        public DockerImageCompletionProvider() {
            super(null);
        }

        static {
            Companion = new Companion(null);
            LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/view/details/ImagePullPanel$DockerImageCompletionProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "intellij.clouds.docker"})
        public static final class Companion {
            private final Logger getLOG() {
                Lazy lazy = LOG$delegate;
                Companion companion = Companion;
                Object var3_3 = null;
                boolean bl = false;
                return (Logger)lazy.getValue();
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/view/details/ImagePullPanel$Companion;", "", "()V", "ICON_GAP", "", "scale", "value", "intellij.clouds.docker"})
    public static final class Companion {
        private final int scale(int value) {
            return JBUIScale.scale((int)value);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

