/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.HtmlCodeStyleMainPanel;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, final CodeStyleSettings originalSettings) {
        return new CodeStyleAbstractConfigurable(settings, originalSettings, Holder.getDisplayName()){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new HtmlCodeStyleMainPanel(settings, originalSettings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.IDE.globalcodestyle.html";
            }
        };
    }

    public String getConfigurableDisplayName() {
        return Holder.getDisplayName();
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new HtmlCodeStyleSettings(settings);
    }

    @Nullable
    public Language getLanguage() {
        return HTMLLanguage.INSTANCE;
    }

    public static class Holder {
        public static String getDisplayName() {
            return "HTML";
        }
    }
}

