/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.xml.XmlNamedReferenceHost;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.xml.XmlNamedReferenceProviderBean;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@ApiStatus.Internal
public final class NamedReferenceProviders {
    private static final ExtensionPointName<XmlNamedReferenceProviderBean> EP_NAME = ExtensionPointName.create((String)"com.intellij.xml.namedReferenceProvider");
    private final Map<Class<?>, ByHostClass> myByHostClass = new ConcurrentHashMap(2);

    @NotNull
    static NamedReferenceProviders getInstance() {
        NamedReferenceProviders namedReferenceProviders = (NamedReferenceProviders)ServiceManager.getService(NamedReferenceProviders.class);
        if (namedReferenceProviders == null) {
            NamedReferenceProviders.$$$reportNull$$$0(0);
        }
        return namedReferenceProviders;
    }

    public NamedReferenceProviders() {
        EP_NAME.addExtensionPointListener(() -> this.myByHostClass.clear(), (Disposable)ApplicationManager.getApplication());
    }

    @NotNull
    Collection<XmlNamedReferenceProviderBean> getNamedReferenceProviderBeans(@NotNull XmlNamedReferenceHost element) {
        String hostName;
        if (element == null) {
            NamedReferenceProviders.$$$reportNull$$$0(1);
        }
        if ((hostName = element.getHostName()) == null) {
            List<XmlNamedReferenceProviderBean> list = Collections.emptyList();
            if (list == null) {
                NamedReferenceProviders.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection<XmlNamedReferenceProviderBean> collection = this.byHostClass(element).byHostName(hostName);
        if (collection == null) {
            NamedReferenceProviders.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private ByHostClass byHostClass(@NotNull XmlNamedReferenceHost element) {
        if (element == null) {
            NamedReferenceProviders.$$$reportNull$$$0(4);
        }
        ByHostClass byHostClass = this.myByHostClass.computeIfAbsent(element.getClass(), NamedReferenceProviders::byHostClassInner);
        if (byHostClass == null) {
            NamedReferenceProviders.$$$reportNull$$$0(5);
        }
        return byHostClass;
    }

    @NotNull
    private static ByHostClass byHostClassInner(@NotNull Class<?> hostClass) {
        if (hostClass == null) {
            NamedReferenceProviders.$$$reportNull$$$0(6);
        }
        SmartList result = new SmartList();
        for (XmlNamedReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            if (!bean.getHostElementClass().isAssignableFrom(hostClass)) continue;
            result.add(bean);
        }
        return new ByHostClass((List<XmlNamedReferenceProviderBean>)result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/impl/NamedReferenceProviders";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/impl/NamedReferenceProviders";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedReferenceProviderBeans";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "byHostClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNamedReferenceProviderBeans";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "byHostClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "byHostClassInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ByHostClass {
        private final Map<String, List<XmlNamedReferenceProviderBean>> myCaseSensitiveMap;
        private final Map<String, List<XmlNamedReferenceProviderBean>> myCaseInsensitiveMap;

        ByHostClass(@NotNull List<XmlNamedReferenceProviderBean> beans) {
            if (beans == null) {
                ByHostClass.$$$reportNull$$$0(0);
            }
            THashMap caseSensitiveMap = new THashMap();
            THashMap caseInsensitiveMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (XmlNamedReferenceProviderBean bean : beans) {
                THashMap map = bean.caseSensitive ? caseSensitiveMap : caseInsensitiveMap;
                for (String hostName : bean.getHostNames()) {
                    map.computeIfAbsent(hostName, __ -> new SmartList()).add(bean);
                }
            }
            caseSensitiveMap.compact();
            caseInsensitiveMap.compact();
            this.myCaseSensitiveMap = caseSensitiveMap;
            this.myCaseInsensitiveMap = caseInsensitiveMap;
        }

        @NotNull
        Collection<XmlNamedReferenceProviderBean> byHostName(@NotNull String hostName) {
            if (hostName == null) {
                ByHostClass.$$$reportNull$$$0(1);
            }
            List list = ContainerUtil.concat((List)((List)ObjectUtils.notNull(this.myCaseSensitiveMap.get(hostName), Collections.emptyList())), (List)((List)ObjectUtils.notNull(this.myCaseInsensitiveMap.get(hostName), Collections.emptyList())));
            if (list == null) {
                ByHostClass.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beans";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/impl/NamedReferenceProviders$ByHostClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/impl/NamedReferenceProviders$ByHostClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byHostName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "byHostName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

