/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.rearranger;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CssArrangementEntry
extends DefaultArrangementEntry
implements NameAwareArrangementEntry {
    @Nullable
    private final String myName;

    CssArrangementEntry(@Nullable String name, @Nullable ArrangementEntry parent, @NotNull TextRange range, boolean sortByName) {
        if (range == null) {
            CssArrangementEntry.$$$reportNull$$$0(0);
        }
        super(parent, range.getStartOffset(), range.getEndOffset(), true);
        if (name == null) {
            if (parent == null) {
                this.myName = null;
            } else {
                String offset = String.valueOf(range.getStartOffset());
                String leadingZeros = StringUtil.repeatSymbol((char)'0', (int)(7 - offset.length()));
                this.myName = "~" + leadingZeros + offset;
            }
        } else {
            this.myName = sortByName ? CssArrangementEntry.adjustName(name) : name;
        }
    }

    @NotNull
    private static String adjustName(@NotNull String origName) {
        int index;
        if (origName == null) {
            CssArrangementEntry.$$$reportNull$$$0(1);
        }
        if (origName.startsWith("-") && origName.length() > 3 && (index = origName.indexOf(45, 2)) > 0) {
            String string = origName.substring(index + 1) + '!' + origName.substring(0, index);
            if (string == null) {
                CssArrangementEntry.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = origName + '#';
        if (string == null) {
            CssArrangementEntry.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "CssArrangementEntry: name = " + this.myName + ", children count = " + this.getChildren().size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/rearranger/CssArrangementEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/rearranger/CssArrangementEntry";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustName";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

