/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.actions.ruleset.InputSelectorDialog;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingFileStyleCreator
extends StyleCreator {
    private static final String HREF_ATTRIBUTE_NAME = "href";
    private final StylesheetFile myTargetFile;

    public ExistingFileStyleCreator(@NotNull PsiFile contextFile, @NotNull StylesheetFile targetFile) {
        if (contextFile == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(0);
        }
        if (targetFile == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(1);
        }
        super(targetFile.getName(), contextFile);
        this.myTargetFile = targetFile;
    }

    @Override
    @Nullable
    public CssRuleset createStyleDeclaration(@NotNull String selector, CssDeclaration ... declarations) {
        if (selector == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(2);
        }
        if (declarations == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(3);
        }
        return (CssRuleset)WriteCommandAction.runWriteCommandAction((Project)this.myContextFile.getProject(), () -> {
            CssRuleset createdRuleset = ExistingFileStyleCreator.createStyleInCssFile(this.myTargetFile, selector, declarations);
            if (createdRuleset != null) {
                ExistingFileStyleCreator.addCssLinkToContextFileIfNeeded(this.myContextFile, this.myTargetFile);
            }
            return createdRuleset;
        });
    }

    @Override
    public void createStyleDeclarationInteractively(@NotNull Editor editor, @NotNull String defaultSelector, @NotNull Collection<String> selectorVariants, @Nullable CreateStyleCallback callback, CssDeclaration ... declarations) {
        String selectorName;
        boolean done;
        if (editor == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(4);
        }
        if (defaultSelector == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(5);
        }
        if (selectorVariants == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(6);
        }
        if (declarations == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            done = true;
            selectorName = defaultSelector;
        } else {
            InputSelectorDialog inputSelectorDialog = new InputSelectorDialog(this.myContextFile.getProject(), (LanguageFileType)this.myTargetFile.getFileType(), ArrayUtilRt.toStringArray(selectorVariants));
            done = inputSelectorDialog.showAndGet();
            selectorName = StringUtil.notNullize((String)StringUtil.nullize((String)inputSelectorDialog.getValue(), (boolean)true), (String)defaultSelector);
        }
        if (done) {
            CssRuleset ruleset = this.createStyleDeclaration(selectorName, declarations);
            if (callback != null) {
                callback.after(selectorName, ruleset);
            }
        }
    }

    public static void addCssLinkToContextFileIfNeeded(@NotNull PsiFile contextFile, @NotNull StylesheetFile targetFile) {
        if (contextFile == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(8);
        }
        if (targetFile == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(9);
        }
        if (contextFile instanceof XmlFile && !ExistingFileStyleCreator.fileAlreadyHasLinkToGivenFile((XmlFile)contextFile, targetFile)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (!FileModificationService.getInstance().prepareFileForWrite(contextFile)) {
                return;
            }
            Project project = contextFile.getProject();
            XmlTag parentTagForLink = ExistingFileStyleCreator.findParentTagForLink((XmlFile)contextFile);
            if (parentTagForLink != null) {
                XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
                VirtualFile targetVirtualFile = targetFile.getVirtualFile();
                if (targetVirtualFile != null) {
                    XmlAttributeValue hrefAttributeValue;
                    String relativePath = VfsUtilCore.findRelativePath((VirtualFile)contextFile.getVirtualFile(), (VirtualFile)targetVirtualFile, (char)'/');
                    String path = relativePath != null ? relativePath : targetVirtualFile.getPath();
                    XmlTag linkTag = elementFactory.createTagFromText((CharSequence)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + path + "\"/>"));
                    if ((linkTag = parentTagForLink.addSubTag(linkTag, true)) != null && (hrefAttributeValue = ExistingFileStyleCreator.getHrefAttributeValue(linkTag)) != null) {
                        CssUtil.rebindFileReference((PsiElement)linkTag, (PsiFile)targetFile);
                    }
                }
            }
        }
    }

    private static boolean fileAlreadyHasLinkToGivenFile(@NotNull XmlFile contextFile, @NotNull StylesheetFile fileToLink) {
        if (contextFile == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(10);
        }
        if (fileToLink == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(11);
        }
        CssResolver resolver = CssResolveManager.getInstance().getNewResolver();
        resolver.setStrictResolveMode(true);
        Object[] stylesheetFiles = resolver.resolveStyleSheets(contextFile, null);
        return ArrayUtil.contains((Object)fileToLink, (Object[])stylesheetFiles);
    }

    @Nullable
    private static XmlAttributeValue getHrefAttributeValue(@NotNull XmlTag tag) {
        XmlAttribute hrefAttribute;
        if (tag == null) {
            ExistingFileStyleCreator.$$$reportNull$$$0(12);
        }
        return (hrefAttribute = tag.getAttribute(HREF_ATTRIBUTE_NAME)) != null ? hrefAttribute.getValueElement() : null;
    }

    @Nullable
    private static XmlTag findParentTagForLink(XmlFile file) {
        XmlDocument document = file.getDocument();
        if (document == null) {
            return null;
        }
        XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
        if (headTag != null) {
            return headTag;
        }
        XmlTag htmlTag = AbstractTagUtil.findGenericHtmlTag(document);
        if (htmlTag != null) {
            XmlTag newHeadTag = XmlElementFactory.getInstance((Project)file.getProject()).createTagFromText((CharSequence)"<head></head>");
            return htmlTag.addSubTag(newHeadTag, true);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSelector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorVariants";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLink";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStyleDeclaration";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createStyleDeclarationInteractively";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addCssLinkToContextFileIfNeeded";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fileAlreadyHasLinkToGivenFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getHrefAttributeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

