/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.coverage.actions.HideCoverageInfoAction;
import com.intellij.coverage.actions.ShowCoveringTestsAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageLineMarkerRenderer
implements ActiveGutterRenderer,
LineMarkerRendererWithErrorStripe {
    private static final int d = 8;
    private final TextAttributesKey b;
    private final String g;
    private final TreeMap<Integer, LineData> c;
    private final boolean h;
    private final Function<? super Integer, Integer> a;
    private final Function<? super Integer, Integer> e;
    private final CoverageSuitesBundle f;
    private final boolean i;
    private final int j;
    private static final long k = com.jetbrains.python.psi.c.a(5499128313018018965L, 1576548298068327762L, MethodHandles.lookup().lookupClass()).a(202155606088922L);

    protected CoverageLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, CoverageSuitesBundle coverageSuite, boolean subCoverageActive) {
        this.b = CoverageLineMarkerRenderer.getAttributesKey(lineNumber, lines);
        this.j = lineNumber;
        this.g = className;
        this.c = lines;
        this.h = coverageByTestApplicable;
        this.a = newToOldConverter;
        this.e = oldToNewConverter;
        this.f = coverageSuite;
        this.i = subCoverageActive;
    }

    @Deprecated
    protected CoverageLineMarkerRenderer(TextAttributesKey key, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, CoverageSuitesBundle coverageSuite, boolean subCoverageActive) {
        this.b = key;
        this.g = className;
        this.c = lines;
        this.h = coverageByTestApplicable;
        this.a = newToOldConverter;
        this.e = oldToNewConverter;
        this.f = coverageSuite;
        this.i = subCoverageActive;
        this.j = -1;
    }

    private int a(@NotNull Editor editor2, Point point) {
        if (editor2 == null) {
            CoverageLineMarkerRenderer.a(0);
        }
        if (this.j > -1) {
            return this.j;
        }
        return editor2.xyToLogicalPosition((Point)point).line;
    }

    public void paint(Editor editor2, Graphics g10, Rectangle r2) {
        TextAttributes textAttributes = editor2.getColorsScheme().getAttributes(this.b);
        Color color = textAttributes.getBackgroundColor();
        if (color == null) {
            color = textAttributes.getForegroundColor();
        }
        if (color != null) {
            g10.setColor(color);
        }
        g10.fillRect(r2.x, r2.y, r2.width, r2.height);
        LineData lineData = this.getLineData(this.a(editor2, new Point(0, r2.y)));
        if (lineData != null && lineData.isCoveredByOneTest()) {
            AllIcons.Gutter.Unique.paintIcon(editor2.getComponent(), g10, r2.x, r2.y);
        }
    }

    public static CoverageLineMarkerRenderer getRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (coverageSuite == null) {
            CoverageLineMarkerRenderer.a(1);
        }
        return new CoverageLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, newToOldConverter, oldToNewConverter, coverageSuite, subCoverageActive);
    }

    public static TextAttributesKey getAttributesKey(int lineNumber, TreeMap<Integer, LineData> lines) {
        return CoverageLineMarkerRenderer.a(lines.get(lineNumber));
    }

    private static TextAttributesKey a(LineData lineData) {
        if (lineData != null) {
            switch (lineData.getStatus()) {
                case 2: {
                    return CodeInsightColors.LINE_FULL_COVERAGE;
                }
                case 1: {
                    return CodeInsightColors.LINE_PARTIAL_COVERAGE;
                }
            }
        }
        return CodeInsightColors.LINE_NONE_COVERAGE;
    }

    public boolean canDoAction(@NotNull MouseEvent e10) {
        Component component;
        if (e10 == null) {
            CoverageLineMarkerRenderer.a(2);
        }
        if ((component = e10.getComponent()) instanceof EditorGutterComponentEx) {
            EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)component;
            return e10.getX() > editorGutterComponentEx.getLineMarkerAreaOffset() && e10.getX() < editorGutterComponentEx.getIconAreaOffset();
        }
        return false;
    }

    public void doAction(@NotNull Editor editor2, @NotNull MouseEvent e10) {
        if (editor2 == null) {
            CoverageLineMarkerRenderer.a(3);
        }
        if (e10 == null) {
            CoverageLineMarkerRenderer.a(4);
        }
        e10.consume();
        JComponent jComponent = (JComponent)e10.getComponent();
        JRootPane jRootPane = jComponent.getRootPane();
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(jComponent, 8, e10.getY(), jLayeredPane);
        this.a(editor2, point, this.a(editor2, e10.getPoint()));
    }

    private void a(Editor editor2, Point point, int n2) {
        EditorImpl editorImpl;
        Object object;
        Object object2;
        long l2 = k ^ 0x1D42013242F2L;
        JPanel jPanel = new JPanel(new BorderLayout());
        final Disposable disposable = new Disposable(){

            public void dispose() {
            }
        };
        jPanel.add((Component)this.createActionsToolbar(editor2, n2, disposable), "North");
        LineData lineData = this.getLineData(n2);
        if (lineData != null && lineData.getStatus() != 0 && !this.i) {
            object2 = EditorFactory.getInstance();
            object = object2.createDocument((CharSequence)this.a(editor2, n2));
            object.setReadOnly(true);
            editorImpl = (EditorImpl)object2.createEditor(object, editor2.getProject());
            jPanel.add((Component)EditorFragmentComponent.createEditorFragmentComponent((Editor)editorImpl, (int)0, (int)object.getLineCount(), (boolean)false, (boolean)false), "Center");
        } else {
            editorImpl = null;
        }
        object2 = new LightweightHint(jPanel){

            public void hide() {
                if (editorImpl != null) {
                    EditorFactory.getInstance().releaseEditor((Editor)editorImpl);
                }
                Disposer.dispose((Disposable)disposable);
                super.hide();
            }
        };
        object = HintManagerImpl.getHintPosition((LightweightHint)object2, (Editor)editor2, (LogicalPosition)new LogicalPosition(n2, 0), (short)2);
        if (point != null) {
            object.x = point.x;
            object.y = point.y + Math.abs(object.y - point.y) % editor2.getLineHeight();
        } else {
            Point point2 = editor2.visualPositionToXY(editor2.offsetToVisualPosition(0));
            EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)editor2.getGutter();
            JLayeredPane jLayeredPane = editorGutterComponentEx.getRootPane().getLayeredPane();
            object.x = SwingUtilities.convertPoint((Component)editorGutterComponentEx, (int)8, (int)point2.y, (Component)jLayeredPane).x;
        }
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)object2, editor2, (Point)object, 58, -1, false, new HintHint(editor2, (Point)object));
    }

    private String a(Editor editor2, int n2) {
        LineData lineData = this.getLineData(n2);
        Document document = editor2.getDocument();
        Project project = editor2.getProject();
        assert (project != null);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        assert (psiFile != null);
        int n3 = document.getLineStartOffset(n2);
        int n4 = document.getLineEndOffset(n2);
        return this.f.getCoverageEngine().generateBriefReport(editor2, psiFile, n2, n3, n4, lineData);
    }

    protected JComponent createActionsToolbar(Editor editor2, int lineNumber, Disposable parent) {
        AnAction anAction;
        long l2 = k ^ 0x36EBAE9CBC4DL;
        JComponent jComponent = editor2.getComponent();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        GotoPreviousCoveredLineAction gotoPreviousCoveredLineAction = new GotoPreviousCoveredLineAction(this, editor2, lineNumber);
        GotoNextCoveredLineAction gotoNextCoveredLineAction = new GotoNextCoveredLineAction(this, editor2, lineNumber);
        defaultActionGroup.add((AnAction)gotoPreviousCoveredLineAction);
        defaultActionGroup.add((AnAction)gotoNextCoveredLineAction);
        gotoPreviousCoveredLineAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(38, 9)), jComponent);
        gotoNextCoveredLineAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 9)), jComponent);
        Disposer.register((Disposable)parent, () -> {
            gotoPreviousCoveredLineAction.unregisterCustomShortcutSet(jComponent);
            gotoNextCoveredLineAction.unregisterCustomShortcutSet(jComponent);
        });
        LineData lineData = this.getLineData(lineNumber);
        if (this.h) {
            defaultActionGroup.add((AnAction)new ShowCoveringTestsAction(this.g, lineData));
        }
        if ((anAction = ActionManager.getInstance().getAction("ByteCodeViewer")) != null) {
            defaultActionGroup.add(anAction);
        }
        defaultActionGroup.add((AnAction)new EditCoverageColorsAction(this, editor2, lineNumber));
        defaultActionGroup.add((AnAction)new HideCoverageInfoAction());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)defaultActionGroup, true);
        JComponent jComponent2 = actionToolbar.getComponent();
        Color color = ((EditorEx)editor2).getBackgroundColor();
        Color color2 = editor2.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        jComponent2.setBackground(color);
        jComponent2.setBorder((Border)new ColoredSideBorder(color2, color2, lineData == null || lineData.getStatus() == 0 || this.i ? color2 : null, color2, 1));
        actionToolbar.updateActionsImmediately();
        return jComponent2;
    }

    public void moveToLine(int lineNumber, Editor editor2) {
        int n2 = editor2.getDocument().getLineStartOffset(lineNumber);
        editor2.getCaretModel().moveToOffset(n2);
        editor2.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor2.getScrollingModel().runActionOnScrollingFinished(() -> this.a(editor2, null, lineNumber));
    }

    @Nullable
    public LineData getLineData(int lineNumber) {
        return this.c != null ? this.c.get(this.a != null ? (Integer)this.a.fun((Object)lineNumber) : lineNumber) : null;
    }

    @Override
    public Color getErrorStripeColor(Editor editor2) {
        return editor2.getColorsScheme().getAttributes(this.b).getErrorStripeColor();
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.LEFT;
        if (position == null) {
            CoverageLineMarkerRenderer.a(5);
        }
        return position;
    }

    @NotNull
    public String getAccessibleName() {
        long l2 = k ^ 0x5CA8F971DB5CL;
        if ("marker: code coverage" == null) {
            CoverageLineMarkerRenderer.a(6);
        }
        return "marker: code coverage";
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x526E364EA717L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLineNumber";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditCoverageColorsAction
    extends AnAction {
        private final Editor a;
        private final int b;
        final /* synthetic */ CoverageLineMarkerRenderer this$0;
        private static final long c = com.jetbrains.python.psi.c.a(3265270859375962001L, -6443033187896118110L, MethodHandles.lookup().lookupClass()).a(60511491001242L);

        private EditCoverageColorsAction(CoverageLineMarkerRenderer coverageLineMarkerRenderer, Editor editor2, int lineNumber) {
            long l2 = c ^ 0x488B22A5C4DAL;
            this.this$0 = coverageLineMarkerRenderer;
            super("Edit Coverage Colors", "Edit coverage colors", AllIcons.General.Settings);
            this.a = editor2;
            this.b = lineNumber;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EditCoverageColorsAction.a(0);
            }
            e10.getPresentation().setVisible(this.this$0.getLineData(this.b) != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e10) {
            long l2 = c ^ 0x2A0082366164L;
            if (e10 == null) {
                EditCoverageColorsAction.a(1);
            }
            final GeneralColorsPage generalColorsPage = new GeneralColorsPage();
            final String string = "Editor | " + ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]) + " | " + generalColorsPage.getDisplayName();
            ColorAndFontOptions colorAndFontOptions = new ColorAndFontOptions(){

                protected List<ColorAndFontPanelFactory> createPanelFactories() {
                    ColorAndFontPanelFactory colorAndFontPanelFactory = new ColorAndFontPanelFactory(){
                        private static final long a = com.jetbrains.python.psi.c.a(5519333796923680782L, -3749717071003365475L, MethodHandles.lookup().lookupClass()).a(140281929471436L);

                        @NotNull
                        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                            if (options == null) {
                                1.a(0);
                            }
                            SimpleEditorPreview simpleEditorPreview = new SimpleEditorPreview(options, (ColorSettingsPage)generalColorsPage);
                            NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create((PreviewPanel)simpleEditorPreview, (String)generalColorsPage.getDisplayName(), (ColorAndFontOptions)options, null, (ColorSettingsPage)generalColorsPage);
                            if (newColorAndFontPanel == null) {
                                1.a(1);
                            }
                            return newColorAndFontPanel;
                        }

                        @NotNull
                        public String getPanelDisplayName() {
                            String string = string;
                            if (string == null) {
                                1.a(2);
                            }
                            return string;
                        }

                        private static /* synthetic */ void a(int n2) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n3;
                            String string;
                            long l2 = a ^ 0x2E700B22229EL;
                            switch (n2) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    n3 = 3;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    n3 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n3];
                            switch (n2) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "options";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "createPanel";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getPanelDisplayName";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "createPanel";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n2) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    };
                    return Collections.singletonList(colorAndFontPanelFactory);
                }
            };
            Configurable[] configurableArray = colorAndFontOptions.buildConfigurables();
            try {
                Configurable[] configurableArray2 = colorAndFontOptions.findPage(string);
                SearchableConfigurable searchableConfigurable = colorAndFontOptions.findSubConfigurable(GeneralColorsPage.class);
                if (searchableConfigurable != null && configurableArray2 != null) {
                    LineData lineData = this.this$0.getLineData(this.b);
                    ShowSettingsUtil.getInstance().editConfigurable(this.a.getProject(), (Configurable)searchableConfigurable, () -> EditCoverageColorsAction.a((NewColorAndFontPanel)configurableArray2, lineData));
                }
            }
            finally {
                for (Configurable configurable : configurableArray) {
                    configurable.disposeUIResources();
                }
                colorAndFontOptions.disposeUIResources();
            }
        }

        private static /* synthetic */ void a(NewColorAndFontPanel newColorAndFontPanel, LineData lineData) {
            newColorAndFontPanel.selectOptionByType(CoverageLineMarkerRenderer.a(lineData).getExternalName());
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x65F55600E20CL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class BaseGotoCoveredLineAction
    extends AnAction {
        private final Editor a;
        private final int b;
        private static final long c = com.jetbrains.python.psi.c.a(1031015111542224444L, -1628373651601455437L, MethodHandles.lookup().lookupClass()).a(55783416663882L);

        BaseGotoCoveredLineAction(Editor editor2, int lineNumber) {
            this.a = editor2;
            this.b = lineNumber;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            Integer n2;
            if (e10 == null) {
                BaseGotoCoveredLineAction.a(0);
            }
            if ((n2 = this.a()) != null) {
                CoverageLineMarkerRenderer.this.moveToLine(n2, this.a);
            }
        }

        protected abstract int next(int var1, int var2);

        @Nullable
        private Integer a() {
            Integer n2;
            block3: {
                int n3;
                ArrayList arrayList = new ArrayList(CoverageLineMarkerRenderer.this.c.keySet());
                Collections.sort(arrayList);
                int n4 = arrayList.size();
                LineData lineData = CoverageLineMarkerRenderer.this.getLineData(this.b);
                int n5 = lineData != null ? lineData.getStatus() : 0;
                int n6 = arrayList.indexOf(CoverageLineMarkerRenderer.this.a != null ? (Integer)CoverageLineMarkerRenderer.this.a.fun((Object)this.b) : this.b);
                if (n6 < 0) {
                    return null;
                }
                while (true) {
                    int n7;
                    Integer n8;
                    if ((n8 = (Integer)arrayList.get(n7 = this.next(n6, n4))) == this.b) {
                        return null;
                    }
                    LineData lineData2 = CoverageLineMarkerRenderer.this.getLineData(n8);
                    n6 = n7;
                    if (lineData2 == null || lineData2.getStatus() == n5) continue;
                    n2 = (Integer)arrayList.get(n6);
                    if (CoverageLineMarkerRenderer.this.e == null) break block3;
                    n3 = (Integer)CoverageLineMarkerRenderer.this.e.fun((Object)n2);
                    if (n3 != 0) break;
                }
                return n3;
            }
            return n2;
        }

        @Nullable
        protected String getNextChange() {
            LineData lineData;
            long l2 = c ^ 0x443DF276EFA6L;
            Integer n2 = this.a();
            if (n2 != null && (lineData = CoverageLineMarkerRenderer.this.getLineData(n2)) != null) {
                switch (lineData.getStatus()) {
                    case 0: {
                        return "Uncovered";
                    }
                    case 1: {
                        return "Partial Covered";
                    }
                    case 2: {
                        return "Fully Covered";
                    }
                }
            }
            return null;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                BaseGotoCoveredLineAction.a(1);
            }
            e10.getPresentation().setEnabled(this.a() != null);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x506F7271A14AL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$BaseGotoCoveredLineAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GotoNextCoveredLineAction
    extends BaseGotoCoveredLineAction {
        final /* synthetic */ CoverageLineMarkerRenderer this$0;
        private static final long d = com.jetbrains.python.psi.c.a(2750743941123752611L, 6627565826423886789L, MethodHandles.lookup().lookupClass()).a(90417454761595L);

        GotoNextCoveredLineAction(CoverageLineMarkerRenderer coverageLineMarkerRenderer, Editor editor2, int lineNumber) {
            long l2 = d ^ 0x4B6F154DFA09L;
            this.this$0 = coverageLineMarkerRenderer;
            super(editor2, lineNumber);
            this.copyFrom(ActionManager.getInstance().getAction("NextOccurence"));
            this.getTemplatePresentation().setText("Next Coverage Mark");
        }

        @Override
        protected int next(int idx, int size) {
            if (idx == size - 1) {
                return 0;
            }
            return idx + 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e10) {
            long l2 = d ^ 0x4C2E8890FAB6L;
            if (e10 == null) {
                GotoNextCoveredLineAction.b(0);
            }
            super.update(e10);
            String string = this.getNextChange();
            if (string != null) {
                e10.getPresentation().setText("Next " + string);
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = d ^ 0x50A1982A011DL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoNextCoveredLineAction", "update"));
        }
    }

    private class GotoPreviousCoveredLineAction
    extends BaseGotoCoveredLineAction {
        final /* synthetic */ CoverageLineMarkerRenderer this$0;
        private static final long d = com.jetbrains.python.psi.c.a(4705696342294247588L, -6744689944005185415L, MethodHandles.lookup().lookupClass()).a(41145992645407L);

        GotoPreviousCoveredLineAction(CoverageLineMarkerRenderer coverageLineMarkerRenderer, Editor editor2, int lineNumber) {
            long l2 = d ^ 0x7CD7D721CD35L;
            this.this$0 = coverageLineMarkerRenderer;
            super(editor2, lineNumber);
            ActionUtil.copyFrom((AnAction)this, (String)"PreviousOccurence");
            this.getTemplatePresentation().setText("Previous Coverage Mark");
        }

        @Override
        protected int next(int idx, int size) {
            if (idx <= 0) {
                return size - 1;
            }
            return idx - 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e10) {
            long l2 = d ^ 0x5F7555DFD4A9L;
            if (e10 == null) {
                GotoPreviousCoveredLineAction.b(0);
            }
            super.update(e10);
            String string = this.getNextChange();
            if (string != null) {
                e10.getPresentation().setText("Previous " + string);
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = d ^ 0x2DFD0AA0FC37L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoPreviousCoveredLineAction", "update"));
        }
    }
}

