/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesPresentationCache;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.ExportHTMLAction;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.impl.SelectInEditorHandler;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesForm
implements Disposable {
    private final JLabel h;
    private final JLabel j;
    private final JPanel b;
    @NonNls
    private static final String l = "DuplicatesForm.SendToLeft";
    @NonNls
    private static final String c = "DuplicatesForm.SendToRight";
    @NonNls
    private static final String i = "find.locateDuplicates.result";
    private final JBSplitter m;
    private final Tree n;
    private final MyDuplicatesModelListener d;
    private final DupInfo o;
    private final Map<DuplicatesPresentation, DuplicatesView> e;
    private final Map<Editor, List<RangeHighlighter>> p;
    private final HighlightManager q;
    private DuplicatesModel f;
    private final Project r;
    private static final DataKey<DuplicatesModel> a;
    private static final String s = "DuplicatesForm.settings.scrollToSource";
    private final MyGlassPanePainter k;
    private static DupInfo g;
    private static final long t;

    private DuplicatesForm(Project project, DupInfo dupInfo) {
        long l2 = t ^ 0x484C4BD90911L;
        this.h = new JLabel(AllIcons.Duplicates.SendToTheLeft);
        this.j = new JLabel(AllIcons.Duplicates.SendToTheRight);
        this.b = new JPanel(new BorderLayout());
        this.n = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.d = new MyDuplicatesModelListener();
        this.e = new HashMap<DuplicatesPresentation, DuplicatesView>();
        this.p = new HashMap<Editor, List<RangeHighlighter>>();
        this.k = new MyGlassPanePainter();
        this.r = project;
        this.o = dupInfo;
        this.q = HighlightManager.getInstance((Project)this.r);
        DataProvider dataProvider = string -> {
            long l2 = t ^ 0x1FB070F81D36L;
            if (PlatformDataKeys.HELP_ID.is(string)) {
                return i;
            }
            if (a.is(string)) {
                return this.f;
            }
            if (this.f == null) {
                return null;
            }
            if (CommonDataKeys.NAVIGATABLE.getName().equals(string)) {
                CodeNode codeNode = this.f.getSelectedCodeNode();
                return codeNode != null ? codeNode.getOpenFileDescriptorIfValid() : null;
            }
            return null;
        };
        this.m = new MySplitter(dataProvider);
        this.m.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.n));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.n);
        SelectInEditorHandler.installKeyListener((JComponent)this.n);
        this.c();
        this.n.setShowsRootHandles(true);
        this.n.setRootVisible(false);
        final MyColoredTreeCellRenderer myColoredTreeCellRenderer = new MyColoredTreeCellRenderer();
        this.n.setCellRenderer((TreeCellRenderer)myColoredTreeCellRenderer);
        PopupHandler.installUnknownPopupHandler((JComponent)this.n, (ActionGroup)DuplicatesForm.a(this.getComponent()), (ActionManager)ActionManager.getInstance());
        this.n.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                int n2 = DuplicatesForm.this.n.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0) {
                    Rectangle rectangle = DuplicatesForm.this.n.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    if (!DuplicatesForm.this.a(e10, rectangle.getLocation(), DuplicatesForm.this.h, 0)) {
                        DuplicatesForm.this.a(e10, new Point(rectangle.x + DuplicatesForm.this.h.getWidth(), rectangle.y), DuplicatesForm.this.j, 1);
                    }
                }
            }
        });
        this.b.add((Component)this.h, "West");
        this.b.add((Component)this.j, "East");
        this.b.setBackground(UIUtil.getTreeBackground());
        IdeGlassPaneUtil.installPainter((JComponent)this.n, (Painter)this.k, (Disposable)this);
        this.n.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e10) {
                Object object;
                int n2 = DuplicatesForm.this.n.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0 && (object = DuplicatesForm.this.n.getPathForRow(n2).getLastPathComponent()) instanceof CodeNode) {
                    Rectangle rectangle = DuplicatesForm.this.n.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    Point point = e10.getPoint();
                    Rectangle rectangle2 = DuplicatesForm.this.h.getBounds();
                    rectangle2.setLocation(rectangle.getLocation());
                    Icon icon = null;
                    if (rectangle2.contains(point)) {
                        icon = AllIcons.Duplicates.SendToTheLeft;
                    } else {
                        rectangle2 = DuplicatesForm.this.j.getBounds();
                        rectangle2.setLocation(new Point(rectangle.x + AllIcons.Duplicates.SendToTheRight.getIconWidth(), rectangle.y));
                        if (rectangle2.contains(point)) {
                            icon = AllIcons.Duplicates.SendToTheRight;
                        }
                    }
                    if (icon != null) {
                        DuplicatesForm.this.k.setPaint(icon, rectangle2.getLocation());
                        return;
                    }
                }
                DuplicatesForm.this.k.setPaint(null, null);
            }
        });
    }

    private void c() {
        final EditSourceOnDoubleClickHandler.TreeMouseListener treeMouseListener = new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.n);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                treeMouseListener.onDoubleClick(e10);
                CodeNode codeNode = DuplicatesForm.this.a();
                if (codeNode != null) {
                    PsiFragment psiFragment = codeNode.getFragment();
                    UsageInfo usageInfo = psiFragment.getUsageInfo();
                    if (usageInfo == null) {
                        return true;
                    }
                    PsiElement[] psiElementArray = psiFragment.getElements();
                    assert (psiElementArray.length > 0);
                    PsiElement psiElement = psiElementArray[0];
                    OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(DuplicatesForm.this.r, usageInfo.getVirtualFile(), psiElement.getTextOffset());
                    Editor editor2 = FileEditorManager.getInstance((Project)DuplicatesForm.this.r).openTextEditor(openFileDescriptor, false);
                    if (editor2 != null) {
                        List list2 = (List)DuplicatesForm.this.p.get(editor2);
                        if (list2 != null) {
                            for (RangeHighlighter rangeHighlighter : list2) {
                                DuplicatesForm.this.q.removeSegmentHighlighter(editor2, rangeHighlighter);
                            }
                        }
                        List<RangeHighlighter> list3 = DuplicatesForm.highlightPsiFragment(editor2, psiFragment, DuplicatesForm.this.q, 0);
                        DuplicatesForm.this.p.put(editor2, list3);
                    }
                }
                return true;
            }
        }.installOn((Component)this.n);
    }

    private boolean a(MouseEvent mouseEvent, Point point, JLabel jLabel, int n2) {
        Point point2 = mouseEvent.getPoint();
        Rectangle rectangle = jLabel.getBounds();
        rectangle.setLocation(point);
        CodeNode codeNode = this.f.getSelectedCodeNode();
        if (codeNode != null && rectangle.contains(point2)) {
            this.f.setDiff(n2, codeNode);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public JTree getDuplicatesTree() {
        return this.n;
    }

    private static DefaultActionGroup a(JComponent jComponent) {
        long l2 = t ^ 0x734F66B3995FL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        defaultActionGroup.add(actionManager.getAction("EditSource"));
        defaultActionGroup.add(actionManager.getAction("ViewSource"));
        defaultActionGroup.addSeparator();
        AnAction anAction = actionManager.getAction(l);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        anAction = actionManager.getAction(c);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        return defaultActionGroup;
    }

    public void addToolbarActionsTo(ContentPanel panel) {
        panel.addActionSeparator();
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){
            private static final long a = com.jetbrains.python.psi.c.a(1789439224107294068L, -4581142407751202144L, MethodHandles.lookup().lookupClass()).a(163889459645846L);

            protected boolean isAutoScrollMode() {
                long l2 = a ^ 0x117182058F6DL;
                return PropertiesComponent.getInstance().getBoolean(DuplicatesForm.s);
            }

            protected void setAutoScrollMode(boolean state2) {
                long l2 = a ^ 0x18B19DBC10B3L;
                PropertiesComponent.getInstance().setValue(DuplicatesForm.s, state2);
            }
        };
        autoScrollToSourceHandler.install((JTree)this.n);
        panel.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
        if (DuplicatesForm.b()) {
            panel.addAction(new EliminateDuplicatesAction(this));
        }
        panel.addAction(new ExportHTMLAction(this.f.getRoot()));
    }

    private static boolean b() {
        for (int i10 = 0; i10 < g.getPatterns(); ++i10) {
            DuplicatesPresentation duplicatesPresentation = DuplicatesPresentationCache.getPresentation(g, i10);
            if (duplicatesPresentation == null || !duplicatesPresentation.isFixAbilityProvided()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CodeNode a() {
        BasicTreeNode basicTreeNode;
        CodeNode codeNode = this.f.getSelectedCodeNode();
        if (codeNode != null) {
            return codeNode;
        }
        TreePath treePath = this.n.getSelectionPath();
        if (treePath != null && (basicTreeNode = (BasicTreeNode)treePath.getLastPathComponent()) instanceof GroupNode && basicTreeNode.getChildCount() > 0) {
            return (CodeNode)basicTreeNode.getChildAt(0);
        }
        return null;
    }

    private void a(DuplicatesModel duplicatesModel) {
        if (this.f != null) {
            this.f.removeListener(this.d);
        }
        this.f = duplicatesModel;
        this.n.setModel(duplicatesModel.getTreeModel());
        this.n.setSelectionModel(duplicatesModel.getSelectionModel());
        duplicatesModel.addListener(this.d);
        this.d.a();
    }

    public JComponent getComponent() {
        return this.m;
    }

    public static DuplicatesForm create(Project project, DupInfo duplicates) {
        g = duplicates;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DuplicatesForm duplicatesForm = new DuplicatesForm(project, duplicates);
        DuplicatesModel duplicatesModel = new DuplicatesModel(duplicates, project);
        duplicatesForm.a(duplicatesModel);
        return duplicatesForm;
    }

    public void dispose() {
        for (Editor editor2 : this.p.keySet()) {
            List<RangeHighlighter> list2 = this.p.get(editor2);
            for (RangeHighlighter rangeHighlighter : list2) {
                this.q.removeSegmentHighlighter(editor2, rangeHighlighter);
            }
        }
        DuplicatesProfileCache.clear(this.o);
        DuplicatesPresentationCache.clear(this.o);
    }

    public static List<RangeHighlighter> highlightPsiFragment(Editor editor2, PsiFragment fragment, HighlightManager highlightManager, int firstOffset) {
        PsiElement[] psiElementArray = fragment.getElements();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ArrayList<RangeHighlighter> arrayList = new ArrayList<RangeHighlighter>();
        for (PsiElement psiElement : psiElementArray) {
            if (psiElement == null) continue;
            TextRange textRange = psiElement.getTextRange();
            int n2 = textRange.getStartOffset() - firstOffset;
            int n3 = textRange.getEndOffset() - firstOffset;
            highlightManager.addRangeHighlight(editor2, n2, n3, textAttributes, false, arrayList);
        }
        return arrayList;
    }

    static {
        t = com.jetbrains.python.psi.c.a(3692937518595718887L, 5972809232907006851L, MethodHandles.lookup().lookupClass()).a(198089410421558L);
        long l2 = t ^ 0x66C80D4F6CB7L;
        a = DataKey.create((String)"DUPLICATES_MODEL");
    }

    private class EliminateDuplicatesAction
    extends AnAction {
        final /* synthetic */ DuplicatesForm this$0;
        private static final long a = com.jetbrains.python.psi.c.a(2227450922559445466L, 929184852011449245L, MethodHandles.lookup().lookupClass()).a(178717528224101L);

        EliminateDuplicatesAction(DuplicatesForm duplicatesForm) {
            long l2 = a ^ 0x7C5D1B0924B9L;
            this.this$0 = duplicatesForm;
            super(DupLocatorBundle.message("eliminate.duplicates.action.text", new Object[0]), DupLocatorBundle.message("eliminate.duplicates.action.text", new Object[0]), AllIcons.Actions.Replace);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EliminateDuplicatesAction.a(0);
            }
            CodeNode codeNode = this.this$0.a();
            assert (codeNode != null);
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            assert (duplicatesPresentation != null);
            duplicatesPresentation.applyFix(codeNode);
        }

        public void update(@NotNull AnActionEvent e10) {
            CodeNode codeNode;
            boolean bl2;
            if (e10 == null) {
                EliminateDuplicatesAction.a(1);
            }
            boolean bl3 = bl2 = (codeNode = this.this$0.a()) != null;
            if (bl2) {
                DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
                bl2 = duplicatesPresentation != null && duplicatesPresentation.isFixAvailable(codeNode);
            }
            e10.getPresentation().setEnabled(bl2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x3512DD2E10E3L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGlassPanePainter
    extends AbstractPainter {
        private Icon a;
        private Point b;

        private MyGlassPanePainter() {
        }

        public boolean setPaint(Icon icon, Point point) {
            this.a = (Icon)this.setNeedsRepaint(this.a, icon);
            this.b = (Point)this.setNeedsRepaint(this.b, point);
            return this.needsRepaint();
        }

        public void executePaint(Component component, Graphics2D g10) {
            if (this.a == null) {
                return;
            }
            this.a.paintIcon(component, g10, this.b.x, this.b.y);
        }
    }

    private class MyDuplicatesModelListener
    implements DuplicatesModel.Listener {
        private final Alarm a = new Alarm();

        private MyDuplicatesModelListener() {
        }

        @Override
        public void onSelectionChanged() {
            this.a.cancelAllRequests();
            DuplicatesModel duplicatesModel = DuplicatesForm.this.f;
            this.a.addRequest(() -> {
                if (duplicatesModel == DuplicatesForm.this.f && DuplicatesForm.this.m.isDisplayable()) {
                    this.a();
                }
            }, 200);
        }

        private void a() {
            JComponent jComponent;
            CodeNode codeNode = DuplicatesForm.this.f.getLeft();
            CodeNode codeNode2 = DuplicatesForm.this.f.getRight();
            if (codeNode == null || codeNode2 == null) {
                return;
            }
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            DuplicatesView duplicatesView = null;
            if (duplicatesPresentation != null && (duplicatesView = (DuplicatesView)DuplicatesForm.this.e.get(duplicatesPresentation)) == null) {
                duplicatesView = duplicatesPresentation.createView(DuplicatesForm.this.r);
                Disposer.register((Disposable)DuplicatesForm.this, (Disposable)duplicatesView);
                DuplicatesForm.this.e.put(duplicatesPresentation, duplicatesView);
            }
            JComponent jComponent2 = DuplicatesForm.this.m.getSecondComponent();
            JComponent jComponent3 = jComponent = duplicatesView != null ? duplicatesView.getComponent() : null;
            if (jComponent != jComponent2) {
                if (jComponent2 != null) {
                    jComponent2.setVisible(false);
                }
                DuplicatesForm.this.m.setSecondComponent(jComponent);
                if (jComponent != null) {
                    jComponent.setMinimumSize((Dimension)JBUI.size((int)10));
                    jComponent.setVisible(true);
                }
            }
            if (duplicatesView != null) {
                duplicatesView.setContent(codeNode, codeNode2);
            }
            DuplicatesForm.this.n.repaint();
        }
    }

    private static class SendToAction
    extends AnAction {
        private final int a;
        private static final long b = com.jetbrains.python.psi.c.a(-6048323533991537897L, -2393504044803655913L, MethodHandles.lookup().lookupClass()).a(69958186732151L);

        SendToAction(String text2, String description, Icon icon, String actionId, int diffIndex) {
            super(text2, description, icon);
            this.a = diffIndex;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)actionId), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(0);
            }
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(a);
            duplicatesModel.setDiff(this.a, duplicatesModel.getSelectedCodeNode());
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(1);
            }
            Presentation presentation = e10.getPresentation();
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(a);
            if (duplicatesModel == null) {
                presentation.setEnabled(false);
                return;
            }
            CodeNode codeNode = duplicatesModel.getSelectedCodeNode();
            if (codeNode == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x391264F715FFL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySplitter
    extends JBSplitter
    implements DataProvider {
        private final DataProvider a;
        private static final long b = com.jetbrains.python.psi.c.a(3712702367269042010L, -7961418343858253755L, MethodHandles.lookup().lookupClass()).a(227673262377229L);

        MySplitter(DataProvider dataProvider) {
            long l2 = b ^ 0x1D0E3A6D6017L;
            super("DuplicatesForm.settings", 0.3f);
            this.a = dataProvider;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MySplitter.a(0);
            }
            return this.a.getData(dataId);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x48A2F3C0730CL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$MySplitter", "getData"));
        }
    }

    private class MyColoredTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long a = com.jetbrains.python.psi.c.a(-3466142772110173475L, 5086249467011642768L, MethodHandles.lookup().lookupClass()).a(246489477818877L);

        private MyColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long l2 = a ^ 0x257D856B3F67L;
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            Color color = UIUtil.getTreeBackground((boolean)sel, (boolean)true);
            UIUtil.changeBackGround((Component)jPanel, (Color)color);
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setOpaque(true);
            jPanel.add((Component)simpleColoredComponent, "Center");
            if (value instanceof GroupNode) {
                ((GroupNode)value).getTitle(sel).customize(simpleColoredComponent);
            } else if (value instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)value;
                jPanel.add((Component)DuplicatesForm.this.b, "West");
                DuplicatesForm.this.h.setIcon(codeNode.isLeftInDiff() ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
                DuplicatesForm.this.j.setIcon(codeNode.isRightInDiff() ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
                codeNode.getTitle(sel).customize(simpleColoredComponent);
                jPanel.setToolTipText(DupLocatorBundle.message("tooltip.tree.text", new Object[0]));
            }
            return jPanel;
        }
    }

    public static class SendToLeftAction
    extends SendToAction {
        private static final long c = com.jetbrains.python.psi.c.a(-530689874787243244L, 1881476028685920587L, MethodHandles.lookup().lookupClass()).a(62838371829660L);

        public SendToLeftAction() {
            long l2 = c ^ 0x985211C84E3L;
            super(DupLocatorBundle.message("duplicates.send.to.left.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.left.action.description", new Object[0]), AllIcons.Duplicates.SendToTheLeft, DuplicatesForm.l, 0);
        }
    }

    public static class SendToRightAction
    extends SendToAction {
        private static final long c = com.jetbrains.python.psi.c.a(5964969474521469425L, 7882418457588451401L, MethodHandles.lookup().lookupClass()).a(2180583947593L);

        public SendToRightAction() {
            long l2 = c ^ 0x534AB13B44FAL;
            super(DupLocatorBundle.message("duplicates.send.to.right.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.right.action.description", new Object[0]), AllIcons.Duplicates.SendToTheRight, DuplicatesForm.c, 1);
        }
    }
}

