/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.psi.c;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ExportHTMLAction
extends AnAction
implements DumbAware {
    private final GroupNode[] d;
    @NonNls
    private static final String c = "HTML";
    @NonNls
    private static final String b = "XML";
    private final DuplicatesRoot a;
    private static final long e = com.jetbrains.python.psi.c.a(-1798647218362640817L, -2991519659504635075L, MethodHandles.lookup().lookupClass()).a(136898587792153L);

    ExportHTMLAction(DuplicatesRoot root) {
        long l2 = e ^ 0x44BC9F32B13EL;
        super("Export", null, AllIcons.ToolbarDecorator.Export);
        this.d = root.getChildren();
        this.a = root;
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        long l2 = e ^ 0x37E12850570BL;
        if (e10 == null) {
            ExportHTMLAction.a(0);
        }
        final Project project = (Project)e10.getData(CommonDataKeys.PROJECT);
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{c, b}){
            private static final long a = com.jetbrains.python.psi.c.a(-3517895780800432846L, 3328351628136797705L, MethodHandles.lookup().lookupClass()).a(54030573169752L);

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    long l2 = a ^ 0x40675DBED92AL;
                    ExportHTMLAction.this.a(project, Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.c));
                });
            }
        });
        InputEvent inputEvent = e10.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            listPopup.showUnderneathOf(inputEvent.getComponent());
        } else {
            listPopup.showInBestPositionFor(e10.getDataContext());
        }
    }

    private void a(Project project, boolean bl2) {
        long l2 = e ^ 0x43B51633B86CL;
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(project, true);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance((Project)project);
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        String string = exportToHTMLSettings.OUTPUT_DIRECTORY;
        try {
            if (bl2) {
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                for (GroupNode groupNode : this.d) {
                    String string2 = "group" + n2++;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (CodeNode codeNode : groupNode.getChildren()) {
                        ExportHTMLAction.a(project, string, string2, stringBuffer2, codeNode);
                    }
                    String object = string2 + "-index.html";
                    HTMLExportUtil.writeFile((String)string, (String)object, (CharSequence)XmlStringUtil.wrapInHtml((CharSequence)stringBuffer2), (Project)project);
                    stringBuffer.append("<a href=\"").append(StringUtil.escapeXmlEntities((String)object)).append("\" target=\"codeFragmentFrame\">").append(string2).append(" (").append(groupNode.getTitle(false).getText()).append(")").append("</a>").append("<br>");
                }
                HTMLExportUtil.writeFile((String)string, (String)"groupIndex.html", (CharSequence)XmlStringUtil.wrapInHtml((CharSequence)stringBuffer), (Project)project);
                ExportHTMLAction.a(project, string);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(string, "index.html"));
                }
            } else {
                DuplocatorHashCallback.writeDuplicates(string, project, this.a.getDuplicates());
            }
        }
        catch (Exception exception) {
            Messages.showErrorDialog((Project)project, (String)exception.getMessage(), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void a(Project project, String string, String string2, StringBuffer stringBuffer, CodeNode codeNode) throws InvalidatedException {
        long l2 = e ^ 0x765FAEABBB91L;
        PsiFragment psiFragment = codeNode.getFragment();
        VirtualFile virtualFile = codeNode.getVirtualFile();
        TextRange textRange = codeNode.getTextRange();
        PsiFile psiFile = psiFragment.getFile();
        if (psiFile == null) {
            return;
        }
        String string3 = psiFile.getText().substring(textRange.getStartOffset(), textRange.getEndOffset());
        String string4 = string2 + "/" + virtualFile.getNameWithoutExtension() + psiFragment.getStartOffset() + ".html";
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<head><h4>");
        stringBuffer2.append(codeNode.getTitle(false).getText());
        stringBuffer2.append("</h4></head>");
        stringBuffer2.append("<body>");
        stringBuffer2.append(StringUtil.escapeXmlEntities((String)string3).replace("\n", "<br>"));
        stringBuffer2.append("</body>");
        HTMLExportUtil.writeFile((String)string, (String)string4, (CharSequence)XmlStringUtil.wrapInHtml((CharSequence)stringBuffer2), (Project)project);
        stringBuffer.append("<a href=\"").append(StringUtil.escapeXmlEntities((String)string4)).append("\" target=\"elementFrame\">").append(virtualFile.getPath()).append("</a>").append("<br>");
    }

    private static void a(Project project, String string) {
        long l2 = e ^ 0x2D3D701A72BEL;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML><HEAD><TITLE>");
        stringBuffer.append(ApplicationNamesInfo.getInstance().getFullProductName());
        stringBuffer.append("Locate Duplicates result");
        stringBuffer.append("</TITLE></HEAD>");
        stringBuffer.append("<FRAMESET cols=\"30%,70%\">");
        stringBuffer.append("  <FRAMESET rows=\"30%,70%\">");
        stringBuffer.append("    <FRAME src=\"groupIndex.html\" name=\"groupFrame\">");
        stringBuffer.append("    <FRAME src=\"group0-index.html\" name=\"codeFragmentFrame\">");
        stringBuffer.append("  </FRAMESET>");
        stringBuffer.append("  <FRAME src=\"empty.html\" name=\"elementFrame\">");
        stringBuffer.append("</FRAMESET></BODY></HTML");
        HTMLExportUtil.writeFile((String)string, (String)"index.html", (CharSequence)stringBuffer, (Project)project);
        HTMLExportUtil.writeFile((String)string, (String)"empty.html", (CharSequence)new StringBuffer(), (Project)project);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = e ^ 0x3026C0BEB9E4L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dupLocator/resultUI/ExportHTMLAction", "actionPerformed"));
    }
}

