/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JComponent;

class GraphBuilderEventHelper
implements MouseMotionListener,
KeyListener,
MouseWheelListener,
FocusListener {
    final EventDispatcher<GraphBuilderListener> dispatcher = EventDispatcher.create(GraphBuilderListener.class);
    private final Graph2DView c;
    private final EditMode h;
    private final ViewMode g = new NavigationMode();
    private final MagnifierViewMode a = new MagnifierViewMode();
    private volatile boolean b = false;
    private volatile boolean e = false;
    private final GraphBuilder d;
    private boolean f = false;

    GraphBuilderEventHelper(EditMode mode, GraphBuilder builder) {
        this.d = builder;
        this.c = builder.getView();
        this.h = mode;
        this.a.setMagnifierRadius(150);
        JComponent jComponent = this.c.getCanvasComponent();
        jComponent.addMouseMotionListener(this);
        jComponent.addKeyListener(this);
        jComponent.addMouseWheelListener(this);
        jComponent.addFocusListener(this);
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                if (e10.isPopupTrigger() && GraphBuilderEventHelper.this.b) {
                    GraphBuilderEventHelper.this.h.mousePressed(e10);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e10) {
                if (GraphBuilderEventHelper.this.f) {
                    GraphBuilderEventHelper.this.f = false;
                    GraphBuilderEventHelper.this.fireEvent(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    @Override
    public void mouseDragged(MouseEvent e10) {
        if (e10.isControlDown() && !e10.isAltDown()) {
            this.c();
        } else if (e10.isAltDown() && !e10.isControlDown()) {
            this.a();
        } else {
            if (!this.f) {
                this.f = true;
                this.fireEvent(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.b();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e10) {
        if (!e10.isAltDown() && this.e || !e10.isControlDown() && this.b) {
            this.b();
        }
    }

    @Override
    public void keyTyped(KeyEvent e10) {
    }

    @Override
    public void keyPressed(KeyEvent e10) {
        int n2 = e10.getKeyCode();
        boolean bl2 = e10.isAltDown();
        boolean bl3 = e10.isControlDown();
        if (bl3 && GraphBuilderEventHelper.b(n2)) {
            this.a(n2);
        } else if (n2 == 17 && !bl2) {
            this.c();
        } else if (n2 == 18 && !bl3) {
            this.a();
        } else {
            this.b();
        }
    }

    private void a(int n2) {
        Graph2D graph2D = this.c.getGraph2D();
        List list2 = GraphViewUtil.getSelectedNodes((Graph2D)graph2D);
        if (list2.size() > 0) {
            this.fireEvent(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node : list2) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(3 * (n2 == 37 ? -1 : (n2 == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(3 * (n2 == 38 ? -1 : (n2 == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.fireEvent(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean b(int n2) {
        return n2 == 37 || n2 == 39 || n2 == 40 || n2 == 38;
    }

    private synchronized void c() {
        if (!this.b) {
            this.c.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.h.setEditing(false);
            this.h.reactivateParent();
            this.b = true;
            this.c.removeViewMode((ViewMode)(this.e ? this.a : this.h));
            this.e = false;
            this.c.addViewMode(this.g);
        }
    }

    private synchronized void a() {
        if (!this.e) {
            this.e = true;
            double d10 = this.c.getZoom();
            d10 = d10 < 1.0 ? 1.5 / d10 : 2.0 * d10;
            this.a.setMagnifierZoomFactor(d10);
            this.c.removeViewMode((ViewMode)(this.b ? this.g : this.h));
            this.b = false;
            this.c.addViewMode((ViewMode)this.a);
        }
    }

    private synchronized void b() {
        if (this.b) {
            this.fireEvent(GraphBuilderEvent.GRAPH_MOVED, false);
            this.b = false;
            this.c.removeViewMode(this.g);
            this.c.addViewMode((ViewMode)this.h);
        } else if (this.e) {
            this.e = false;
            this.c.removeViewMode((ViewMode)this.a);
            this.c.updateView();
            this.c.addViewMode((ViewMode)this.h);
        }
    }

    @Override
    public void keyReleased(KeyEvent e10) {
        if (e10.getKeyCode() == 17 || e10.getKeyCode() == 18) {
            this.b();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e10) {
        int n2 = e10.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        if (e10.isControlDown()) {
            double d10 = this.c.getZoom() - (double)n2 * 0.1;
            Magnificator magnificator = (Magnificator)ComponentUtil.getParentOfType(Magnificator.class, (Component)this.c.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(d10 / this.c.getZoom(), e10.getPoint());
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e10) {
    }

    @Override
    public void focusLost(FocusEvent e10) {
        this.b();
    }

    public void fireEvent(GraphBuilderEvent event, boolean before) {
        if (before) {
            ((GraphBuilderListener)this.dispatcher.getMulticaster()).beforeActionPerformed(this.d, event);
        } else {
            ((GraphBuilderListener)this.dispatcher.getMulticaster()).actionPerformed(this.d, event);
        }
    }
}

