/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.SSHUtil;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshRemoteHostIdentificationHasChangedException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSyncUtil {
    private static final Logger b;
    public static final String RSYNC = "rsync";
    public static final String RSYNC_OPTIONS = "-zarv";
    public static final String RSYNC_SSH_PORT_OPTION = "-e";
    public static final String RSYNC_PORT_OPTION = "-p %s";
    public static final String RSYNC_PUBLIC_KEY_OPTION = "-i %s";
    public static final String RSYNC_SSH_OPTIONS = "ssh %s %s";
    private static final String a = "--log-file=%s";
    public static final int CHECK_CANCELLED_TIMEOUT = 200;
    public static final NotificationGroup NOTIFICATION_GROUP;
    private static final long c;

    private static boolean a() {
        return RSyncUtil.b();
    }

    @NotNull
    public static List<String> externalToolSuggestion() {
        long l2 = c ^ 0x3C2AC761D01AL;
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync")) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RSyncUtil.a(0);
            }
            return list2;
        }
        if (!PlatformUtils.isRubyMine()) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                RSyncUtil.a(1);
            }
            return list3;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!RSyncUtil.a()) {
            arrayList.add(RSYNC);
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RSyncUtil.a(2);
        }
        return arrayList2;
    }

    public static boolean canUseRSync() {
        long l2 = c ^ 0x3C70F5E45115L;
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync") || SystemInfo.isWindows && !Registry.is((String)"ide.remote.interpreters.rsync.enabled.on.windows")) {
            return false;
        }
        return RSyncUtil.a();
    }

    private static boolean b() {
        long l2 = c ^ 0x4CD8B2DF6ECEL;
        try {
            File file = PathEnvironmentVariableUtil.findInPath((String)RSYNC);
            if (file == null) {
                return false;
            }
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{file.getAbsolutePath(), "--version"});
            String string = ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)generalCommandLine);
            String string2 = string.split("\n")[0];
            if (string2.matches(".*command not found.*")) {
                b.info("rsync not found");
                return false;
            }
            b.info("rsync version: " + string2);
        }
        catch (ExecutionException executionException) {
            b.error("Error during execution of command rsync");
            return false;
        }
        return true;
    }

    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        String string;
        if (progressIndicator == null) {
            RSyncUtil.a(3);
        }
        if ((string = PathUtilRt.getFileName((String)remotePath)).equals(PathUtilRt.getFileName((String)localPath))) {
            remotePath = remotePath.substring(0, remotePath.length() - string.length());
        }
        Pair<String, String[]> pair = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, null, true);
        RSyncUtil.a((String)pair.first, (String[])pair.second, progressIndicator, credentials);
    }

    public static void downloadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator, @NotNull String logfilePath) throws ExecutionException {
        if (progressIndicator == null) {
            RSyncUtil.a(4);
        }
        if (logfilePath == null) {
            RSyncUtil.a(5);
        }
        if (!remotePath.endsWith(File.separator)) {
            remotePath = remotePath + File.separator;
        }
        FileUtil.createDirectory((File)new File(localPath));
        Pair<String, String[]> pair = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, logfilePath, false);
        RSyncUtil.a((String)pair.first, (String[])pair.second, progressIndicator, credentials);
    }

    public static void download(@NotNull List<? extends PathMappingSettings.PathMapping> pathMappings, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        long l2 = c ^ 0x18F4F27349ACL;
        if (pathMappings == null) {
            RSyncUtil.a(6);
        }
        if (credentials == null) {
            RSyncUtil.a(7);
        }
        if (progressIndicator == null) {
            RSyncUtil.a(8);
        }
        Notification notification2 = null;
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"rsync_download", (String)".log");
            for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
                RSyncUtil.downloadWithRSync(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot(), credentials, progressIndicator, file.getPath());
            }
        }
        catch (IOException iOException) {
        }
        catch (SshRemoteHostIdentificationHasChangedException sshRemoteHostIdentificationHasChangedException) {
            String string = sshRemoteHostIdentificationHasChangedException.getMessage() + "\n" + SshBundle.message("rsync.ssh.remote.host.identification.has.changed.message", new Object[0]);
            notification2 = NOTIFICATION_GROUP.createNotification(string, null, null, NotificationType.ERROR);
        }
        if (notification2 == null) {
            notification2 = NOTIFICATION_GROUP.createNotification(SshBundle.message("rsync.download.complete.title", new Object[0]), null, null, NotificationType.INFORMATION);
            if (file != null) {
                final String string = file.getPath();
                b.debug(SshBundle.message("rsync.download.complete.message", string));
                notification2.addAction((AnAction)new DumbAwareAction("Log file"){
                    private static final long a = com.jetbrains.python.psi.c.a(1376535532169141423L, 7395910943956604288L, MethodHandles.lookup().lookupClass()).a(25588047579729L);

                    public void actionPerformed(@NotNull AnActionEvent e10) {
                        if (e10 == null) {
                            1.a(0);
                        }
                        ShowFilePathAction.openFile((File)new File(string));
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x1F20A0345F8AL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/RSyncUtil$1", "actionPerformed"));
                    }
                });
            }
        }
        notification2.notify(null);
    }

    private static void a(@NotNull String string, String[] stringArray, final @NotNull ProgressIndicator progressIndicator, final @NotNull RemoteCredentials remoteCredentials) throws ExecutionException {
        File file;
        long l2 = c ^ 0x1993E20921B4L;
        if (string == null) {
            RSyncUtil.a(9);
        }
        if (progressIndicator == null) {
            RSyncUtil.a(10);
        }
        if (remoteCredentials == null) {
            RSyncUtil.a(11);
        }
        if ((file = PathEnvironmentVariableUtil.findInPath((String)string)) == null) {
            return;
        }
        PtyCommandLine ptyCommandLine = new PtyCommandLine().withConsoleMode(false);
        ptyCommandLine.setExePath(file.getPath());
        ptyCommandLine.addParameters(stringArray);
        final OSProcessHandler oSProcessHandler = new OSProcessHandler((GeneralCommandLine)ptyCommandLine);
        assert (oSProcessHandler.getProcessInput() != null);
        final PrintWriter printWriter = new PrintWriter(oSProcessHandler.getProcessInput());
        final Ref ref = new Ref();
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(-5459670917828287735L, -7452630679900897256L, MethodHandles.lookup().lookupClass()).a(188958835690213L);

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                long l2 = a ^ 0x3511EB0722B2L;
                if (event == null) {
                    2.a(0);
                }
                if (outputType == null) {
                    2.a(1);
                }
                try {
                    progressIndicator.checkCanceled();
                }
                catch (ProcessCanceledException processCanceledException) {
                    oSProcessHandler.destroyProcess();
                }
                String string = event.getText();
                if (string == null) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    if (string.contains(File.separator)) {
                        progressIndicator.setText(string);
                    }
                } else if (outputType == ProcessOutputTypes.STDERR && !string.contains("No such file or directory")) {
                    b.info(string);
                }
                if (SSHUtil.PASSPHRASE_PROMPT.matcher(string).matches()) {
                    this.a(remoteCredentials.getPassphrase());
                } else if (string.toLowerCase(Locale.getDefault()).contains("remote host identification has changed")) {
                    ref.set((Object)new SshRemoteHostIdentificationHasChangedException());
                    oSProcessHandler.destroyProcess();
                } else if (string.trim().toLowerCase(Locale.getDefault()).endsWith("password:")) {
                    String string2 = remoteCredentials.getPassword() != null ? remoteCredentials.getPassword() : remoteCredentials.getUserName();
                    this.a(string2);
                } else if (string.contains("Are you sure you want to continue connecting")) {
                    this.a("yes");
                }
            }

            private void a(String string) {
                printWriter.println(string != null ? string : "");
                printWriter.flush();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x51A9D9999B0CL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/RSyncUtil$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        oSProcessHandler.startNotify();
        while (!oSProcessHandler.waitFor(200L)) {
            if (progressIndicator.isCanceled()) {
                oSProcessHandler.destroyProcess();
            }
            progressIndicator.checkCanceled();
        }
        oSProcessHandler.waitFor();
        if (!ref.isNull()) {
            throw (ExecutionException)((Object)ref.get());
        }
        if (!progressIndicator.isCanceled() && oSProcessHandler.getExitCode() != null && oSProcessHandler.getExitCode() != 0) {
            b.warn("RSync exited with code: " + oSProcessHandler.getExitCode() + "\n\t" + ptyCommandLine.getCommandLineString());
        }
    }

    static Pair<String, String[]> getRSyncCommandAndParameters(String localPath, String remotePath, RemoteCredentials credentials, @Nullable String logfilePath, boolean isServerSideModification) {
        String string;
        String string2;
        long l2 = c ^ 0x242A6DFA14DDL;
        String string3 = Ssh.wrapIPv6Address(credentials.getHost());
        String string4 = String.format("%s@%s:%s", credentials.getUserName(), string3, remotePath);
        if (isServerSideModification) {
            string2 = localPath;
            string = string4;
        } else {
            string2 = string4;
            string = localPath;
        }
        String string5 = credentials.getPrivateKeyFile() != null ? String.format(RSYNC_PUBLIC_KEY_OPTION, credentials.getPrivateKeyFile()) : "";
        String string6 = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String string7 = String.format(RSYNC_SSH_OPTIONS, string6, string5);
        String string8 = String.format(a, logfilePath);
        return Pair.create((Object)RSYNC, (Object)new String[]{RSYNC_OPTIONS, RSYNC_SSH_PORT_OPTION, string7, string8, string2, string});
    }

    static {
        c = com.jetbrains.python.psi.c.a(-2266105993391862183L, 6136600626711992210L, MethodHandles.lookup().lookupClass()).a(39711237308807L);
        long l2 = c ^ 0x76F5D672B67BL;
        b = Logger.getInstance(RSyncUtil.class);
        NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)SshBundle.message("notification.group.name", new Object[0]));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x6DABBE60DA84L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/RSyncUtil";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logfilePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "externalToolSuggestion";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/RSyncUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uploadWithRSync";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "downloadWithRSync";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runAndListenBashCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

