/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.find.FindBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.plugin.ui.DirectoryComboBoxWithButtons;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePanel
extends JPanel {
    private static final Condition<ScopeDescriptor> g;
    private final Project f;
    @NotNull
    private SearchScope b;
    private NullableConsumer<? super SearchScope> e;
    Scopes.Type myScopeType;
    final ActionToolbarImpl myToolbar;
    final JPanel myScopeDetailsPanel;
    private final ModulesComboBox a;
    private final DirectoryComboBoxWithButtons c;
    private final ScopeChooserCombo d;
    private static final long h;

    public ScopePanel(@NotNull Project project, Disposable parent) {
        long l2 = h ^ 0x17189CE78043L;
        if (project == null) {
            ScopePanel.a(0);
        }
        super(null);
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.a = new ModulesComboBox();
        this.d = new ScopeChooserCombo();
        this.f = project;
        this.b = GlobalSearchScope.projectScope((Project)this.f);
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        this.a.setModules(Arrays.asList(moduleArray));
        if (moduleArray.length > 0) {
            this.a.setSelectedModule(moduleArray[0]);
        }
        this.a.addItemListener(itemEvent -> this.setScopeFromUI(Scopes.Type.MODULE, false));
        this.a.setMinimumAndPreferredWidth(JBUIScale.scale((int)300));
        this.d.init(project, true, false, (Object)"", g);
        this.d.getComboBox().addItemListener(itemEvent -> this.setScopeFromUI(Scopes.Type.NAMED, false));
        Disposer.register((Disposable)parent, (Disposable)this.d);
        this.c = new DirectoryComboBoxWithButtons(this.f);
        this.c.setCallback(() -> this.setScopeFromUI(Scopes.Type.DIRECTORY, false));
        this.myScopeDetailsPanel.add(Scopes.Type.PROJECT.toString(), new JLabel());
        this.myScopeDetailsPanel.add(Scopes.Type.MODULE.toString(), ScopePanel.a((JComponent)this.a));
        this.myScopeDetailsPanel.add(Scopes.Type.DIRECTORY.toString(), this.c);
        this.myScopeDetailsPanel.add(Scopes.Type.NAMED.toString(), ScopePanel.a((JComponent)this.d));
        this.myScopeDetailsPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)(UIUtil.isUnderDefaultMacTheme() ? 0 : 3)));
        boolean bl2 = !PlatformUtils.isDataGrip();
        DefaultActionGroup defaultActionGroup = bl2 ? new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.project", (Object[])new Object[0]), Scopes.Type.PROJECT), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.module", (Object[])new Object[0]), Scopes.Type.MODULE), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED)}) : new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY)});
        this.myToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("ScopePanel", (ActionGroup)defaultActionGroup, true);
        this.myToolbar.setForceMinimumSize(true);
        this.myToolbar.setLayoutPolicy(0);
        this.setScope(null);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent((Component)this.myToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, 25).addComponent(this.myScopeDetailsPanel));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent((Component)this.myToolbar).addComponent(this.myScopeDetailsPanel));
    }

    private static JComponent a(JComponent jComponent) {
        long l2 = h ^ 0x22B9B28148D5L;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jComponent, "West");
        jPanel.add(Box.createHorizontalGlue(), "Center");
        return jPanel;
    }

    public void setRecentDirectories(@NotNull List<String> recentDirectories) {
        if (recentDirectories == null) {
            ScopePanel.a(1);
        }
        this.c.setRecentDirectories(recentDirectories);
    }

    public void setScope(@Nullable SearchScope selectedScope) {
        long l2 = h ^ 0x62FE0BD6FCA2L;
        if (selectedScope instanceof LocalSearchScope && selectedScope.getDisplayName().startsWith("Hierarchy of ")) {
            selectedScope = null;
        }
        if (selectedScope != null) {
            this.b = selectedScope;
        }
        this.myScopeType = Scopes.getType(this.b);
        if (selectedScope instanceof ModuleWithDependenciesScope) {
            ModuleWithDependenciesScope moduleWithDependenciesScope = (ModuleWithDependenciesScope)selectedScope;
            this.a.setSelectedModule(moduleWithDependenciesScope.getModule());
        } else if (selectedScope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)selectedScope;
            VirtualFile virtualFile = directoryScope.getDirectory();
            this.c.setDirectory(virtualFile);
            this.c.setRecursive(directoryScope.isWithSubdirectories());
        } else if (selectedScope != null && selectedScope != GlobalSearchScope.projectScope((Project)this.f)) {
            this.d.selectItem((Object)selectedScope.getDisplayName());
            SearchScope searchScope = this.d.getSelectedScope();
            this.b = searchScope == null ? GlobalSearchScope.projectScope((Project)this.f) : searchScope;
        }
        this.myToolbar.updateActionsImmediately();
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.myScopeType.toString());
    }

    public void setScopesFromContext() {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
            Editor editor2;
            long l2 = h ^ 0xF09D02F3211L;
            Module module2 = (Module)LangDataKeys.MODULE.getData(dataContext);
            if (module2 != null) {
                this.a.setSelectedModule(module2);
            }
            if ((editor2 = (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext)) != null) {
                Document document = editor2.getDocument();
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile != null) {
                    this.c.setDirectory(virtualFile.getParent());
                }
                this.d.selectItem((Object)IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]));
            } else {
                VirtualFile[] virtualFileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
                if (virtualFileArray != null && virtualFileArray.length > 0) {
                    boolean bl2 = false;
                    for (VirtualFile virtualFile : virtualFileArray) {
                        if (!virtualFile.isDirectory()) continue;
                        this.c.setDirectory(virtualFile);
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        this.d.selectItem((Object)"Selected Files");
                        this.c.setDirectory(virtualFileArray[0].getParent());
                    }
                }
            }
        });
    }

    public void setScopeConsumer(@Nullable NullableConsumer<? super SearchScope> consumer) {
        this.e = consumer;
    }

    @NotNull
    public SearchScope getScope() {
        SearchScope searchScope = this.b;
        if (searchScope == null) {
            ScopePanel.a(2);
        }
        return searchScope;
    }

    void setScopeFromUI(@NotNull Scopes.Type type, boolean requestFocus) {
        if (type == null) {
            ScopePanel.a(3);
        }
        switch (type) {
            case PROJECT: {
                this.b = GlobalSearchScope.projectScope((Project)this.f);
                break;
            }
            case MODULE: {
                Module module2 = this.a.getSelectedModule();
                if (module2 == null) {
                    return;
                }
                this.b = GlobalSearchScope.moduleScope((Module)module2);
                if (!requestFocus) break;
                this.a.requestFocus();
                break;
            }
            case DIRECTORY: {
                VirtualFile virtualFile = this.c.getDirectory();
                if (virtualFile == null) {
                    return;
                }
                this.b = GlobalSearchScopesCore.directoryScope((Project)this.f, (VirtualFile)virtualFile, (boolean)this.c.isRecursive());
                if (!requestFocus) break;
                this.c.getComboBox().requestFocus();
                break;
            }
            case NAMED: {
                SearchScope searchScope = this.d.getSelectedScope();
                Object object = this.b = searchScope == null ? GlobalSearchScope.projectScope((Project)this.f) : searchScope;
                if (!requestFocus) break;
                this.d.requestFocus();
            }
        }
        if (this.e != null) {
            this.e.consume((Object)this.b);
        }
    }

    static {
        h = com.jetbrains.python.psi.c.a(-7346177298172941622L, -7662713019234881368L, MethodHandles.lookup().lookupClass()).a(125880390079556L);
        g = scopeDescriptor -> {
            long l2 = h ^ 0x5E3689A014CFL;
            return IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(scopeDescriptor.getDisplayName()) || !(scopeDescriptor.getScope() instanceof ModuleWithDependenciesScope);
        };
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x3A4DAB4D4A5EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentDirectories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRecentDirectories";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setScopeFromUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class ScopeToggleAction
    extends ToggleAction {
        private final Scopes.Type a;
        private static final long b = com.jetbrains.python.psi.c.a(-884920688938561367L, -5551626205808231721L, MethodHandles.lookup().lookupClass()).a(271250600978737L);

        ScopeToggleAction(@NotNull String text2, Scopes.Type scopeType) {
            if (text2 == null) {
                ScopeToggleAction.a(0);
            }
            if (scopeType == null) {
                ScopeToggleAction.a(1);
            }
            super(text2, null, EmptyIcon.ICON_0);
            this.a = scopeType;
            this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                ScopeToggleAction.a(2);
            }
            return this.a == ScopePanel.this.myScopeType;
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state2) {
            if (e10 == null) {
                ScopeToggleAction.a(3);
            }
            if (state2) {
                ((CardLayout)ScopePanel.this.myScopeDetailsPanel.getLayout()).show(ScopePanel.this.myScopeDetailsPanel, this.a.toString());
                ScopePanel.this.myScopeType = this.a;
                ScopePanel.this.setScopeFromUI(this.a, true);
                ScopePanel.this.myToolbar.updateActionsImmediately();
            }
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x455275E97E9EL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel$ScopeToggleAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

