/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.AdditionalDownloadableLibraryProvider;
import com.intellij.webcore.libraries.ui.download.DefaultDownloadableWebLibrariesSource;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import com.jetbrains.python.psi.c;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadWebLibraryDialog
extends DialogWrapper {
    private JPanel c;
    private JBTable b;
    private JLabel d;
    private DownloadableFileSetDescriptionWithUrl a;
    private static final long e = com.jetbrains.python.psi.c.a(6789278315883975617L, 4906981068741552340L, MethodHandles.lookup().lookupClass()).a(217809672388815L);

    public DownloadWebLibraryDialog(@NotNull Project project, LangScriptingContextProvider provider) {
        long l2 = e ^ 0x7B71479FA5CCL;
        if (project == null) {
            DownloadWebLibraryDialog.a(0);
        }
        super(project);
        this.a();
        this.setTitle("Download Library");
        this.setOKButtonText("Download and Install");
        this.setCancelButtonText("Close");
        this.setOKActionEnabled(false);
        this.b.setSelectionMode(0);
        DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource> defaultComboBoxModel = new DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource>();
        defaultComboBoxModel.addElement(new DefaultDownloadableWebLibrariesSource(project, provider));
        DownloadableWebLibrariesSource downloadableWebLibrariesSource = AdditionalDownloadableLibraryProvider.getLibrary(project);
        if (downloadableWebLibrariesSource != null) {
            this.d.setText(downloadableWebLibrariesSource.toString());
            this.a(project, downloadableWebLibrariesSource, provider);
        }
        this.init();
        TableColumnModel tableColumnModel = this.b.getColumnModel();
        int[] nArray = new int[]{100, 20, 300};
        for (int i10 = 0; i10 < tableColumnModel.getColumnCount(); ++i10) {
            tableColumnModel.getColumn(i10).setPreferredWidth(nArray[i10]);
        }
        new TableSpeedSearch((JTable)this.b).setComparator(new SpeedSearchComparator(true));
        this.b.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                TableModel tableModel = DownloadWebLibraryDialog.this.b.getModel();
                if (tableModel instanceof MyLibraryTableModel) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(true);
                    DownloadWebLibraryDialog.this.a = ((MyLibraryTableModel)tableModel).getDescriptionAt(DownloadWebLibraryDialog.this.b.getSelectedRow());
                }
            }
        });
    }

    private void a(final @NotNull Project project, final @NotNull DownloadableWebLibrariesSource downloadableWebLibrariesSource, final @NotNull LangScriptingContextProvider langScriptingContextProvider) {
        long l2 = e ^ 0x4D8286D4AE4AL;
        if (project == null) {
            DownloadWebLibraryDialog.a(1);
        }
        if (downloadableWebLibrariesSource == null) {
            DownloadWebLibraryDialog.a(2);
        }
        if (langScriptingContextProvider == null) {
            DownloadWebLibraryDialog.a(3);
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Fetching a list of libraries..."}, 1){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setOKActionEnabled(false);
        this.b.setModel((TableModel)defaultTableModel);
        ApplicationManager.getApplication().executeOnPooledThread(() -> downloadableWebLibrariesSource.prepareTableModel(new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl>(){
            private static final long a = com.jetbrains.python.psi.c.a(7947660276162956978L, -3178325469363131409L, MethodHandles.lookup().lookupClass()).a(70903392624493L);

            public void onSuccess(@NotNull List<? extends DownloadableFileSetDescriptionWithUrl> versions) {
                if (versions == null) {
                    3.a(0);
                }
                if (versions.size() > 0) {
                    langScriptingContextProvider.filterExistingLibraries(project, versions);
                    ApplicationManager.getApplication().invokeLater(() -> DownloadWebLibraryDialog.this.b.setModel((TableModel)new MyLibraryTableModel(versions, downloadableWebLibrariesSource.includeVersionColumn())), ModalityState.any());
                }
            }

            public void onError(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    3.a(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    long l2 = a ^ 0x163DB561CB75L;
                    defaultTableModel.setColumnIdentifiers(new Object[]{"Error while fetching list of libraries: " + errorMessage});
                }, ModalityState.any());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x677E8C8AA83CL;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "versions";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccess";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Nullable
    protected String getHelpId() {
        long l2 = e ^ 0x2EE3ABFEB4F7L;
        return "JavaScript.Libraries";
    }

    protected JComponent createCenterPanel() {
        return this.c;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.c;
    }

    @Nullable
    public DownloadableFileSetDescriptionWithUrl getSelection() {
        return this.a;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x46E1E9333E28L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void a() {
        JLabel jLabel;
        JBTable jBTable;
        JPanel jPanel;
        long l2 = e ^ 0x2B3AF5268313L;
        this.c = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.b = jBTable = new JBTable();
        jBTable.setAutoResizeMode(2);
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.d = jLabel = new JLabel();
        jLabel.setText("No libraries available");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.c;
    }

    private static class MyLibraryTableModel
    extends AbstractTableModel {
        private final int e;
        private final int c;
        private final int d;
        private final List<? extends DownloadableFileSetDescriptionWithUrl> b;
        private final boolean a;
        private static final long f = com.jetbrains.python.psi.c.a(-1377201534845118987L, 4925106081984240179L, MethodHandles.lookup().lookupClass()).a(157091859126004L);

        MyLibraryTableModel(List<? extends DownloadableFileSetDescriptionWithUrl> descriptions, boolean includeVersionColumn) {
            this.b = descriptions;
            this.a = includeVersionColumn;
            this.e = 0;
            this.c = this.a ? 1 : -1;
            this.d = this.a ? 2 : 1;
            Collections.sort(this.b, (downloadableFileSetDescription, downloadableFileSetDescription2) -> {
                if (downloadableFileSetDescription.getName().equals(downloadableFileSetDescription2.getName())) {
                    return downloadableFileSetDescription.getVersionString().compareTo(downloadableFileSetDescription2.getVersionString());
                }
                return downloadableFileSetDescription.getName().compareToIgnoreCase(downloadableFileSetDescription2.getName());
            });
        }

        @Override
        public int getRowCount() {
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a ? 3 : 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = this.b.get(rowIndex);
            if (columnIndex == this.e) {
                return downloadableFileSetDescriptionWithUrl.getName();
            }
            if (columnIndex == this.c) {
                return downloadableFileSetDescriptionWithUrl.getVersionString();
            }
            if (columnIndex == this.d) {
                return downloadableFileSetDescriptionWithUrl.getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            long l2 = f ^ 0x454DF1C802ACL;
            if (column == this.e) {
                return "Name";
            }
            if (column == this.c) {
                return "Version";
            }
            if (column == this.d) {
                return "URL";
            }
            return "";
        }

        @Nullable
        public DownloadableFileSetDescriptionWithUrl getDescriptionAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.b.size()) {
                return null;
            }
            return this.b.get(rowIndex);
        }
    }
}

