/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.modelApi;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoField;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.modelApi.DjangoUrlModel;
import com.jetbrains.django.model.modelApi.NoDjangoModuleException;
import com.jetbrains.django.model.modelApi.NoSuchApplicationException;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoader;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoaderStrategy;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.extensions.ModuleExtKt;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoModelApi {
    public static final String PACKAGE_NAME = "Django";
    @NotNull
    private final PsiDirectory d;
    @NotNull
    private final Module a;
    @NotNull
    private final VirtualFile c;
    @NotNull
    private final VirtualFile b;
    private static final long e = com.jetbrains.python.psi.c.a(2078108153389273937L, 45092493289721386L, MethodHandles.lookup().lookupClass()).a(126674384960779L);

    public DjangoModelApi(@NotNull Module djangoModule) throws NoDjangoModuleException {
        long l2 = e ^ 0x37FBDAB47D36L;
        if (djangoModule == null) {
            DjangoModelApi.a(0);
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(djangoModule);
        if (djangoFacet == null) {
            throw new NoDjangoModuleException("Facet not found in module " + djangoModule);
        }
        VirtualFile virtualFile = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile();
        if (virtualFile == null) {
            throw new NoDjangoModuleException("Root not found in module " + djangoModule);
        }
        this.b = virtualFile;
        PsiManager psiManager = PsiManager.getInstance((Project)djangoModule.getProject());
        VirtualFile virtualFile2 = DjangoUtil.getSettingsFile(djangoFacet);
        if (virtualFile2 == null) {
            throw new NoDjangoModuleException("Settings file not found in module " + djangoModule);
        }
        this.c = virtualFile2;
        VirtualFile virtualFile3 = this.c.getParent();
        if (virtualFile3 == null) {
            throw new NoDjangoModuleException("WebSite virtual folder not found in module " + djangoModule);
        }
        PsiDirectory psiDirectory = psiManager.findDirectory(virtualFile3);
        if (psiDirectory == null) {
            throw new NoDjangoModuleException("WebSite directory not found in module " + djangoModule);
        }
        this.d = psiDirectory;
        this.a = djangoModule;
    }

    public DjangoModelApi(@NotNull PyElement djangoElement) throws NoDjangoModuleException {
        if (djangoElement == null) {
            DjangoModelApi.a(1);
        }
        this(DjangoModelApi.a(djangoElement));
    }

    public boolean isDjangoPackageMatches(@NotNull PyRequirement requirement, boolean defaultValue) {
        Boolean bl2;
        if (requirement == null) {
            DjangoModelApi.a(2);
        }
        return (bl2 = this.isDjangoPackageMatches(requirement)) != null ? bl2 : defaultValue;
    }

    @Nullable
    public Boolean isDjangoPackageMatches(@NotNull PyRequirement requirement) {
        PyPackage pyPackage;
        if (requirement == null) {
            DjangoModelApi.a(3);
        }
        if ((pyPackage = this.getDjangoPackage()) == null) {
            return null;
        }
        return pyPackage.matches(requirement);
    }

    @NotNull
    private static Module a(@NotNull PyElement pyElement) throws NoDjangoModuleException {
        Module module2;
        long l2 = e ^ 0x6481F8758F06L;
        if (pyElement == null) {
            DjangoModelApi.a(4);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)pyElement)) == null) {
            throw new NoDjangoModuleException("No module found for element " + pyElement);
        }
        Module module3 = module2;
        if (module3 == null) {
            DjangoModelApi.a(5);
        }
        return module3;
    }

    @Deprecated
    public DjangoModelApi(@NotNull Project djangoProject) throws NoDjangoModuleException {
        if (djangoProject == null) {
            DjangoModelApi.a(6);
        }
        this(DjangoModelApi.a(djangoProject));
    }

    @NotNull
    public List<DjangoUrlModel> getRootUrls() {
        PyFile pyFile = this.getURLConfFile();
        if (pyFile == null) {
            List<DjangoUrlModel> list2 = Collections.emptyList();
            if (list2 == null) {
                DjangoModelApi.a(7);
            }
            return list2;
        }
        List<DjangoUrlModel> list3 = DjangoUrlModel.getUrlsByFile(pyFile);
        if (list3 == null) {
            DjangoModelApi.a(8);
        }
        return list3;
    }

    @NotNull
    public List<DjangoModelClass> getModelClasses(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoModelApi.a(9);
        }
        ArrayList<DjangoModelClass> arrayList = new ArrayList<DjangoModelClass>();
        for (DjangoApplicationModel djangoApplicationModel : this.getApplications()) {
            arrayList.addAll(djangoApplicationModel.getModelClasses(context));
        }
        ArrayList<DjangoModelClass> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DjangoModelApi.a(10);
        }
        return arrayList2;
    }

    @NotNull
    public List<DjangoApplicationModel> getApplications() {
        ArrayList<DjangoApplicationModel> arrayList = new ArrayList<DjangoApplicationModel>();
        for (String string : DjangoSettingsPy.getInstalledApps(this.a)) {
            try {
                arrayList.add(new DjangoApplicationModel(string, this.a, this.b));
            }
            catch (NoSuchApplicationException noSuchApplicationException) {}
        }
        ArrayList<DjangoApplicationModel> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DjangoModelApi.a(11);
        }
        return arrayList2;
    }

    @NotNull
    public List<Pair<VirtualFile, Class<?>>> getTemplateFolders() {
        ArrayList arrayList = new ArrayList();
        for (DjangoTemplateLoader djangoTemplateLoader : DjangoTemplateLoaderStrategy.getLoaders(this)) {
            for (VirtualFile virtualFile : djangoTemplateLoader.getTemplateFolders(this)) {
                arrayList.add(Pair.create((Object)virtualFile, djangoTemplateLoader.getClass()));
            }
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            DjangoModelApi.a(12);
        }
        return arrayList2;
    }

    @NotNull
    public Module getDjangoModule() {
        Module module2 = this.a;
        if (module2 == null) {
            DjangoModelApi.a(13);
        }
        return module2;
    }

    @Nullable
    public List<String> getDjangoVersionParts() {
        PyPackage pyPackage = this.getDjangoPackage();
        if (pyPackage == null) {
            return null;
        }
        return DjangoUtil.getDjangoVersionParts(pyPackage);
    }

    @Nullable
    public PyPackage getDjangoPackage() {
        long l2 = e ^ 0x4FC06C0C9101L;
        Sdk sdk = ModuleExtKt.getSdk(this.a);
        if (sdk == null) {
            return null;
        }
        List<PyPackage> list2 = PyPackageManager.getInstance(sdk).getPackages();
        if (list2 == null) {
            return null;
        }
        return PyPackageUtil.findPackage(list2, PACKAGE_NAME);
    }

    @NotNull
    private static Module a(@NotNull Project project) throws NoDjangoModuleException {
        Module module2;
        long l2 = e ^ 0x22CD4DC02F0CL;
        if (project == null) {
            DjangoModelApi.a(14);
        }
        if ((module2 = DjangoUtil.getDjangoModule(project)) == null) {
            throw new NoDjangoModuleException("No module found for project " + project);
        }
        Module module3 = module2;
        if (module3 == null) {
            DjangoModelApi.a(15);
        }
        return module3;
    }

    @NotNull
    public VirtualFile getSettingsFile() {
        VirtualFile virtualFile = this.c;
        if (virtualFile == null) {
            DjangoModelApi.a(16);
        }
        return virtualFile;
    }

    @Nullable
    public PyFile getURLConfFile() {
        long l2 = e ^ 0x10F16F393D3FL;
        PsiFile psiFile = null;
        String string = DjangoSettingsPy.getRootUrlconf(this.a);
        if (string != null) {
            psiFile = DjangoPsiUtil.findFileInRoots(string, (PsiElement)this.d);
        }
        if (psiFile == null) {
            psiFile = this.d.findFile("urls.py");
        }
        return PyUtil.as(psiFile, PyFile.class);
    }

    @Nullable
    public static DjangoModelApi create(@NotNull Module module2) {
        if (module2 == null) {
            DjangoModelApi.a(17);
        }
        try {
            return new DjangoModelApi(module2);
        }
        catch (NoDjangoModuleException noDjangoModuleException) {
            return null;
        }
    }

    @Nullable
    public static DjangoModelApi create(@NotNull PyElement element) {
        if (element == null) {
            DjangoModelApi.a(18);
        }
        try {
            return new DjangoModelApi(element);
        }
        catch (NoDjangoModuleException noDjangoModuleException) {
            return null;
        }
    }

    public static boolean notDjangoModule(@NotNull PsiElement element) {
        Module module2;
        if (element == null) {
            DjangoModelApi.a(19);
        }
        return (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && !DjangoFacet.isPresent(module2);
    }

    public final void collectAllUrlsFromCache(@NotNull Set<? super PyFile> files2) {
        long l2 = e ^ 0x77722232A5A8L;
        if (files2 == null) {
            DjangoModelApi.a(20);
        }
        Project project = this.a.getProject();
        Collection collection = StubIndex.getElements(PyVariableNameIndex.KEY, (Object)"urlpatterns", (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project), PyTargetExpression.class);
        for (PyTargetExpression pyTargetExpression : collection) {
            PsiFile psiFile = pyTargetExpression.getContainingFile();
            if (!(psiFile instanceof PyFile)) continue;
            files2.add((PyFile)psiFile);
        }
    }

    @NotNull
    public VirtualFile getDjangoProjectRoot() {
        VirtualFile virtualFile = this.b;
        if (virtualFile == null) {
            DjangoModelApi.a(21);
        }
        return virtualFile;
    }

    @NotNull
    public static List<DjangoField> getFieldsWithTypes(@NotNull TypeEvalContext context, @NotNull PyClass clazz, @NotNull Function<? super PyTargetExpression, ? extends PyType> typeProvider, @NotNull DjangoFQNamesProvider fieldParent) {
        if (context == null) {
            DjangoModelApi.a(22);
        }
        if (clazz == null) {
            DjangoModelApi.a(23);
        }
        if (typeProvider == null) {
            DjangoModelApi.a(24);
        }
        if (fieldParent == null) {
            DjangoModelApi.a(25);
        }
        ArrayList<DjangoField> arrayList = new ArrayList<DjangoField>();
        for (PyTargetExpression pyTargetExpression : clazz.getClassAttributesInherited(context)) {
            PyExpression pyExpression;
            String string = pyTargetExpression.getName();
            if (string == null || (pyExpression = pyTargetExpression.findAssignedValue()) == null) continue;
            PyClassType pyClassType = PyUtil.as(context.getType(pyExpression), PyClassType.class);
            PyType pyType = typeProvider.apply(pyTargetExpression);
            if (pyType != null && pyClassType != null) {
                arrayList.add(new DjangoField(pyTargetExpression, pyType, string, pyClassType));
                continue;
            }
            if (pyClassType == null || !NameResolverTools.isSubclass(pyClassType.getPyClass(), fieldParent, context)) continue;
            arrayList.add(new DjangoField(pyTargetExpression, null, string, pyClassType));
        }
        ArrayList<DjangoField> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DjangoModelApi.a(26);
        }
        return arrayList2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x4AAC38186978L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 26: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModule";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/modelApi/DjangoModelApi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoProject";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProvider";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldParent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/modelApi/DjangoModelApi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleByElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplications";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFolders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDjangoModule";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findDjangoModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDjangoProjectRoot";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsWithTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoPackageMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByElement";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 26: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getModelClasses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDjangoModule";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "notDjangoModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectAllUrlsFromCache";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsWithTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

