/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.util.PythonUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDataflowUtil {
    private static final long a = c.a(6434311781594977984L, 230159259319794571L, MethodHandles.lookup().lookupClass()).a(65867854911836L);

    private PythonDataflowUtil() {
    }

    @Nullable
    public static Set<LookupElement> getDictionaryKeys(PyExpression expr) {
        Set<LookupElement> set;
        if (expr instanceof PyDictLiteralExpression) {
            return PythonUtil.getKeys((PyDictLiteralExpression)expr);
        }
        if (expr instanceof PyCallExpression && (set = PythonDataflowUtil.a((PyCallExpression)expr)) != null) {
            return set;
        }
        if (expr instanceof PyReferenceExpression) {
            return PythonDataflowUtil.a(expr);
        }
        return Collections.emptySet();
    }

    @Nullable
    private static Set<LookupElement> a(PyCallExpression pyCallExpression) {
        long l2 = a ^ 0x3EECB64B7171L;
        String string = pyCallExpression.getCallee().getText();
        if ("locals".equals(string)) {
            return PythonDataflowUtil.getLocals(pyCallExpression);
        }
        if ("dict".equals(string)) {
            return PythonDataflowUtil.b(pyCallExpression);
        }
        return null;
    }

    private static Set<LookupElement> a(PyExpression pyExpression) {
        final String string = pyExpression.getText();
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)pyExpression, PyFunction.class);
        if (pyFunction == null) {
            return null;
        }
        final HashSet hashSet = Sets.newHashSet();
        PyRecursiveElementVisitor pyRecursiveElementVisitor = new PyRecursiveElementVisitor(){

            @Override
            public void visitPyAssignmentStatement(PyAssignmentStatement node) {
                for (Pair<PyExpression, PyExpression> pair : PythonUtil.getTargetsToValuesMapping(node)) {
                    PyExpression pyExpression;
                    PyExpression pyExpression2 = (PyExpression)pair.getFirst();
                    if (PythonUtil.isVariable(pyExpression2, string)) {
                        Set set;
                        pyExpression = (PyExpression)pair.getSecond();
                        if (pyExpression instanceof PyDictLiteralExpression) {
                            hashSet.addAll(PythonUtil.getKeys((PyDictLiteralExpression)pyExpression));
                        }
                        if (!(pyExpression instanceof PyCallExpression) || (set = PythonDataflowUtil.a((PyCallExpression)pyExpression)) == null) continue;
                        hashSet.addAll(set);
                        continue;
                    }
                    if (!PythonUtil.isKeyAccess(pyExpression2, string) || (pyExpression = PythonUtil.getKey(pyExpression2)) == null) continue;
                    hashSet.add(LookupElementBuilder.createWithSmartPointer((String)pyExpression.getStringValue(), (PsiElement)pyExpression));
                }
            }
        };
        pyFunction.accept(pyRecursiveElementVisitor);
        return hashSet;
    }

    @Nullable
    private static Set<LookupElement> b(PyCallExpression pyCallExpression) {
        boolean bl2 = true;
        HashSet hashSet = Sets.newHashSet();
        for (PyExpression pyExpression : pyCallExpression.getArguments()) {
            if (!(pyExpression instanceof PyKeywordArgument)) {
                bl2 = false;
                break;
            }
            PyKeywordArgument pyKeywordArgument = (PyKeywordArgument)pyExpression;
            if (pyKeywordArgument.getKeywordNode() == null || pyKeywordArgument.getKeyword() == null) continue;
            hashSet.add(LookupElementBuilder.createWithSmartPointer((String)pyKeywordArgument.getKeyword(), (PsiElement)pyKeywordArgument.getKeywordNode().getPsi()));
        }
        if (bl2) {
            return hashSet;
        }
        if (pyCallExpression.getArguments().length == 1) {
            return PythonDataflowUtil.getDictionaryKeys(pyCallExpression.getArguments()[0]);
        }
        return null;
    }

    public static Set<PyCallExpression> getCalls(PyExpression expr) {
        PyCallExpression pyCallExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class);
        if (pyCallExpression != null) {
            return Collections.singleton(pyCallExpression);
        }
        HashSet<PyCallExpression> hashSet = new HashSet<PyCallExpression>();
        PyStatement pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyStatement.class);
        if (pyStatement instanceof PyAssignmentStatement) {
            PyAssignmentStatement pyAssignmentStatement = (PyAssignmentStatement)pyStatement;
            for (Pair<PyExpression, PyExpression> pair : PythonUtil.getTargetsToValuesMapping(pyAssignmentStatement)) {
                if (!((PyExpression)pair.getSecond()).equals(expr)) continue;
                CallVisitor callVisitor = new CallVisitor(pyStatement, expr, hashSet);
                pyStatement.getParent().accept((PsiElementVisitor)callVisitor);
            }
        }
        return hashSet;
    }

    private static boolean a(@NotNull PyCallExpression pyCallExpression, @NotNull PyExpression pyExpression) {
        PyArgumentList pyArgumentList;
        if (pyCallExpression == null) {
            PythonDataflowUtil.a(0);
        }
        if (pyExpression == null) {
            PythonDataflowUtil.a(1);
        }
        if ((pyArgumentList = pyCallExpression.getArgumentList()) != null) {
            for (PyExpression pyExpression2 : pyArgumentList.getArguments()) {
                QualifiedResolveResult qualifiedResolveResult;
                if (pyExpression2 instanceof PyReferenceExpressionImpl && pyExpression.equals((qualifiedResolveResult = ((PyReferenceExpressionImpl)pyExpression2).followAssignmentsChain(PyResolveContext.noImplicits())).getElement())) {
                    return true;
                }
                if (!pyExpression.equals(pyExpression2)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<LookupElement> getLocals(PyElement element) {
        ArrayList arrayList = Lists.newArrayList();
        PsiElement psiElement2 = PyPsiUtils.getRealContext((PsiElement)element);
        CompletionVariantsProcessor completionVariantsProcessor = new CompletionVariantsProcessor((PsiElement)element, (Condition<PsiElement>)((Condition)psiElement -> psiElement instanceof PyTargetExpression || psiElement instanceof PyParameter), null);
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PyFunction.class);
        if (pyFunction != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)completionVariantsProcessor, pyFunction, null, (PsiElement)pyFunction);
            arrayList.addAll(completionVariantsProcessor.getResultList());
        }
        return Sets.newLinkedHashSet((Iterable)arrayList);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = a ^ 0x569FED7AC51CL;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "arg";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/util/PythonDataflowUtil";
        objectArray[2] = "isCallWithArgument";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CallVisitor
    extends PyRecursiveElementVisitor {
        private final PyStatement d;
        private final PyExpression a;
        private boolean b = false;
        private final Set<PyCallExpression> c;

        private CallVisitor(PyStatement startStatement, PyExpression argument, Set<PyCallExpression> result) {
            this.d = startStatement;
            this.a = argument;
            this.c = result;
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            if (this.b && PythonDataflowUtil.a(node, this.a)) {
                this.c.add(node);
            }
            super.visitPyCallExpression(node);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            if (node.equals(this.d)) {
                this.b = true;
            }
            super.visitPyAssignmentStatement(node);
        }
    }
}

