/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.mako.psi.impl.MakoControlBlock;
import com.jetbrains.mako.psi.impl.MakoFunction;
import com.jetbrains.mako.psi.impl.MakoNamespace;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MakoUtil {
    private static final long a = c.a(-7677747858455203033L, -2384701733325041402L, MethodHandles.lookup().lookupClass()).a(119515609725872L);

    private MakoUtil() {
    }

    public static MultiMap<String, PsiElement> getAvailableLocalFunctions(PsiElement call) {
        Object object;
        MultiMap multiMap = new MultiMap();
        MakoFunction[] makoFunctionArray = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)call.getContainingFile(), MakoFunction.class);
        if (makoFunctionArray != null) {
            object = makoFunctionArray;
            int n2 = ((MakoFunction[])object).length;
            for (int i10 = 0; i10 < n2; ++i10) {
                MakoFunction makoFunction = object[i10];
                multiMap.putValue((Object)makoFunction.getName(), (Object)makoFunction);
            }
        }
        if ((object = (MakoFunction)PsiTreeUtil.getParentOfType((PsiElement)call, MakoFunction.class)) != null && (makoFunctionArray = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)object, MakoFunction.class)) != null) {
            for (MakoFunction makoFunction : makoFunctionArray) {
                multiMap.putValue((Object)makoFunction.getName(), (Object)makoFunction);
            }
        }
        return multiMap;
    }

    public static MultiMap<String, PsiElement> getAvailableImportedFunctions(PsiElement call) {
        return MakoUtil.getAvailableImportedFunctions(call, false);
    }

    public static MultiMap<String, PsiElement> getFunctionsFromNamespace(PsiElement call, String qualifier) {
        MultiMap multiMap = new MultiMap();
        MakoNamespace[] makoNamespaceArray = (MakoNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)call.getContainingFile(), MakoNamespace.class);
        if (makoNamespaceArray != null) {
            for (MakoNamespace makoNamespace : makoNamespaceArray) {
                String string;
                Object object;
                if (!qualifier.equals(makoNamespace.getName())) continue;
                MakoFunction[] makoFunctionArray = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)makoNamespace, MakoFunction.class);
                if (makoFunctionArray != null) {
                    object = makoFunctionArray;
                    int n2 = ((MakoFunction[])object).length;
                    for (int i10 = 0; i10 < n2; ++i10) {
                        MakoFunction makoFunction = object[i10];
                        multiMap.putValue((Object)makoFunction.getName(), (Object)makoFunction);
                    }
                }
                if ((object = makoNamespace.getFile()) == null && (string = makoNamespace.getModule()) == null) continue;
                multiMap.putAllValues(MakoUtil.functionsFromNamespace(makoNamespace, makoNamespace.getImport(), false, call.getProject(), false));
            }
        }
        return multiMap;
    }

    public static MultiMap<String, PsiElement> getAvailableImportedFunctions(PsiElement call, boolean forCompletion) {
        MultiMap multiMap = new MultiMap();
        MakoNamespace[] makoNamespaceArray = (MakoNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)call.getContainingFile(), MakoNamespace.class);
        if (makoNamespaceArray != null) {
            for (MakoNamespace makoNamespace : makoNamespaceArray) {
                Object object;
                MakoFunction[] makoFunctionArray = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)makoNamespace, MakoFunction.class);
                if (makoFunctionArray != null) {
                    object = makoFunctionArray;
                    int n2 = ((MakoFunction[])object).length;
                    for (int i10 = 0; i10 < n2; ++i10) {
                        MakoFunction makoFunction = object[i10];
                        if (forCompletion) {
                            multiMap.putValue((Object)(makoNamespace.getName() + ":" + makoFunction.getName()), (Object)makoFunction);
                            continue;
                        }
                        multiMap.putValue((Object)(makoNamespace.getName() + "." + makoFunction.getName()), (Object)makoFunction);
                    }
                }
                if ((object = makoNamespace.getFile()) == null && makoNamespace.getModule() == null) continue;
                multiMap.putAllValues(MakoUtil.functionsFromNamespace(makoNamespace, forCompletion, call.getProject()));
            }
        }
        return multiMap;
    }

    public static MultiMap<String, PsiElement> functionsFromNamespace(MakoNamespace namespace, boolean forCompletion, Project project) {
        return MakoUtil.functionsFromNamespace(namespace, namespace.getImport(), forCompletion, project);
    }

    public static MultiMap<String, PsiElement> functionsFromNamespace(MakoNamespace namespace, @Nullable String importString, boolean forCompletion, Project project) {
        return MakoUtil.functionsFromNamespace(namespace, importString, forCompletion, project, true);
    }

    public static MultiMap<String, PsiElement> functionsFromNamespace(MakoNamespace namespace, @Nullable String importString, boolean forCompletion, Project project, boolean addNamespace) {
        MultiMap multiMap;
        block4: {
            block3: {
                PsiFile[] psiFileArray;
                multiMap = new MultiMap();
                String string = namespace.getName();
                if (string == null && importString == null) {
                    return multiMap;
                }
                if (namespace.getFile() == null) break block3;
                for (PsiFile psiFile : psiFileArray = FilenameIndex.getFilesByName((Project)project, (String)namespace.getFile(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
                    multiMap.putAllValues(MakoUtil.a(namespace, psiFile, importString, addNamespace, forCompletion));
                }
                break block4;
            }
            if (namespace.getModule() == null) break block4;
            List<PsiElement> list2 = ResolveImportUtil.resolveModule(QualifiedName.fromDottedString((String)namespace.getModule()), namespace.getContainingFile(), false, 0);
            for (PsiElement psiElement : list2) {
                if (!(psiElement instanceof PsiFile)) continue;
                multiMap.putAllValues(MakoUtil.a(namespace, (PsiFile)psiElement, importString, addNamespace, forCompletion));
            }
        }
        return multiMap;
    }

    private static MultiMap<String, PsiElement> a(MakoNamespace makoNamespace, PsiFile psiFile, String string, boolean bl2, boolean bl3) {
        MultiMap multiMap;
        block4: {
            multiMap = new MultiMap();
            PyFunction[] pyFunctionArray = (PyFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, PyFunction.class);
            if (pyFunctionArray == null) break block4;
            String string2 = makoNamespace.getName();
            if (string == null) {
                for (PyFunction pyFunction : pyFunctionArray) {
                    String string3 = bl2 ? (bl3 ? string2 + ":" + pyFunction.getName() : string2 + "." + pyFunction.getName()) : pyFunction.getName();
                    multiMap.putValue((Object)string3, (Object)pyFunction);
                }
            } else {
                for (PyFunction pyFunction : pyFunctionArray) {
                    String string4 = pyFunction.getName();
                    if (!"*".equals(string) && (string4 == null || !string.contains(string4))) continue;
                    multiMap.putValue((Object)string4, (Object)pyFunction);
                }
            }
        }
        return multiMap;
    }

    public static MultiMap<String, PsiElement> getAvailableFunctions(PsiElement call) {
        MultiMap<String, PsiElement> multiMap = MakoUtil.getAvailableLocalFunctions(call);
        multiMap.putAllValues(MakoUtil.getAvailableImportedFunctions(call));
        return multiMap;
    }

    public static List<ResolveResult> resolveFunctionCall(PsiElement psiElement) {
        ArrayList<ResolveResult> arrayList = new ArrayList<ResolveResult>();
        MakoNamespace makoNamespace = (MakoNamespace)PsiTreeUtil.getParentOfType((PsiElement)psiElement, MakoNamespace.class);
        if (makoNamespace != null) {
            for (Map.Entry entry : MakoUtil.functionsFromNamespace(makoNamespace, false, psiElement.getProject()).entrySet()) {
                String string = psiElement.getText();
                if (!((String)entry.getKey()).equals(string)) continue;
                for (PsiElement psiElement2 : (Collection)entry.getValue()) {
                    arrayList.add((ResolveResult)new PsiElementResolveResult(psiElement2));
                }
            }
            return arrayList;
        }
        for (Map.Entry entry : MakoUtil.getAvailableFunctions(psiElement).entrySet()) {
            String string = psiElement.getText();
            if (!((String)entry.getKey()).equals(string)) continue;
            for (PsiElement psiElement3 : (Collection)entry.getValue()) {
                arrayList.add((ResolveResult)new PsiElementResolveResult(psiElement3));
            }
        }
        for (PsiElement psiElement4 : MakoUtil.elementsFromControl(psiElement)) {
            if (!psiElement4.getText().equals(psiElement.getText())) continue;
            arrayList.add((ResolveResult)new PsiElementResolveResult(psiElement4));
        }
        return arrayList;
    }

    public static List<PyTargetExpression> elementsFromControl(PsiElement element) {
        ArrayList<PyTargetExpression> arrayList = new ArrayList<PyTargetExpression>();
        MakoControlBlock makoControlBlock = (MakoControlBlock)PsiTreeUtil.getParentOfType((PsiElement)element, MakoControlBlock.class);
        while (makoControlBlock != null) {
            List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)makoControlBlock, PyTargetExpression.class);
            arrayList.addAll(list2);
            makoControlBlock = (MakoControlBlock)PsiTreeUtil.getParentOfType((PsiElement)makoControlBlock, MakoControlBlock.class);
        }
        return arrayList;
    }

    public static Set<String> getDefaultNamespaces() {
        long l2 = a ^ 0x577544710536L;
        return Sets.newHashSet((Object[])new String[]{"self", "parent", "local", "next"});
    }
}

