/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.editor;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.mako.MakoElementTypes;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.MakoTagBlock;
import com.jetbrains.mako.psi.impl.MakoCall;
import com.jetbrains.mako.psi.impl.MakoFunction;
import com.jetbrains.mako.psi.impl.MakoNamespace;
import com.jetbrains.mako.psi.impl.MakoTag;
import com.jetbrains.mako.psi.impl.MakoTagAttribute;
import com.jetbrains.mako.ref.MakoCallReference;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MakoTagAttributesContributor
extends CompletionContributor {
    public static final ElementPattern<PsiElement> TAG_ATTRIBUTE_PATTERN;
    public static final Map<String, String[]> TAG_TO_ATTRIBUTES;

    public MakoTagAttributesContributor() {
        this.extend(CompletionType.BASIC, TAG_ATTRIBUTE_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){
            private static final long a = c.a(-1310363244319099219L, -7998339020517806500L, MethodHandles.lookup().lookupClass()).a(169592668340059L);

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                MakoTag makoTag;
                long l2 = a ^ 0x58C13D43AF70L;
                if (parameters == null) {
                    1.a(0);
                }
                if (context == null) {
                    1.a(1);
                }
                if (result == null) {
                    1.a(2);
                }
                PsiElement psiElement = parameters.getPosition();
                NavigatablePsiElement navigatablePsiElement = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{MakoTag.class, MakoTagBlock.class});
                String string = "";
                HashSet hashSet = Sets.newHashSet();
                if (navigatablePsiElement == null) {
                    navigatablePsiElement = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, MakoFunction.class);
                    if (navigatablePsiElement != null) {
                        string = "def";
                    }
                } else {
                    string = navigatablePsiElement.getName();
                    if (navigatablePsiElement instanceof MakoNamespace) {
                        string = "namespace";
                    }
                }
                List list2 = (makoTag = (MakoTag)PsiTreeUtil.getChildOfType((PsiElement)navigatablePsiElement, MakoTag.class)) != null ? PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)makoTag, MakoTagAttribute.class) : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)navigatablePsiElement, MakoTagAttribute.class);
                for (Object object : list2) {
                    hashSet.add(((MakoTagAttribute)((Object)object)).getName());
                }
                String[] stringArray = TAG_TO_ATTRIBUTES.get(string);
                if (stringArray != null) {
                    for (String string2 : stringArray) {
                        if (hashSet.contains(string2)) continue;
                        result.addElement((LookupElement)LookupElementBuilder.create((String)string2).withInsertHandler((InsertHandler)new AttributeInsertHandler()));
                    }
                } else {
                    ResolveResult[] resolveResultArray;
                    Object object;
                    object = (MakoCall)PsiTreeUtil.getParentOfType((PsiElement)psiElement, MakoCall.class);
                    if (object == null) {
                        return;
                    }
                    MakoCallReference makoCallReference = ((MakoCall)object).getReference();
                    for (ResolveResult resolveResult : resolveResultArray = makoCallReference.multiResolve(true)) {
                        PsiElement psiElement2 = resolveResult.getElement();
                        if (!(psiElement2 instanceof PyFunction)) continue;
                        for (PyParameter pyParameter : ((PyFunction)psiElement2).getParameterList().getParameters()) {
                            if (pyParameter.getName() == null || hashSet.contains(pyParameter.getName())) continue;
                            result.addElement((LookupElement)LookupElementBuilder.create((String)pyParameter.getName()).withInsertHandler((InsertHandler)new AttributeInsertHandler()));
                        }
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x1A4F597CDF4DL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/mako/editor/MakoTagAttributesContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    static {
        long l2 = c.a(-8895909982005486910L, 2150538336972477465L, MethodHandles.lookup().lookupClass()).a(34194229797966L) ^ 0x5B67D8C6CEC7L;
        TAG_ATTRIBUTE_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withElementType((IElementType)MakoTokenTypes.ATTR_NAME), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{MakoElementTypes.OPEN_TAG, MakoElementTypes.TAG_BLOCK})))).andNot((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)MakoElementTypes.TAG_ATTRIBUTE)))});
        TAG_TO_ATTRIBUTES = Maps.newHashMap();
        TAG_TO_ATTRIBUTES.put("page", new String[]{"args", "cached", "cache_type", "cache_key", "cache_timeout", "cache_url", "cache_dir"});
        TAG_TO_ATTRIBUTES.put("include", new String[]{"file", "args"});
        TAG_TO_ATTRIBUTES.put("def", new String[]{"name", "filter", "cached", "cache_type", "cache_key", "cache_timeout", "cache_url", "cache_dir"});
        TAG_TO_ATTRIBUTES.put("block", new String[]{"name", "args", "filter", "cached", "cache_type", "cache_key", "cache_timeout", "cache_url", "cache_dir"});
        TAG_TO_ATTRIBUTES.put("namespace", new String[]{"import", "file", "name", "inheritable", "module"});
        TAG_TO_ATTRIBUTES.put("inherit", new String[]{"file"});
        TAG_TO_ATTRIBUTES.put("call", new String[]{"expr"});
        TAG_TO_ATTRIBUTES.put("doc", new String[0]);
        TAG_TO_ATTRIBUTES.put("text", new String[]{"filter"});
    }

    private static class AttributeInsertHandler
    implements InsertHandler {
        private static final long a = c.a(-3935229755025206020L, -310444700812514925L, MethodHandles.lookup().lookupClass()).a(77045577872214L);

        private AttributeInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            long l2 = a ^ 0x5922659AE5A8L;
            if (context == null) {
                AttributeInsertHandler.a(0);
            }
            if (item == null) {
                AttributeInsertHandler.a(1);
            }
            Editor editor2 = context.getEditor();
            Document document = editor2.getDocument();
            int n2 = editor2.getCaretModel().getOffset();
            CharSequence charSequence = document.getCharsSequence();
            if (!CharArrayUtil.regionMatches((CharSequence)charSequence, (int)n2, (CharSequence)"=\"") && !CharArrayUtil.regionMatches((CharSequence)charSequence, (int)n2, (CharSequence)"='")) {
                String string = "=\"\"";
                if (n2 >= document.getTextLength() || "/> \n\t\r".indexOf(document.getCharsSequence().charAt(n2)) < 0) {
                    document.insertString(n2, (CharSequence)(string + " "));
                } else {
                    document.insertString(n2, (CharSequence)string);
                }
            }
            editor2.getCaretModel().moveToOffset(n2 + 2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x607DD1CD7FFDL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/mako/editor/MakoTagAttributesContributor$AttributeInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

