/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.lexer;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.lexer.MakoFlexLexer;
import com.jetbrains.mako.lexer._MakoFlexLexer;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingProcessor;

public class MakoIndentingLexer
extends PythonIndentingProcessor {
    int myInitialIndent = 0;
    boolean insertEndOfStatement = false;

    public MakoIndentingLexer() {
        super(new _MakoFlexLexer(null), MakoFlexLexer.TOKENS_TO_MERGE);
    }

    @Override
    public void advance() {
        if (super.getBaseTokenType() == MakoTokenTypes.PYTHON_CODE) {
            this.insertEndOfStatement = true;
        }
        if (super.getBaseTokenType() == MakoTokenTypes.MAKO_TAG_START) {
            super.advanceBase();
            if (this.getTokenType() == PyTokenTypes.LINE_BREAK) {
                int n2 = this.getTokenStart();
                super.advanceBase();
                this.myLastNewLineIndent = this.myInitialIndent = this.getNextLineIndent();
                this.myIndentStack.push(this.myLastNewLineIndent);
                this.pushToken(PyTokenTypes.LINE_BREAK, n2, this.getTokenStart());
            }
            return;
        }
        super.advance();
    }

    @Override
    protected void processSpecialTokens() {
        super.processSpecialTokens();
        int n2 = this.getBaseTokenStart();
        if (super.getBaseTokenType() == MakoTokenTypes.MAKO_TAG_END && this.insertEndOfStatement && this.myLineHasSignificantTokens) {
            this.pushToken(PyTokenTypes.STATEMENT_BREAK, n2, n2);
            this.insertEndOfStatement = false;
        }
    }

    @Override
    protected int getNextLineIndent() {
        int n2 = super.getNextLineIndent();
        if (this.getBaseTokenType() == MakoTokenTypes.MAKO_TAG_END) {
            n2 = this.myInitialIndent;
        }
        return n2;
    }

    @Override
    protected IElementType getCommentTokenType() {
        return MakoTokenTypes.COMMENT;
    }

    @Override
    protected void checkStartState(int startOffset, int initialState) {
    }
}

