/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.formatter.PyBlock;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportHelper {
    private static final Logger b;
    private static final Comparator<PyImportStatementBase> a;
    private static final ImportPriority c;
    private static final long d;

    @NotNull
    private static Comparator<PyImportStatementBase> a(@NotNull PyCodeStyleSettings pyCodeStyleSettings) {
        if (pyCodeStyleSettings == null) {
            AddImportHelper.a(0);
        }
        Comparator comparator = (pyImportStatementBase, pyImportStatementBase2) -> {
            Comparator comparator = pyCodeStyleSettings.OPTIMIZE_IMPORTS_CASE_INSENSITIVE_ORDER ? String.CASE_INSENSITIVE_ORDER : Comparator.naturalOrder();
            return ContainerUtil.compareLexicographically(AddImportHelper.a(pyImportStatementBase), AddImportHelper.a(pyImportStatementBase2), Comparator.nullsFirst(comparator));
        };
        if (comparator == null) {
            AddImportHelper.a(1);
        }
        return comparator;
    }

    @NotNull
    private static List<String> a(@NotNull PyImportStatementBase pyImportStatementBase) {
        if (pyImportStatementBase == null) {
            AddImportHelper.a(2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        PyFromImportStatement pyFromImportStatement = PyUtil.as(pyImportStatementBase, PyFromImportStatement.class);
        if (pyFromImportStatement != null) {
            arrayList.add(StringUtil.repeatSymbol((char)'.', (int)pyFromImportStatement.getRelativeLevel()));
            QualifiedName qualifiedName = pyFromImportStatement.getImportSourceQName();
            arrayList.add(Objects.toString(qualifiedName, ""));
            if (pyFromImportStatement.isStarImport()) {
                arrayList.add("*");
            }
        } else {
            arrayList.add("");
        }
        for (QualifiedName qualifiedName : pyImportStatementBase.getImportElements()) {
            QualifiedName qualifiedName2 = qualifiedName.getImportedQName();
            arrayList.add(Objects.toString(qualifiedName2, ""));
            arrayList.add(StringUtil.notNullize((String)qualifiedName.getAsName()));
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            AddImportHelper.a(3);
        }
        return arrayList2;
    }

    @NotNull
    public static Comparator<PyImportStatementBase> getSameGroupImportsComparator(@NotNull PsiFile settingsAnchor) {
        if (settingsAnchor == null) {
            AddImportHelper.a(4);
        }
        PyCodeStyleSettings pyCodeStyleSettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)settingsAnchor, PyCodeStyleSettings.class);
        if (pyCodeStyleSettings.OPTIMIZE_IMPORTS_SORT_BY_TYPE_FIRST) {
            Comparator<PyImportStatementBase> comparator = a.thenComparing(AddImportHelper.a(pyCodeStyleSettings));
            if (comparator == null) {
                AddImportHelper.a(5);
            }
            return comparator;
        }
        Comparator<PyImportStatementBase> comparator = AddImportHelper.a(pyCodeStyleSettings).thenComparing(a);
        if (comparator == null) {
            AddImportHelper.a(6);
        }
        return comparator;
    }

    private AddImportHelper() {
    }

    public static void addLocalImportStatement(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            AddImportHelper.a(7);
        }
        if (name == null) {
            AddImportHelper.a(8);
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement psiElement = AddImportHelper.getLocalInsertPosition(element);
        PsiElement psiElement2 = PyUtil.sure(psiElement).getParent();
        if (psiElement2 != null) {
            psiElement2.addBefore((PsiElement)pyElementGenerator.createImportStatement(languageLevel, name, null), psiElement);
        }
    }

    public static void addLocalFromImportStatement(@NotNull PsiElement element, @NotNull String qualifier, @NotNull String name) {
        if (element == null) {
            AddImportHelper.a(9);
        }
        if (qualifier == null) {
            AddImportHelper.a(10);
        }
        if (name == null) {
            AddImportHelper.a(11);
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement psiElement = AddImportHelper.getLocalInsertPosition(element);
        PsiElement psiElement2 = PyUtil.sure(psiElement).getParent();
        if (psiElement2 != null) {
            psiElement2.addBefore((PsiElement)pyElementGenerator.createFromImportStatement(languageLevel, qualifier, name, null), psiElement);
        }
    }

    @Nullable
    public static PsiElement getLocalInsertPosition(@NotNull PsiElement anchor) {
        if (anchor == null) {
            AddImportHelper.a(12);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatement.class, (boolean)false);
    }

    @Nullable
    public static PsiElement getFileInsertPosition(PsiFile file) {
        return AddImportHelper.a((PsiElement)file, null, null);
    }

    @Nullable
    private static PsiElement a(@NotNull PsiElement psiElement, @Nullable PyImportStatementBase pyImportStatementBase, @Nullable ImportPriority importPriority) {
        ImportPriority importPriority2;
        Object object;
        PsiElement psiElement2;
        if (psiElement == null) {
            AddImportHelper.a(13);
        }
        if ((psiElement2 = psiElement.getFirstChild()) == null) {
            return null;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        PsiElement psiElement3 = psiElement2;
        boolean bl4 = InjectedLanguageManager.getInstance((Project)psiElement2.getProject()).isInjectedFragment(psiElement2.getContainingFile());
        PyImportStatementBase pyImportStatementBase2 = null;
        PyImportStatementBase pyImportStatementBase3 = null;
        do {
            if (psiElement2 instanceof PyImportStatementBase && !bl4) {
                object = (PyImportStatementBase)psiElement2;
                if (importPriority != null && pyImportStatementBase != null) {
                    if (AddImportHelper.a(pyImportStatementBase, (PyImportStatementBase)object, importPriority)) {
                        pyImportStatementBase3 = object;
                        break;
                    }
                    pyImportStatementBase2 = object;
                }
                psiElement3 = psiElement2;
                psiElement2 = psiElement2.getNextSibling();
                bl2 = true;
                continue;
            }
            if (PsiTreeUtil.instanceOf((Object)psiElement2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) {
                psiElement3 = psiElement2;
                psiElement2 = psiElement2.getNextSibling();
                continue;
            }
            if (PsiTreeUtil.instanceOf((Object)psiElement2, (Class[])new Class[]{OuterLanguageElement.class})) {
                psiElement3 = psiElement2 = psiElement2.getNextSibling();
                continue;
            }
            if (bl2 || bl3 || !(psiElement instanceof PyFile) || (object = DocStringUtil.findDocStringExpression((PyElement)psiElement)) == null || object.getParent() != psiElement2) break;
            psiElement3 = psiElement2 = psiElement2.getNextSibling();
            bl3 = true;
        } while (psiElement2 != null);
        object = pyImportStatementBase2 != null ? AddImportHelper.getImportPriority(pyImportStatementBase2) : null;
        ImportPriority importPriority3 = importPriority2 = pyImportStatementBase3 != null ? AddImportHelper.getImportPriority(pyImportStatementBase3) : null;
        if (pyImportStatementBase != null && (object == null || ((Enum)object).compareTo(importPriority) < 0)) {
            pyImportStatementBase.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, true);
        }
        if (importPriority2 != null) {
            if (importPriority2.compareTo(importPriority) > 0) {
                pyImportStatementBase3.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, true);
            } else if (importPriority2 == importPriority) {
                pyImportStatementBase3.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, null);
            }
        }
        return psiElement3;
    }

    private static boolean a(@Nullable PyImportStatementBase pyImportStatementBase, @NotNull PyImportStatementBase pyImportStatementBase2, @NotNull ImportPriority importPriority) {
        ImportPriority importPriority2;
        int n2;
        if (pyImportStatementBase2 == null) {
            AddImportHelper.a(14);
        }
        if (importPriority == null) {
            AddImportHelper.a(15);
        }
        if ((n2 = importPriority.compareTo(importPriority2 = AddImportHelper.getImportPriority(pyImportStatementBase2))) != 0) {
            return n2 < 0;
        }
        if (pyImportStatementBase == null) {
            return false;
        }
        return AddImportHelper.getSameGroupImportsComparator(pyImportStatementBase2.getContainingFile()).compare(pyImportStatementBase, pyImportStatementBase2) < 0;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        long l2 = d ^ 0x208BA0450F59L;
        if (importLocation == null) {
            AddImportHelper.a(16);
        }
        if (toImport == null) {
            AddImportHelper.a(17);
        }
        ImportPriorityChoice importPriorityChoice = AddImportHelper.getImportPriorityWithReason(importLocation, toImport);
        b.debug(String.format("Import group for %s at %s is %s: %s", new Object[]{toImport, importLocation.getContainingFile(), importPriorityChoice.a, importPriorityChoice.b}));
        ImportPriority importPriority = importPriorityChoice.a;
        if (importPriority == null) {
            AddImportHelper.a(18);
        }
        return importPriority;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PyImportStatementBase importStatement) {
        long l2 = d ^ 0x47B9762E7678L;
        if (importStatement == null) {
            AddImportHelper.a(19);
        }
        ImportPriorityChoice importPriorityChoice = AddImportHelper.getImportPriorityWithReason(importStatement);
        b.debug(String.format("Import group for '%s' is %s: %s", new Object[]{importStatement.getText(), importPriorityChoice.a, importPriorityChoice.b}));
        ImportPriority importPriority = importPriorityChoice.a;
        if (importPriority == null) {
            AddImportHelper.a(20);
        }
        return importPriority;
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PyImportStatementBase importStatement) {
        PsiElement psiElement;
        Object object;
        Object object2;
        long l2 = d ^ 0x4CC767885C20L;
        if (importStatement == null) {
            AddImportHelper.a(21);
        }
        if (importStatement instanceof PyFromImportStatement) {
            object2 = (PyFromImportStatement)importStatement;
            if (object2.isFromFuture()) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.FUTURE, "import from __future__");
                if (importPriorityChoice == null) {
                    AddImportHelper.a(22);
                }
                return importPriorityChoice;
            }
            if (object2.getRelativeLevel() > 0) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.PROJECT, "explicit relative import");
                if (importPriorityChoice == null) {
                    AddImportHelper.a(23);
                }
                return importPriorityChoice;
            }
            object = ((PyFromImportStatement)importStatement).getImportSource();
            psiElement = object2.resolveImportSource();
        } else {
            object2 = (PyImportElement)ArrayUtil.getFirstElement((Object[])importStatement.getImportElements());
            if (object2 == null) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(c, "incomplete import statement");
                if (importPriorityChoice == null) {
                    AddImportHelper.a(24);
                }
                return importPriorityChoice;
            }
            object = object2;
            psiElement = object2.resolve();
        }
        if (psiElement == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(c, object == null ? "incomplete import statement" : object.getText() + " is unresolved");
            if (importPriorityChoice == null) {
                AddImportHelper.a(25);
            }
            return importPriorityChoice;
        }
        object2 = psiElement instanceof PsiDirectory ? (PsiFileSystemItem)psiElement : (psiElement instanceof PsiDirectoryContainer ? (PsiFileSystemItem)ArrayUtil.getFirstElement((Object[])((PsiDirectoryContainer)psiElement).getDirectories()) : psiElement.getContainingFile());
        if (object2 instanceof PyiFile) {
            object2 = PyUtil.as(PyiUtil.getOriginalElement((PyiFile)object2), PsiFileSystemItem.class);
        }
        if (object2 == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(c, psiElement + " is not a file or directory");
            if (importPriorityChoice == null) {
                AddImportHelper.a(26);
            }
            return importPriorityChoice;
        }
        ImportPriorityChoice importPriorityChoice = AddImportHelper.getImportPriorityWithReason((PsiElement)importStatement, object2);
        if (importPriorityChoice == null) {
            AddImportHelper.a(27);
        }
        return importPriorityChoice;
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        Sdk sdk;
        VirtualFile virtualFile;
        long l2 = d ^ 0x58BB6A0C666EL;
        if (importLocation == null) {
            AddImportHelper.a(28);
        }
        if (toImport == null) {
            AddImportHelper.a(29);
        }
        if ((virtualFile = toImport.getVirtualFile()) == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(c, toImport + " doesn't have an associated virtual file");
            if (importPriorityChoice == null) {
                AddImportHelper.a(30);
            }
            return importPriorityChoice;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)toImport.getProject());
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        if (projectFileIndex.isInContent(virtualFile) && !projectFileIndex.isInLibraryClasses(virtualFile)) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.PROJECT, virtualFile + " belongs to the project and not under interpreter paths");
            if (importPriorityChoice == null) {
                AddImportHelper.a(31);
            }
            return importPriorityChoice;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)importLocation);
        Sdk sdk2 = sdk = module2 != null ? PythonSdkType.findPythonSdk(module2) : projectRootManager.getProjectSdk();
        if (PythonSdkType.isStdLib(virtualFile, sdk)) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.BUILTIN, virtualFile + " is either in lib but not under site-packages, or belongs to the root of skeletons, or is a .pyi stub definition for stdlib module");
            if (importPriorityChoice == null) {
                AddImportHelper.a(32);
            }
            return importPriorityChoice;
        }
        ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.THIRD_PARTY, sdk == null ? "SDK for " + virtualFile + " isn't found" : "Fall back value for " + virtualFile);
        if (importPriorityChoice == null) {
            AddImportHelper.a(33);
        }
        return importPriorityChoice;
    }

    public static boolean addImportStatement(@NotNull PsiFile file, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        Object object;
        if (file == null) {
            AddImportHelper.a(34);
        }
        if (name == null) {
            AddImportHelper.a(35);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        List<PyImportElement> list2 = ((PyFile)file).getImportTargets();
        for (PyImportElement object22 : list2) {
            object = Objects.toString(object22.getImportedQName(), "");
            if (!name.equals(object) || !Comparing.equal((String)asName, (String)object22.getAsName())) continue;
            return false;
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        object = pyElementGenerator.createImportStatement(languageLevel, name, asName);
        PyImportStatementBase pyImportStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false);
        PsiFile psiFile = pyImportStatementBase != null && pyImportStatementBase.getContainingFile() == file ? pyImportStatementBase.getParent() : file;
        try {
            if (anchor instanceof PyImportStatementBase) {
                psiFile.addAfter((PsiElement)object, anchor);
            } else {
                psiFile.addBefore((PsiElement)object, AddImportHelper.a((PsiElement)psiFile, (PyImportStatementBase)object, priority));
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            b.error((Throwable)incorrectOperationException);
        }
        return true;
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.a(36);
        }
        if (from == null) {
            AddImportHelper.a(37);
        }
        if (name == null) {
            AddImportHelper.a(38);
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyFromImportStatement pyFromImportStatement = pyElementGenerator.createFromImportStatement(languageLevel, from, name, asName);
        AddImportHelper.addFromImportStatement(file, pyFromImportStatement, priority, anchor);
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull PyFromImportStatement newImport, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        long l2 = d ^ 0x6ECF93E42C6DL;
        if (file == null) {
            AddImportHelper.a(39);
        }
        if (newImport == null) {
            AddImportHelper.a(40);
        }
        try {
            boolean bl2;
            PyImportStatementBase pyImportStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false);
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)file.getProject());
            PsiLanguageInjectionHost psiLanguageInjectionHost = injectedLanguageManager.getInjectionHost((PsiElement)file);
            boolean bl3 = bl2 = file instanceof PyDocstringFile && psiLanguageInjectionHost != null && DocStringUtil.getParentDefinitionDocString((PsiElement)psiLanguageInjectionHost) == psiLanguageInjectionHost;
            Object object = pyImportStatementBase != null && pyImportStatementBase.getContainingFile() == file ? pyImportStatementBase.getParent() : (psiLanguageInjectionHost != null && !bl2 ? injectedLanguageManager.getTopLevelFile((PsiElement)file) : file);
            if (bl2) {
                PsiElement psiElement = object.addBefore((PsiElement)newImport, AddImportHelper.a((PsiElement)object, (PyImportStatementBase)newImport, priority));
                PsiElement psiElement2 = psiElement.getNextSibling();
                if (!(psiElement2 instanceof PsiWhiteSpace)) {
                    psiElement2 = PsiParserFacade.SERVICE.getInstance((Project)file.getProject()).createWhiteSpaceFromText("  >>> ");
                }
                object.addBefore(psiElement2, psiElement);
            } else if (anchor instanceof PyImportStatementBase) {
                object.addAfter((PsiElement)newImport, anchor);
            } else {
                object.addBefore((PsiElement)newImport, AddImportHelper.a((PsiElement)object, (PyImportStatementBase)newImport, priority));
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            b.error((Throwable)incorrectOperationException);
        }
    }

    public static boolean addOrUpdateFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.a(41);
        }
        if (from == null) {
            AddImportHelper.a(42);
        }
        if (name == null) {
            AddImportHelper.a(43);
        }
        List<PyFromImportStatement> list2 = ((PyFile)file).getFromImports();
        PyCodeStyleSettings pyCodeStyleSettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PyCodeStyleSettings.class);
        if (!pyCodeStyleSettings.OPTIMIZE_IMPORTS_ALWAYS_SPLIT_FROM_IMPORTS) {
            for (PyFromImportStatement pyFromImportStatement : list2) {
                String string;
                if (pyFromImportStatement.isStarImport() || !from.equals(string = Objects.toString(pyFromImportStatement.getImportSourceQName(), "")) || pyFromImportStatement.getRelativeLevel() != 0) continue;
                for (PyImportElement pyImportElement : pyFromImportStatement.getImportElements()) {
                    String string2 = Objects.toString(pyImportElement.getImportedQName(), "");
                    if (!name.equals(string2) || !Comparing.equal((String)asName, (String)pyImportElement.getAsName())) continue;
                    return false;
                }
                PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(file.getProject());
                PyImportElement pyImportElement = pyElementGenerator.createImportElement(LanguageLevel.forElement((PsiElement)file), name, asName);
                pyFromImportStatement.add((PsiElement)pyImportElement);
                CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)pyFromImportStatement);
                return true;
            }
        }
        AddImportHelper.addFromImportStatement(file, from, name, asName, priority, anchor);
        return true;
    }

    public static void addImport(@NotNull PsiNamedElement target, @NotNull PsiFile file, @NotNull PyElement element) {
        if (target == null) {
            AddImportHelper.a(44);
        }
        if (file == null) {
            AddImportHelper.a(45);
        }
        if (element == null) {
            AddImportHelper.a(46);
        }
        if (target instanceof PsiFileSystemItem) {
            AddImportHelper.a((PsiFileSystemItem)target, file, element);
            return;
        }
        String string = target.getName();
        if (string == null) {
            return;
        }
        PsiFile psiFile = target.getContainingFile();
        if (psiFile == null) {
            return;
        }
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target, (PsiElement)element);
        if (qualifiedName == null) {
            return;
        }
        String string2 = qualifiedName.toString();
        ImportPriority importPriority = AddImportHelper.getImportPriority((PsiElement)file, (PsiFileSystemItem)psiFile);
        if (!PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            AddImportHelper.addImportStatement(file, string2, null, importPriority, (PsiElement)element);
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(file.getProject());
            element.replace((PsiElement)pyElementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target), string2 + "." + string));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(file, string2, string, null, importPriority, (PsiElement)element);
        }
    }

    private static void a(@NotNull PsiFileSystemItem psiFileSystemItem, @NotNull PsiFile psiFile, @NotNull PyElement pyElement) {
        PsiFileSystemItem psiFileSystemItem2;
        if (psiFileSystemItem == null) {
            AddImportHelper.a(47);
        }
        if (psiFile == null) {
            AddImportHelper.a(48);
        }
        if (pyElement == null) {
            AddImportHelper.a(49);
        }
        if ((psiFileSystemItem2 = psiFileSystemItem.getParent()) == null) {
            return;
        }
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)psiFileSystemItem, (PsiElement)pyElement);
        if (qualifiedName == null) {
            return;
        }
        ImportPriority importPriority = AddImportHelper.getImportPriority((PsiElement)psiFile, psiFileSystemItem2);
        if (qualifiedName.getComponentCount() == 1 || !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            String string = qualifiedName.toString();
            AddImportHelper.addImportStatement(psiFile, string, null, importPriority, (PsiElement)pyElement);
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(psiFile.getProject());
            pyElement.replace((PsiElement)pyElementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)psiFileSystemItem), string));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(psiFile, qualifiedName.removeLastComponent().toString(), psiFileSystemItem.getName(), null, importPriority, (PsiElement)pyElement);
        }
    }

    static {
        d = com.jetbrains.python.psi.c.a(-623507028419502094L, 109981987438361486L, MethodHandles.lookup().lookupClass()).a(77536654430518L);
        b = Logger.getInstance(AddImportHelper.class);
        a = (pyImportStatementBase, pyImportStatementBase2) -> {
            int n2 = pyImportStatementBase instanceof PyFromImportStatement ? 1 : 0;
            int n3 = pyImportStatementBase2 instanceof PyFromImportStatement ? 1 : 0;
            return n2 - n3;
        };
        c = ImportPriority.THIRD_PARTY;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x4DFD79495529L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 2: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 7: 
            case 9: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: 
            case 35: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertParent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingImport";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importLocation";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImport";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportNamesComparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameGroupImportsComparator";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPriority";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPriorityWithReason";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImportNamesComparator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSortNames";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSameGroupImportsComparator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLocalImportStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addLocalFromImportStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInsertPosition";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInsertPosition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertBefore";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriority";
                break;
            }
            case 21: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriorityWithReason";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addImportStatement";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addFromImportStatement";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateFromImportStatement";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addFileSystemItemImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ImportPriorityChoice {
        private final ImportPriority a;
        private final String b;
        private static final long c = com.jetbrains.python.psi.c.a(-639060987379332072L, -4691985746034103325L, MethodHandles.lookup().lookupClass()).a(23594912828800L);

        ImportPriorityChoice(@NotNull ImportPriority priority, @NotNull String description) {
            if (priority == null) {
                ImportPriorityChoice.a(0);
            }
            if (description == null) {
                ImportPriorityChoice.a(1);
            }
            this.a = priority;
            this.b = description;
        }

        @NotNull
        public ImportPriority getPriority() {
            ImportPriority importPriority = this.a;
            if (importPriority == null) {
                ImportPriorityChoice.a(2);
            }
            return importPriority;
        }

        @NotNull
        public String getDescription() {
            String string = this.b;
            if (string == null) {
                ImportPriorityChoice.a(3);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x772D2D7837CAL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ImportPriority
    extends Enum<ImportPriority> {
        public static final /* enum */ ImportPriority FUTURE;
        public static final /* enum */ ImportPriority BUILTIN;
        public static final /* enum */ ImportPriority THIRD_PARTY;
        public static final /* enum */ ImportPriority PROJECT;
        private static final /* synthetic */ ImportPriority[] a;

        public static ImportPriority[] values() {
            return (ImportPriority[])a.clone();
        }

        public static ImportPriority valueOf(String name) {
            return Enum.valueOf(ImportPriority.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-4996170488818995281L, -5177401747089276002L, MethodHandles.lookup().lookupClass()).a(99350491420532L) ^ 0x3C8AAFC8EF0FL;
            FUTURE = new ImportPriority();
            BUILTIN = new ImportPriority();
            THIRD_PARTY = new ImportPriority();
            PROJECT = new ImportPriority();
            a = new ImportPriority[]{FUTURE, BUILTIN, THIRD_PARTY, PROJECT};
        }
    }
}

