/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.ImportFromExistingAction;
import com.jetbrains.python.codeInsight.imports.PyImportCandidateProvider;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageAliasesProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.sdk.PythonSdkType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonImportUtils {
    private static final long a = c.a(-2232427854594660462L, -6865399555992587283L, MethodHandles.lookup().lookupClass()).a(73206549923756L);

    private PythonImportUtils() {
    }

    @Nullable
    public static AutoImportQuickFix proposeImportFix(PyElement node, PsiReference reference) {
        String string = reference.getElement().getText();
        String string2 = reference.getRangeInElement().substring(string);
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
        if (module2 != null && PythonSdkType.findPythonSdk(module2) == null) {
            return null;
        }
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class);
        if (scopeOwner != null && ControlFlowCache.getScope(scopeOwner).containsDeclaration(string2)) {
            return null;
        }
        AutoImportQuickFix autoImportQuickFix = PythonImportUtils.a(node, reference, string2, null);
        if (autoImportQuickFix != null) {
            return autoImportQuickFix;
        }
        String string3 = PyPackageAliasesProvider.commonImportAliases.get(string2);
        if (string3 != null && (autoImportQuickFix = PythonImportUtils.a(node, reference, string3, string2)) != null) {
            return autoImportQuickFix;
        }
        return null;
    }

    @Nullable
    private static AutoImportQuickFix a(PyElement pyElement, PsiReference psiReference, String string, @Nullable String string2) {
        boolean bl2 = !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT;
        AutoImportQuickFix autoImportQuickFix = new AutoImportQuickFix((PsiElement)pyElement, psiReference.getClass(), string, bl2);
        HashSet<String> hashSet = new HashSet<String>();
        PsiFile psiFile = PythonImportUtils.a(pyElement, string, autoImportQuickFix, hashSet);
        ProgressManager.checkCanceled();
        PythonImportUtils.a(pyElement, string, string2, autoImportQuickFix, hashSet, psiFile);
        for (PyImportCandidateProvider pyImportCandidateProvider : PyImportCandidateProvider.EP_NAME.getExtensionList()) {
            pyImportCandidateProvider.addImportCandidates(psiReference, string, autoImportQuickFix);
        }
        if (!autoImportQuickFix.getCandidates().isEmpty()) {
            autoImportQuickFix.sortCandidates();
            return autoImportQuickFix;
        }
        return null;
    }

    @Nullable
    private static PsiFile a(PyElement pyElement, String string, AutoImportQuickFix autoImportQuickFix, Set<String> set) {
        PsiFile psiFile = null;
        PsiFile psiFile2 = pyElement.getContainingFile();
        if (psiFile2 instanceof PyFile) {
            PyFile pyFile = (PyFile)psiFile2;
            for (PyImportElement object : pyFile.getImportTargets()) {
                psiFile = PythonImportUtils.a(string, autoImportQuickFix, set, psiFile, object, object.resolve());
            }
            Object object = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)pyElement.getContainingFile(), PyCodeStyleSettings.class);
            if (!((PyCodeStyleSettings)((Object)object)).OPTIMIZE_IMPORTS_ALWAYS_SPLIT_FROM_IMPORTS) {
                for (PyFromImportStatement pyFromImportStatement : pyFile.getFromImports()) {
                    if (pyFromImportStatement.isStarImport() || pyFromImportStatement.getImportElements().length <= 0) continue;
                    PsiFileSystemItem psiFileSystemItem = pyFromImportStatement.resolveImportSource();
                    psiFile = PythonImportUtils.a(string, autoImportQuickFix, set, psiFile, pyFromImportStatement.getImportElements()[0], (PsiElement)psiFileSystemItem);
                }
            }
        }
        return psiFile;
    }

    private static PsiFile a(String string, AutoImportQuickFix autoImportQuickFix, Set<String> set, PsiFile psiFile, PyImportElement pyImportElement, PsiElement psiElement) {
        PyFile pyFile = PyUtil.as(PyUtil.turnDirIntoInit(psiElement), PyFile.class);
        if (pyFile instanceof PyFileImpl) {
            String string2;
            PsiElement psiElement2 = pyFile.findExportedName(string);
            String string3 = string2 = psiElement2 instanceof PyQualifiedNameOwner ? ((PyQualifiedNameOwner)psiElement2).getQualifiedName() : null;
            if (string2 != null && set.contains(string2)) {
                return psiFile;
            }
            if (psiElement2 != null && !(psiElement2 instanceof PyFile) && !(psiElement2 instanceof PyImportElement) && psiElement2.getContainingFile() != null && PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)psiElement2.getContainingFile(), (boolean)false)) {
                psiFile = pyFile;
                autoImportQuickFix.addImport(psiElement2, pyFile, pyImportElement);
                if (string2 != null) {
                    set.add(string2);
                }
            }
        }
        return psiFile;
    }

    private static void a(PyElement pyElement, String string, @Nullable String string2, AutoImportQuickFix autoImportQuickFix, Set<String> set, PsiFile psiFile) {
        Project project = pyElement.getProject();
        ArrayList<PyClass> arrayList = new ArrayList<PyClass>(PyClassNameIndex.find(string, project, true));
        GlobalSearchScope globalSearchScope = PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)pyElement);
        if (!PythonImportUtils.b(pyElement)) {
            arrayList.addAll(PyFunctionNameIndex.find(string, project, globalSearchScope));
        }
        arrayList.addAll(PyVariableNameIndex.find(string, project, globalSearchScope));
        if (PythonImportUtils.a(pyElement)) {
            arrayList.addAll(PythonImportUtils.a(pyElement.getContainingFile(), string, project, globalSearchScope));
        }
        if (!arrayList.isEmpty()) {
            for (PsiElement psiElement : arrayList) {
                String string3;
                QualifiedName qualifiedName;
                PsiFile psiFile2;
                if (!PythonImportUtils.a(psiElement) || (psiFile2 = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getParent() : psiElement.getContainingFile()) == null || !PythonImportUtils.a(pyElement, psiFile, (PsiFileSystemItem)psiFile2) || (qualifiedName = QualifiedNameFinder.findCanonicalImportPath(psiElement, (PsiElement)pyElement)) == null) continue;
                if (psiElement instanceof PsiFileSystemItem) {
                    qualifiedName = qualifiedName.removeTail(1);
                }
                if (set.contains(string3 = qualifiedName.append(string).toString())) continue;
                autoImportQuickFix.addImport(psiElement, (PsiFileSystemItem)psiFile2, qualifiedName, string2);
                set.add(string3);
            }
        }
    }

    private static boolean a(PyElement pyElement, PsiFile psiFile, PsiFileSystemItem psiFileSystemItem) {
        return psiFileSystemItem != psiFile && psiFileSystemItem != pyElement.getContainingFile() && (ImportFromExistingAction.isRoot(psiFileSystemItem) || PyNames.isIdentifier(FileUtilRt.getNameWithoutExtension((String)psiFileSystemItem.getName()))) && !PythonImportUtils.a(psiFileSystemItem);
    }

    private static boolean a(PsiFileSystemItem psiFileSystemItem) {
        long l2 = a ^ 0x2DCE076342D8L;
        if (psiFileSystemItem.isDirectory() || psiFileSystemItem.getName().equals("__init__.py")) {
            return false;
        }
        String string = FileUtilRt.getNameWithoutExtension((String)psiFileSystemItem.getName());
        PsiDirectory psiDirectory = ((PsiFile)psiFileSystemItem).getContainingDirectory();
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory psiDirectory2 = psiDirectory.findSubdirectory(string);
        return psiDirectory2 != null && psiDirectory2.findFile("__init__.py") != null;
    }

    private static boolean b(PyElement pyElement) {
        return pyElement.getParent() instanceof PyReferenceExpression && pyElement == ((PyReferenceExpression)pyElement.getParent()).getQualifier();
    }

    private static boolean a(PyElement pyElement) {
        PyClass pyClass;
        PyArgumentList pyArgumentList;
        PyCallExpression pyCallExpression = PyUtil.as(pyElement.getParent(), PyCallExpression.class);
        if (pyCallExpression != null && pyElement == pyCallExpression.getCallee()) {
            PyDecorator pyDecorator = PyUtil.as(pyCallExpression, PyDecorator.class);
            return pyDecorator != null && !pyDecorator.hasArgumentList();
        }
        return !(pyElement.getParent() instanceof PyArgumentList) || !((pyArgumentList = (PyArgumentList)pyElement.getParent()).getParent() instanceof PyClass) || (pyClass = (PyClass)pyArgumentList.getParent()).getSuperClassExpressionList() != pyArgumentList;
    }

    private static Collection<PsiElement> a(PsiFile psiFile, String string, Project project, GlobalSearchScope globalSearchScope) {
        long l2 = a ^ 0x5E4148F49F9CL;
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        FilenameIndex.processFilesByName((String)string, (boolean)true, psiFileSystemItem -> {
            long l2 = a ^ 0x42239C8E35F1L;
            ProgressManager.checkCanceled();
            PsiDirectory psiDirectory = PyUtil.as(psiFileSystemItem, PsiDirectory.class);
            if (psiDirectory != null && psiDirectory.findFile("__init__.py") != null) {
                arrayList.add((PsiElement)psiDirectory);
            }
            return true;
        }, (GlobalSearchScope)globalSearchScope, (Project)project, null);
        FilenameIndex.processFilesByName((String)(string + ".py"), (boolean)false, (boolean)true, psiFileSystemItem -> {
            ProgressManager.checkCanceled();
            if (PythonImportUtils.isImportable(psiFile, psiFileSystemItem)) {
                arrayList.add((PsiElement)psiFileSystemItem);
            }
            return true;
        }, (GlobalSearchScope)globalSearchScope, (Project)project, null);
        return arrayList;
    }

    public static boolean isImportable(PsiFile targetFile, @NotNull PsiFileSystemItem file) {
        PsiDirectory psiDirectory;
        if (file == null) {
            PythonImportUtils.a(0);
        }
        return (psiDirectory = (PsiDirectory)file.getParent()) != null && file != targetFile && (ImportFromExistingAction.isRoot((PsiFileSystemItem)psiDirectory) || psiDirectory == targetFile.getParent() || PyUtil.isPackage(psiDirectory, false, null));
    }

    private static boolean a(PsiElement psiElement) {
        if (psiElement instanceof PsiFileSystemItem) {
            return true;
        }
        if (psiElement instanceof PyClass || psiElement instanceof PyFunction) {
            return PyUtil.isTopLevel(psiElement);
        }
        return psiElement instanceof PyTargetExpression;
    }

    public static boolean isImportable(PsiElement ref_element) {
        PyStatement pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)ref_element, PyStatement.class);
        if (pyStatement instanceof PyGlobalStatement || pyStatement instanceof PyNonlocalStatement || pyStatement instanceof PyImportStatementBase) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)ref_element, PyStringLiteralExpression.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) == null;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = a ^ 0x3FBC613468A5L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/PythonImportUtils", "isImportable"));
    }
}

