/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathMapper;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleWithFileRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunnerFactory
extends PythonConsoleRunnerFactory {
    private static final long b = c.a(659384919962641674L, -2699710598366821426L, MethodHandles.lookup().lookupClass()).a(202218397473669L);

    protected ConsoleParameters createConsoleParameters(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PydevConsoleRunnerFactory.b(0);
        }
        Pair<Sdk, Module> pair = PydevConsoleRunner.findPythonSdkAndModule(project, contextModule);
        Module module2 = (Module)pair.second;
        Sdk sdk = (Sdk)pair.first;
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        PyRemotePathMapper pyRemotePathMapper = PydevConsoleRunner.getPathMapper(project, sdk, pyConsoleSettings);
        String string2 = PydevConsoleRunnerFactory.getWorkingDir(project, module2, (PathMapper)pyRemotePathMapper, pyConsoleSettings);
        String[] stringArray = PydevConsoleRunnerFactory.createSetupFragment(module2, string2, (PathMapper)pyRemotePathMapper, pyConsoleSettings);
        HashMap hashMap = Maps.newHashMap(pyConsoleSettings.getEnvs());
        PydevConsoleRunnerFactory.putIPythonEnvFlag(project, hashMap);
        Consumer consumer = string -> {
            PydevConsoleRunner pydevConsoleRunner = this.createConsoleRunner(project, module2);
            if (pydevConsoleRunner instanceof PydevConsoleRunnerImpl) {
                ((PydevConsoleRunnerImpl)pydevConsoleRunner).setConsoleTitle((String)string);
            }
            pydevConsoleRunner.run(true);
        };
        return new ConsoleParameters(project, sdk, string2, hashMap, PyConsoleType.PYTHON, pyConsoleSettings, (Consumer<String>)consumer, stringArray);
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PydevConsoleRunnerFactory.b(1);
        }
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, contextModule);
        PydevConsoleRunner pydevConsoleRunner = this.createConsoleRunner(project, consoleParameters.mySdk, consoleParameters.myWorkingDir, consoleParameters.myEnvs, consoleParameters.myConsoleType, consoleParameters.mySettingsProvider, consoleParameters.myRerunAction, consoleParameters.mySetupFragment);
        if (pydevConsoleRunner == null) {
            PydevConsoleRunnerFactory.b(2);
        }
        return pydevConsoleRunner;
    }

    public static void putIPythonEnvFlag(@NotNull Project project, Map<String, String> envs) {
        long l2 = b ^ 0x51D4C45BBDB4L;
        if (project == null) {
            PydevConsoleRunnerFactory.b(3);
        }
        String string = PyConsoleOptions.getInstance(project).isIpythonEnabled() ? "True" : "False";
        envs.put("IPYTHONENABLE", string);
    }

    @Nullable
    public static String getWorkingDir(@NotNull Project project, @Nullable Module module2, @Nullable PathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
        String string;
        if (project == null) {
            PydevConsoleRunnerFactory.b(4);
        }
        if (StringUtil.isEmpty((String)(string = settingsProvider.getWorkingDirectory()))) {
            VirtualFile[] virtualFileArray;
            if (module2 != null && ModuleRootManager.getInstance((Module)module2).getContentRoots().length > 0) {
                string = ModuleRootManager.getInstance((Module)module2).getContentRoots()[0].getPath();
            } else if (ModuleManager.getInstance((Project)project).getModules().length > 0 && (virtualFileArray = ModuleRootManager.getInstance((Module)ModuleManager.getInstance((Project)project).getModules()[0]).getContentRoots()).length > 0) {
                string = virtualFileArray[0].getPath();
            }
        }
        if (pathMapper != null && string != null) {
            string = pathMapper.convertToRemote(string);
        }
        return string;
    }

    public static String[] createSetupFragment(@Nullable Module module2, @Nullable String workingDir, @Nullable PathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
        String[] stringArray;
        String string = settingsProvider.getCustomStartScript();
        if (string.trim().length() > 0) {
            string = "\n" + string;
        }
        List list2 = PythonCommandLineState.collectPythonPath(module2, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
        if (pathMapper != null) {
            list2 = pathMapper.convertToRemote(list2);
        }
        String string2 = PydevConsoleRunner.constructPyPathAndWorkingDirCommand(list2, workingDir, string);
        BuildoutFacet buildoutFacet = null;
        if (module2 != null) {
            buildoutFacet = BuildoutFacet.getInstance(module2);
        }
        if (buildoutFacet != null) {
            List list3 = buildoutFacet.getAdditionalPythonPath();
            if (pathMapper != null) {
                list3 = pathMapper.convertToRemote(list3);
            }
            String string3 = buildoutFacet.getPathPrependStatement(list3);
            stringArray = new String[]{string3, string2};
        } else {
            stringArray = new String[]{string2};
        }
        return stringArray;
    }

    @NotNull
    protected PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<? super String> rerunAction, String ... setupFragment) {
        if (project == null) {
            PydevConsoleRunnerFactory.b(5);
        }
        if (envs == null) {
            PydevConsoleRunnerFactory.b(6);
        }
        if (consoleType == null) {
            PydevConsoleRunnerFactory.b(7);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerFactory.b(8);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerFactory.b(9);
        }
        if (setupFragment == null) {
            PydevConsoleRunnerFactory.b(10);
        }
        PydevConsoleRunnerImpl pydevConsoleRunnerImpl = new PydevConsoleRunnerImpl(project, sdk, consoleType, workingDir, envs, settingsProvider, rerunAction, setupFragment);
        if (pydevConsoleRunnerImpl == null) {
            PydevConsoleRunnerFactory.b(11);
        }
        return pydevConsoleRunnerImpl;
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunnerWithFile(@NotNull Project project, @Nullable Module contextModule, final @Nullable String runFileText, @NotNull PythonRunConfiguration config) {
        if (project == null) {
            PydevConsoleRunnerFactory.b(12);
        }
        if (config == null) {
            PydevConsoleRunnerFactory.b(13);
        }
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, contextModule);
        Consumer consumer = string2 -> {
            PydevConsoleRunner pydevConsoleRunner = this.createConsoleRunnerWithFile(project, contextModule, runFileText, config);
            if (pydevConsoleRunner instanceof PydevConsoleRunnerImpl) {
                ((PydevConsoleRunnerImpl)pydevConsoleRunner).setConsoleTitle((String)string2);
            }
            final PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(project);
            pydevConsoleRunner.addConsoleListener(new PydevConsoleRunner.ConsoleListener(){
                private static final long a = c.a(4240187906639925329L, 7120855678632525993L, MethodHandles.lookup().lookupClass()).a(245963924984542L);

                @Override
                public void handleConsoleInitialized(@NotNull LanguageConsoleView consoleView) {
                    if (consoleView == null) {
                        1.a(0);
                    }
                    if (consoleView instanceof PyCodeExecutor) {
                        ((PyCodeExecutor)consoleView).executeCode(runFileText, null);
                        if (pythonConsoleToolWindow != null) {
                            pythonConsoleToolWindow.getToolWindow().show(null);
                        }
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x43E1A5D6F342L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/jetbrains/python/console/PydevConsoleRunnerFactory$1", "handleConsoleInitialized"));
                }
            });
            pydevConsoleRunner.run(true);
        };
        Sdk sdk = config.getSdk() != null ? config.getSdk() : consoleParameters.mySdk;
        String string = config.getWorkingDirectory() != null ? config.getWorkingDirectory() : consoleParameters.myWorkingDir;
        PydevConsoleWithFileRunnerImpl pydevConsoleWithFileRunnerImpl = new PydevConsoleWithFileRunnerImpl(project, sdk, consoleParameters.myConsoleType, config.getName(), string, consoleParameters.myEnvs, consoleParameters.mySettingsProvider, (Consumer<String>)consumer, config, consoleParameters.mySetupFragment);
        if (pydevConsoleWithFileRunnerImpl == null) {
            PydevConsoleRunnerFactory.b(14);
        }
        return pydevConsoleWithFileRunnerImpl;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x6D8631E47AE4L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupFragment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerFactory";
                break;
            }
            case 2: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleRunner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleRunnerWithFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleParameters";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunner";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putIPythonEnvFlag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunnerWithFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ConsoleParameters {
        @NotNull
        Project myProject;
        @Nullable
        Sdk mySdk;
        @Nullable
        String myWorkingDir;
        @NotNull
        Map<String, String> myEnvs;
        @NotNull
        PyConsoleType myConsoleType;
        @NotNull
        PyConsoleOptions.PyConsoleSettings mySettingsProvider;
        @NotNull
        Consumer<String> myRerunAction;
        @NotNull
        String[] mySetupFragment;
        private static final long a = c.a(-2354817964241507863L, 8716865142525331329L, MethodHandles.lookup().lookupClass()).a(177653155161883L);

        public ConsoleParameters(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<String> rerunAction, @NotNull String[] setupFragment) {
            if (project == null) {
                ConsoleParameters.a(0);
            }
            if (envs == null) {
                ConsoleParameters.a(1);
            }
            if (consoleType == null) {
                ConsoleParameters.a(2);
            }
            if (settingsProvider == null) {
                ConsoleParameters.a(3);
            }
            if (rerunAction == null) {
                ConsoleParameters.a(4);
            }
            if (setupFragment == null) {
                ConsoleParameters.a(5);
            }
            this.myProject = project;
            this.mySdk = sdk;
            this.myWorkingDir = workingDir;
            this.myEnvs = envs;
            this.myConsoleType = consoleType;
            this.mySettingsProvider = settingsProvider;
            this.myRerunAction = rerunAction;
            this.mySetupFragment = setupFragment;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x1A1A0702DFC8L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingsProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rerunAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "setupFragment";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

