/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.coverage;

import com.google.common.collect.Lists;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.coverage.PyCoverageEngine;
import com.jetbrains.python.coverage.PyCoverageOptionsProvider;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.PythonProcessHandler;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCoverageUtil {
    private static final Logger a;
    private static final long b;

    private PyCoverageUtil() {
    }

    public static void generateReport(final @NotNull Project project, DataContext dataContext, CoverageSuitesBundle currentSuite) {
        long l2 = b ^ 0x26AA2BA6DE59L;
        if (project == null) {
            PyCoverageUtil.a(0);
        }
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance((Project)project);
        final String string = exportToHTMLSettings.OUTPUT_DIRECTORY;
        final boolean bl2 = exportToHTMLSettings.OPEN_IN_BROWSER;
        final Module module2 = PyCoverageUtil.a(project);
        if (module2 == null) {
            Messages.showErrorDialog((Project)project, (String)"Module with valid Python sdk found", (String)"Module not Found");
            return;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(module2);
        assert (sdk != null);
        final String string2 = currentSuite.getSuites()[0].getCoverageDataFileName();
        Task.Modal modal = new Task.Modal(project, "Generating Coverage Report", false){
            private static final long a = c.a(2119994249060369896L, 5422657052314966256L, MethodHandles.lookup().lookupClass()).a(245115368426989L);

            public void run(@NotNull ProgressIndicator indicator) {
                long l2 = a ^ 0x11A3555D06D6L;
                if (indicator == null) {
                    1.a(0);
                }
                try {
                    GeneralCommandLine generalCommandLine = PyCoverageUtil.a(module2, Lists.newArrayList((Object[])new String[]{"html", "-d", string}));
                    PyCoverageUtil.addCoverageFileEnv(generalCommandLine, string2);
                    PyCoverageUtil.addRunCoverageEnv(generalCommandLine);
                    if (PyCoverageOptionsProvider.getInstance(project).isUseBundledCoveragePy()) {
                        PythonHelper.COVERAGEPY.addToPythonPath(generalCommandLine.getEnvironment());
                    }
                    PythonProcessHandler pythonProcessHandler = new PythonProcessHandler(generalCommandLine);
                    ProcessOutput processOutput = new ProcessOutput();
                    pythonProcessHandler.addProcessListener((ProcessListener)new CapturingProcessAdapter(processOutput));
                    pythonProcessHandler.startNotify();
                    pythonProcessHandler.waitFor();
                    processOutput.setExitCode(pythonProcessHandler.getProcess().exitValue());
                    if (processOutput.getExitCode() == 0) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            long l2 = a ^ 0x2DDBC56818EEL;
                            File file = new File(string, "index.html");
                            if (!file.exists()) {
                                String string22 = "Report wasn't generated in " + string;
                                if (StringUtil.isNotEmpty((String)processOutput.getStdout())) {
                                    string22 = string22 + "\n" + processOutput.getStdout();
                                }
                                if (StringUtil.isNotEmpty((String)processOutput.getStderr())) {
                                    string22 = string22 + "\n" + processOutput.getStderr();
                                }
                                Messages.showErrorDialog((String)string22, (String)"Error");
                            } else if (bl2) {
                                BrowserUtil.browse((File)file);
                            } else {
                                ApplicationManager.getApplication().invokeLater(() -> {
                                    long l2 = a ^ 0x579A854559DEL;
                                    Messages.showInfoMessage((String)("Report generated in " + string), (String)"Report Generated");
                                });
                            }
                        });
                    } else {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            long l2 = a ^ 0x64B5C095E53DL;
                            Messages.showErrorDialog((String)("Exit code: " + processOutput.getExitCode()), (String)"Error Generating Report");
                        });
                    }
                }
                catch (Exception exception) {
                    a.error("epic fail", (Throwable)exception);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3F715D0AD9F3L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/coverage/PyCoverageUtil$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)modal);
    }

    @Nullable
    private static Module a(@NotNull Project project) {
        Module[] moduleArray;
        if (project == null) {
            PyCoverageUtil.a(1);
        }
        for (Module module2 : moduleArray = ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            if (sdk == null) continue;
            return module2;
        }
        return null;
    }

    private static GeneralCommandLine a(Module module2, List<String> list2) throws ExecutionException {
        long l2 = b ^ 0x4BA28AE3E3B3L;
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk == null) {
            throw new ExecutionException(DjangoBundle.message("manage.run.error.no-python", new Object[0]));
        }
        String string = sdk.getHomePath();
        if (string != null) {
            string = FileUtil.toSystemDependentName((String)string);
        }
        GeneralCommandLine generalCommandLine = PythonHelper.COVERAGE.newCommandLine(string, list2);
        PythonEnvUtil.setPythonUnbuffered(generalCommandLine.getEnvironment());
        return generalCommandLine;
    }

    static void addCoverageFileEnv(GeneralCommandLine cmdLine, String coverageFilePath) {
        long l2 = b ^ 0xF3550526387L;
        cmdLine.getEnvironment().put("PYCHARM_COVERAGE_FILE", coverageFilePath);
    }

    static void addRunCoverageEnv(GeneralCommandLine cmdLine) {
        long l2 = b ^ 0x629D4754DC41L;
        cmdLine.getEnvironment().put("PYCHARM_RUN_COVERAGE", "1");
    }

    static {
        b = c.a(8955617673063916649L, 6103031263392195434L, MethodHandles.lookup().lookupClass()).a(177959476575944L);
        a = Logger.getInstance(PyCoverageEngine.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = b ^ 0x2511B3147AEEL;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/python/coverage/PyCoverageUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateReport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleWithPySdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

