/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugSessionFactory;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.DebugAwareConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugRunner
extends GenericProgramRunner {
    public static final String PY_DEBUG_RUNNER = "PyDebugRunner";
    public static final String DEBUGGER_MAIN = "pydev/pydevd.py";
    public static final String CLIENT_PARAM = "--client";
    public static final String PORT_PARAM = "--port";
    public static final String FILE_PARAM = "--file";
    public static final String MODULE_PARAM = "--module";
    public static final String MULTIPROCESS_PARAM = "--multiprocess";
    public static final String IDE_PROJECT_ROOTS = "IDE_PROJECT_ROOTS";
    public static final String LIBRARY_ROOTS = "LIBRARY_ROOTS";
    public static final String PYTHON_ASYNCIO_DEBUG = "PYTHONASYNCIODEBUG";
    public static final String GEVENT_SUPPORT = "GEVENT_SUPPORT";
    public static final String PYDEVD_FILTERS = "PYDEVD_FILTERS";
    public static final String PYDEVD_FILTER_LIBRARIES = "PYDEVD_FILTER_LIBRARIES";
    public static final String PYDEVD_USE_CYTHON = "PYDEVD_USE_CYTHON";
    public static final String CYTHON_EXTENSIONS_DIR;
    private static final long e;

    @NotNull
    public String getRunnerId() {
        long l2 = e ^ 0x3A868EAADF9BL;
        if (PY_DEBUG_RUNNER == null) {
            PyDebugRunner.a(0);
        }
        return PY_DEBUG_RUNNER;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PyDebugRunner.a(1);
        }
        if (profile == null) {
            PyDebugRunner.a(2);
        }
        if (!DefaultDebugExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        if (profile instanceof WrappingRunConfiguration) {
            return PyDebugRunner.a((RunProfile)((WrappingRunConfiguration)profile).getPeer());
        }
        return PyDebugRunner.a(profile);
    }

    private static boolean a(@NotNull RunProfile runProfile) {
        if (runProfile == null) {
            PyDebugRunner.a(3);
        }
        if (runProfile instanceof DebugAwareConfiguration) {
            return ((DebugAwareConfiguration)runProfile).canRunUnderDebug();
        }
        return runProfile instanceof AbstractPythonRunConfiguration;
    }

    protected XDebugSession createSession(@NotNull RunProfileState state2, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state2 == null) {
            PyDebugRunner.a(4);
        }
        if (environment == null) {
            PyDebugRunner.a(5);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final PythonCommandLineState pythonCommandLineState = (PythonCommandLineState)state2;
        Sdk sdk = pythonCommandLineState.getSdk();
        PyDebugSessionFactory pyDebugSessionFactory = PyDebugSessionFactory.findExtension(sdk);
        if (pyDebugSessionFactory != null) {
            return pyDebugSessionFactory.createSession(pythonCommandLineState, environment);
        }
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        int n2 = serverSocket.getLocalPort();
        RunProfile runProfile = environment.getRunProfile();
        final ExecutionResult executionResult = pythonCommandLineState.execute(environment.getExecutor(), this.createCommandLinePatchers(environment.getProject(), pythonCommandLineState, runProfile, n2));
        return XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){
            private static final long a = c.a(8300655406213702347L, -5434756704161233582L, MethodHandles.lookup().lookupClass()).a(150331867486846L);

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.a(0);
                }
                PyDebugProcess pyDebugProcess = PyDebugRunner.this.createDebugProcess(session, serverSocket, executionResult, pythonCommandLineState);
                PyDebugRunner.createConsoleCommunicationAndSetupActions(environment.getProject(), executionResult, pyDebugProcess, session);
                PyDebugProcess pyDebugProcess2 = pyDebugProcess;
                if (pyDebugProcess2 == null) {
                    1.a(1);
                }
                return pyDebugProcess2;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x1D1081AE61F0L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    protected PyDebugProcess createDebugProcess(@NotNull XDebugSession session, ServerSocket serverSocket, ExecutionResult result, PythonCommandLineState pyState) {
        if (session == null) {
            PyDebugRunner.a(6);
        }
        PyDebugProcess pyDebugProcess = new PyDebugProcess(session, serverSocket, result.getExecutionConsole(), result.getProcessHandler(), pyState.isMultiprocessDebug());
        if (pyDebugProcess == null) {
            PyDebugRunner.a(7);
        }
        return pyDebugProcess;
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state2 == null) {
            PyDebugRunner.a(8);
        }
        if (environment == null) {
            PyDebugRunner.a(9);
        }
        XDebugSession xDebugSession = this.createSession(state2, environment);
        this.initSession(xDebugSession, state2, environment.getExecutor());
        return xDebugSession.getRunContentDescriptor();
    }

    protected void initSession(XDebugSession session, RunProfileState state2, Executor executor) {
    }

    public static int findIndex(List<String> paramList, String paramName) {
        for (int i10 = 0; i10 < paramList.size(); ++i10) {
            if (!paramName.equals(paramList.get(i10))) continue;
            return i10 + 1;
        }
        return -1;
    }

    public static void createConsoleCommunicationAndSetupActions(@NotNull Project project, @NotNull ExecutionResult result, @NotNull PyDebugProcess debugProcess, @NotNull XDebugSession session) {
        ExecutionConsole executionConsole;
        if (project == null) {
            PyDebugRunner.a(10);
        }
        if (result == null) {
            PyDebugRunner.a(11);
        }
        if (debugProcess == null) {
            PyDebugRunner.a(12);
        }
        if (session == null) {
            PyDebugRunner.a(13);
        }
        if ((executionConsole = result.getExecutionConsole()) instanceof PythonDebugLanguageConsoleView) {
            ProcessHandler processHandler = result.getProcessHandler();
            PyDebugRunner.initDebugConsoleView(project, debugProcess, (PythonDebugLanguageConsoleView)executionConsole, processHandler, session);
        }
    }

    public static PythonDebugConsoleCommunication initDebugConsoleView(Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, final XDebugSession session) {
        long l2 = e ^ 0x152680DDDCB2L;
        PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
        PythonDebugConsoleCommunication pythonDebugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess);
        pythonConsoleView.setConsoleCommunication((ConsoleCommunication)pythonDebugConsoleCommunication);
        PydevDebugConsoleExecuteActionHandler pydevDebugConsoleExecuteActionHandler = new PydevDebugConsoleExecuteActionHandler((LanguageConsoleView)pythonConsoleView, processHandler, (ConsoleCommunication)pythonDebugConsoleCommunication);
        pythonConsoleView.setExecutionHandler(pydevDebugConsoleExecuteActionHandler);
        debugProcess.getSession().addSessionListener((XDebugSessionListener)pydevDebugConsoleExecuteActionHandler);
        new LanguageConsoleBuilder((LanguageConsoleView)pythonConsoleView).processHandler(processHandler).initActions((BaseConsoleExecuteActionHandler)pydevDebugConsoleExecuteActionHandler, "py");
        pythonDebugConsoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            public void commandExecuted(boolean more) {
                session.rebuildViews();
            }

            public void inputRequested() {
            }
        });
        return pythonDebugConsoleCommunication;
    }

    @Nullable
    public static CommandLinePatcher createRunConfigPatcher(RunProfileState state2, RunProfile profile) {
        AbstractPythonRunConfiguration abstractPythonRunConfiguration = null;
        if (state2 instanceof PythonCommandLineState && profile instanceof AbstractPythonRunConfiguration) {
            abstractPythonRunConfiguration = (AbstractPythonRunConfiguration)profile;
        }
        return abstractPythonRunConfiguration;
    }

    public CommandLinePatcher[] createCommandLinePatchers(Project project, PythonCommandLineState state2, RunProfile profile, int serverLocalPort) {
        return new CommandLinePatcher[]{this.a(project, state2, serverLocalPort, profile), PyDebugRunner.createRunConfigPatcher((RunProfileState)state2, profile)};
    }

    public static boolean patchExeParams(ParametersList parametersList) {
        long l2 = e ^ 0xE6740212FD2L;
        int n2 = parametersList.getParamsGroups().indexOf(parametersList.getParamsGroup("Module"));
        ParamsGroup paramsGroup = parametersList.removeParamsGroup(n2);
        if (paramsGroup == null) {
            return false;
        }
        boolean bl2 = false;
        ParamsGroup paramsGroup2 = new ParamsGroup("Module");
        for (String string : paramsGroup.getParameters()) {
            if (!string.equals("-m")) {
                paramsGroup2.addParameter(string);
                continue;
            }
            bl2 = true;
        }
        parametersList.addParamsGroupAt(n2, paramsGroup2);
        return bl2;
    }

    private CommandLinePatcher a(final Project project, final PythonCommandLineState pythonCommandLineState, final int n2, final RunProfile runProfile) {
        return new CommandLinePatcher(){
            private static final long a = c.a(656990677880240050L, -8596933008003261549L, MethodHandles.lookup().lookupClass()).a(113086970683815L);

            @Override
            public void patchCommandLine(GeneralCommandLine commandLine) {
                long l2 = a ^ 0x122ADA46C9A7L;
                ParametersList parametersList = commandLine.getParametersList();
                ParamsGroup paramsGroup = parametersList.getParamsGroup("Debugger");
                assert (paramsGroup != null);
                boolean bl2 = PyDebugRunner.patchExeParams(parametersList);
                PyDebugRunner.this.a(project, paramsGroup, n2, pythonCommandLineState, commandLine, runProfile, bl2);
                ParamsGroup paramsGroup2 = parametersList.getParamsGroup("Exe Options");
                PythonSdkFlavor pythonSdkFlavor = pythonCommandLineState.getSdkFlavor();
                if (pythonSdkFlavor != null) {
                    assert (paramsGroup2 != null);
                    for (String string : pythonSdkFlavor.getExtraDebugOptions()) {
                        paramsGroup2.addParameter(string);
                    }
                }
            }
        };
    }

    private void a(@NotNull Project project, @NotNull ParamsGroup paramsGroup, int n2, @NotNull PythonCommandLineState pythonCommandLineState, @NotNull GeneralCommandLine generalCommandLine, @Nullable RunProfile runProfile, boolean bl2) {
        long l2 = e ^ 0x70612BF11E5AL;
        if (project == null) {
            PyDebugRunner.a(14);
        }
        if (paramsGroup == null) {
            PyDebugRunner.a(15);
        }
        if (pythonCommandLineState == null) {
            PyDebugRunner.a(16);
        }
        if (generalCommandLine == null) {
            PyDebugRunner.a(17);
        }
        PythonHelper.DEBUGGER.addToGroup(paramsGroup, generalCommandLine);
        if (bl2) {
            paramsGroup.addParameter(MODULE_PARAM);
        }
        this.configureDebugParameters(project, paramsGroup, pythonCommandLineState, generalCommandLine);
        PyDebugRunner.configureDebugEnvironment(project, generalCommandLine.getEnvironment(), runProfile);
        PyDebugRunner.a(paramsGroup, n2);
    }

    public static void configureDebugEnvironment(@NotNull Project project, Map<String, String> environment, @Nullable RunProfile runProfile) {
        AbstractPythonRunConfiguration abstractPythonRunConfiguration;
        PyDebuggerSettings pyDebuggerSettings;
        long l2 = e ^ 0x2C94034AAAA4L;
        if (project == null) {
            PyDebugRunner.a(18);
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportGeventDebugging()) {
            environment.put(GEVENT_SUPPORT, "True");
        }
        if ((pyDebuggerSettings = PyDebuggerSettings.getInstance()).isSteppingFiltersEnabled()) {
            environment.put(PYDEVD_FILTERS, pyDebuggerSettings.getSteppingFiltersForProject(project));
        }
        if (pyDebuggerSettings.isLibrariesFilterEnabled()) {
            environment.put(PYDEVD_FILTER_LIBRARIES, "True");
        }
        if (pyDebuggerSettings.getValuesPolicy() != PyDebugValue.ValuesPolicy.SYNC) {
            environment.put((String)PyDebugValue.POLICY_ENV_VARS.get(pyDebuggerSettings.getValuesPolicy()), "True");
        }
        PydevConsoleRunnerFactory.putIPythonEnvFlag(project, environment);
        PythonEnvUtil.addToPythonPath(environment, CYTHON_EXTENSIONS_DIR);
        PyDebugRunner.a(project, environment);
        AbstractPythonRunConfiguration abstractPythonRunConfiguration2 = abstractPythonRunConfiguration = runProfile instanceof AbstractPythonRunConfiguration ? (AbstractPythonRunConfiguration)runProfile : null;
        if (abstractPythonRunConfiguration != null) {
            LanguageLevel languageLevel;
            PythonSdkFlavor pythonSdkFlavor;
            Sdk sdk = abstractPythonRunConfiguration.getSdk();
            if (sdk != null && (pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdk)) != null && ((languageLevel = pythonSdkFlavor.getLanguageLevel(sdk)) == LanguageLevel.PYTHON34 || languageLevel == LanguageLevel.PYTHON35)) {
                environment.put(PYDEVD_USE_CYTHON, "NO");
            }
            PyDebugRunner.a(environment, abstractPythonRunConfiguration);
            PythonEnvUtil.addToPythonPath(environment, abstractPythonRunConfiguration.getWorkingDirectorySafe());
        }
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd) {
        long l2 = e ^ 0x43CFCFB5CB3FL;
        if (project == null) {
            PyDebugRunner.a(19);
        }
        if (debugParams == null) {
            PyDebugRunner.a(20);
        }
        if (pyState == null) {
            PyDebugRunner.a(21);
        }
        if (cmd == null) {
            PyDebugRunner.a(22);
        }
        if (pyState.isMultiprocessDebug()) {
            debugParams.addParameter("--multiproc");
        }
        PyDebugRunner.configureCommonDebugParameters(project, debugParams);
    }

    public static void configureCommonDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams) {
        long l2 = e ^ 0x7E304420C692L;
        if (project == null) {
            PyDebugRunner.a(23);
        }
        if (debugParams == null) {
            PyDebugRunner.a(24);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            debugParams.addParameter("--DEBUG");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSaveCallSignatures()) {
            debugParams.addParameter("--save-signatures");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportQtDebugging()) {
            String string = StringUtil.toLowerCase((String)PyDebuggerOptionsProvider.getInstance(project).getPyQtBackend());
            debugParams.addParameter(String.format("--qt-support=%s", string));
        }
    }

    public static void disableBuiltinBreakpoint(@Nullable Sdk sdk, Map<String, String> env) {
        PythonSdkFlavor pythonSdkFlavor;
        long l2 = e ^ 0x71A14149C90CL;
        if (sdk != null && (pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdk)) != null && pythonSdkFlavor.getLanguageLevel(sdk) == LanguageLevel.PYTHON37) {
            env.put("PYTHONBREAKPOINT", "0");
        }
    }

    private static void a(@NotNull ParamsGroup paramsGroup, int n2) {
        String[] stringArray;
        long l2 = e ^ 0x45AE6B5B0D53L;
        if (paramsGroup == null) {
            PyDebugRunner.a(25);
        }
        for (String string : stringArray = new String[]{CLIENT_PARAM, "127.0.0.1", PORT_PARAM, String.valueOf(n2), FILE_PARAM}) {
            paramsGroup.addParameter(string);
        }
    }

    private static void a(@NotNull Project project, @NotNull Map<String, String> map2) {
        long l2 = e ^ 0x18981C21D37EL;
        if (project == null) {
            PyDebugRunner.a(26);
        }
        if (map2 == null) {
            PyDebugRunner.a(27);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (VirtualFile virtualFile : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            arrayList.add(virtualFile.getPath());
        }
        map2.put(IDE_PROJECT_ROOTS, StringUtil.join((Collection)arrayList, (String)File.pathSeparator));
    }

    private static void a(@NotNull Map<String, String> map2, @NotNull AbstractPythonRunConfiguration abstractPythonRunConfiguration) {
        Sdk sdk;
        long l2 = e ^ 0x1374B284960L;
        if (map2 == null) {
            PyDebugRunner.a(28);
        }
        if (abstractPythonRunConfiguration == null) {
            PyDebugRunner.a(29);
        }
        if ((sdk = abstractPythonRunConfiguration.getSdk()) != null) {
            ArrayList arrayList = Lists.newArrayList();
            for (VirtualFile virtualFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                arrayList.add(virtualFile.getPath());
            }
            map2.put(LIBRARY_ROOTS, StringUtil.join((Collection)arrayList, (String)File.pathSeparator));
        }
    }

    static {
        e = c.a(5736576511092530607L, 4129742522078300074L, MethodHandles.lookup().lookupClass()).a(143330015236464L);
        long l2 = e ^ 0x4D753E3A5589L;
        CYTHON_EXTENSIONS_DIR = new File(PathManager.getSystemPath(), "cythonExtensions").toString();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x50826E48EE4EL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 9: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 15: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDebuggable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleCommunicationAndSetupActions";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillDebugParameters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugEnvironment";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugParameters";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureCommonDebugParameters";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugConnectionParameters";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addProjectRootsToEnv";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addSdkRootsToEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

