/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLocalPositionConverter
implements PyPositionConverter {
    private static final String[] a;
    private static final long e;

    @NotNull
    public PySourcePosition create(@NotNull String file, int line2) {
        if (file == null) {
            PyLocalPositionConverter.a(0);
        }
        PySourcePosition pySourcePosition = this.convertPythonToFrame(file, line2);
        if (pySourcePosition == null) {
            PyLocalPositionConverter.a(1);
        }
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertPythonToFrame(@NotNull String filePath, int line2) {
        File file;
        if (filePath == null) {
            PyLocalPositionConverter.a(2);
        }
        if ((file = new File(filePath)).exists()) {
            PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(file.getPath(), line2);
            if (pyLocalSourcePosition == null) {
                PyLocalPositionConverter.a(3);
            }
            return pyLocalSourcePosition;
        }
        PyRemoteSourcePosition pyRemoteSourcePosition = new PyRemoteSourcePosition(filePath, line2);
        if (pyRemoteSourcePosition == null) {
            PyLocalPositionConverter.a(4);
        }
        return pyRemoteSourcePosition;
    }

    @NotNull
    public PySourcePosition convertFrameToPython(@NotNull PySourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.a(5);
        }
        PySourcePosition pySourcePosition = position;
        if (pySourcePosition == null) {
            PyLocalPositionConverter.a(6);
        }
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.a(7);
        }
        PySourcePosition pySourcePosition = this.convertToPython(PyLocalPositionConverter.b(position.getFile().getPath()), PyLocalPositionConverter.convertLocalLineToRemote(position.getFile(), position.getLine()));
        if (pySourcePosition == null) {
            PyLocalPositionConverter.a(8);
        }
        return pySourcePosition;
    }

    @NotNull
    protected PySourcePosition convertToPython(@NotNull String filePath, int line2) {
        if (filePath == null) {
            PyLocalPositionConverter.a(9);
        }
        PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(filePath, line2);
        if (pyLocalSourcePosition == null) {
            PyLocalPositionConverter.a(10);
        }
        return pyLocalSourcePosition;
    }

    protected static int convertLocalLineToRemote(VirtualFile file, int l2) {
        return (Integer)ReadAction.compute(() -> {
            int n3 = l2;
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null) {
                while (PyDebugSupportUtils.isContinuationLine(document, n3)) {
                    ++n3;
                }
            }
            return n3 + 1;
        });
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, String frameName) {
        if (position == null) {
            PyLocalPositionConverter.a(11);
        }
        return PyLocalPositionConverter.createXSourcePosition(this.getVirtualFile(position.getFile()), position.getLine());
    }

    public PySignature convertSignature(PySignature signature) {
        return signature;
    }

    public VirtualFile getVirtualFile(String path) {
        VirtualFile virtualFile = this.getLocalFileSystem().findFileByPath(path);
        if (virtualFile == null) {
            virtualFile = this.c(path);
        }
        return virtualFile;
    }

    protected VirtualFileSystem getLocalFileSystem() {
        return LocalFileSystem.getInstance();
    }

    private VirtualFile c(String string) {
        String string2;
        int n2 = -1;
        Object object = a;
        int n3 = ((String[])object).length;
        for (int i10 = 0; i10 < n3 && (n2 = string.indexOf(string2 = object[i10])) == -1; ++i10) {
        }
        if (n2 != -1) {
            object = string.substring(0, n2 + 4);
            VirtualFile virtualFile = this.getLocalFileSystem().findFileByPath((String)object);
            if (virtualFile != null) {
                String string3 = string.substring(n2 + 4);
                string2 = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile);
                if (string2 != null) {
                    return string2.findFileByRelativePath(string3);
                }
            }
        }
        return null;
    }

    private static String b(String string) {
        String string2;
        int n2 = -1;
        String[] stringArray = a;
        int n3 = stringArray.length;
        for (int i10 = 0; i10 < n3 && (n2 = string.indexOf((string2 = stringArray[i10]) + "!")) == -1; ++i10) {
        }
        if (n2 != -1) {
            return string.substring(0, n2 + 4) + string.substring(n2 + 5);
        }
        return string;
    }

    private static String a(String string) {
        String string2;
        int n2 = -1;
        String[] stringArray = a;
        int n3 = stringArray.length;
        for (int i10 = 0; i10 < n3 && (n2 = string.indexOf(string2 = stringArray[i10])) == -1; ++i10) {
        }
        if (n2 != -1) {
            return StringUtil.toLowerCase((String)string.substring(0, n2 + 4)) + string.substring(n2 + 4);
        }
        return StringUtil.toLowerCase((String)string);
    }

    @Nullable
    public static XSourcePosition createXSourcePosition(@Nullable VirtualFile vFile, int line2) {
        if (vFile != null) {
            return XDebuggerUtil.getInstance().createPosition(vFile, PyLocalPositionConverter.a(vFile, line2));
        }
        return null;
    }

    private static int a(VirtualFile virtualFile, int n2) {
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(virtualFile));
        --n2;
        if (document != null) {
            while (PyDebugSupportUtils.isContinuationLine(document, n2 - 1)) {
                --n2;
            }
        }
        return n2;
    }

    static {
        e = c.a(-5817891331458561102L, -2163654080974256348L, MethodHandles.lookup().lookupClass()).a(166441547334004L);
        long l2 = e ^ 0x3A47006CD844L;
        a = new String[]{".egg", ".zip"};
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x61D385635816L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPythonToFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFrameToPython";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPython";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertPythonToFrame";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertFrameToPython";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToPython";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPython";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PyRemoteSourcePosition
    extends PySourcePosition {
        public PyRemoteSourcePosition(String file, int line2) {
            super(file, line2);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows && PyRemoteSourcePosition.isWindowsPath((String)file)) {
                file = PyLocalPositionConverter.a(file);
            }
            return super.normalize(file);
        }
    }

    protected static class PyLocalSourcePosition
    extends PySourcePosition {
        public PyLocalSourcePosition(String file, int line2) {
            super(file, line2);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows) {
                file = PyLocalPositionConverter.a(file);
            }
            return super.normalize(file);
        }
    }
}

