/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PySignatureCacheManager {
    static final String RETURN_TYPE = "<RETURN_TYPE>";
    private static final long d = c.a(7316753329204547248L, -836602476330113860L, MethodHandles.lookup().lookupClass()).a(111778953014578L);

    public static PySignatureCacheManager getInstance(Project project) {
        return (PySignatureCacheManager)ServiceManager.getService((Project)project, PySignatureCacheManager.class);
    }

    public static String signatureToString(PySignature signature) {
        return signature.getFunctionName() + "\t" + StringUtil.join(PySignatureCacheManager.a(signature), (String)"\t") + (signature.getReturnType() != null ? "\t" + StringUtil.join((Collection)signature.getReturnType().getTypesList().stream().map(string -> {
            long l2 = d ^ 0x1874DE081B9EL;
            return "<RETURN_TYPE>:" + string;
        }).collect(Collectors.toList()), (String)"\t") : "");
    }

    private static List<String> a(PySignature pySignature) {
        ArrayList arrayList = Lists.newArrayList();
        for (PySignature.NamedParameter namedParameter : pySignature.getArgs()) {
            arrayList.add(namedParameter.getName() + ":" + namedParameter.getTypeQualifiedName());
        }
        return arrayList;
    }

    public abstract void recordSignature(@NotNull PySignature var1);

    @Nullable
    public abstract String findParameterType(@NotNull PyFunction var1, @NotNull String var2);

    @Nullable
    public abstract PySignature findSignature(@NotNull PyFunction var1);

    public abstract void clearCache();
}

